/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorate;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class FtileWithConnection
extends FtileDecorate {
    private final List<Connection> connections = new ArrayList<Connection>();

    FtileWithConnection(Ftile ftile, Collection<Connection> connections) {
        super(ftile);
        if (connections == null || connections.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.connections.addAll(connections);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.connections;
    }

    public FtileWithConnection(Ftile ftile, Connection connection) {
        this(ftile, Arrays.asList(Objects.requireNonNull(connection)));
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getFtileDelegated().drawU(ug);
        for (Connection c : this.connections) {
            ug.draw(c);
        }
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        ArrayList<Connection> result = new ArrayList<Connection>(super.getInnerConnections());
        result.addAll(this.connections);
        return Collections.unmodifiableList(this.connections);
    }
}

