/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.at.gadermaier.argon2.model;

import ext.plantuml.com.at.gadermaier.argon2.Argon2;
import ext.plantuml.com.at.gadermaier.argon2.model.Argon2Type;
import ext.plantuml.com.at.gadermaier.argon2.model.Block;

public class Instance {
    public Block[] memory;
    private int version;
    private int iterations;
    private int segmentLength;
    private int laneLength;
    private int lanes;
    private Argon2Type type;

    public Instance(Argon2 argon2) {
        this.version = argon2.getVersion();
        this.iterations = argon2.getIterations();
        this.lanes = argon2.getLanes();
        this.type = argon2.getType();
        int memoryBlocks = argon2.getMemory();
        if (memoryBlocks < 8 * argon2.getLanes()) {
            memoryBlocks = 8 * argon2.getLanes();
        }
        this.segmentLength = memoryBlocks / (argon2.getLanes() * 4);
        this.laneLength = this.segmentLength * 4;
        memoryBlocks = this.segmentLength * (argon2.getLanes() * 4);
        this.initMemory(memoryBlocks);
    }

    private void initMemory(int memoryBlocks) {
        this.memory = new Block[memoryBlocks];
        for (int i = 0; i < this.memory.length; ++i) {
            this.memory[i] = new Block();
        }
    }

    public void clear() {
        for (Block b : this.memory) {
            b.clear();
        }
        this.memory = null;
    }

    public Block[] getMemory() {
        return this.memory;
    }

    public int getVersion() {
        return this.version;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public int getLaneLength() {
        return this.laneLength;
    }

    public int getLanes() {
        return this.lanes;
    }

    public Argon2Type getType() {
        return this.type;
    }
}

