/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMCommon.IServerAdmin;
import com.sas.iom.SASIOMCommon.IServerAdminHelper;
import com.sas.iom.SASIOMCommon.IServerStatus;
import com.sas.iom.SASIOMCommon.IServerStatusHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.brg.ORBImpl;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public class Util {
    private Util() {
    }

    public static String getServerVersion(Object root) throws GenericError {
        IServerStatus iServerStatus;
        StringSeqHolder softwareInfoHolder;
        IServerAdmin iServerAdmin;
        String serverVersion = null;
        if (root instanceof IWorkspace) {
            IWorkspace iWorkspace = (IWorkspace)root;
            IUtilities iUtil = iWorkspace.Utilities();
            IHostSystem iHostSystem = iUtil.HostSystem();
            StringSeqHolder softwareInfoHolder2 = new StringSeqHolder();
            VariableArray2dOfStringHolder hardwareInfoHolder = new VariableArray2dOfStringHolder();
            iHostSystem.GetInfo(softwareInfoHolder2, hardwareInfoHolder);
            serverVersion = softwareInfoHolder2.value[0];
        }
        if (serverVersion == null && (iServerAdmin = IServerAdminHelper.narrow(root)) != null) {
            softwareInfoHolder = new StringSeqHolder();
            VariableArray2dOfStringHolder hardwareInfoHolder = new VariableArray2dOfStringHolder();
            iServerAdmin.ServerAdminGetInfo(softwareInfoHolder, hardwareInfoHolder);
            serverVersion = softwareInfoHolder.value[0];
        }
        if (serverVersion == null && (iServerStatus = IServerStatusHelper.narrow(root)) != null) {
            softwareInfoHolder = new StringSeqHolder();
            iServerStatus.ServerStatusGetInfo(softwareInfoHolder);
            serverVersion = softwareInfoHolder.value[0];
        }
        if (serverVersion == null) {
            serverVersion = "UNKNOWN";
        }
        return serverVersion;
    }

    public static String getUserName(Object root) {
        ORBImpl orb = (ORBImpl)((ObjectImpl)root)._orb();
        SASURI uri = orb.object_to_uri(root);
        String userName = uri.getUser();
        return userName;
    }
}

