/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.MissingValues;
import com.sas.text.FormatDescription;
import com.sas.text.Info;
import com.sas.text.InvalidFormatException;
import com.sas.text.InvalidFormatNameException;
import com.sas.text.InvalidFormatWidthException;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SASFormatInfo;
import com.sas.text.SASFormatInterface;
import com.sas.text.SASNumericFormat;
import com.sas.text.SASUserDefinedFormat;
import com.sas.text.StandardNoopCharacter;
import com.sas.text.TableEntry;
import com.sas.text.UnImplementedFormat;
import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public abstract class SASFormat
extends Format
implements SASFormatInterface {
    protected Locale locale;
    protected Info formatInfo;
    protected static Hashtable lookUpTable;
    protected static Hashtable localeFormatCache;
    static Locale DANISH;
    static Locale FINNISH;
    static Locale SPANISH;
    static Locale SWEDISH;
    static Locale NORWEGIAN;
    static Locale DUTCH;
    static Locale PORTUGUESE;
    static Locale AFRIKAANS;
    static Locale CATALAN;
    static Locale HUNGARIAN;
    static Locale POLISH;
    static Locale CZECH;
    static Locale SLOVENIAN;
    static Locale CROATIAN;
    static Locale MACEDONIAN;
    static Locale RUSSIAN;
    static Locale FRENCH_SWITZERLAND;
    static Locale GERMAN_SWITZERLAND;
    private static final String[] EURfmtLocales;
    static TimeZone timezone;
    protected String origFormat;
    private boolean insertBlanks = true;

    protected SASFormat() {
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof MissingValues || obj instanceof Double && ((Double)obj).isNaN()) {
            StringBuffer value = null;
            value = MissingValues.Dot.equals(obj) || obj instanceof Double && ((Double)obj).isNaN() ? new StringBuffer(".") : new StringBuffer(obj.toString());
            if (this.formatInfo.width - value.length() < 0) {
                value.setLength(this.formatInfo.width);
            } else {
                String name = this.formatInfo.getBaseFormat();
                if (name.charAt(0) == '$' || name.equalsIgnoreCase("ROMAN")) {
                    this.insertTrailingWhitespaces(value, this.formatInfo.width - value.length());
                } else {
                    this.insertLeadingBlanks(value);
                }
            }
            return toAppendTo.append(value);
        }
        return null;
    }

    @Override
    public abstract Object parseObject(String var1, ParsePosition var2);

    protected abstract void init();

    public static SASFormat getInstance(String baseFormat, int width) {
        return SASFormat.getInstance(baseFormat, width, 0, Locale.getDefault());
    }

    public static SASFormat getInstance(String baseFormat, int width, int decimalWidth) {
        return SASFormat.getInstance(baseFormat, width, decimalWidth, Locale.getDefault());
    }

    public static SASFormat getInstance(String baseFormat, int width, Locale locale) {
        return SASFormat.getInstance(baseFormat, width, 0, locale);
    }

    public static SASFormat getInstance(SASFormatInterface fmt) {
        return SASFormat.getInstance(fmt.getBaseFormatName(), fmt.getWidth(), fmt.getDecimalWidth(), fmt.getLocale());
    }

    public static SASFormat getInstance(String baseFormat, int width, int decimalWidth, Locale locale) {
        UnImplementedFormat unEmplementedFormat;
        String DefaultFormat;
        Object localeFormat;
        String origFormat = baseFormat;
        if ("Z".equals(baseFormat = baseFormat.toUpperCase())) {
            baseFormat = "F";
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        baseFormat = SASFormat.jFormatFilter(baseFormat);
        if (localeFormatCache == null) {
            SASFormat.refreshFormatCache(locale);
        }
        if ((localeFormat = localeFormatCache.get(locale)) == null) {
            SASFormat.refreshFormatCache(locale);
        } else {
            lookUpTable = (Hashtable)localeFormat;
        }
        TableEntry entry = (TableEntry)lookUpTable.get(baseFormat);
        if (entry == null) {
            entry = SASUserDefinedFormat.getUserDefinedFormat(baseFormat);
        }
        if (entry == null && (DefaultFormat = (unEmplementedFormat = UnImplementedFormat.getinstance()).getDefaultFormat(baseFormat)) != null) {
            baseFormat = DefaultFormat;
            entry = (TableEntry)lookUpTable.get(DefaultFormat);
        }
        if (entry != null) {
            try {
                Class<?> temp = Class.forName(entry.getClassName());
                SASFormat format = (SASFormat)temp.newInstance();
                format.locale = locale;
                format.formatInfo = entry instanceof SASFormatEntry ? new SASFormatInfo((SASFormatEntry)entry, baseFormat, width, decimalWidth) : new Info(entry, baseFormat, width);
                format.init();
                format.origFormat = origFormat;
                return format;
            }
            catch (InvalidFormatException ife) {
                return null;
            }
            catch (Exception cnfe) {
                return null;
            }
        }
        return null;
    }

    public static SASFormat getInstance(String sFormat) {
        return SASFormat.getInstance(sFormat, Locale.getDefault());
    }

    public static SASFormat getInstance(String sFormat, Locale locale) {
        try {
            int decimalWidth;
            int width;
            if (sFormat.equalsIgnoreCase("$.") || sFormat.equalsIgnoreCase("$F.")) {
                return new StandardNoopCharacter(sFormat, locale);
            }
            String[] pf = SASFormat.parseFormat(sFormat.trim().toUpperCase());
            String baseFormat = pf[0] == null ? String.valueOf(' ') : pf[0];
            int n = width = pf[1] == null ? -1 : Integer.parseInt(pf[1], 10);
            if (baseFormat.startsWith("NLMNI") || baseFormat.startsWith("NLMNL")) {
                decimalWidth = pf[2] == null ? -1 : Integer.parseInt(pf[2], 10);
            } else if ("D".equals(baseFormat)) {
                decimalWidth = pf[2] == null ? -1 : Integer.parseInt(pf[2], 10);
            } else if ("NLPVALUE".equals(baseFormat) || "PVALUE".equals(baseFormat)) {
                decimalWidth = pf[2] == null ? Math.min(4, width - 2) : Integer.parseInt(pf[2], 10);
            } else {
                int n2 = decimalWidth = pf[2] == null ? 0 : Integer.parseInt(pf[2], 10);
            }
            if (decimalWidth != 0 && decimalWidth >= width) {
                decimalWidth = width - 1;
            }
            if (baseFormat.startsWith("NLPVALUE") && decimalWidth > 30) {
                decimalWidth = 30;
            }
            return SASFormat.getInstance(baseFormat, width, decimalWidth, locale);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String[] parseFormat(String s) {
        int fw;
        int index;
        StringBuffer width;
        String format;
        int decimalIndex;
        String[] result = new String[3];
        if (s != null && s.length() > 0) {
            decimalIndex = s.indexOf(46);
            format = decimalIndex != -1 ? s.substring(0, decimalIndex) : s;
            width = new StringBuffer(3);
            for (index = format.length() - 1; index >= 0 && Character.isDigit(format.charAt(index)); --index) {
                width.insert(0, Character.digit(format.charAt(index), 10));
            }
        } else {
            throw new RuntimeException("Invalid format " + s);
        }
        result[0] = index != -1 ? ((fw = format.length() - width.length()) <= 0 ? null : format.substring(0, fw)) : "F";
        result[1] = width.length() == 0 ? null : width.toString();
        result[2] = decimalIndex == -1 || decimalIndex + 1 >= s.length() ? null : s.substring(decimalIndex + 1);
        return result;
    }

    protected void insertLeadingBlanks(StringBuffer str) {
        this.insertLeadingBlanks(str, 0);
    }

    protected void insertLeadingBlanks(StringBuffer str, int index) {
        if (this.insertBlanks) {
            this.insertLeadingCharacter(str, index, ' ');
        }
    }

    protected void insertLeadingCharacter(StringBuffer str, int index, char c) {
        int width;
        int numOfSpaces;
        if (this.insertBlanks && (numOfSpaces = (width = this.formatInfo.getWidth()) - str.length()) > 0) {
            str.ensureCapacity(width);
            for (int i = 0; i < numOfSpaces; ++i) {
                str.insert(index, c);
            }
        }
    }

    protected StringBuffer insertTrailingWhitespaces(StringBuffer input) {
        int width = this.formatInfo.getWidth();
        int numOfSpaces = width - input.length();
        return this.insertTrailingWhitespaces(input, numOfSpaces);
    }

    protected StringBuffer insertTrailingWhitespaces(StringBuffer input, int numberOfWhitespaces) {
        if (this.insertBlanks) {
            for (int i = 0; i < numberOfWhitespaces; ++i) {
                input.append(' ');
            }
        }
        return input;
    }

    protected double round(double value, int decimalCount) {
        BigDecimal bd = new BigDecimal(new Double(value).toString());
        bd = bd.setScale(decimalCount, 4);
        return bd.doubleValue();
    }

    public String getName() {
        int dv;
        SASFormatInfo sfi;
        StringBuffer result = new StringBuffer(this.formatInfo.getBaseFormat());
        result.append(this.formatInfo.getWidth());
        if (this.formatInfo instanceof SASFormatInfo && (sfi = (SASFormatInfo)this.formatInfo).isDecimalWidthSupported() && (dv = sfi.getDValue()) > 0) {
            result.append('.');
            result.append(dv);
        }
        return result.toString();
    }

    @Override
    public int getWidth() {
        return this.formatInfo.getWidth();
    }

    @Override
    public String getBaseFormatName() {
        return this.formatInfo.getBaseFormat();
    }

    @Override
    public int getDecimalWidth() {
        SASFormatInfo sfi;
        SASFormatEntry entry;
        int dw = -1;
        if (this.formatInfo instanceof SASFormatInfo && (entry = (SASFormatEntry)(sfi = (SASFormatInfo)this.formatInfo).getEntry()).isDecimalWidthSupported()) {
            dw = sfi.getDValue();
        }
        return dw;
    }

    public boolean isCharacterFormat() {
        return this.formatInfo.getBaseFormat().charAt(0) == '$';
    }

    public boolean isDateFormat() {
        return false;
    }

    public boolean isDateTimeFormat() {
        return false;
    }

    public boolean isTimeFormat() {
        return false;
    }

    public boolean isNumericFormat() {
        return false;
    }

    public boolean isUserDefinedFormat() {
        return false;
    }

    protected boolean isEURformatLocale() {
        Locale locale = this.formatInfo.getEntry().getFormatLocale() == null ? Locale.getDefault() : this.formatInfo.getEntry().getFormatLocale();
        for (int i = 0; i < EURfmtLocales.length; ++i) {
            if (!EURfmtLocales[i].equals(locale.getLanguage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.init();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setInsertBlanks(boolean trueOrFalse) {
        this.insertBlanks = trueOrFalse;
    }

    @Override
    public void setBaseFormatName(String baseFormat) {
    }

    @Override
    public void setWidth(int width) {
    }

    @Override
    public void setDecimalWidth(int decimal) {
    }

    public static void readFormat(Locale locale) {
        FormatDescription[] keys;
        Object[] nf = SASNumericFormat.getSupportedFormats(locale);
        Object[] dtf = SASDateTimeFormat.getSupportedFormats(locale);
        Object[] cf = SASCharacterFormat.getSupportedFormats();
        lookUpTable = new Hashtable(55);
        int i = 0;
        int k = 0;
        for (i = 0; i < nf.length; ++i) {
            keys = ((SASFormatEntry)nf[i]).getFormatDescription();
            for (k = 0; k < keys.length; ++k) {
                lookUpTable.put(keys[k].getBaseFormatName(), nf[i]);
            }
        }
        for (i = 0; i < dtf.length; ++i) {
            keys = ((SASFormatEntry)dtf[i]).getFormatDescription();
            for (k = 0; k < keys.length; ++k) {
                lookUpTable.put(keys[k].getBaseFormatName(), dtf[i]);
            }
        }
        for (i = 0; i < cf.length; ++i) {
            keys = ((SASFormatEntry)cf[i]).getFormatDescription();
            for (k = 0; k < keys.length; ++k) {
                lookUpTable.put(keys[k].getBaseFormatName(), cf[i]);
            }
        }
    }

    static void refreshFormatCache(Locale locale) {
        if (localeFormatCache == null) {
            localeFormatCache = new Hashtable();
            localeFormatCache.put(Locale.getDefault(), lookUpTable);
        }
        if (localeFormatCache.get(locale) != null) {
            return;
        }
        SASFormat.readFormat(locale);
        localeFormatCache.put(locale, lookUpTable);
    }

    public FormatDescription getFormatDescription() {
        return this.formatInfo.getEntry();
    }

    public static String jFormatFilter(String baseFormat) {
        String[][] JFORMAT_MAP = new String[][]{{"NLDATE", "JDATEMDW", "JDATEYDW", "JDATEYMD", "JDATEYMW", "JNENGO", "JNENGOW"}, {"NLTIME", "JTIMEHMS", "JTIMESW"}, {"NLDATM", "JDATEYT", "JDATEYTW", "JNENGOT", "JNENGOTW"}, {"NLDATEMN", "JDATEMNW", "JDATEMON"}, {"NLDATEWN", "JDATEWK"}, {"NLDATEYM", "JDATEYM"}, {"NLDATEMD", "JDATEMD"}, {"HOUR", "JTIMEH", "JTIMEHW"}, {"HHMM", "JTIMEHM", "JTIMEMW"}};
        if (baseFormat == null || !baseFormat.startsWith("J") && !baseFormat.startsWith("j")) {
            return baseFormat;
        }
        for (int row = 0; row < JFORMAT_MAP.length; ++row) {
            String[] jformats = JFORMAT_MAP[row];
            for (int col = 1; col < jformats.length; ++col) {
                String jf = jformats[col];
                if (!jf.equals(baseFormat.toUpperCase())) continue;
                return jformats[0];
            }
        }
        return baseFormat;
    }

    protected final boolean isDateInLimits(double date) {
        if (this.isDateFormat() & (date < -138061.0 || date > 6589335.0)) {
            return false;
        }
        return !(this.isDateTimeFormat() & (date < -1.19284704E10 || date > 5.69318630399E11));
    }

    public static void isValidFormat(String fmtname, Locale loc) throws InvalidFormatException {
        String[] pf = SASFormat.parseFormat(fmtname);
        String baseFormat = SASFormat.jFormatFilter(pf[0]);
        if (loc == null) {
            loc = Locale.getDefault();
        }
        SASFormat.refreshFormatCache(loc);
        Hashtable htLocFormat = (Hashtable)localeFormatCache.get(loc);
        TableEntry te = (TableEntry)htLocFormat.get(baseFormat);
        if (te != null) {
            int width;
            int n = width = pf[1] == null ? te.getDefaultWidth() : Integer.parseInt(pf[1], 10);
            if (width < te.getMinWidth() || width > te.getMaxWidth()) {
                throw new InvalidFormatWidthException("Width specified for format " + baseFormat + " is invalid.", baseFormat, te.getMinWidth(), te.getMaxWidth());
            }
        } else {
            throw new InvalidFormatNameException(baseFormat + " is invalid name.", baseFormat);
        }
    }

    public static SASFormat getInstance2(String fmtname, Locale loc) throws InvalidFormatException {
        SASFormat.isValidFormat(fmtname, loc);
        return SASFormat.getInstance(fmtname, loc);
    }

    protected boolean isDFormat() {
        return false;
    }

    protected void setDFormat(boolean value) {
    }

    public boolean isPercent() {
        return false;
    }

    static {
        DANISH = new Locale("da");
        FINNISH = new Locale("fi");
        SPANISH = new Locale("es");
        SWEDISH = new Locale("sv");
        NORWEGIAN = new Locale("no");
        DUTCH = new Locale("nl");
        PORTUGUESE = new Locale("pt");
        AFRIKAANS = Locale.US;
        CATALAN = new Locale("ca");
        HUNGARIAN = new Locale("hu");
        POLISH = new Locale("pl");
        CZECH = new Locale("cs");
        SLOVENIAN = new Locale("sl");
        CROATIAN = new Locale("hr");
        MACEDONIAN = new Locale("mk");
        RUSSIAN = new Locale("ru");
        FRENCH_SWITZERLAND = new Locale("fr", "CH");
        GERMAN_SWITZERLAND = new Locale("de", "CH");
        EURfmtLocales = new String[]{"en", "fr", "it", "de", "da", "fi", "es", "sv", "no", "nl", "pl", "ca", "hu", "po", "cs", "sl", "hr", "mk", "ru", "pt"};
        timezone = TimeZone.getDefault();
        SASFormat.readFormat(Locale.getDefault());
    }
}

