/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.net.BaseResourceLocator;
import com.sas.net.ResourceLocatorInterface;
import com.sas.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ClassResourceLocator
extends BaseResourceLocator
implements ResourceLocatorInterface {
    static final long serialVersionUID = 2407231415924293430L;
    protected Class _relativeClass;

    public ClassResourceLocator() {
    }

    public ClassResourceLocator(String resourceName) {
        super(resourceName);
    }

    public ClassResourceLocator(Class relClass) {
        this();
        this._relativeClass = relClass;
    }

    public ClassResourceLocator(String resourceName, Class relClass) {
        this(resourceName);
        this._relativeClass = relClass;
    }

    @Override
    public void setResourceName(String newValue) {
        if (newValue != null) {
            newValue = newValue.replace('\\', '/');
        }
        super.setResourceName(newValue);
    }

    public Class getRelativeClass() {
        return this._relativeClass;
    }

    public void setRelativeClass(Class newValue) {
        if (!Util.equal(this._relativeClass, newValue)) {
            Class oldValue = this._relativeClass;
            this._relativeClass = newValue;
            this.firePropertyChange("relativeClass", oldValue, newValue);
        }
    }

    @Override
    public URL getResource() throws MalformedURLException {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL newURL = null;
                try {
                    ClassLoader classLoader;
                    if (ClassResourceLocator.this.getRelativeClass() != null && (classLoader = ClassResourceLocator.this.getRelativeClass().getClassLoader()) != null && ClassResourceLocator.this.getResourceName() != null && (newURL = classLoader.getResource(ClassResourceLocator.this.getResourceName())) != null) {
                        return newURL;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (ClassResourceLocator.this.getResourceName() != null && ClassResourceLocator.this.getRelativeClass() != null) {
                    newURL = ClassResourceLocator.this.getRelativeClass().getResource(ClassResourceLocator.this.getResourceName());
                }
                return newURL;
            }
        });
        return url;
    }

    @Override
    public String encode() {
        return new String("Class: ~<" + this.getRelativeClass() + ">~ ~<" + this.getResourceName() + ">~");
    }

    public static ResourceLocatorInterface decode(String resource) {
        ClassResourceLocator crl = new ClassResourceLocator();
        if (resource.startsWith("Class: ")) {
            int index = resource.indexOf(">~");
            if (index != -1) {
                try {
                    crl.setRelativeClass(Class.forName(resource.substring(15, index)));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                crl.setResourceName(resource.substring(index + 5, resource.length() - 2));
            }
            return crl;
        }
        return null;
    }

    @Override
    protected ResourceLocatorInterface createInstance(String resource) {
        return ClassResourceLocator.decode(resource);
    }
}

