# Change log

## v0.5.0 (2021-06-01)
### Features
* An output method on Scope, providing output formatting
### Breaking changes
* Dropped the Evaluator class
### Miscellaneous
* Moved Metaschema, Vocabulary and Keyword into the vocabulary subpackage

## v0.4.0 (2021-05-21)
### Bug fixes
* Fixed error and annotation collection for array items (#8)
### Miscellaneous
* Improved and better encapsulated the Scope class's internal logic
* Added `doc` dependencies to setup.py
* Support testing with Python 3.10

## v0.3.0 (2021-05-15)
### Features
* Evaluator class providing output formatting
* Multiple Catalogue instances now supported; with an optional default catalogue
### Bug fixes
* Fixed percent-encoding of the URI fragment form of JSON pointers
### Documentation
* Created user guides and API reference documentation; published to Read the Docs
### Miscellaneous
* Improvements to base URI-directory mapping and file loading in the Catalogue
* Tweaks to annotation and error collection in the Scope class affecting output generation
* Auto-generated schema URIs are now formatted as `'urn:uuid:<uuid>'`

## v0.2.0 (2021-04-18)
### Features
* Class methods for constructing JSON instances from JSON strings/files
### Bug fixes
* Fixed unevaluatedItems-contains interaction
### Miscellaneous
* Top-level package API defined in `__init.py__`
* Improved handling of floats in JSON constructor input
* Removed mod operator from JSON class
* Added development setup (`pip install -e .[dev]`)
* Added JSON class usage info to the README

## v0.1.1 (2021-04-06)
### Bug fixes
* Fixed $dynamicRef resolution (#3)

## v0.1.0 (2021-03-31)
### Features
* JSON class implementing the JSON data model
* JSON Pointer implementation
* JSON Schema implementation, supporting drafts 2019-09 and 2020-12 of the specification
* Catalogue for managing (meta)schemas, vocabularies and format validators
* URI class (wraps rfc3986.URIReference)
