# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from lidarr.models.medium import Medium

class AlbumRelease(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    album_id: Optional[int]
    foreign_release_id: Optional[str]
    old_foreign_release_ids: Optional[List]
    title: Optional[str]
    status: Optional[str]
    duration: Optional[int]
    label: Optional[List]
    disambiguation: Optional[str]
    country: Optional[List]
    release_date: Optional[datetime]
    media: Optional[List]
    track_count: Optional[int]
    monitored: Optional[bool]
    album: Optional[AlbumLazyLoaded]
    tracks: Optional[TrackListLazyLoaded]
    __properties = ["id", "albumId", "foreignReleaseId", "oldForeignReleaseIds", "title", "status", "duration", "label", "disambiguation", "country", "releaseDate", "media", "trackCount", "monitored", "album", "tracks"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AlbumRelease:
        """Create an instance of AlbumRelease from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in media (list)
        _items = []
        if self.media:
            for _item in self.media:
                if _item:
                    _items.append(_item.to_dict())
            _dict['media'] = _items
        # override the default output from pydantic by calling `to_dict()` of album
        if self.album:
            _dict['album'] = self.album.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tracks
        if self.tracks:
            _dict['tracks'] = self.tracks.to_dict()
        # set to None if foreign_release_id (nullable) is None
        if self.foreign_release_id is None:
            _dict['foreignReleaseId'] = None

        # set to None if old_foreign_release_ids (nullable) is None
        if self.old_foreign_release_ids is None:
            _dict['oldForeignReleaseIds'] = None

        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        # set to None if status (nullable) is None
        if self.status is None:
            _dict['status'] = None

        # set to None if label (nullable) is None
        if self.label is None:
            _dict['label'] = None

        # set to None if disambiguation (nullable) is None
        if self.disambiguation is None:
            _dict['disambiguation'] = None

        # set to None if country (nullable) is None
        if self.country is None:
            _dict['country'] = None

        # set to None if release_date (nullable) is None
        if self.release_date is None:
            _dict['releaseDate'] = None

        # set to None if media (nullable) is None
        if self.media is None:
            _dict['media'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AlbumRelease:
        """Create an instance of AlbumRelease from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AlbumRelease.parse_obj(obj)

        _obj = AlbumRelease.parse_obj({
            "id": obj.get("id"),
            "album_id": obj.get("albumId"),
            "foreign_release_id": obj.get("foreignReleaseId"),
            "old_foreign_release_ids": obj.get("oldForeignReleaseIds"),
            "title": obj.get("title"),
            "status": obj.get("status"),
            "duration": obj.get("duration"),
            "label": obj.get("label"),
            "disambiguation": obj.get("disambiguation"),
            "country": obj.get("country"),
            "release_date": obj.get("releaseDate"),
            "media": [Medium.from_dict(_item) for _item in obj.get("media")] if obj.get("media") is not None else None,
            "track_count": obj.get("trackCount"),
            "monitored": obj.get("monitored"),
            "album": AlbumLazyLoaded.from_dict(obj.get("album")) if obj.get("album") is not None else None,
            "tracks": TrackListLazyLoaded.from_dict(obj.get("tracks")) if obj.get("tracks") is not None else None
        })
        return _obj

