"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The width of the grid we're filling
 */
exports.GRID_WIDTH = 24;
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position
 *
 * This is in contrast to other widgets which exist for layout purposes.
 */
class ConcreteWidget {
    constructor(width, height) {
        this.width = width;
        this.height = height;
        if (this.width > exports.GRID_WIDTH) {
            throw new Error(`Widget is too wide, max ${exports.GRID_WIDTH} units allowed`);
        }
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.ConcreteWidget = ConcreteWidget;
//# sourceMappingURL=data:application/json;base64,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