import { FileAssetPackaging } from '../file-asset';
/**
 * Validate that a given key is of a given type in an object
 *
 * If not optional, the key is considered required.
 *
 * Uses predicate validators that return a 'witness', so we can use the return type of
 * the validator function to infer the actual type of the value and enrich the type information
 * of the given input field.
 *
 * In effect, validators should be written like this:
 *
 *   if (!valid(input)) { throw; }
 *   return input;
 */
export declare function expectKey<K extends string, A extends object, R, P extends (x: unknown) => R>(obj: A, key: K, validate: P, optional?: boolean): asserts obj is A & {
    [k in K]: ReturnType<P>;
};
export declare function isString(x: unknown): string;
export declare function isMapOf<T>(pred: (e: unknown) => T): (x: unknown) => Record<string, T>;
export declare function isObjectAnd<A>(p: (x: object) => A): (x: unknown) => A;
export declare function assertIsObject(x: unknown): asserts x is object;
export declare function isFileAssetPackaging(x: unknown): FileAssetPackaging;
