# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['trakt_scrobbler',
 'trakt_scrobbler.commands',
 'trakt_scrobbler.player_monitors']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.3,<2.0.0',
 'cleo>=0.7.6,<0.8.0',
 'confuse>=1.1.0,<2.0.0',
 'guessit>=3.1.0,<4.0.0',
 'requests>=2.22.0,<3.0.0',
 'toml>=0.10.0,<0.11.0']

extras_require = \
{':sys_platform == "win32"': ['pywin32>=227,<228', 'win10toast>=0.9,<0.10'],
 'socks': ['pysocks>=1.7.1,<2.0.0']}

entry_points = \
{'console_scripts': ['trakts = trakt_scrobbler.console:main']}

setup_kwargs = {
    'name': 'trakt-scrobbler',
    'version': '1.0.0b8',
    'description': 'Scrobbler for trakt.tv that supports VLC, Plex, MPC-HC, and MPV',
    'long_description': '# Trakt Scrobbler\n\nA trakt.tv scrobbler for your computer.\n\n## What is Trakt?\n\nAutomatically scrobble TV show episodes and movies you are watching to [Trakt.tv](https://trakt.tv)! It keeps a history of everything you\'ve watched!\n\n## What is trakt-scrobbler?\n\nTrakt.tv has a lot of [plugins](https://trakt.tv/apps) to automatically scrobble the movies and episodes you watch from your media center. But there is a dearth of up-to-date apps for syncing your progress on Desktop environments. This is where `trakt-scrobbler` comes in! It is a Python application that runs in the background and monitors your media players for any new activity. When it detects some file being played, it determines the media info (such as name of the movie/show, episode number, etc.) and sends this to trakt servers, so that it can be marked as "Currently Watching" on your profile. No manual intervention required!\n\n## Features\n\n*   Full featured command line interface to control the service. Just run `trakts`.\n*   Automatic media info extraction using [guessit](https://github.com/guessit-io/guessit).\n*   Scrobbling is independent of the player(s) where the media is played. Support for new players can thus be easily added.\n*   Currently supports:\n    *   [VLC](https://www.videolan.org/vlc/) (via web interface)\n    *   [Plex](https://www.plex.tv) (doesn\'t require Plex Pass)\n    *   [MPV](https://mpv.io) (via IPC server)\n    *   [MPC-BE](https://sourceforge.net/projects/mpcbe/)/[MPC-HC](https://mpc-hc.org) (via web interface).\n*   **Folder whitelisting:** Only media files from subdirectories of these folders are synced with trakt.\n*   Optionally, you can receive a quick notification that the media start/pause/stop activity has been scrobbled.\n*   For cases when it misidentifies the files, you can specify a regex to manually extract the necessary details.\n*   Proxy support: Optionally specify a proxy server to handle all communication with trakt servers!\n\nFor more information, see the [`How it works`](#how-it-works) section.\n\n## Getting started\n\n### Players\n\n*   **VLC:** Enable the Lua Web Interface from advanced options. Don\'t forget to specify the password in Lua options.\n\n      ![VLC Web Interface](https://wiki.videolan.org/images/thumb/VLC_2.0_Activate_HTTP.png/450px-VLC_2.0_Activate_HTTP.png)\n\n*   **Plex:** No server side set up is required, as the app uses the existing API. Do note that since this is a polling based approach, it will be inferior to Webhooks. So if you are a premium user of Plex, it is recommended to use that directly. This app is mainly useful for those users who don\'t need most of the features of Plex Pass.\n\n*   **MPV:** Enable the [JSON IPC](https://mpv.io/manual/master/#json-ipc), **either** via .conf file or as a command line option:\n    *   **mpv.conf** (Recommended): Add `input-ipc-server=<path>` to the top of the [`mpv.conf` file](https://mpv.io/manual/master/#configuration-files). (Linux: `~/.config/mpv/mpv.conf`, Windows: `C:\\users\\<USERNAME>\\AppData\\Roaming\\mpv\\mpv.conf`)\n    *   **Command line** (If you are using a wrapper over mpv): `mpv file.mkv --input-ipc-server=/tmp/mpvsocket` (linux) and `mpv file.mkv --input-ipc-server=\\\\.\\pipe\\mpvsocket` (windows). Note that in this case, the scrobbler won\'t be able to autodetect the path, so you need to manually add that using `trakts config set players.mpv.ipc_path <PATH>`\n\n*   **MPC-BE/MPC-HC:** Enable the web interface from Options.\n\n### Installation\n(For updating, see [FAQ section](#how-to-update))  \nFor Arch (and its derivatives) users: An AUR package exists at [trakt-scrobbler](https://aur.archlinux.org/packages/trakt-scrobbler/), thanks to [@ahmubashshir](https://github.com/ahmubashshir).\n\n**Windows/Mac/Linux installation steps:**\n1.  Open a terminal/powershell.\n2.  Ensure you have [Python 3.7](https://www.python.org/downloads/) or higher installed, and in your system `PATH`. (Check by running `python --version`)\n3.  Ensure `pip` is installed. (Check: `pip --version`)\n4.  Install [`pipx`](https://pipxproject.github.io/pipx/):  \n    MacOS:\n    ```bash\n    brew install pipx\n    pipx ensurepath\n    ```\n    Linux and windows (replace `python3` with `python` if the commands fail):\n    ```bash\n    python3 -m pip install --user pipx\n    python3 -m pipx ensurepath\n    ```\n    (Windows users may require a reboot after this step)\n5.  Run `pipx install trakt-scrobbler`. You will now have the `trakts` command available.  \nFor SOCKS proxy support, use `pipx install "trakt-scrobbler[socks]"`.\n6.  Run `trakts init`. You will be prompted to select the players to be monitored, and authorize the app to access the Trakt.tv API on your behalf. Follow the steps on screen to finish the process.\n\n**For Linux:**\nTo enable notification support on Linux, `libnotify` needs to be installed (Reboot after installation).\n\n*   Arch/Manjaro: `pacman -S libnotify`\n*   Ubuntu: `apt install libnotify-bin`\n\n## `trakts` command usage:\n\nAll commands have descriptive help messages available. So in case of doubt, simply add `--help` to the (sub)command to see the help docs (Example: `trakts autostart --help` and `trakts --help`). For reference, the various available commands are:\n\n*   `auth`: Shows the status of the trakt authentication. If no token is found, or if the token in expired, it runs the authetication flow for trakt.tv  \n    You can pass `--force` option to make it ignore the existing token, and force the authentication again.\n\n*   `autostart`: Controls the autostart behaviour of the scrobbler\n\n*   `backlog`: Manage the backlog of watched media yet to be synced with trakt servers (mostly due to internet connectivity issues). Read [this](#backlog-cleaner) for more info\n\n    *   `list`: Lists all the files in the backlog\n\n    *   `clear`: Try to add the unsynced files to trakt history\n\n*   `config`: Edits the scrobbler config settings. See [Configuration](#configuration) section for more details\n\n    *   `list`: This command will list the parameters in the config, along with their current values.\n          Eg: `trakts config list`\n\n            players.monitored = [\'mpv\', \'vlc\']\n            players.skip_interval = 5\n            general.enable_notifs = True\n            fileinfo.whitelist = [\'/path/to/movies\', \'/path/to/anime\', \'/path/to/TV\']\n\n          Additionally, it also accepts a `--all` option, which can be used to list *ALL* the config parameters, including those not overriden by the user.\n\n    *   `set`: Set the value for a config parameter.\n\n        *   Separate multiple values with spaces. \n              Eg: `trakts config set players.monitored mpv vlc mpc-be`\n\n                User config updated with \'players.monitored = [\'mpv\', \'vlc\', \'mpc-be\']\'\n\n        *   For values containing space(s), surround them with double-quotes. \n              Eg: `trakts config set fileinfo.whitelist D:\\Media\\Movies "C:\\Users\\My Name\\Shows"`\n\n                User config updated with \'fileinfo.whitelist = [\'D:\\\\Media\\\\Movies\', \'C:\\\\Users\\\\My Name\\\\Shows\']\'\n\n        *   Use `--add` to avoid overwriting the previous list values (whitelist, monitored, etc.):  \n              `trakts config set players.monitored mpv vlc`  \n              `trakts config set --add players.monitored plex mpc-hc`  \n              will have final value: \n\n                User config updated with \'players.monitored = [\'mpv\', \'vlc\', \'plex\', \'mpc-hc\']\'\n    *   `unset`: Reset a config value to its default.\n\n*   `init`: Runs the initial setup of the scrobbler.\n*   `log`: Access the log file, mainly for debugging purposes.  \n    Subcommands: (Run as `trakts log <subcommand>`)\n    *   `open`: Opens the latest log file in your default editor.\n    *   `path`: Prints the location of the log file.\n*   `plex`: Command to run the auth flow for Plex.\n    You can pass `--force` option to make it ignore the existing token, and force the authentication again.\n*   `run`: Run the scrobbler in the foreground. Mainly needed in case you have disabled the autostart service, and want to run the app manually.\n*   `start`: Starts the trakt-scrobbler service. If already running, does nothing.\n    *   Use `--restart` to force restart the service.\n*   `status`: Shows the status trakt-scrobbler service.\n*   `stop`: Stops the trakt-scrobbler service.\n*   `whitelist`: Shortcut command to add folder(s) to whitelist in config.\n    *   `add`: Add folder(s) to whitelist.  \n           Eg: `trakts whitelist add D:\\Media\\Movies "C:\\Users\\My Name\\Shows"`  \n        *For folders containing spaces, use double quotes*\n\n    *   `show`: List the current folders in whitelist.\n    *   `remove`: Interactively remove folder(s) from whitelist.\n\n## FAQs\n\n#### It doesn\'t work. What do I do?\n\nFirst, look through the log file (using the `trakts log` command) to see what went wrong. If you are unable to fix the problem, feel free to create an [Issue](https://github.com/iamkroot/trakt-scrobbler/issues).\n\n#### How to update?\n\n1.  Stop the app using `trakts stop`\n2.  Run `pipx upgrade trakt-scrobbler`\n3.  Start the app again using `trakts start`\n\n#### How to update from pre 1.0.0 versions?\n\nThere has been a major UX overhaul with v1.0.0, due to the introduction of the `trakts` command, changes in how config is stored and a much simpler way of installation. So long story short, you will have to remove the older version and re-install using the [new method](#installation). In some cases, you may also have to set some configuration parameters again, if you have custom overrides - use `trakts config` command for that.\n\n**Old version uninstall steps:**  \nIn a terminal/command prompt, run the following commands:\n*   **Linux**\n    1.  `systemctl --user stop trakt-scrobbler` to stop the background service.\n    2.  `cd ~/.local/trakt-scrobbler/ && poetry env remove python3` to remove python environment.\n    3.  `cd ~ && rm -rf ~/.local/trakt-scrobbler` to remove installed code files.\n*   **MacOS**\n    1.  `launchctl stop com.github.iamkroot.trakt-scrobbler` to stop the background service.\n    2.  `cd ~/Library/trakt-scrobbler && poetry env remove python3` to remove python environment.\n    3.  `cd ~ && rm -rf ~/Library/trakt-scrobbler` to remove installed code files.\n*   **Windows**\n    1.  `taskkill /im pythonw.exe` to stop the background service.\n    2.  `del "%APPDATA%\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\trakt-scrobbler.bat"` to delete the autostart script.\n    3.  `cd "%LOCALAPPDATA%\\trakt-scrobbler"`\n    4.  `poetry env remove python3` to remove python environment.\n    5.  `cd %LOCALAPPDATA%`\n    5.  `rd /S /Q "%LOCALAPPDATA%\\trakt-scrobbler"` to remove installed code files.\n\nYou should also uninstall poetry if you don\'t require it:\n*   `osx / linux / bashonwindows`: `POETRY_UNINSTALL=1 curl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python`\n*   `windows powershell`: `$env:POETRY_UNINSTALL = 1; (Invoke-WebRequest -Uri https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python`\n\nAfter this, you can install the new version using steps in [Installation](#installation) section.\n\n#### Where is the log file/other data stored?\n\n*   **Linux:** `~/.local/share/trakt-scrobbler/`\n*   **Mac:** `~/Library/Application Support/trakt-scrobbler/`\n*   **Windows:** `%APPDATA%\\trakt-scrobbler\\`\n\nThe latest log is stored in a file named `trakt_scrobbler.log`; older logs can be found in the files `...log.1`, `...log.2`, and so on.\nEverything is in human readable form, so that you can figure out what data is used by the app. While submitting a bug report, be sure to include the log file contents.\n\n## How it works\n\nThis is an application written in the Python programming language, designed for hassle-free integration of your media players with Trakt. Once set up, you can forget that it exists.\n\n*   The app is designed to start with your PC, and remain running in the backgroud.\n*   It has a "monitor" for each media player you specify. This monitor keeps checking if the media player is running or not. If not, you get the "Could not connect..." message in the log file.\n*   When the player is running, the monitor extracts the currently playing media information from the player.\n*   This media file path is parsed using `guessit` (or regexes, if specified) to recognize the metadata such as "Title", "Season", etc. (See: [Identifying Media](#identifying-media))\n*   This info, along with the playing state (`playing`, `stopped` or `paused`) and progress are then sent to trakt.tv using their API to update their side and mark the media as "Currently Watching", "Finished", etc and you get a notification of the same.\n*   Once the player is closed, the monitor goes back to "dormant" state, where it waits for the player to start again.\n\n### Other details\n\n#### Polling for activity\n\nThe checking for media info from player happens at a set interval (`poll_interval` in config, 10 secs by default), which is the maximum delay between you starting/stopping/pausing the player, and the monitor recognizing that activity.\n\n#### Identifying media\n\nHere\'s a brief overview of how the scrobbler identifies the movie/show:\n1. It uses the file path of the media being played and extracts the title, season, ep, year, etc. using some heuristics. Note that this is very much prone to errors, so make sure your media directories are organized and named properly.\n2. Next, just like you would in real life, the app uses Trakt search to find the corresponding show/movie in the trakt servers. The search is mainly done on the info extracted from step 1: the title, the type (movie or show), and year (if available). It picks the topmost result that trakt gives, since that has the highest score and matches our given info the most. Again, this is prone to errors, since the trakt search result might not be the actual movie/show being played.\n3. This returned trakt result (as a numeric ID) is stored on your PC, and every time you play the same movie/show, this numeric id is used to identify the media on trakt servers. This means that the search happens only for the first time a movie/show is played.\n\n#### Backlog Cleaner\n\nGenerally, this app provides "live" updates to trakt regarding your playing status. However, it may happen that the app is unable to communicate with trakt servers (probably due to connection issues), and thus scrobbling updates won\'t be meaningful. For such cases, the app maintains a "backlog cleaner" which remembers the media that you have finished watching (progress > 80%) and will try to sync that information with trakt the next time its servers are reachable.\n\n## Configuration\n\n*   The config is stored in [YAML](https://yaml.org) format.\n\n*   Most parameters have default values, stored in [`config_default.yaml`](trakt_scrobbler/config_default.yaml). \n\n*   The file is hierarchical, with multiple sections such as `general`, `players`, etc.\n\n*   Everything you see on the left hand side of a `:` is a *key*. This means `players` is a key, `vlc` is a key, and so is `poll_interval`.\n\n*   You can use the `config` command to override the values easily. (See [Commands Reference](#trakts-command-usage))\n\n*   To access a config parameter, use the dotted-notation - use a `.` to go down a hierarchy level.  \n    Example: `players.vlc.poll_interval` selects what you think it selects :P  \n    (The `_` is not special, it\'s just a way for programmers to represent spaces in names)\n\n### Reference\n*   `general`\n    *   `enable_notifs`: (Default: `true`) Enable notifications after successful scrobbles.\n    *   `proxies`: (Default: `{}`)\n        *   Defines the proxies to be used for external connections.\n        *   See [this](https://requests.readthedocs.io/en/latest/user/advanced/#proxies) for format.\n        *   Example command: `trakts config set general.proxies.https "socks5://my-proxy.example.com:1234"`  \n            This adds a `SOCKSv5` proxy for the `HTTPS` protocol, and is identical to setting `proxies = {\'https\': \'socks5://my-proxy.example.com:1234\'}` in the Python `requests` library, or in `YML` form:\n            ```yml\n            proxies:\n                https: socks5://my-proxy.example.com:1234\n            ```\n*   `fileinfo`:\n    *   `whitelist`: (List of folder path strings | Default: `[]` aka Allow all)\n        *   List of directories you want to be scanned for shows or movies.\n        *   If empty, all files played in the player are scanned.\n        *   You can prevent the program from scanning all played files if your shows and movies are located in fixed directories.\n        *   If possible you should use this option to minimize traffic on the Trakt API.\n    *   `include_regexes`: (Default: `{movie = [], episode = []}`)\n        *   If you find that the default module for identifying media info ([guessit](https://github.com/guessit-io/guessit)) is misidentifying some titles, you can specify the regex for that file path.\n        *   The regex should have posix-like path, and not Windows\' `\\` to separate directories.\n        *   The minimum required information is the title of the file, and episode number in the case of TV Shows. If season is not found, it defaults to 1.\n        *   Example command: `trakts config set --add fileinfo.include_regexes.episode ".*/(?P<title>.+?)(\\s\\[[0-9]{3,4}p\\])?/(?P<episode>\\d+) - (?:.*)"`  \n            This adds a new regex string (everything between the `"`) to the list of episode regexes, which can be used to extract info from Anime episodes of the form `Name of anime [720p]/12 - episode name.mkv`\n        *   If season is not provided, it will default to `1`. This is mainly useful for anime since they don\'t follow the SxxExx format and fail to be recognized by the default parser. \n*   `players`:\n    *   `monitored`: (List of player names | Default: `[]`) Specify players which are to be monitored for scrobbling.\n    *   `skip_interval`: (Default: `5`) Min percent jump to consider for scrobbling to trakt. Useful when you skip ahead a few seconds, and don\'t want to spam the trakt API.\n    *   Other player specific parameters: For most installations, you won\'t have to fiddle with these as the app can automatically read the settings of the players and extract the necessary values.\n*   `backlog`:\n    *   `clear_interval`: (Default: `1800` i.e., 30 minutes) How often the app should try to sync previously failed scrobbles with trakt.\n    *   `expiry`: (Default: `2592000` i.e., 30 days) The maximum time an item can remain in the backlog.\n\n## TODO\n\n*   [x] Switch to poetry for dependency management\n*   [x] Make a unified installer script for all OSes\n*   [x] Proper configuration management module with autodetection for players\n*   [x] A CLI for controlling the app (start, stop, config, etc.)\n*   [ ] Use a proper [Windows Service](http://thepythoncorner.com/dev/how-to-create-a-windows-service-in-python/) instead of an autostart script\n\n## Contributing\n\nFeel free to create a new issue in case you find a bug/want to have a feature added. Proper PRs are welcome.\n\n## Authors\n\n*   [iamkroot](https://www.github.com/iamkroot)\n\n## Acknowledgements\n\n*   Inspired from [TraktForVLC](https://github.com/XaF/TraktForVLC)\n*   [mpv-trakt-sync-daemon](https://github.com/stareInTheAir/mpv-trakt-sync-daemon) was a huge help in making the mpv monitor\n',
    'author': 'iamkroot',
    'author_email': 'kroot.patel@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/iamkroot/trakt-scrobbler',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
