"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class FargateToSqs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        if (props.queuePermissions) {
            defaults.CheckListValues(['Read', 'Write'], props.queuePermissions, 'queue permission');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SQS);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            const createFargateServiceResponse = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
            this.service = createFargateServiceResponse.service;
            this.container = createFargateServiceResponse.containerDefinition;
        }
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the SQS Queue
        const buildQueueResponse = defaults.buildQueue(this, `${id}-queue`, {
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            existingQueueObj: props.existingQueueObj,
            enableEncryptionWithCustomerManagedKey: props.enableEncryptionWithCustomerManagedKey,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        this.sqsQueue = buildQueueResponse.queue;
        // Enable message send and receive permissions for Fargate service by default
        if (props.queuePermissions) {
            if (props.queuePermissions.includes('Read')) {
                this.sqsQueue.grantConsumeMessages(this.service.taskDefinition.taskRole);
            }
            if (props.queuePermissions.includes('Write')) {
                this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
            }
        }
        else {
            this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
        }
        // Setting environment variables
        const queueArnEnvironmentVariableName = props.queueArnEnvironmentVariableName || 'SQS_QUEUE_ARN';
        this.container.addEnvironment(queueArnEnvironmentVariableName, this.sqsQueue.queueArn);
        const queueUrlEnvironmentVariableName = props.queueUrlEnvironmentVariableName || 'SQS_QUEUE_URL';
        this.container.addEnvironment(queueUrlEnvironmentVariableName, this.sqsQueue.queueUrl);
    }
}
exports.FargateToSqs = FargateToSqs;
_a = JSII_RTTI_SYMBOL_1;
FargateToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-sqs.FargateToSqs", version: "2.36.0" };
//# sourceMappingURL=data:application/json;base64,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