# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['getpaid_payu']

package_data = \
{'': ['*'], 'getpaid_payu': ['templates/getpaid_payu/*']}

install_requires = \
['django-getpaid>=2.3.0,<3.0.0',
 'swapper>=1.1.2,<2.0.0',
 'typing-extensions>=3.10.0,<4.0.0']

extras_require = \
{'test': ['pytest>=6.2.4,<7.0.0',
          'codecov>=2.1.11,<3.0.0',
          'coverage>=5.5,<6.0',
          'requests>=2.25.1,<3.0.0',
          'requests-mock>=1.9.3,<2.0.0',
          'pytest-cov>=2.12.1,<3.0.0',
          'pytest-django>=4.4.0,<5.0.0',
          'pytest-factoryboy>=2.1.0,<3.0.0']}

setup_kwargs = {
    'name': 'django-getpaid-payu',
    'version': '0.2.1',
    'description': 'Django-GetPaid plugin for PayU service.',
    'long_description': '.. image:: https://img.shields.io/pypi/v/django-getpaid-payu.svg\n    :target: https://pypi.org/project/django-getpaid-payu/\n    :alt: Latest PyPI version\n.. image:: https://github.com/django-getpaid/django-getpaid-payu/actions/workflows/run_tox.yml/badge.svg\n    :target: https://github.com/django-getpaid/django-getpaid-payu/actions/\n.. image:: https://img.shields.io/pypi/wheel/django-getpaid-payu.svg\n    :target: https://pypi.org/project/django-getpaid-payu/\n.. image:: https://img.shields.io/pypi/l/django-getpaid-payu.svg\n    :target: https://pypi.org/project/django-getpaid-payu/\n\n===================\ndjango-getpaid-payu\n===================\n\nDjango-getpaid plugin for PayU service.\n\n.. note::\n\n    This is Alpha-quality software. You are more than welcome to `send PRs <https://github.com/django-getpaid/django-getpaid-payu>`_\n    with fixes and new features.\n\nInstallation\n============\n\nFirst make sure that `django-getpaid <https://django-getpaid.readthedocs.io/>`_ is installed and configured.\n\nThen, simply install the plugin:\n\n.. code-block:: shell\n\n    pip install django-getpaid-payu\n\nThis should pull django-getpaid in case it\'s not installed yet.\n\n\nConfiguration\n=============\n\nAdd ``"getpaid_payu"`` to your ``INSTALLED_APPS`` and add plugin configuration.\n\n.. code-block:: python\n\n    # settings.py\n\n    INSTALLED_APPS = [\n        # ...\n        "getpaid",\n        "getpaid_payu",\n    ]\n\n    GETPAID_BACKEND_SETTINGS = {\n        "getpaid_payu": {\n            # take these from your merchant panel:\n            "pos_id": 12345,\n            "second_key": "91ae651578c5b5aa93f2d38a9be8ce11",\n            "oauth_id": 12345,\n            "oauth_secret": "12f071174cb7eb79d4aac5bc2f07563f",\n        },\n        # ...\n    }\n\n.. note::\n\n    If ``DEBUG`` setting is set to ``True``, the plugin will use the sandbox API.\n\nThat should be enough to make your ``django-getpaid`` integration use new plugin\nand allow you to choose PayU for supported currencies.\n\nOther settings\n--------------\n\nYou can change additional settings for the plugin:\n\nconfirmation_method\n~~~~~~~~~~~~~~~~~~~\n\n* PUSH - paywall will send status updates to the callback endpoint hence updating status automatically\n* PULL - each Payment has to be verified by calling its ``fetch_and_update_status()``, eg. from a Celery task.\n\nDefault: PUSH\n\npaywall_method\n~~~~~~~~~~~~~~\n\n* REST - payment will be created using REST api call to paywall\n* POST - an extra screen will be displayed with a confirmation button that will\n  send all Payment params to paywall using POST. This is not recommended by PayU.\n\nLicence\n=======\n\nMIT\n\nAuthors\n=======\n\n`Dominik Kozaczko <https://github.com/dekoza/>`_\n',
    'author': 'Dominik Kozaczko',
    'author_email': 'dominik@kozaczko.info',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/django-getpaid/django-getpaid-payu',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
