# coding: utf-8

"""
    DocuSign Rooms API - v2

    An API for an integrator to access the features of DocuSign Rooms  # noqa: E501

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class RoomsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_document_to_room(self, room_id, account_id, **kwargs):
        """
        Add a document to a 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_document_to_room(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param Document body:
        :return: RoomDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_document_to_room_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.add_document_to_room_with_http_info(room_id, account_id, **kwargs)
            return data

    def add_document_to_room_with_http_info(self, room_id, account_id, **kwargs):
        """
        Add a document to a 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_document_to_room_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param Document body:
        :return: RoomDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_document_to_room" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `add_document_to_room`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `add_document_to_room`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomDocument',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_document_to_room_via_file_upload(self, room_id, account_id, **kwargs):
        """
        Add a document to a room via file contents upload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_document_to_room_via_file_upload(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param file file:
        :return: RoomDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_document_to_room_via_file_upload_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.add_document_to_room_via_file_upload_with_http_info(room_id, account_id, **kwargs)
            return data

    def add_document_to_room_via_file_upload_with_http_info(self, room_id, account_id, **kwargs):
        """
        Add a document to a room via file contents upload.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_document_to_room_via_file_upload_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param file file:
        :return: RoomDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'file']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_document_to_room_via_file_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `add_document_to_room_via_file_upload`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `add_document_to_room_via_file_upload`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/documents/contents'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomDocument',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_form_to_room(self, room_id, account_id, **kwargs):
        """
        Adds a DocuSign Form to a room
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_form_to_room(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: Id of the room to which the DocuSign Form is being added (required)
        :param str account_id: (required)
        :param FormForAdd body:
        :return: RoomDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_form_to_room_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.add_form_to_room_with_http_info(room_id, account_id, **kwargs)
            return data

    def add_form_to_room_with_http_info(self, room_id, account_id, **kwargs):
        """
        Adds a DocuSign Form to a room
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_form_to_room_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: Id of the room to which the DocuSign Form is being added (required)
        :param str account_id: (required)
        :param FormForAdd body:
        :return: RoomDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_form_to_room" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `add_form_to_room`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `add_form_to_room`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/forms'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomDocument',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_room(self, account_id, **kwargs):
        """
        Creates a new Room
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_room(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param RoomForCreate body:
        :return: Room
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_room_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_room_with_http_info(account_id, **kwargs)
            return data

    def create_room_with_http_info(self, account_id, **kwargs):
        """
        Creates a new Room
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_room_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param RoomForCreate body:
        :return: Room
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_room" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_room`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Room',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_room(self, room_id, account_id, **kwargs):
        """
        Deletes the room having the given room ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_room(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: ID of the room to be deleted. (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_room_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.delete_room_with_http_info(room_id, account_id, **kwargs)
            return data

    def delete_room_with_http_info(self, room_id, account_id, **kwargs):
        """
        Deletes the room having the given room ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_room_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: ID of the room to be deleted. (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_room" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `delete_room`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_room`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_assignable_roles(self, room_id, account_id, **kwargs):
        """
        Returns the roles for which the calling user, based on their role within the room, can assign to invitees.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assignable_roles(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param str assignee_email: Optional parameter indicating to only return roles (internal/external) assignable to this user.
        :param str filter: 
        :param int start_position: 
        :param int count: 
        :return: AssignableRoles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_assignable_roles_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.get_assignable_roles_with_http_info(room_id, account_id, **kwargs)
            return data

    def get_assignable_roles_with_http_info(self, room_id, account_id, **kwargs):
        """
        Returns the roles for which the calling user, based on their role within the room, can assign to invitees.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assignable_roles_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param str assignee_email: Optional parameter indicating to only return roles (internal/external) assignable to this user.
        :param str filter: 
        :param int start_position: 
        :param int count: 
        :return: AssignableRoles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'assignee_email', 'filter', 'start_position', 'count']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assignable_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `get_assignable_roles`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_assignable_roles`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/assignable_roles'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'assignee_email' in params:
            query_params['assigneeEmail'] = params['assignee_email']
        if 'filter' in params:
            query_params['filter'] = params['filter']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']
        if 'count' in params:
            query_params['count'] = params['count']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AssignableRoles',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_documents(self, room_id, account_id, **kwargs):
        """
        Get documents in the room accessible to the calling user.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_documents(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param int count: Number of documents to return. Defaults to the maximum which is 100.
        :param int start_position: Position of the first item in the total results. Defaults to 0.
        :return: RoomDocumentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_documents_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.get_documents_with_http_info(room_id, account_id, **kwargs)
            return data

    def get_documents_with_http_info(self, room_id, account_id, **kwargs):
        """
        Get documents in the room accessible to the calling user.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_documents_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param int count: Number of documents to return. Defaults to the maximum which is 100.
        :param int start_position: Position of the first item in the total results. Defaults to 0.
        :return: RoomDocumentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'count', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `get_documents`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_documents`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomDocumentList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_room(self, room_id, account_id, **kwargs):
        """
        Gets information about the given 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param bool include_field_data: Indicates if field data (a.k.a., room details) should be included in the response. Defaults to false.
        :return: Room
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_room_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.get_room_with_http_info(room_id, account_id, **kwargs)
            return data

    def get_room_with_http_info(self, room_id, account_id, **kwargs):
        """
        Gets information about the given 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param bool include_field_data: Indicates if field data (a.k.a., room details) should be included in the response. Defaults to false.
        :return: Room
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'include_field_data']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_room" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `get_room`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_room`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'include_field_data' in params:
            query_params['includeFieldData'] = params['include_field_data']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Room',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_room_field_data(self, room_id, account_id, **kwargs):
        """
        Returns the FieldData associated with the provided roomId.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_field_data(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :return: FieldData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_room_field_data_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.get_room_field_data_with_http_info(room_id, account_id, **kwargs)
            return data

    def get_room_field_data_with_http_info(self, room_id, account_id, **kwargs):
        """
        Returns the FieldData associated with the provided roomId.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_field_data_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :return: FieldData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_room_field_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `get_room_field_data`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_room_field_data`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/field_data'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FieldData',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_room_field_set(self, room_id, account_id, **kwargs):
        """
        Gets the field set associated with the 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_field_set(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :return: FieldSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_room_field_set_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.get_room_field_set_with_http_info(room_id, account_id, **kwargs)
            return data

    def get_room_field_set_with_http_info(self, room_id, account_id, **kwargs):
        """
        Gets the field set associated with the 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_field_set_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :return: FieldSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_room_field_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `get_room_field_set`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_room_field_set`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/field_set'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FieldSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_room_users(self, room_id, account_id, **kwargs):
        """
        Retrieves the list of users in the given 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_users(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param int count: Number of room users to return. Defaults to the maximum which is 100.
        :param int start_position: Position of the first item in the total results. Defaults to 0.
        :param str filter: Returns room users filtered by Name and Email.
        :param str sort: Sorts results. Options are FirstNameAsc, FirstNameDesc, LastNameAsc, LastNameDesc, EmailAsc, EmailDesc. Defaults to LastNameDesc
        :return: RoomUsersResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_room_users_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.get_room_users_with_http_info(room_id, account_id, **kwargs)
            return data

    def get_room_users_with_http_info(self, room_id, account_id, **kwargs):
        """
        Retrieves the list of users in the given 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_room_users_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param int count: Number of room users to return. Defaults to the maximum which is 100.
        :param int start_position: Position of the first item in the total results. Defaults to 0.
        :param str filter: Returns room users filtered by Name and Email.
        :param str sort: Sorts results. Options are FirstNameAsc, FirstNameDesc, LastNameAsc, LastNameDesc, EmailAsc, EmailDesc. Defaults to LastNameDesc
        :return: RoomUsersResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'count', 'start_position', 'filter', 'sort']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_room_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `get_room_users`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_room_users`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']
        if 'filter' in params:
            query_params['filter'] = params['filter']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomUsersResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_rooms(self, account_id, **kwargs):
        """
        Gets rooms available to the calling user.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rooms(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param int count: Number of rooms to return. Defaults to the maximum which is 100.
        :param int start_position: Position of the first item in the total results. Defaults to 0.
        :param str room_status: Status of the rooms to return. Defaults to \"Active\".
        :param int office_id: Only return rooms in this office.
        :param str field_data_changed_start_date: Fields data changed start datetime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :param str field_data_changed_end_date: Fields-data changed end DateTime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :param str room_closed_start_date: Room closed start datetime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :param str room_closed_end_date: Room closed end datetime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :return: RoomSummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_rooms_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_rooms_with_http_info(account_id, **kwargs)
            return data

    def get_rooms_with_http_info(self, account_id, **kwargs):
        """
        Gets rooms available to the calling user.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rooms_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param int count: Number of rooms to return. Defaults to the maximum which is 100.
        :param int start_position: Position of the first item in the total results. Defaults to 0.
        :param str room_status: Status of the rooms to return. Defaults to \"Active\".
        :param int office_id: Only return rooms in this office.
        :param str field_data_changed_start_date: Fields data changed start datetime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :param str field_data_changed_end_date: Fields-data changed end DateTime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :param str room_closed_start_date: Room closed start datetime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :param str room_closed_end_date: Room closed end datetime in UTC. Valid formats: yyyy-mm-dd hh:mm:ss or yyyy/mm/dd hh:mm:ss -Time is optional and will default to 00:00:00.
        :return: RoomSummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'count', 'start_position', 'room_status', 'office_id', 'field_data_changed_start_date', 'field_data_changed_end_date', 'room_closed_start_date', 'room_closed_end_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rooms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_rooms`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']
        if 'room_status' in params:
            query_params['roomStatus'] = params['room_status']
        if 'office_id' in params:
            query_params['officeId'] = params['office_id']
        if 'field_data_changed_start_date' in params:
            query_params['fieldDataChangedStartDate'] = params['field_data_changed_start_date']
        if 'field_data_changed_end_date' in params:
            query_params['fieldDataChangedEndDate'] = params['field_data_changed_end_date']
        if 'room_closed_start_date' in params:
            query_params['roomClosedStartDate'] = params['room_closed_start_date']
        if 'room_closed_end_date' in params:
            query_params['roomClosedEndDate'] = params['room_closed_end_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomSummaryList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def invite_user(self, room_id, account_id, **kwargs):
        """
        Invites a user to the room by email address.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invite_user(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: (required)
        :param str account_id: (required)
        :param RoomInvite body:
        :return: RoomInviteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.invite_user_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.invite_user_with_http_info(room_id, account_id, **kwargs)
            return data

    def invite_user_with_http_info(self, room_id, account_id, **kwargs):
        """
        Invites a user to the room by email address.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invite_user_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: (required)
        :param str account_id: (required)
        :param RoomInvite body:
        :return: RoomInviteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invite_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `invite_user`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `invite_user`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomInviteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_room_user(self, room_id, user_id, account_id, **kwargs):
        """
        Updates the specified user's role and transaction side.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_room_user(room_id, user_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: (required)
        :param int user_id: (required)
        :param str account_id: (required)
        :param RoomUserForUpdate body:
        :return: RoomUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_room_user_with_http_info(room_id, user_id, account_id, **kwargs)
        else:
            (data) = self.put_room_user_with_http_info(room_id, user_id, account_id, **kwargs)
            return data

    def put_room_user_with_http_info(self, room_id, user_id, account_id, **kwargs):
        """
        Updates the specified user's role and transaction side.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_room_user_with_http_info(room_id, user_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: (required)
        :param int user_id: (required)
        :param str account_id: (required)
        :param RoomUserForUpdate body:
        :return: RoomUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'user_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_room_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `put_room_user`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_room_user`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `put_room_user`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/users/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomUser',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def restore_room_user_access(self, room_id, user_id, account_id, **kwargs):
        """
        Restores the specified user's access to the 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restore_room_user_access(room_id, user_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: The room Id to restore access (required)
        :param int user_id: The user Id getting restored to the room (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.restore_room_user_access_with_http_info(room_id, user_id, account_id, **kwargs)
        else:
            (data) = self.restore_room_user_access_with_http_info(room_id, user_id, account_id, **kwargs)
            return data

    def restore_room_user_access_with_http_info(self, room_id, user_id, account_id, **kwargs):
        """
        Restores the specified user's access to the 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restore_room_user_access_with_http_info(room_id, user_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: The room Id to restore access (required)
        :param int user_id: The user Id getting restored to the room (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'user_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restore_room_user_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `restore_room_user_access`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `restore_room_user_access`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `restore_room_user_access`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/users/{userId}/restore_access'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def revoke_room_user_access(self, room_id, user_id, account_id, **kwargs):
        """
        Revokes the specified user's access to the 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revoke_room_user_access(room_id, user_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: The room Id to revoke access from (required)
        :param int user_id: The user Id getting revoked from the room (required)
        :param str account_id: (required)
        :param RoomUserRemovalDetail body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.revoke_room_user_access_with_http_info(room_id, user_id, account_id, **kwargs)
        else:
            (data) = self.revoke_room_user_access_with_http_info(room_id, user_id, account_id, **kwargs)
            return data

    def revoke_room_user_access_with_http_info(self, room_id, user_id, account_id, **kwargs):
        """
        Revokes the specified user's access to the 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revoke_room_user_access_with_http_info(room_id, user_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: The room Id to revoke access from (required)
        :param int user_id: The user Id getting revoked from the room (required)
        :param str account_id: (required)
        :param RoomUserRemovalDetail body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'user_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_room_user_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `revoke_room_user_access`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `revoke_room_user_access`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `revoke_room_user_access`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/users/{userId}/revoke_access'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_picture(self, room_id, account_id, **kwargs):
        """
        Update the picture for a 
        This endpoint supports the following content types, application/json as JSON PictureForUpdate{\"fileName\":\"string\", \"Base64Contents\":\"string\"}, multipart/formdata and any other streamed binary content type (as long as either query parameter fileName or request header ContentDisposition filename is included).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_picture(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: ID of the room the picture is for. (required)
        :param str account_id: (required)
        :param file file:
        :return: RoomPicture
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_picture_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.update_picture_with_http_info(room_id, account_id, **kwargs)
            return data

    def update_picture_with_http_info(self, room_id, account_id, **kwargs):
        """
        Update the picture for a 
        This endpoint supports the following content types, application/json as JSON PictureForUpdate{\"fileName\":\"string\", \"Base64Contents\":\"string\"}, multipart/formdata and any other streamed binary content type (as long as either query parameter fileName or request header ContentDisposition filename is included).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_picture_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id: ID of the room the picture is for. (required)
        :param str account_id: (required)
        :param file file:
        :return: RoomPicture
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'file']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `update_picture`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_picture`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/picture'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RoomPicture',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_room_field_data(self, room_id, account_id, **kwargs):
        """
        Updates room field data.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_room_field_data(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param FieldDataForUpdate body:
        :return: FieldData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_room_field_data_with_http_info(room_id, account_id, **kwargs)
        else:
            (data) = self.update_room_field_data_with_http_info(room_id, account_id, **kwargs)
            return data

    def update_room_field_data_with_http_info(self, room_id, account_id, **kwargs):
        """
        Updates room field data.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_room_field_data_with_http_info(room_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int room_id:  (required)
        :param str account_id: (required)
        :param FieldDataForUpdate body:
        :return: FieldData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_room_field_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'room_id' is set
        if ('room_id' not in params) or (params['room_id'] is None):
            raise ValueError("Missing the required parameter `room_id` when calling `update_room_field_data`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_room_field_data`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/rooms/{roomId}/field_data'.replace('{format}', 'json')
        path_params = {}
        if 'room_id' in params:
            path_params['roomId'] = params['room_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FieldData',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
