# coding: utf-8

"""
    DocuSign Rooms API - v2

    An API for an integrator to access the features of DocuSign Rooms  # noqa: E501

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class FormGroupsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def assign_form_group_form(self, form_group_id, account_id, **kwargs):
        """
        Assigns a form to a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.assign_form_group_form(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :param FormGroupFormToAssign body:
        :return: FormGroupFormToAssign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.assign_form_group_form_with_http_info(form_group_id, account_id, **kwargs)
        else:
            (data) = self.assign_form_group_form_with_http_info(form_group_id, account_id, **kwargs)
            return data

    def assign_form_group_form_with_http_info(self, form_group_id, account_id, **kwargs):
        """
        Assigns a form to a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.assign_form_group_form_with_http_info(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :param FormGroupFormToAssign body:
        :return: FormGroupFormToAssign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_form_group_form" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `assign_form_group_form`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `assign_form_group_form`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}/assign_form'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormGroupFormToAssign',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_form_group(self, account_id, **kwargs):
        """
        Creates a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_form_group(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param FormGroupForCreate body:
        :return: FormGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_form_group_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_form_group_with_http_info(account_id, **kwargs)
            return data

    def create_form_group_with_http_info(self, account_id, **kwargs):
        """
        Creates a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_form_group_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param FormGroupForCreate body:
        :return: FormGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_form_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_form_group`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_form_group(self, form_group_id, account_id, **kwargs):
        """
        Deletes a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_form_group(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_form_group_with_http_info(form_group_id, account_id, **kwargs)
        else:
            (data) = self.delete_form_group_with_http_info(form_group_id, account_id, **kwargs)
            return data

    def delete_form_group_with_http_info(self, form_group_id, account_id, **kwargs):
        """
        Deletes a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_form_group_with_http_info(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_form_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `delete_form_group`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_form_group`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_form_group(self, form_group_id, account_id, **kwargs):
        """
        Gets a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_group(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :return: FormGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_form_group_with_http_info(form_group_id, account_id, **kwargs)
        else:
            (data) = self.get_form_group_with_http_info(form_group_id, account_id, **kwargs)
            return data

    def get_form_group_with_http_info(self, form_group_id, account_id, **kwargs):
        """
        Gets a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_group_with_http_info(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :return: FormGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `get_form_group`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_form_group`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_form_groups(self, account_id, **kwargs):
        """
        Get account Form Groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_groups(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param int count: Number of Form Groups to include in the response, (Default 100).
        :param int start_position: Position in the overall list of Form Groups to begin results.
        :return: FormGroupSummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_form_groups_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_form_groups_with_http_info(account_id, **kwargs)
            return data

    def get_form_groups_with_http_info(self, account_id, **kwargs):
        """
        Get account Form Groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_groups_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param int count: Number of Form Groups to include in the response, (Default 100).
        :param int start_position: Position in the overall list of Form Groups to begin results.
        :return: FormGroupSummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'count', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_form_groups`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormGroupSummaryList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def grant_office_access_to_form_group(self, form_group_id, office_id, account_id, **kwargs):
        """
        Assign office to a form group so the specified office has access to the form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grant_office_access_to_form_group(form_group_id, office_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param int office_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.grant_office_access_to_form_group_with_http_info(form_group_id, office_id, account_id, **kwargs)
        else:
            (data) = self.grant_office_access_to_form_group_with_http_info(form_group_id, office_id, account_id, **kwargs)
            return data

    def grant_office_access_to_form_group_with_http_info(self, form_group_id, office_id, account_id, **kwargs):
        """
        Assign office to a form group so the specified office has access to the form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grant_office_access_to_form_group_with_http_info(form_group_id, office_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param int office_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'office_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grant_office_access_to_form_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `grant_office_access_to_form_group`")
        # verify the required parameter 'office_id' is set
        if ('office_id' not in params) or (params['office_id'] is None):
            raise ValueError("Missing the required parameter `office_id` when calling `grant_office_access_to_form_group`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `grant_office_access_to_form_group`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}/grant_office_access/{officeId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'office_id' in params:
            path_params['officeId'] = params['office_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_form_group_form(self, form_group_id, form_id, account_id, **kwargs):
        """
        Removes a form from a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_form_group_form(form_group_id, form_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str form_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_form_group_form_with_http_info(form_group_id, form_id, account_id, **kwargs)
        else:
            (data) = self.remove_form_group_form_with_http_info(form_group_id, form_id, account_id, **kwargs)
            return data

    def remove_form_group_form_with_http_info(self, form_group_id, form_id, account_id, **kwargs):
        """
        Removes a form from a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_form_group_form_with_http_info(form_group_id, form_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str form_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'form_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_form_group_form" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `remove_form_group_form`")
        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `remove_form_group_form`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `remove_form_group_form`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}/unassign_form/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'form_id' in params:
            path_params['formId'] = params['form_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def rename_form_group(self, form_group_id, account_id, **kwargs):
        """
        Renames a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rename_form_group(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :param FormGroupForUpdate body:
        :return: FormGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rename_form_group_with_http_info(form_group_id, account_id, **kwargs)
        else:
            (data) = self.rename_form_group_with_http_info(form_group_id, account_id, **kwargs)
            return data

    def rename_form_group_with_http_info(self, form_group_id, account_id, **kwargs):
        """
        Renames a form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rename_form_group_with_http_info(form_group_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param str account_id: (required)
        :param FormGroupForUpdate body:
        :return: FormGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'account_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_form_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `rename_form_group`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `rename_form_group`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def revoke_office_access_from_form_group(self, form_group_id, office_id, account_id, **kwargs):
        """
        Remove office to a form group so the specified office doesn't have access to the form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revoke_office_access_from_form_group(form_group_id, office_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param int office_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.revoke_office_access_from_form_group_with_http_info(form_group_id, office_id, account_id, **kwargs)
        else:
            (data) = self.revoke_office_access_from_form_group_with_http_info(form_group_id, office_id, account_id, **kwargs)
            return data

    def revoke_office_access_from_form_group_with_http_info(self, form_group_id, office_id, account_id, **kwargs):
        """
        Remove office to a form group so the specified office doesn't have access to the form group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revoke_office_access_from_form_group_with_http_info(form_group_id, office_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_group_id:  (required)
        :param int office_id:  (required)
        :param str account_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_group_id', 'office_id', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_office_access_from_form_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_group_id' is set
        if ('form_group_id' not in params) or (params['form_group_id'] is None):
            raise ValueError("Missing the required parameter `form_group_id` when calling `revoke_office_access_from_form_group`")
        # verify the required parameter 'office_id' is set
        if ('office_id' not in params) or (params['office_id'] is None):
            raise ValueError("Missing the required parameter `office_id` when calling `revoke_office_access_from_form_group`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `revoke_office_access_from_form_group`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_groups/{formGroupId}/revoke_office_access/{officeId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_group_id' in params:
            path_params['formGroupId'] = params['form_group_id']
        if 'office_id' in params:
            path_params['officeId'] = params['office_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
