# 🚀 Tempspace

Tempspace is a terminal-style file sharing service that allows you to upload files and share them via a link, with features like password protection, one-time downloads, and automatic expiration.

![Screenshot](https://i.imgur.com/your-screenshot.png)

## ✨ Features

- **Multiple Upload Methods:** Use the web interface, cURL, or the official CLI tool.
- **Security:** Optional password protection, one-time downloads, and rate limiting.
- **Modern UI:** A terminal-inspired design with QR code generation and upload history.
- **File Management:** Support for large files, multiple expiry options, and automatic cleanup.

## 🚀 Getting Started

### Method 1: Using the Web Interface

The easiest way to use Tempspace is through the web interface.

1.  **Open** the service URL (e.g., `http://localhost:8000`) in your browser.
2.  **Drag and drop** a file or click to browse.
3.  **Configure** the expiry time and an optional password.
4.  **Upload** and share the generated link.

### Method 2: Using cURL

You can use `cURL` to upload files directly from your terminal.

```bash
# Basic upload
curl -F "file=@/path/to/file.txt" -F "hours=6" https://tempspace.fly.dev/upload

# With a password
curl -F "file=@/path/to/secret.txt" -F "password=secret123" https://tempspace.fly.dev/upload
```

### Method 3: Using the Official CLI Tool

For a more integrated terminal experience, you can install the official CLI tool from PyPI.

#### Installation
```bash
pip install tempspace-cli
```

#### Usage
```bash
# Basic upload
tempspace /path/to/document.pdf -t 6h

# With a password
tempspace /path/to/secret.txt -p "mypassword"

# Point to a self-hosted server
tempspace /path/to/file.txt --url http://localhost:8000
```

## 🔧 Self-Hosting

You can run your own instance of Tempspace.

### Installation
```bash
# Clone the repository
git clone https://github.com/your-repo/tempspace.git
cd tempspace

# Install dependencies
pip install -r requirements.txt

# Configure
cp .env.example .env
nano .env  # Change the admin password
```

### Running the Server
```bash
python main.py
```

The server will be available at `http://localhost:8000`.

## 🛡️ Admin & Configuration

For advanced configuration, such as setting up a reverse proxy, managing admin endpoints, and more, please refer to the project's documentation or open an issue.

## 🤝 Contributing

Contributions are welcome! Please fork the repository and submit a pull request.

## 📝 License

This project is licensed under the MIT License.
