![groupyr logo](https://raw.githubusercontent.com/richford/groupyr/main/doc/images/groupyr-logo-large.svg)

# _groupyr_: Sparse Group Lasso in Python

[![Build Status](https://github.com/richford/groupyr/workflows/build/badge.svg)](https://github.com/richford/groupyr/workflows/test/badge.svg)
[![Coverage Status](https://coveralls.io/repos/github/richford/groupyr/badge.svg?branch=main)](https://coveralls.io/github/richford/groupyr?branch=main)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/python/black)
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)

<!-- [![DOI](https://zenodo.org/badge/102051437.svg)](https://zenodo.org/badge/latestdoi/102051437) -->

_groupyr_ is a Python library for penalized regression of grouped covariates.
This is the _groupyr_ development site. You can view the source code, file new issues, and contribute to _groupyr_'s development. If you just want to learn how to install and use _groupyr_, please look at the [_groupyr_ documentation](https://richford.github.io/groupyr/).

## Contributing

We love contributions! _groupyr_ is open source, built on open source,
and we'd love to have you hang out in our community.

We have developed some [guidelines](.github/CONTRIBUTING.md) for contributing to
_groupyr_.

## Citing _groupyr_

If you use _groupyr_ in a scientific publication, please see our [citation
instructions](https://richford/github.io/groupyr/index.html#citing-groupyr).

## Acknowledgements

_groupyr_ development is supported through a grant from the [Gordon
and Betty Moore Foundation](https://www.moore.org/) and from the
[Alfred P. Sloan Foundation](https://sloan.org/) to the [University of
Washington eScience Institute](http://escience.washington.edu/), as
well as NIH Collaborative Research in Computational Neuroscience grant
R01EB027585-01 through the National Institute of Biomedical Imaging and
Bioengineering to Eleftherios Garyfallidis (Indiana University) and
Ariel Rokem (University of Washington).

The API design of _groupyr_ was facilitated by the [scikit-learn project
template](https://github.com/scikit-learn-contrib/project-template) and it
therefore borrows heavily from
[scikit-learn](https://scikit-learn.org/stable/index.html). _groupyr_ relies
on the [copt optimization library](http://openo.pt/copt/index.html) for its
solver. The _groupyr_ logo is a flipped silhouette of an [image from J. E.
Randall](https://commons.wikimedia.org/wiki/File:Epinephelus_amblycephalus,_banded_grouper.jpg)
and is licensed [CC BY-SA](https://creativecommons.org/licenses/by-sa/3.0).
