# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContactPointArgs', 'ContactPoint']

@pulumi.input_type
class ContactPointArgs:
    def __init__(__self__, *,
                 alertmanagers: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]]] = None,
                 dingdings: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]]] = None,
                 discords: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]]] = None,
                 googlechats: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opsgenies: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]]] = None,
                 pagerduties: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]]] = None,
                 pushovers: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]]] = None,
                 sensugos: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]]] = None,
                 slacks: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]]] = None,
                 telegrams: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]]] = None,
                 threemas: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]]] = None,
                 victorops: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]]] = None,
                 webhooks: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]]] = None,
                 wecoms: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]]] = None):
        """
        The set of arguments for constructing a ContactPoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]] alertmanagers: A contact point that sends notifications to other Alertmanager instances.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]] dingdings: A contact point that sends notifications to DingDing.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]] discords: A contact point that sends notifications as Discord messages
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]] emails: A contact point that sends notifications to an email address.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]] googlechats: A contact point that sends notifications to Google Chat.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]] kafkas: A contact point that publishes notifications to Apache Kafka topics.
        :param pulumi.Input[str] name: The name of the contact point.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]] opsgenies: A contact point that sends notifications to OpsGenie.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]] pagerduties: A contact point that sends notifications to PagerDuty.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]] pushovers: A contact point that sends notifications to Pushover.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]] sensugos: A contact point that sends notifications to SensuGo.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]] slacks: A contact point that sends notifications to Slack.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]] teams: A contact point that sends notifications to Microsoft Teams.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]] telegrams: A contact point that sends notifications to Telegram.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]] threemas: A contact point that sends notifications to Threema.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]] victorops: A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]] webhooks: A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]] wecoms: A contact point that sends notifications to WeCom.
        """
        if alertmanagers is not None:
            pulumi.set(__self__, "alertmanagers", alertmanagers)
        if dingdings is not None:
            pulumi.set(__self__, "dingdings", dingdings)
        if discords is not None:
            pulumi.set(__self__, "discords", discords)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if googlechats is not None:
            pulumi.set(__self__, "googlechats", googlechats)
        if kafkas is not None:
            pulumi.set(__self__, "kafkas", kafkas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opsgenies is not None:
            pulumi.set(__self__, "opsgenies", opsgenies)
        if pagerduties is not None:
            pulumi.set(__self__, "pagerduties", pagerduties)
        if pushovers is not None:
            pulumi.set(__self__, "pushovers", pushovers)
        if sensugos is not None:
            pulumi.set(__self__, "sensugos", sensugos)
        if slacks is not None:
            pulumi.set(__self__, "slacks", slacks)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if telegrams is not None:
            pulumi.set(__self__, "telegrams", telegrams)
        if threemas is not None:
            pulumi.set(__self__, "threemas", threemas)
        if victorops is not None:
            pulumi.set(__self__, "victorops", victorops)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)
        if wecoms is not None:
            pulumi.set(__self__, "wecoms", wecoms)

    @property
    @pulumi.getter
    def alertmanagers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]]]:
        """
        A contact point that sends notifications to other Alertmanager instances.
        """
        return pulumi.get(self, "alertmanagers")

    @alertmanagers.setter
    def alertmanagers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]]]):
        pulumi.set(self, "alertmanagers", value)

    @property
    @pulumi.getter
    def dingdings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]]]:
        """
        A contact point that sends notifications to DingDing.
        """
        return pulumi.get(self, "dingdings")

    @dingdings.setter
    def dingdings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]]]):
        pulumi.set(self, "dingdings", value)

    @property
    @pulumi.getter
    def discords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]]]:
        """
        A contact point that sends notifications as Discord messages
        """
        return pulumi.get(self, "discords")

    @discords.setter
    def discords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]]]):
        pulumi.set(self, "discords", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]]]:
        """
        A contact point that sends notifications to an email address.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter
    def googlechats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]]]:
        """
        A contact point that sends notifications to Google Chat.
        """
        return pulumi.get(self, "googlechats")

    @googlechats.setter
    def googlechats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]]]):
        pulumi.set(self, "googlechats", value)

    @property
    @pulumi.getter
    def kafkas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]]]:
        """
        A contact point that publishes notifications to Apache Kafka topics.
        """
        return pulumi.get(self, "kafkas")

    @kafkas.setter
    def kafkas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]]]):
        pulumi.set(self, "kafkas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the contact point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def opsgenies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]]]:
        """
        A contact point that sends notifications to OpsGenie.
        """
        return pulumi.get(self, "opsgenies")

    @opsgenies.setter
    def opsgenies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]]]):
        pulumi.set(self, "opsgenies", value)

    @property
    @pulumi.getter
    def pagerduties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]]]:
        """
        A contact point that sends notifications to PagerDuty.
        """
        return pulumi.get(self, "pagerduties")

    @pagerduties.setter
    def pagerduties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]]]):
        pulumi.set(self, "pagerduties", value)

    @property
    @pulumi.getter
    def pushovers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]]]:
        """
        A contact point that sends notifications to Pushover.
        """
        return pulumi.get(self, "pushovers")

    @pushovers.setter
    def pushovers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]]]):
        pulumi.set(self, "pushovers", value)

    @property
    @pulumi.getter
    def sensugos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]]]:
        """
        A contact point that sends notifications to SensuGo.
        """
        return pulumi.get(self, "sensugos")

    @sensugos.setter
    def sensugos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]]]):
        pulumi.set(self, "sensugos", value)

    @property
    @pulumi.getter
    def slacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]]]:
        """
        A contact point that sends notifications to Slack.
        """
        return pulumi.get(self, "slacks")

    @slacks.setter
    def slacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]]]):
        pulumi.set(self, "slacks", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]]]:
        """
        A contact point that sends notifications to Microsoft Teams.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter
    def telegrams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]]]:
        """
        A contact point that sends notifications to Telegram.
        """
        return pulumi.get(self, "telegrams")

    @telegrams.setter
    def telegrams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]]]):
        pulumi.set(self, "telegrams", value)

    @property
    @pulumi.getter
    def threemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]]]:
        """
        A contact point that sends notifications to Threema.
        """
        return pulumi.get(self, "threemas")

    @threemas.setter
    def threemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]]]):
        pulumi.set(self, "threemas", value)

    @property
    @pulumi.getter
    def victorops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]]]:
        """
        A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        """
        return pulumi.get(self, "victorops")

    @victorops.setter
    def victorops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]]]):
        pulumi.set(self, "victorops", value)

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]]]:
        """
        A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        """
        return pulumi.get(self, "webhooks")

    @webhooks.setter
    def webhooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]]]):
        pulumi.set(self, "webhooks", value)

    @property
    @pulumi.getter
    def wecoms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]]]:
        """
        A contact point that sends notifications to WeCom.
        """
        return pulumi.get(self, "wecoms")

    @wecoms.setter
    def wecoms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]]]):
        pulumi.set(self, "wecoms", value)


@pulumi.input_type
class _ContactPointState:
    def __init__(__self__, *,
                 alertmanagers: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]]] = None,
                 dingdings: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]]] = None,
                 discords: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]]] = None,
                 googlechats: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opsgenies: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]]] = None,
                 pagerduties: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]]] = None,
                 pushovers: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]]] = None,
                 sensugos: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]]] = None,
                 slacks: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]]] = None,
                 telegrams: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]]] = None,
                 threemas: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]]] = None,
                 victorops: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]]] = None,
                 webhooks: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]]] = None,
                 wecoms: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]]] = None):
        """
        Input properties used for looking up and filtering ContactPoint resources.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]] alertmanagers: A contact point that sends notifications to other Alertmanager instances.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]] dingdings: A contact point that sends notifications to DingDing.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]] discords: A contact point that sends notifications as Discord messages
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]] emails: A contact point that sends notifications to an email address.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]] googlechats: A contact point that sends notifications to Google Chat.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]] kafkas: A contact point that publishes notifications to Apache Kafka topics.
        :param pulumi.Input[str] name: The name of the contact point.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]] opsgenies: A contact point that sends notifications to OpsGenie.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]] pagerduties: A contact point that sends notifications to PagerDuty.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]] pushovers: A contact point that sends notifications to Pushover.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]] sensugos: A contact point that sends notifications to SensuGo.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]] slacks: A contact point that sends notifications to Slack.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]] teams: A contact point that sends notifications to Microsoft Teams.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]] telegrams: A contact point that sends notifications to Telegram.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]] threemas: A contact point that sends notifications to Threema.
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]] victorops: A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]] webhooks: A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        :param pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]] wecoms: A contact point that sends notifications to WeCom.
        """
        if alertmanagers is not None:
            pulumi.set(__self__, "alertmanagers", alertmanagers)
        if dingdings is not None:
            pulumi.set(__self__, "dingdings", dingdings)
        if discords is not None:
            pulumi.set(__self__, "discords", discords)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if googlechats is not None:
            pulumi.set(__self__, "googlechats", googlechats)
        if kafkas is not None:
            pulumi.set(__self__, "kafkas", kafkas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opsgenies is not None:
            pulumi.set(__self__, "opsgenies", opsgenies)
        if pagerduties is not None:
            pulumi.set(__self__, "pagerduties", pagerduties)
        if pushovers is not None:
            pulumi.set(__self__, "pushovers", pushovers)
        if sensugos is not None:
            pulumi.set(__self__, "sensugos", sensugos)
        if slacks is not None:
            pulumi.set(__self__, "slacks", slacks)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if telegrams is not None:
            pulumi.set(__self__, "telegrams", telegrams)
        if threemas is not None:
            pulumi.set(__self__, "threemas", threemas)
        if victorops is not None:
            pulumi.set(__self__, "victorops", victorops)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)
        if wecoms is not None:
            pulumi.set(__self__, "wecoms", wecoms)

    @property
    @pulumi.getter
    def alertmanagers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]]]:
        """
        A contact point that sends notifications to other Alertmanager instances.
        """
        return pulumi.get(self, "alertmanagers")

    @alertmanagers.setter
    def alertmanagers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointAlertmanagerArgs']]]]):
        pulumi.set(self, "alertmanagers", value)

    @property
    @pulumi.getter
    def dingdings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]]]:
        """
        A contact point that sends notifications to DingDing.
        """
        return pulumi.get(self, "dingdings")

    @dingdings.setter
    def dingdings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDingdingArgs']]]]):
        pulumi.set(self, "dingdings", value)

    @property
    @pulumi.getter
    def discords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]]]:
        """
        A contact point that sends notifications as Discord messages
        """
        return pulumi.get(self, "discords")

    @discords.setter
    def discords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointDiscordArgs']]]]):
        pulumi.set(self, "discords", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]]]:
        """
        A contact point that sends notifications to an email address.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointEmailArgs']]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter
    def googlechats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]]]:
        """
        A contact point that sends notifications to Google Chat.
        """
        return pulumi.get(self, "googlechats")

    @googlechats.setter
    def googlechats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointGooglechatArgs']]]]):
        pulumi.set(self, "googlechats", value)

    @property
    @pulumi.getter
    def kafkas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]]]:
        """
        A contact point that publishes notifications to Apache Kafka topics.
        """
        return pulumi.get(self, "kafkas")

    @kafkas.setter
    def kafkas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointKafkaArgs']]]]):
        pulumi.set(self, "kafkas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the contact point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def opsgenies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]]]:
        """
        A contact point that sends notifications to OpsGenie.
        """
        return pulumi.get(self, "opsgenies")

    @opsgenies.setter
    def opsgenies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointOpsgenyArgs']]]]):
        pulumi.set(self, "opsgenies", value)

    @property
    @pulumi.getter
    def pagerduties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]]]:
        """
        A contact point that sends notifications to PagerDuty.
        """
        return pulumi.get(self, "pagerduties")

    @pagerduties.setter
    def pagerduties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPagerdutyArgs']]]]):
        pulumi.set(self, "pagerduties", value)

    @property
    @pulumi.getter
    def pushovers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]]]:
        """
        A contact point that sends notifications to Pushover.
        """
        return pulumi.get(self, "pushovers")

    @pushovers.setter
    def pushovers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointPushoverArgs']]]]):
        pulumi.set(self, "pushovers", value)

    @property
    @pulumi.getter
    def sensugos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]]]:
        """
        A contact point that sends notifications to SensuGo.
        """
        return pulumi.get(self, "sensugos")

    @sensugos.setter
    def sensugos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSensugoArgs']]]]):
        pulumi.set(self, "sensugos", value)

    @property
    @pulumi.getter
    def slacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]]]:
        """
        A contact point that sends notifications to Slack.
        """
        return pulumi.get(self, "slacks")

    @slacks.setter
    def slacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointSlackArgs']]]]):
        pulumi.set(self, "slacks", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]]]:
        """
        A contact point that sends notifications to Microsoft Teams.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTeamArgs']]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter
    def telegrams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]]]:
        """
        A contact point that sends notifications to Telegram.
        """
        return pulumi.get(self, "telegrams")

    @telegrams.setter
    def telegrams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointTelegramArgs']]]]):
        pulumi.set(self, "telegrams", value)

    @property
    @pulumi.getter
    def threemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]]]:
        """
        A contact point that sends notifications to Threema.
        """
        return pulumi.get(self, "threemas")

    @threemas.setter
    def threemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointThreemaArgs']]]]):
        pulumi.set(self, "threemas", value)

    @property
    @pulumi.getter
    def victorops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]]]:
        """
        A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        """
        return pulumi.get(self, "victorops")

    @victorops.setter
    def victorops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointVictoropArgs']]]]):
        pulumi.set(self, "victorops", value)

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]]]:
        """
        A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        """
        return pulumi.get(self, "webhooks")

    @webhooks.setter
    def webhooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWebhookArgs']]]]):
        pulumi.set(self, "webhooks", value)

    @property
    @pulumi.getter
    def wecoms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]]]:
        """
        A contact point that sends notifications to WeCom.
        """
        return pulumi.get(self, "wecoms")

    @wecoms.setter
    def wecoms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactPointWecomArgs']]]]):
        pulumi.set(self, "wecoms", value)


class ContactPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alertmanagers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointAlertmanagerArgs']]]]] = None,
                 dingdings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDingdingArgs']]]]] = None,
                 discords: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDiscordArgs']]]]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointEmailArgs']]]]] = None,
                 googlechats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointGooglechatArgs']]]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointKafkaArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opsgenies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointOpsgenyArgs']]]]] = None,
                 pagerduties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPagerdutyArgs']]]]] = None,
                 pushovers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPushoverArgs']]]]] = None,
                 sensugos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSensugoArgs']]]]] = None,
                 slacks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSlackArgs']]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTeamArgs']]]]] = None,
                 telegrams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTelegramArgs']]]]] = None,
                 threemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointThreemaArgs']]]]] = None,
                 victorops: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointVictoropArgs']]]]] = None,
                 webhooks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWebhookArgs']]]]] = None,
                 wecoms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWecomArgs']]]]] = None,
                 __props__=None):
        """
        Manages Grafana Alerting contact points.

        * [Official documentation](https://grafana.com/docs/grafana/next/alerting/contact-points)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/alerting_provisioning/#contact-points)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        my_contact_point = grafana.ContactPoint("myContactPoint", emails=[grafana.ContactPointEmailArgs(
            addresses=[
                "one@company.org",
                "two@company.org",
            ],
            disable_resolve_message=False,
            message="{{ len .Alerts.Firing }} firing.",
            single_email=True,
            subject="{{ template \\"default.title\\" .}}",
        )])
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/contactPoint:ContactPoint contact_point_name {{contact_point_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointAlertmanagerArgs']]]] alertmanagers: A contact point that sends notifications to other Alertmanager instances.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDingdingArgs']]]] dingdings: A contact point that sends notifications to DingDing.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDiscordArgs']]]] discords: A contact point that sends notifications as Discord messages
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointEmailArgs']]]] emails: A contact point that sends notifications to an email address.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointGooglechatArgs']]]] googlechats: A contact point that sends notifications to Google Chat.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointKafkaArgs']]]] kafkas: A contact point that publishes notifications to Apache Kafka topics.
        :param pulumi.Input[str] name: The name of the contact point.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointOpsgenyArgs']]]] opsgenies: A contact point that sends notifications to OpsGenie.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPagerdutyArgs']]]] pagerduties: A contact point that sends notifications to PagerDuty.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPushoverArgs']]]] pushovers: A contact point that sends notifications to Pushover.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSensugoArgs']]]] sensugos: A contact point that sends notifications to SensuGo.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSlackArgs']]]] slacks: A contact point that sends notifications to Slack.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTeamArgs']]]] teams: A contact point that sends notifications to Microsoft Teams.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTelegramArgs']]]] telegrams: A contact point that sends notifications to Telegram.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointThreemaArgs']]]] threemas: A contact point that sends notifications to Threema.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointVictoropArgs']]]] victorops: A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWebhookArgs']]]] webhooks: A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWecomArgs']]]] wecoms: A contact point that sends notifications to WeCom.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ContactPointArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Grafana Alerting contact points.

        * [Official documentation](https://grafana.com/docs/grafana/next/alerting/contact-points)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/alerting_provisioning/#contact-points)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        my_contact_point = grafana.ContactPoint("myContactPoint", emails=[grafana.ContactPointEmailArgs(
            addresses=[
                "one@company.org",
                "two@company.org",
            ],
            disable_resolve_message=False,
            message="{{ len .Alerts.Firing }} firing.",
            single_email=True,
            subject="{{ template \\"default.title\\" .}}",
        )])
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/contactPoint:ContactPoint contact_point_name {{contact_point_name}}
        ```

        :param str resource_name: The name of the resource.
        :param ContactPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alertmanagers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointAlertmanagerArgs']]]]] = None,
                 dingdings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDingdingArgs']]]]] = None,
                 discords: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDiscordArgs']]]]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointEmailArgs']]]]] = None,
                 googlechats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointGooglechatArgs']]]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointKafkaArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opsgenies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointOpsgenyArgs']]]]] = None,
                 pagerduties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPagerdutyArgs']]]]] = None,
                 pushovers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPushoverArgs']]]]] = None,
                 sensugos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSensugoArgs']]]]] = None,
                 slacks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSlackArgs']]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTeamArgs']]]]] = None,
                 telegrams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTelegramArgs']]]]] = None,
                 threemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointThreemaArgs']]]]] = None,
                 victorops: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointVictoropArgs']]]]] = None,
                 webhooks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWebhookArgs']]]]] = None,
                 wecoms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWecomArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactPointArgs.__new__(ContactPointArgs)

            __props__.__dict__["alertmanagers"] = alertmanagers
            __props__.__dict__["dingdings"] = dingdings
            __props__.__dict__["discords"] = discords
            __props__.__dict__["emails"] = emails
            __props__.__dict__["googlechats"] = googlechats
            __props__.__dict__["kafkas"] = kafkas
            __props__.__dict__["name"] = name
            __props__.__dict__["opsgenies"] = opsgenies
            __props__.__dict__["pagerduties"] = pagerduties
            __props__.__dict__["pushovers"] = pushovers
            __props__.__dict__["sensugos"] = sensugos
            __props__.__dict__["slacks"] = slacks
            __props__.__dict__["teams"] = teams
            __props__.__dict__["telegrams"] = telegrams
            __props__.__dict__["threemas"] = threemas
            __props__.__dict__["victorops"] = victorops
            __props__.__dict__["webhooks"] = webhooks
            __props__.__dict__["wecoms"] = wecoms
        super(ContactPoint, __self__).__init__(
            'grafana:index/contactPoint:ContactPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alertmanagers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointAlertmanagerArgs']]]]] = None,
            dingdings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDingdingArgs']]]]] = None,
            discords: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDiscordArgs']]]]] = None,
            emails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointEmailArgs']]]]] = None,
            googlechats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointGooglechatArgs']]]]] = None,
            kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointKafkaArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            opsgenies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointOpsgenyArgs']]]]] = None,
            pagerduties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPagerdutyArgs']]]]] = None,
            pushovers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPushoverArgs']]]]] = None,
            sensugos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSensugoArgs']]]]] = None,
            slacks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSlackArgs']]]]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTeamArgs']]]]] = None,
            telegrams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTelegramArgs']]]]] = None,
            threemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointThreemaArgs']]]]] = None,
            victorops: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointVictoropArgs']]]]] = None,
            webhooks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWebhookArgs']]]]] = None,
            wecoms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWecomArgs']]]]] = None) -> 'ContactPoint':
        """
        Get an existing ContactPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointAlertmanagerArgs']]]] alertmanagers: A contact point that sends notifications to other Alertmanager instances.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDingdingArgs']]]] dingdings: A contact point that sends notifications to DingDing.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointDiscordArgs']]]] discords: A contact point that sends notifications as Discord messages
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointEmailArgs']]]] emails: A contact point that sends notifications to an email address.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointGooglechatArgs']]]] googlechats: A contact point that sends notifications to Google Chat.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointKafkaArgs']]]] kafkas: A contact point that publishes notifications to Apache Kafka topics.
        :param pulumi.Input[str] name: The name of the contact point.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointOpsgenyArgs']]]] opsgenies: A contact point that sends notifications to OpsGenie.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPagerdutyArgs']]]] pagerduties: A contact point that sends notifications to PagerDuty.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointPushoverArgs']]]] pushovers: A contact point that sends notifications to Pushover.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSensugoArgs']]]] sensugos: A contact point that sends notifications to SensuGo.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointSlackArgs']]]] slacks: A contact point that sends notifications to Slack.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTeamArgs']]]] teams: A contact point that sends notifications to Microsoft Teams.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointTelegramArgs']]]] telegrams: A contact point that sends notifications to Telegram.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointThreemaArgs']]]] threemas: A contact point that sends notifications to Threema.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointVictoropArgs']]]] victorops: A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWebhookArgs']]]] webhooks: A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContactPointWecomArgs']]]] wecoms: A contact point that sends notifications to WeCom.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContactPointState.__new__(_ContactPointState)

        __props__.__dict__["alertmanagers"] = alertmanagers
        __props__.__dict__["dingdings"] = dingdings
        __props__.__dict__["discords"] = discords
        __props__.__dict__["emails"] = emails
        __props__.__dict__["googlechats"] = googlechats
        __props__.__dict__["kafkas"] = kafkas
        __props__.__dict__["name"] = name
        __props__.__dict__["opsgenies"] = opsgenies
        __props__.__dict__["pagerduties"] = pagerduties
        __props__.__dict__["pushovers"] = pushovers
        __props__.__dict__["sensugos"] = sensugos
        __props__.__dict__["slacks"] = slacks
        __props__.__dict__["teams"] = teams
        __props__.__dict__["telegrams"] = telegrams
        __props__.__dict__["threemas"] = threemas
        __props__.__dict__["victorops"] = victorops
        __props__.__dict__["webhooks"] = webhooks
        __props__.__dict__["wecoms"] = wecoms
        return ContactPoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alertmanagers(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointAlertmanager']]]:
        """
        A contact point that sends notifications to other Alertmanager instances.
        """
        return pulumi.get(self, "alertmanagers")

    @property
    @pulumi.getter
    def dingdings(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointDingding']]]:
        """
        A contact point that sends notifications to DingDing.
        """
        return pulumi.get(self, "dingdings")

    @property
    @pulumi.getter
    def discords(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointDiscord']]]:
        """
        A contact point that sends notifications as Discord messages
        """
        return pulumi.get(self, "discords")

    @property
    @pulumi.getter
    def emails(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointEmail']]]:
        """
        A contact point that sends notifications to an email address.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter
    def googlechats(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointGooglechat']]]:
        """
        A contact point that sends notifications to Google Chat.
        """
        return pulumi.get(self, "googlechats")

    @property
    @pulumi.getter
    def kafkas(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointKafka']]]:
        """
        A contact point that publishes notifications to Apache Kafka topics.
        """
        return pulumi.get(self, "kafkas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the contact point.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def opsgenies(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointOpsgeny']]]:
        """
        A contact point that sends notifications to OpsGenie.
        """
        return pulumi.get(self, "opsgenies")

    @property
    @pulumi.getter
    def pagerduties(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointPagerduty']]]:
        """
        A contact point that sends notifications to PagerDuty.
        """
        return pulumi.get(self, "pagerduties")

    @property
    @pulumi.getter
    def pushovers(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointPushover']]]:
        """
        A contact point that sends notifications to Pushover.
        """
        return pulumi.get(self, "pushovers")

    @property
    @pulumi.getter
    def sensugos(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointSensugo']]]:
        """
        A contact point that sends notifications to SensuGo.
        """
        return pulumi.get(self, "sensugos")

    @property
    @pulumi.getter
    def slacks(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointSlack']]]:
        """
        A contact point that sends notifications to Slack.
        """
        return pulumi.get(self, "slacks")

    @property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointTeam']]]:
        """
        A contact point that sends notifications to Microsoft Teams.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def telegrams(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointTelegram']]]:
        """
        A contact point that sends notifications to Telegram.
        """
        return pulumi.get(self, "telegrams")

    @property
    @pulumi.getter
    def threemas(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointThreema']]]:
        """
        A contact point that sends notifications to Threema.
        """
        return pulumi.get(self, "threemas")

    @property
    @pulumi.getter
    def victorops(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointVictorop']]]:
        """
        A contact point that sends notifications to VictorOps (now known as Splunk OnCall).
        """
        return pulumi.get(self, "victorops")

    @property
    @pulumi.getter
    def webhooks(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointWebhook']]]:
        """
        A contact point that sends notifications to an arbitrary webhook, using the Prometheus webhook format defined here: https://prometheus.io/docs/alerting/latest/configuration/#webhook_config
        """
        return pulumi.get(self, "webhooks")

    @property
    @pulumi.getter
    def wecoms(self) -> pulumi.Output[Optional[Sequence['outputs.ContactPointWecom']]]:
        """
        A contact point that sends notifications to WeCom.
        """
        return pulumi.get(self, "wecoms")

