# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from .color_scheme_request import ColorSchemeRequest
from .email_provider_request import EmailProviderRequest
from .metadata_schema import MetadataSchema
from .onboarding_options_request import OnboardingOptionsRequest
from .payment_methods_request import PaymentMethodsRequest


class OrganizationRequest(pydantic.BaseModel):
    name: typing.Optional[str]
    logo: typing.Optional[str]
    website_url: typing.Optional[str] = pydantic.Field(alias="websiteUrl")
    support_email: typing.Optional[str] = pydantic.Field(alias="supportEmail")
    payment_methods: typing.Optional[PaymentMethodsRequest] = pydantic.Field(alias="paymentMethods")
    email_provider: typing.Optional[EmailProviderRequest] = pydantic.Field(alias="emailProvider")
    color_scheme: typing.Optional[ColorSchemeRequest] = pydantic.Field(alias="colorScheme")
    payee_onboarding_options: typing.Optional[OnboardingOptionsRequest] = pydantic.Field(alias="payeeOnboardingOptions")
    payor_onboarding_options: typing.Optional[OnboardingOptionsRequest] = pydantic.Field(alias="payorOnboardingOptions")
    metadata_schema: typing.Optional[typing.List[MetadataSchema]] = pydantic.Field(alias="metadataSchema")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
