# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from .metadata_conditional import MetadataConditional
from .metadata_type import MetadataType


class MetadataSchema(pydantic.BaseModel):
    key: str
    display_name: str = pydantic.Field(alias="displayName")
    description: typing.Optional[str]
    type: MetadataType
    allow_multiple: typing.Optional[bool] = pydantic.Field(
        alias="allowMultiple",
        description="Whether or not multiple values are allowed for this field. Defaults to false. If true, the value will be a list of the specified type.",
    )
    conditional: typing.Optional[MetadataConditional] = pydantic.Field(
        description="A list of conditional rules that determine whether or not this field should be shown. The field will only be shown if all of the conditions are met. If no conditions are specified, the field will always be shown."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
