# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import pydantic

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ..commons.errors.auth_header_malformed_error import AuthHeaderMalformedError
from ..commons.errors.auth_header_missing_error import AuthHeaderMissingError
from ..commons.errors.forbidden import Forbidden
from ..commons.errors.not_found import NotFound
from ..commons.errors.unauthorized import Unauthorized
from ..commons.errors.unimplemented import Unimplemented
from ..entity_types.types.entity_id import EntityId
from ..entity_types.types.vendor_network import VendorNetwork
from .errors.ocr_failure import OcrFailure
from .types.ocr_response import OcrResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OcrClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def ocr(
        self,
        *,
        vendor_network: typing.Optional[VendorNetwork] = None,
        entity_id: typing.Optional[EntityId] = None,
        mime_type: str,
        image: str,
    ) -> OcrResponse:
        """
        Run OCR on an Base64 encoded image or PDF

        Parameters:
            - vendor_network: typing.Optional[VendorNetwork]. Limit OCR vendor search to a specific network

            - entity_id: typing.Optional[EntityId]. When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.

            - mime_type: str. MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.

            - image: str. Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "ocr"),
            params=remove_none_from_dict({"vendorNetwork": vendor_network, "entityId": entity_id}),
            json=jsonable_encoder({"mimeType": mime_type, "image": image}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OcrResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "OcrFailure":
                raise OcrFailure(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOcrClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def ocr(
        self,
        *,
        vendor_network: typing.Optional[VendorNetwork] = None,
        entity_id: typing.Optional[EntityId] = None,
        mime_type: str,
        image: str,
    ) -> OcrResponse:
        """
        Run OCR on an Base64 encoded image or PDF

        Parameters:
            - vendor_network: typing.Optional[VendorNetwork]. Limit OCR vendor search to a specific network

            - entity_id: typing.Optional[EntityId]. When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.

            - mime_type: str. MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.

            - image: str. Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "ocr"),
            params=remove_none_from_dict({"vendorNetwork": vendor_network, "entityId": entity_id}),
            json=jsonable_encoder({"mimeType": mime_type, "image": image}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OcrResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "OcrFailure":
                raise OcrFailure(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
