# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...entity_types.types.entity_user_response import EntityUserResponse
from .associated_approval_action import AssociatedApprovalAction


class CommentResponse(pydantic.BaseModel):
    id: str
    text: str
    user: typing.Optional[EntityUserResponse]
    associated_approval_action: typing.Optional[AssociatedApprovalAction] = pydantic.Field(
        alias="associatedApprovalAction",
        description="If an approval action has triggered the generation of this comment, returns the associated approval action and actor",
    )
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
