# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...entity_types.types.entity_user_id import EntityUserId
from .approval_slot_id import ApprovalSlotId
from .approver_action import ApproverAction


class ApprovalSlot(pydantic.BaseModel):
    approval_slot_id: ApprovalSlotId = pydantic.Field(
        alias="approvalSlotId", description="The identifier for this approval slot"
    )
    assigned_user_id: typing.Optional[EntityUserId] = pydantic.Field(alias="assignedUserId")
    action: ApproverAction
    eligible_roles: typing.List[str] = pydantic.Field(alias="eligibleRoles")
    eligible_user_ids: typing.List[EntityUserId] = pydantic.Field(alias="eligibleUserIds")
    date: dt.datetime = pydantic.Field(
        description="Either the date the invoice was created, date the approver was assigned, or date of last action by approver, whichever is latest."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
