# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...commons.types.address import Address
from ...commons.types.birth_date import BirthDate
from ...commons.types.full_name import FullName
from ...commons.types.individual_government_id import IndividualGovernmentId
from ...commons.types.phone_number import PhoneNumber
from .responsibilities import Responsibilities


class RepresentativeRequest(pydantic.BaseModel):
    name: FullName
    phone: PhoneNumber
    email: str
    address: Address
    birth_date: BirthDate = pydantic.Field(alias="birthDate")
    government_id: IndividualGovernmentId = pydantic.Field(alias="governmentID")
    responsibilities: Responsibilities

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
