# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class BusinessType(str, enum.Enum):
    SOLE_PROPRIETORSHIP = "soleProprietorship"
    UNINCORPORATED_ASSOCIATION = "unincorporatedAssociation"
    TRUST = "trust"
    PUBLIC_CORPORATION = "publicCorporation"
    PRIVATE_CORPORATION = "privateCorporation"
    LLC = "llc"
    PARTNERSHIP = "partnership"
    UNINCORPORATED_NON_PROFIT = "unincorporatedNonProfit"
    INCORPORATED_NON_PROFIT = "incorporatedNonProfit"

    def visit(
        self,
        sole_proprietorship: typing.Callable[[], T_Result],
        unincorporated_association: typing.Callable[[], T_Result],
        trust: typing.Callable[[], T_Result],
        public_corporation: typing.Callable[[], T_Result],
        private_corporation: typing.Callable[[], T_Result],
        llc: typing.Callable[[], T_Result],
        partnership: typing.Callable[[], T_Result],
        unincorporated_non_profit: typing.Callable[[], T_Result],
        incorporated_non_profit: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is BusinessType.SOLE_PROPRIETORSHIP:
            return sole_proprietorship()
        if self is BusinessType.UNINCORPORATED_ASSOCIATION:
            return unincorporated_association()
        if self is BusinessType.TRUST:
            return trust()
        if self is BusinessType.PUBLIC_CORPORATION:
            return public_corporation()
        if self is BusinessType.PRIVATE_CORPORATION:
            return private_corporation()
        if self is BusinessType.LLC:
            return llc()
        if self is BusinessType.PARTNERSHIP:
            return partnership()
        if self is BusinessType.UNINCORPORATED_NON_PROFIT:
            return unincorporated_non_profit()
        if self is BusinessType.INCORPORATED_NON_PROFIT:
            return incorporated_non_profit()
