# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import pydantic

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.remove_none_from_dict import remove_none_from_dict
from ....commons.errors.auth_header_malformed_error import AuthHeaderMalformedError
from ....commons.errors.auth_header_missing_error import AuthHeaderMissingError
from ....commons.errors.forbidden import Forbidden
from ....commons.errors.not_found import NotFound
from ....commons.errors.unauthorized import Unauthorized
from ....commons.errors.unimplemented import Unimplemented
from ....entity_types.types.counterparties_response import CounterpartiesResponse
from ....entity_types.types.counterparty_network_type import CounterpartyNetworkType
from ....entity_types.types.entity_id import EntityId
from ....entity_types.types.find_counterparties_response import FindCounterpartiesResponse


class CounterpartyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def find(
        self,
        entity_id: EntityId,
        *,
        payment_methods: typing.Optional[bool] = None,
        counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]],
    ) -> CounterpartiesResponse:
        """
        Find counterparties. Deprecated. Use findPayees or findPayors instead.

        Parameters:
            - entity_id: EntityId.

            - payment_methods: typing.Optional[bool]. If true, will include counterparty payment methods as part of the response

            - counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]]. Filter by counterparty ids
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"entity/{entity_id}/counterparties"),
            params=remove_none_from_dict({"paymentMethods": payment_methods, "counterpartyId": counterparty_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def find_payees(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]],
        payment_methods: typing.Optional[bool] = None,
        counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]],
    ) -> FindCounterpartiesResponse:
        """
        Find payee counterparties. This endpoint lets you find vendors linked to the entity.

        Parameters:
            - entity_id: EntityId.

            - name: typing.Optional[str]. Filter by counterparty name

            - network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]]. Filter by network type. By default, only ENTITY counterparties are returned.

            - payment_methods: typing.Optional[bool]. If true, will include counterparty payment methods as part of the response

            - counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]]. Filter by counterparty ids
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"entity/{entity_id}/counterparties/payees"
            ),
            params=remove_none_from_dict(
                {
                    "name": name,
                    "networkType": network_type,
                    "paymentMethods": payment_methods,
                    "counterpartyId": counterparty_id,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def find_payors(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]],
        payment_methods: typing.Optional[bool] = None,
        counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]],
    ) -> FindCounterpartiesResponse:
        """
        Find payor counterparties. This endpoint lets you find customers linked to the entity.

        Parameters:
            - entity_id: EntityId.

            - name: typing.Optional[str]. Filter by counterparty name

            - network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]]. Filter by network type. By default, only ENTITY counterparties are returned.

            - payment_methods: typing.Optional[bool]. If true, will include counterparty payment methods as part of the response

            - counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]]. Filter by counterparty ids
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"entity/{entity_id}/counterparties/payors"
            ),
            params=remove_none_from_dict(
                {
                    "name": name,
                    "networkType": network_type,
                    "paymentMethods": payment_methods,
                    "counterpartyId": counterparty_id,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCounterpartyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def find(
        self,
        entity_id: EntityId,
        *,
        payment_methods: typing.Optional[bool] = None,
        counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]],
    ) -> CounterpartiesResponse:
        """
        Find counterparties. Deprecated. Use findPayees or findPayors instead.

        Parameters:
            - entity_id: EntityId.

            - payment_methods: typing.Optional[bool]. If true, will include counterparty payment methods as part of the response

            - counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]]. Filter by counterparty ids
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"entity/{entity_id}/counterparties"),
            params=remove_none_from_dict({"paymentMethods": payment_methods, "counterpartyId": counterparty_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def find_payees(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]],
        payment_methods: typing.Optional[bool] = None,
        counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]],
    ) -> FindCounterpartiesResponse:
        """
        Find payee counterparties. This endpoint lets you find vendors linked to the entity.

        Parameters:
            - entity_id: EntityId.

            - name: typing.Optional[str]. Filter by counterparty name

            - network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]]. Filter by network type. By default, only ENTITY counterparties are returned.

            - payment_methods: typing.Optional[bool]. If true, will include counterparty payment methods as part of the response

            - counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]]. Filter by counterparty ids
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"entity/{entity_id}/counterparties/payees"
            ),
            params=remove_none_from_dict(
                {
                    "name": name,
                    "networkType": network_type,
                    "paymentMethods": payment_methods,
                    "counterpartyId": counterparty_id,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def find_payors(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]],
        payment_methods: typing.Optional[bool] = None,
        counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]],
    ) -> FindCounterpartiesResponse:
        """
        Find payor counterparties. This endpoint lets you find customers linked to the entity.

        Parameters:
            - entity_id: EntityId.

            - name: typing.Optional[str]. Filter by counterparty name

            - network_type: typing.Union[typing.Optional[CounterpartyNetworkType], typing.List[CounterpartyNetworkType]]. Filter by network type. By default, only ENTITY counterparties are returned.

            - payment_methods: typing.Optional[bool]. If true, will include counterparty payment methods as part of the response

            - counterparty_id: typing.Union[typing.Optional[EntityId], typing.List[EntityId]]. Filter by counterparty ids
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"entity/{entity_id}/counterparties/payors"
            ),
            params=remove_none_from_dict(
                {
                    "name": name,
                    "networkType": network_type,
                    "paymentMethods": payment_methods,
                    "counterpartyId": counterparty_id,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "AuthHeaderMissingError":
                raise AuthHeaderMissingError()
            if _response_json["errorName"] == "AuthHeaderMalformedError":
                raise AuthHeaderMalformedError(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
