# This file was auto-generated by Fern from our API Definition.

import typing

import httpx

from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import MercoaEnvironment
from .resources.bank_lookup.client import AsyncBankLookupClient, BankLookupClient
from .resources.entity.client import AsyncEntityClient, EntityClient
from .resources.invoice.client import AsyncInvoiceClient, InvoiceClient
from .resources.ocr.client import AsyncOcrClient, OcrClient
from .resources.organization.client import AsyncOrganizationClient, OrganizationClient
from .resources.payment_method_schema.client import AsyncPaymentMethodSchemaClient, PaymentMethodSchemaClient
from .resources.transaction.client import AsyncTransactionClient, TransactionClient


class Mercoa:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: MercoaEnvironment = MercoaEnvironment.PRODUCTION,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = 60
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.Client(timeout=timeout),
        )
        self.entity = EntityClient(client_wrapper=self._client_wrapper)
        self.invoice = InvoiceClient(client_wrapper=self._client_wrapper)
        self.organization = OrganizationClient(client_wrapper=self._client_wrapper)
        self.bank_lookup = BankLookupClient(client_wrapper=self._client_wrapper)
        self.ocr = OcrClient(client_wrapper=self._client_wrapper)
        self.payment_method_schema = PaymentMethodSchemaClient(client_wrapper=self._client_wrapper)
        self.transaction = TransactionClient(client_wrapper=self._client_wrapper)


class AsyncMercoa:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: MercoaEnvironment = MercoaEnvironment.PRODUCTION,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = 60
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.AsyncClient(timeout=timeout),
        )
        self.entity = AsyncEntityClient(client_wrapper=self._client_wrapper)
        self.invoice = AsyncInvoiceClient(client_wrapper=self._client_wrapper)
        self.organization = AsyncOrganizationClient(client_wrapper=self._client_wrapper)
        self.bank_lookup = AsyncBankLookupClient(client_wrapper=self._client_wrapper)
        self.ocr = AsyncOcrClient(client_wrapper=self._client_wrapper)
        self.payment_method_schema = AsyncPaymentMethodSchemaClient(client_wrapper=self._client_wrapper)
        self.transaction = AsyncTransactionClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: MercoaEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
