# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_data_validation_engine',
 'nautobot_data_validation_engine.api',
 'nautobot_data_validation_engine.migrations',
 'nautobot_data_validation_engine.tests']

package_data = \
{'': ['*'],
 'nautobot_data_validation_engine': ['templates/nautobot_data_validation_engine/*']}

setup_kwargs = {
    'name': 'nautobot-data-validation-engine',
    'version': '1.0.0.dev0',
    'description': 'Provides UI to build custom data validation rules for data in Nautobot',
    'long_description': '# Nautobot Data Validation Engine Plugin\n\nA plugin for [Nautobot](https://github.com/nautobot/nautobot) with a UI to build custom data validation rules for Source of Truth data.\n\n## Usage\n\nThe data validation engine plugin offers a set of user definable rules which are used to enforce business constraints on the data in Nautobot. These rules are tied to particular models and each rule is meant to enforce one aspect of a business use case. There are currently two supported rule types, regular expressions, and min/max numeric rules.\n\n![Dropdown](docs/images/dropdown.png)\n\n### Regular Expression Rules\n\n![Regex Rules List](docs/images/regex-rules-list.png)\n\nEach rule is defined with these fields:\n\n* name - A unique name for the rule.\n* enabled - A boolean to toggle enforcement of the rule on and off.\n* content type - The Nautobot model to which the rule should apply (device, site, etc.).\n* field - The name of the character based field on the model to which the regular expression is validated.\n* regular expression - The body of the regular expression used for validation.\n* error message - An optional error message to display to the use when validation fails. By default, a message indicating validation against the defined regular expression has failed is shown.\n\n![Regex Rules Edit](docs/images/regex-rules-edit.png)\n\nIn this example, a device hostname validation rule has been created and prevents device records from being created or updated that do not conform to the naming standard.\n\n![Regex Rules Enforcement](docs/images/regex-rules-enforcement.png)\n\n### Min/Max Rules\n\n![Min/Max List](docs/images/min-max-rules-list.png)\n\nEach rule is defined with these fields:\n\n* name - A unique name for the rule.\n* enabled - A boolean to toggle enforcement of the rule on and off.\n* content type - The Nautobot model to which the rule should apply (device, site, etc.).\n* field - The name of the numeric based field on the model to which the min/max value is validated.\n* min - The min value to validate value against (greater than or equal).\n* max - The max value to validate value against (less than or equal).\n* error message - An optional error message to display to the use when validation fails. By default, a message indicating validation against the defined min/max value has failed is shown.\n\n![Min/Max Rules Edit](docs/images/min-max-rules-edit.png)\n\nIn this example, a max value for VLAN IDs has been configured, preventing VLANs greater than 3999 from being created.\n\n![Min/Max Rules Enforcement](docs/images/min-max-rules-enforcement.png)\n\n## Installation\n\nIf using the installation pattern from the Nautobot Documentation, you will need to activate the\nvirtual environment before installing so that you install the package into the virtual environment.\n\n```shell\ncd /opt/nautobot\nsource venv/bin/activate\n```\n\nThe plugin is available as a Python package in pypi and can be installed with pip. Once the\ninstallation is completed, then Nautobot and the Nautobot worker must be restarted.\n\n```shell\npip install nautobot-data-validation-engine\nsystemctl restart nautobot nautobot-rq\n```\n\nTo ensure Data Validation Engine plugin is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-data-validation-engine` package:\n\n```no-highlight\n# echo nautobot-data-validation-engine >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `nautobot_config.py`\n```python\n# In your configuration.py\nPLUGINS = ["nautobot_data_validation_engine"]\n```\n\nFinally, make sure to run the migrations for this plugin\n\n```bash\nnautobot-server migrate\n```\n\n## Upgrades\n\nWhen a new release comes out it may be necessary to run a migration of the database to account for any changes in the data models used by this plugin. Execute the command `nautobot-server migrate` from the Nautobot install `nautobot/` directory after updating the package.\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`. \n\nEach command can be executed with `invoke <command>`. All commands support the arguments `--nautobot-ver` and `--python-ver` if you want to manually define the version of Python and Nautobot to use. Each command also has its own help `invoke <command> --help`\n\n#### Local dev environment\n```\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility \n```\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n#### Testing \n\n```\n  tests            Run all tests for this plugin.\n  pylint           Run pylint code analysis.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).\nSign up [here](http://slack.networktocode.com/)\n\n\n',
    'author': 'Network to Code, LLC',
    'author_email': 'opensource@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nautobot/nautobot-plugin-data-validation-engine',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
