# Generated by Django 3.1.11 on 2021-05-26 06:04

from django.db import migrations, models
import django.db.models.deletion
import nautobot.extras.utils
import nautobot_data_validation_engine.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="RegularExpressionValidationRule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("slug", models.SlugField(max_length=100, unique=True)),
                ("enabled", models.BooleanField(default=True)),
                ("error_message", models.CharField(blank=True, max_length=255, null=True)),
                ("field", models.CharField(max_length=50)),
                (
                    "regular_expression",
                    models.TextField(validators=[nautobot_data_validation_engine.models.validate_regex]),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to=nautobot.extras.utils.FeatureQuery("custom_validators"),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "ordering": ("name",),
                "unique_together": {("content_type", "field")},
            },
        ),
        migrations.CreateModel(
            name="MinMaxValidationRule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("slug", models.SlugField(max_length=100, unique=True)),
                ("enabled", models.BooleanField(default=True)),
                ("error_message", models.CharField(blank=True, max_length=255, null=True)),
                ("field", models.CharField(max_length=50)),
                ("min", models.FloatField(blank=True, null=True)),
                ("max", models.FloatField(blank=True, null=True)),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to=nautobot.extras.utils.FeatureQuery("custom_validators"),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "ordering": ("name",),
                "unique_together": {("content_type", "field")},
            },
        ),
    ]
