class CasioConstants:
    CASIO_GET_DEVICE_NAME = "00002a00-0000-1000-8000-00805f9b34fb"
    CASIO_APPEARANCE = "00002a01-0000-1000-8000-00805f9b34fb"
    TX_POWER_LEVEL_CHARACTERISTIC_UUID = "00002a07-0000-1000-8000-00805f9b34fb"
    CASIO_READ_REQUEST_FOR_ALL_FEATURES_CHARACTERISTIC_UUID = (
        "26eb002c-b012-49a8-b1f8-394fb2032b0f"
    )
    CASIO_ALL_FEATURES_CHARACTERISTIC_UUID = "26eb002d-b012-49a8-b1f8-394fb2032b0f"
    CASIO_NOTIFICATION_CHARACTERISTIC_UUID = "26eb0030-b012-49a8-b1f8-394fb2032b0f"
    CASIO_DATA_REQUEST_SP_CHARACTERISTIC_UUID = "26eb0023-b012-49a8-b1f8-394fb2032b0f"
    CASIO_CONVOY_CHARACTERISTIC_UUID = "26eb0024-b012-49a8-b1f8-394fb2032b0f"
    SERIAL_NUMBER_STRING = "00002a25-0000-1000-8000-00805f9b34fb"

    CHARACTERISTICS = {
        "CASIO_WATCH_NAME": 0x23,
        "CASIO_APP_INFORMATION": 0x22,
        "CASIO_BLE_FEATURES": 0x10,
        "CASIO_SETTING_FOR_BLE": 0x11,
        "CASIO_ADVERTISE_PARAMETER_MANAGER": 0x3B,
        "CASIO_CONNECTION_PARAMETER_MANAGER": 0x3A,
        "CASIO_MODULE_ID": 0x26,
        "CASIO_WATCH_CONDITION": 0x28,  # battery %
        "CASIO_VERSION_INFORMATION": 0x20,
        "CASIO_DST_WATCH_STATE": 0x1D,
        "CASIO_DST_SETTING": 0x1E,
        "CASIO_SERVICE_DISCOVERY_MANAGER": 0x47,
        "CASIO_CURRENT_TIME": 0x09,
        "CASIO_SETTING_FOR_USER_PROFILE": 0x45,
        "CASIO_SETTING_FOR_TARGET_VALUE": 0x43,
        "ALERT_LEVEL": 0x0A,
        "CASIO_SETTING_FOR_ALM": 0x15,
        "CASIO_SETTING_FOR_ALM2": 0x16,
        "CASIO_SETTING_FOR_BASIC": 0x13,
        "CASIO_CURRENT_TIME_MANAGER": 0x39,
        "CASIO_WORLD_CITIES": 0x1F,
        "CASIO_REMINDER_TITLE": 0x30,
        "CASIO_REMINDER_TIME": 0x31,
        "CASIO_TIMER": 0x18,
        "ERROR": 0xFF,
        "UNKNOWN": 0x0A,

        #  ECB-30
        "CMD_SET_TIMEMODE": 0x47,
        "FIND_PHONE": 0x0A,
    }
