from prettytable import PrettyTable
from pprint import pprint
from .plugin import Plugin
from csirtg_indicator.utils import parse_timestamp
import arrow


class Table(Plugin):
    __name__ = 'table'

    def __repr__(self):
        t = PrettyTable(self.cols)
        t.align['provider'] = 'l'
        for obs in reversed(self.data):
            r = []
            for c in self.cols:
                y = obs.get(c, '')
                if type(y) is list:
                    y = ','.join(y)

                # http://stackoverflow.com/questions/3224268/python-unicode-encode-error
                # http://stackoverflow.com/questions/19833440/unicodeencodeerror-ascii-codec-cant-encode-character-u-xe9-in-position-7
                try:
                    if type(y) is unicode:
                        y = y.encode('ascii', 'ignore')
                except NameError:
                    # python3
                    pass

                if y and (c in ['firsttime', 'lasttime', 'reporttime']):
                    y = arrow.get(y).format('YYYY-MM-DDTHH:mm:ss.SSSSS')
                    y = '{}Z'.format(y)
                else:
                    y = str(y)
                y = (y[:self.max_field_size] + '..') if len(y) > self.max_field_size else y
                r.append(y)
            t.add_row(r)
        return str(t)
