from .plugin import Plugin
import time
import os

OUTPUT_PATH = os.getenv('CSIRTG_INDICATOR_BIND_PATH', '/etc/namedb')


class Bind(Plugin):

    def __init__(self, *args, **kwargs):
        super(Bind, self).__init__(*args, **kwargs)

        self.output = kwargs.get('output', OUTPUT_PATH)

    def __repr__(self):
        text = [
            '// generated by: {} at {}'.format('csirtg-indicator', time.strftime('%Y-%M-%dT%H:%m:%S %Z'))
        ]
        for obs in self.data:
            if obs['itype'] is not 'fqdn':
                pass

            text.append('zone "{}" {{type master; file "{}";}};'.format(obs['indicator'], self.output))

        return '\n'.join(text)