# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['perry_the_docker_agent']

package_data = \
{'': ['*'],
 'perry_the_docker_agent': ['sceptre/config/dev/*', 'sceptre/templates/*']}

install_requires = \
['PyYAML>=5.1,<6.0',
 'boto3>=1.24.59,<2.0.0',
 'click>=7.1.1,<7.2.0',
 'colorlog>=6.7.0,<7.0.0',
 'pathspec>=0.10.1,<0.11.0',
 'pydantic>=1.10.2,<2.0.0',
 'sceptre>=3.2.0,<4.0.0',
 'typer[all]>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['perry = perry_the_docker_agent:main.app']}

setup_kwargs = {
    'name': 'perry-the-docker-agent',
    'version': '0.2.8',
    'description': 'Your cool remote docker agent in the cloud',
    'long_description': '## Perry The Docker Agent\n### Your cool remote docker agent in the cloud ⛄️\n\n[![PyPI version](https://badge.fury.io/py/perry-the-docker-agent.svg)](https://badge.fury.io/py/perry-the-docker-agent)\n![Python versions](https://img.shields.io/pypi/pyversions/perry-the-docker-agent.svg?style=flat-square&label=Python%20Versions)\n\nBased on [remote-docker-aws](https://github.com/lime-green/remote-docker-aws) 🙏🏾\n\nUse docker to develop services, but without the overhead of running docker on your machine! This is a development tool that you should use if your machine is low performance, or if you are running many docker services.\n\n### Why is this useful?\n\nFrees up your local machine for useful tasks\nsuch as running your code editor, browser, and email, leaving running Docker to a dedicated server instance.\nThe result is that your local machine functions faster, uses up less disk space, and consumes less power.\nMacOS users will also see noticeable speed improvements since Docker on Linux (which is\nwhat the remote hosts runs) is much more performant.\n\nThe downsides:\n- SSH tunnel communication is slower than local communication. However using an AWS region with low ping makes the latency unnoticeable. Find the region fastest for you using [this site](https://www.cloudping.info/)\n- Some more setup required to get everything configured properly and running (tunneling ports, syncing file changes)\n- Running the ec2 instance incurs an additional cost over running locally, although a t3.medium instance in Canada only costs just under 5 cents/hour\n\nHow it works: two processes are run, a sync and a tunnel process. \n- The sync process keeps local and remote files in sync so that the docker process run remotely can use docker volumes transparently\n- The tunnel process forwards ports needed so your local system can communicate with docker, plus additional ports as required, such as port 443 for browser communication\n\n## Setup\n1. First login to your AWS account and [create access keys to access AWS through the CLI](https://docs.aws.amazon.com/powershell/latest/userguide/pstools-appendix-sign-up.html)\n\n    You will need the following IAM policies:\n    - AmazonEC2FullAccess\n    - AWSCloudFormationFullAccess\n\n    And now in your terminal:\n\n    ```bash\n    # Replace dav with your name\n    # You will need to setup an AWS account if you don\'t have one\n    # and create access key credentials\n\n    aws configure --profile dav\n    export AWS_PROFILE=dav\n    ```\n\n1. Install pre-requisites\n\n   Have [Homebrew](https://brew.sh/) (Available on both macOS and Linux now!)\n\n   Have [pipx](https://github.com/pipxproject/pipx)\n\n    ```bash\n   pip install perry-the-docker-agent\n   # or.... if part of a project\n   poetry add perry-the-docker-agent\n\n   # Install unison sync utility\n   brew install unison\n\n   # Install file-watcher driver for unison\n   # On MacOS:\n   brew install autozimu/homebrew-formulas/unison-fsmonitor\n\n   # Or, on Linux since the above formula doesn\'t work:\n   brew install eugenmayer/dockersync/unox\n    ```\n\n1. Generate and upload a keypair to AWS\n\n    ```bash\n   perry create-key-pair\n    ```\n\n1. Create the ec2 instance\n\n    ```bash\n   perry create\n    ```\n\n## Daily Running\n\n1. Start the remote-docker ec2 instance\n    ```bash\n    perry start\n    ```\n   This will automatically switch the docker context for you. If you want to switch\n   back to the default agent run `docker context use default`\n\n1. In one terminal start the tunnel so that the ports you need to connect to are exposed\n    ```bash\n    perry tunnel\n    ```\n\n1. In another terminal sync file changes to the remote instance:\n    ```bash\n    perry sync\n    ```\n\n1. Develop and code! All services should be accessible and usable as usual (eg: `docker ps`, `docker-compose up`, etc.)\nas long as you are running `perry tunnel` and are forwarding the ports you need\n\n1. When you\'re done for the day don\'t forget to stop the instance to save money:\n    ```bash\n    perry stop\n    ```\n\n## Config File\nLooks for a config file at the path `./perry_config.yml` by default,\nwhich can be overriden by passing `--config-path`. \n\nAn example `perry_config.yml` file:\n```yaml\naws_region: af-south-1\ninstance_type: t3.large\nvolume_size: 100\nsync_dir: ./\nproject_id: "ranger"\nignore_dirs:\n  - .venv\n  - .git\n  - node_modules\n  - __pycache__\nremote_port_forwards:\n  local-webpack-app:\n    "8080": "8080"\nlocal_port_forwards:\n  user-api:\n    "2020": "2020"\n  blog-api:\n    "3030": "3030"\n```\n\n```bash\n Usage: perry [OPTIONS] COMMAND [ARGS]...                                                  \n                                                                                           \n╭─ Options ───────────────────────────────────────────────────────────────────────────────╮\n│ --config-path               TEXT  Path of the perry config                              │\n│                                   [default: ./perry_config.yml]                         │\n│ --install-completion              Install completion for the current shell.             │\n│ --show-completion                 Show completion for the current shell, to copy it or  │\n│                                   customize the installation.                           │\n│ --help                            Show this message and exit.                           │\n╰─────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ──────────────────────────────────────────────────────────────────────────────╮\n│ create           Provision a new ec2 instance to use as the remote agent                │\n│ create-key-pair  Create and upload a new keypair to AWS for SSH access                  │\n│ delete           Delete the provisioned ec2 instance                                    │\n│ ssh              Connect to the remote agent via SSH                                    │\n│ start            Start the remote agent instance                                        │\n│ stop             Stop the remote agent instance                                         │\n│ sync             Sync the given directories with the remote instance                    │\n│ test             Test new config                                                        │\n│ tunnel           Create a SSH tunnel to the remote instance to connect with the docker  │\n│                  agent and containers                                                   │\n╰─────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\nThe current configurable values can be seen in [config.py](perry_the_docker_agent/config.py)\n\n#### `aws_region` (takes precedence over `AWS_REGION` and `.aws/config`)\n- The region to create the instance in\n\n#### `instance_type`\n- Type of ec2 instance, defaults to: `t3.medium`\n\n#### `project_id`\n  - defaults to `None`\n  - Used to uniquely identify the instance, this is useful if multiple remote-docker agents\n  will be created in the same AWS account\n\n#### `key_path`\n  - defaults to: `~/.ssh/id_rsa_perry_{{project_id}}`\n\n#### `local_port_forwards`\n  - defaults to: `{}`\n  - Object containing label -> port mapping objects for opening the ports on the remote host.\n    A mapping of `"remote_port_forwards": {"my_app": {"80": "8080"}}` will open port 80 on your local machine\n    and point it to port 8080 of the remote-docker instance (which ostensibly a container is listening on).\n    The name doesn\'t do anything except help legibility.\n\n#### `remote_port_forwards`\n  - defaults to: `{}`\n  - Similar to `local_port_forwards` except will open the port on the remote instance.\n\n    This is useful to have frontend webpack apps accessible on the remote host\n\n#### `ignore_dirs`\n  - defaults to: `[]`\n  - list of directories to ignore\n\n#### `sync_dir`\n - directory to sync, will usually be the root fo the project\n\n#### `volume_size`\n - defaults to: `30` (GB)\n - Size of the ec2 volume.\n\n## Cost\nA t3.medium instance on ca-central-1 currently costs $0.046 /hour. [See current prices](https://aws.amazon.com/ec2/pricing/on-demand/)\n\nNothing else used should incur any cost with reasonable usage\n\n## Notes\n- See `perry --help` for more information on the commands available\n- The unison version running on the server and running locally have to\nmatch. If one of them updates to a newer version, you should update the other.\n\n## Perry improvements on [remote-docker-aws](https://github.com/lime-green/remote-docker-aws)\n- Perry is configured to the project by a local `perry_config.yml`\n- Perry uses [poetry](https://github.com/python-poetry/poetry), [pydantic](https://github.com/pydantic/pydantic) and [typer](https://github.com/tiangolo/typer)\n- Perry enables swap accounting on the remote ec2 instance which allows docker-compose resource limits\n- Perry uses a simpler method to sync and ignore directories.\n',
    'author': 'Daverin',
    'author_email': 'mail@daverin.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/daverin/perry-the-docker-agent/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
