import logging

from expressoptionchain.option_stream import OptionStream

logging.basicConfig(level=logging.INFO,
             format='%(asctime)s.%(msecs)03d %(name)s:%(funcName)s - %(processName)s -%(levelname)s - %(message)s',
             datefmt='%Y-%m-%d %H:%M:%S')
log = logging.getLogger(__name__)

from expressoptionchain.helper import get_secrets

if __name__ == '__main__':
    secrets = {
        'api_key': get_secrets()['api_key'],
        'access_token': get_secrets()['access_token']
    }
    expiry = '23-02-2023'
    text = '''BANKNIFTY, AARTIIND, ABB, ABBOTINDIA, ABCAPITAL, ABFRL, ACC, ADANIENT, ADANIPORTS, ALKEM, AMBUJACEM, APOLLOHOSP, APOLLOTYRE, ASHOKLEY, ASIANPAINT, ASTRAL, ATUL, AUBANK, AUROPHARMA, AXISBANK, BAJAJ-AUTO, BAJAJFINSV, BAJFINANCE, BALKRISIND, BALRAMCHIN, BANDHANBNK, BANKBARODA, BATAINDIA, BEL, BERGEPAINT, BHARATFORG, BHARTIARTL, BHEL, BIOCON, BOSCHLTD, BPCL, BRITANNIA, BSOFT, CANBK, CANFINHOME, CHAMBLFERT, CHOLAFIN, CIPLA, COALINDIA, COFORGE, COLPAL, CONCOR, COROMANDEL, CROMPTON, CUB, CUMMINSIND, DABUR, DALBHARAT, DEEPAKNTR, DELTACORP, DIVISLAB, DIXON, DLF, DRREDDY, EICHERMOT, ESCORTS, EXIDEIND, FEDERALBNK, FSL, GAIL, GLENMARK, GMRINFRA, GNFC, GODREJCP, GODREJPROP, GRANULES, GRASIM, GUJGASLTD, HAL, HAVELLS, HCLTECH, HDFC, HDFCAMC, HDFCBANK, HDFCLIFE, HEROMOTOCO, HINDALCO, HINDCOPPER, HINDPETRO, HINDUNILVR, HONAUT, ICICIBANK, ICICIGI, ICICIPRULI, IDEA, IDFC, IDFCFIRSTB, IEX, IGL, INDHOTEL, INDIACEM, INDIAMART, INDIGO, INDUSINDBK, INDUSTOWER, INFY, INTELLECT, IOC, IPCALAB, IRCTC, ITC, JINDALSTEL, JKCEMENT, JSWSTEEL, JUBLFOOD, KOTAKBANK, L&TFH, LALPATHLAB, LAURUSLABS, LICHSGFIN, LT, LTIM, LTTS, LUPIN, M&M, M&MFIN, MANAPPURAM, MARICO, MARUTI, MCX, METROPOLIS, MFSL, MGL, MOTHERSON, MPHASIS, MRF, MUTHOOTFIN, NATIONALUM, NAUKRI, NAVINFLUOR, NESTLEIND, NMDC, NTPC, OBEROIRLTY, OFSS, ONGC, PAGEIND, PEL, PERSISTENT, PETRONET, PFC, PIDILITIND, PIIND, PNB, POLYCAB, POWERGRID, PVR, RAIN, RAMCOCEM, RBLBANK, RECLTD, RELIANCE, SAIL, SBICARD, SBILIFE, SBIN, SHREECEM, SHRIRAMFIN, SIEMENS, SRF, SUNPHARMA, SUNTV, SYNGENE, TATACHEM, TATACOMM, TATACONSUM, TATAMOTORS, TATAPOWER, TATASTEEL, TCS, TECHM, TITAN, TORNTPHARM, TORNTPOWER, TRENT, TVSMOTOR, UBL, ULTRACEMCO, UPL, VEDL, VOLTAS, WHIRLPOOL, WIPRO, ZEEL, ZYDUSLIFE'''
    symbols = []
    for item in text.split(', '):
        symbols.append(f'NFO:{item}')

    # option stream should be started in main module
    criteria = {'name': 'percentage', 'properties': {'value': 12.5}}

    stream = OptionStream(symbols, secrets, expiry=expiry, criteria=criteria)
    stream.start()

