# Datasets

Here we provide a few worked examples of creating graph datasets from protein structures

## PPISP - Protein-Protein Interaction Site Prediction

The data contained within PPISP is drawn from [DeepPPISP](https://github.com/CSUBioGroup/DeepPPISP) [1]. They collate a number of protein-protein interaction structures from three existing datasets. This is a node-classification task, where the task to is to predict whether or not a residue in the graph participates in a protein-protein interaction. The authors make available additional evolutionary information in the form of a PSSM for each protein.

The authors describe the dataset construction as follows: The three benchmark datasets are given, i.e., ``Dset_186``, ``Dset_72`` and ``PDBset_164``. ``Dset_186`` consists of 186 protein sequences with the resolution lower than 3.0 Å with sequence homology less than 25%. ``Dset_72`` and ``PDBset_164`` were constructed as the same as ``Dset_186``. ``Dset_72`` has 72 protein sequences and ``PDBset_164`` consists of 164 protein sequences. These protein sequences in the three benchmark datasets have been annotated. Thus, we have 422 different annotated protein sequences. We remove two protein sequences for they do not have PSSM file.

## PSCDB - Protein Structural Change Database

The data contained within ``PSCDB`` is drawn from the [Protein Structural Change Database](https://idp1.force.cs.is.nagoya-u.ac.jp/pscdb/#:~:text=Protein%20Structural%20Change%20DataBase%20%3A%3A,where%20the%20dominant%20motion%20occurs.) [2] . The dataset consists of paired protein structures in their bound and unbound forms across 7 classes of structural rearrangement motion. Several tasks can be formulated with this dataset. E.g. predicting the bound conformation of a protein as and edge-prediction task or graph-classification task predicting which class of structural rearrangement a protein undergoes upon ligand binding.

## PROTEINS_{LIGANDS / METAL / NUCLEOTIDES / NUCLEIC}

These datasets are unions of structural protein-ligand / protein-metal / protein-nucleotide / protein-nucleic acid interactions sourced from [ccPDB](https://webs.iiitd.edu.in/raghava/ccpdb/index.html) [3, 4]. Each of the datasets are collections of non-redundant PDB chain of ligand interacting protein chains generated by [Blastclust](http://nebc.nox.ac.uk/bioinformatics/docs/blastclust.html) (25% identity) and [LPC](https://oca.weizmann.ac.il/oca-bin/lpccsu). PDB resolution is maximum 3 $\AA$ and PDB chain length is minimum 80 amino acids and interaction distance (distance between SO4 - amino acid interaction) is 0-4.0 $\AA$.

| Dataset | # Classes | # Proteins   | Notebook |
|---|---|---|---|
|[PROTEINS_LIGANDS](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/PROTEINS_LIGANDS.csv) | 7   | 3312  | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_ligands/parse_dataset.ipynb)
| [PROTEINS_METAL](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/PROTEINS_METAL.csv) | 7   | 6262  | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_metal/parse_dataset.ipynb)
| [PROTEINS_NUCLEIC](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleic/PROTEINS_NUCLEIC.csv) | 2   | 975  | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_nucleic/parse_dataset.ipynb)
| [PROTEINS_NUCLEOTIDES](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/PROTEINS_NUCLEOTIDES.csv) | 8   | 1226  | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/parse_dataset.ipynb)

### [PROTEINS_LIGANDS](https://github.com/a-r-j/graphein/tree/master/datasets/proteins_ligands)

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_ligands/parse_dataset.ipynb)

|PDB Ligand |Ligand Name| # Proteins   | # Residues   | Dataset   |
|---|---|---|---|---|
|[SO4](https://www.rcsb.org/ligand/SO4)| Sulphate   | 3312  |  954518  |  [SO4_3312](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/SO4.csv) |
|[PO4](https://www.rcsb.org/ligand/PO4)| Phosphate   | 1299  |  401977  |  [PO4_1299](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/PO4.csv) |
|[NAG](https://www.rcsb.org/ligand/NAG)| N-Acetylglucosamine   | 727  |  267137  |  [NAG_727](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/NAG.csv) |
|[HEM](https://www.rcsb.org/ligand/HEM)| Heme   | 176  |  48737  |  [HEM176](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/HEM.csv) |
|[BME](https://www.rcsb.org/ligand/BME)| Beta-Mercaptoethanol   | 191  |  52910  |  [BME191](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/BME.csv) |
|[EDO](https://www.rcsb.org/ligand/EDO)| Ethylene Glycol   | 1507  |  438555  |  [EDO1507](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/EDO.csv) |
|[PLP](https://www.rcsb.org/ligand/PLP)| Vitamin B6 Phosphate   | 65  |  26754  |  [PLP65](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_ligands/PLP.csv) |

### [PROTEINS_NUCLEOTIDES](https://github.com/a-r-j/graphein/tree/master/datasets/proteins_nucleotides)

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/parse_dataset.ipynb)

|PDB Ligand |Ligand Name| # Proteins   | # Residues   | Dataset   |
|---|---|---|---|---|
|[ATP](https://www.rcsb.org/ligand/ATP)| Adenosine Triphosphate   | 313  |  127493  |  [ATP313](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/ATP.csv) |
|[ADP](https://www.rcsb.org/ligand/ADP)| Adenosine Diphosphate   | 353  |  152419  |  [ADP353](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/ADP.csv) |
|[GTP](https://www.rcsb.org/ligand/GTP)| Guanosine Triphosphate   | 83  |  40442  |  [GTP83](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/GTP.csv) |
|[GDP](https://www.rcsb.org/ligand/GDP)| Guanosine Diphosphate   | 120  |  41412  |  [GDP120](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/GDP.csv) |
|[NAD](https://www.rcsb.org/ligand/NAD)| Nicotinamide Adenine Dinucleotide   | 140  |  53276  |  [NAD140](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/NAD.csv) |
|[FAD](https://www.rcsb.org/ligand/FAD)| Flavin Adenine Dinucleotide   | 172  |  73733  |  [FAD172](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/FAD.csv) |
|[FMN](https://www.rcsb.org/ligand/FMN)| Flavin Mononucleotide   | 117  |  33514  |  [FMN117](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/FMN.csv) |
|[UDP](https://www.rcsb.org/ligand/UDP)| Uridine Diphosphate   | 68  |  25064  |  [UDP68](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleotides/UDP.csv) |

### [PROTEINS_METAL](https://github.com/a-r-j/graphein/tree/master/datasets/proteins_metal)

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_metal/parse_dataset.ipynb)

|PDB Ligand |Ligand Name| # Proteins   | # Residues   | Dataset   |
|---|---|---|---|---|
|[Fe](https://www.rcsb.org/ligand/FE)| Iron   | 215  |  69779  |  [Fe215](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/FE.csv) |
|[Mg](https://www.rcsb.org/ligand/MG)| Magnesium | 1908  |  655860  |  [MG1908](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/MG.csv) |
|[Ca](https://www.rcsb.org/ligand/CA)| Calcium | 1402  |  468225  |  [CA1402](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/CA.csv) |
|[Mn](https://www.rcsb.org/ligand/MN)| Manganese | 521  |  179324  |  [MN521](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/MN.csv) |
|[Zn](https://www.rcsb.org/ligand/NZ)| Zinc | 1660  |  487759  |  [ZN1660](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/ZN.csv) |
|[Co](https://www.rcsb.org/ligand/CO)| Cobalt | 201  |  56079  |  [CO201](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/CO.csv) |
|[Ni](https://www.rcsb.org/ligand/NI)| Nickel | 355  |  95902  |  [NI355](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_metal/CO.csv) |

### [PROTEINS_NUCLEIC](https://github.com/a-r-j/graphein/tree/master/datasets/proteins_nucleic)

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/a-r-j/graphein/blob/master/datasets/proteins_nucleic/parse_dataset.ipynb)

|Ligand Name| # Proteins   | # Residues   | Dataset   |
|---|---|---|---|
| DNA   | 560  |  168746  |  [DNA560](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleic/dna.csv) |
| RNA   | 415  |  117841  |  [RNA415](https://github.com/a-r-j/graphein/blob/master/datasets/proteins_nucleic/rna.csv) |

## References

[1] Min Zeng, Fuhao Zhang, Fang-Xiang Wu, Yaohang Li, Jianxin Wang, Min Li. Protein-protein interaction site prediction through combining local and global features with deep neural networks. Bioinformatics. DOI:10.1093/bioinformatics/btz699

[2] Amemiya, T., Koike, R., Kidera, A., & Ota, M. (2011). PSCDB: a database for protein structural change upon ligand binding. Nucleic Acids Research, 40(D1), D554–D558. <https://doi.org/10.1093/nar/gkr966>

[3] Agrawal et al., (2019) ccPDB 2.0: an updated version of datasets created and compiled from Protein Data Bank. Database, Volume 2019, 1 January 2019, bay142

[4] Singh et al., (2012) ccPDB: compilation and creation of data sets from Protein Data Bank. Nucleic Acids Res. 40(1):D486-9
