# T1055.008 - Process Injection: Ptrace System Calls
Ptrace based process injection is a technique where one process can read/write arbitrarty memory in another process. It can also allow one process to inject code and modify the execution flow of another process. These tests try to demonstrate each of those behaviors and variations on how they may be accomplished.

## Running the tests
To run all of the ptrace tests with the default arguments
```python
python -m posixath linux -t T1055_008
```

To run a specific ptrace test
```python
python -m posixath linux -t T1055_008 -k ptrace_read_regs
```

To run a specific ptrace test with arguments
```python
python -m posixath linux -t T1055_008 -k ptrace_shellcode_injection --shellcode-path="/home/user/shellcode.bin" --target-proc="/usr/bin/ls" --target-args="-laR /etc"
```

## Read/write memory
There are a few different ways to read and write memory of another process. The test harnesses enumerates the various ways this can be done. It excercises the

- Write
    - PTRACE_POKETEXT
    - PTRACE_POKEDATA
    - PTRACE_POKEUSER
- Read
    - PTRACE_PEEKTEXT
    - PTRACE_PEEKDATA
    - PTRACE_PEEKUSR

## Other ptrace operations
This test suite also tests the following ptrace commands

- PTRACE_SETSIGMASK/PTRACE_GETSIGMASK
- PTRACE_SETREGS
- PTRACE_GETREGS
- PTRACE_GET_THREAD_AREA

## Code injection
The shellcode injection test has built in shellcode that it will inject into a process that it creates. This shellcode returns a speicific value that the test harness can use to verify that shellcode was successfully injected and executed. It does this by attaching to the target process. It then gets the current registers from the process. Using RIP it then writes the shell code to the location RIP points to. We then update the registers to point to the beginning of the shell code and start the process again. The shell code outputs the string "Hello, world\n" and returns the return code 42.

## Input
Every test accepts two arguments: `target_proc` and `target_args`. The shellcode injection tests accepts those two arguments and also accepts a another argument `shellcode_path`

### `target_proc` [pathlib.Path]
This argument is the path to a process to use as the target process for the ptrace command. The path should be the absolute path to a binary that will get run.

### `target_args` [list[str]]
This argument is a list of command line arguments to pass to the target process. This is to allow the user to specify custom command line environments when specifying the `target_proc`

### `shellcode_path` [pathlib.Path]
This argument is only used for the shellcode injection test. This argument is the full path to a file that contains shellcode that will be injected into the target process. If this argument is specified the shellcode injection test will inject and attempt to run the shellcode but will not be able to verify successfull execution of it.
## Output
`activity_at_ts` - The time at which the event occured

`command_line` - The command line that was executed that generated the event

`cwd` - The current working directory

`gid` - The group id of the process that was run

`md5` - The MD5 sum of the executable that was run

`pid` - The pid of the process that was run
 
`ppid` - The parent pid of the process that was run

`process_path` - The path to the executable that was run

`result` - This value is a string that will be either "success" or "failed"

`return_code` - The return code from the process that was run

`ptrace_cmds` - A list of the ptrace commands that were run for the test

`stderr` - Any output written to stderr

`stdin` - Any data written to stdin

`stdout` - Any output written to stdout

`target_pid` - The pid of the target process

`uid` - The user id of the process


## Example
```json
{
  "activity_at_ts": "2022-09-20T06:47:14.753Z",
  "command_line": "",
  "cwd": "/home/user",
  "gid": 1000,
  "md5": "40cd4952157426ab4d93e66a7027eeea",
  "pid": 35803,
  "ppid": 27137,
  "process_path": "/home/user/.local/share/virtualenvs/posix-_bUZGQT4/bin/python3",
  "ptrace_cmds": [
    "PTRACE_ATTACH",
    "PTRACE_GETREGS",
    "PTRACE_POKETEXT",
    "PTRACE_SETREGS",
    "PTRACE_DETACH"
  ],
  "result": "success",
  "return_code": 0,
  "stderr": null,
  "stdin": null,
  "stdout": null,
  "target_pid": 39151,
  "uid": 1000
}
```