// DO NOT EDIT THIS FILE
import { OctokitResponse } from "../OctokitResponse";
import { RequestHeaders } from "../RequestHeaders";
import { RequestRequestOptions } from "../RequestRequestOptions";

type RequiredPreview<T> = {
  mediaType: {
    previews: [T, ...string[]];
  };
};

export interface Endpoints {
  /**
   * @see https://developer.github.com/v3/apps/#delete-an-installation
   */
  "DELETE /app/installations/:installation_id": {
    parameters: AppsDeleteInstallationEndpoint;
    request: AppsDeleteInstallationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-authorization
   */
  "DELETE /applications/:client_id/grant": {
    parameters: AppsDeleteAuthorizationEndpoint;
    request: AppsDeleteAuthorizationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#revoke-a-grant-for-an-application
   */
  "DELETE /applications/:client_id/grants/:access_token": {
    parameters: AppsRevokeGrantForApplicationEndpoint;
    request: AppsRevokeGrantForApplicationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
   */
  "DELETE /applications/:client_id/token": {
    parameters: AppsDeleteTokenEndpoint;
    request: AppsDeleteTokenRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#revoke-an-authorization-for-an-application
   */
  "DELETE /applications/:client_id/tokens/:access_token": {
    parameters: AppsRevokeAuthorizationForApplicationEndpoint;
    request: AppsRevokeAuthorizationForApplicationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#delete-a-grant
   */
  "DELETE /applications/grants/:grant_id": {
    parameters: OauthAuthorizationsDeleteGrantEndpoint;
    request: OauthAuthorizationsDeleteGrantRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#delete-an-authorization
   */
  "DELETE /authorizations/:authorization_id": {
    parameters: OauthAuthorizationsDeleteAuthorizationEndpoint;
    request: OauthAuthorizationsDeleteAuthorizationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#delete-a-gist
   */
  "DELETE /gists/:gist_id": {
    parameters: GistsDeleteEndpoint;
    request: GistsDeleteRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/gists/comments/#delete-a-comment
   */
  "DELETE /gists/:gist_id/comments/:comment_id": {
    parameters: GistsDeleteCommentEndpoint;
    request: GistsDeleteCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#unstar-a-gist
   */
  "DELETE /gists/:gist_id/star": {
    parameters: GistsUnstarEndpoint;
    request: GistsUnstarRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#revoke-an-installation-token
   */
  "DELETE /installation/token": {
    parameters: AppsRevokeInstallationTokenEndpoint;
    request: AppsRevokeInstallationTokenRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#delete-a-thread-subscription
   */
  "DELETE /notifications/threads/:thread_id/subscription": {
    parameters: ActivityDeleteThreadSubscriptionEndpoint;
    request: ActivityDeleteThreadSubscriptionRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#delete-a-self-hosted-runner-from-an-organization
   */
  "DELETE /orgs/:org/actions/runners/:runner_id": {
    parameters: ActionsDeleteSelfHostedRunnerFromOrgEndpoint;
    request: ActionsDeleteSelfHostedRunnerFromOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/blocking/#unblock-a-user
   */
  "DELETE /orgs/:org/blocks/:username": {
    parameters: OrgsUnblockUserEndpoint;
    request: OrgsUnblockUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#remove-a-credential-authorization-for-an-organization
   */
  "DELETE /orgs/:org/credential-authorizations/:credential_id": {
    parameters: OrgsRemoveCredentialAuthorizationEndpoint;
    request: OrgsRemoveCredentialAuthorizationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/hooks/#delete-a-hook
   */
  "DELETE /orgs/:org/hooks/:hook_id": {
    parameters: OrgsDeleteHookEndpoint;
    request: OrgsDeleteHookRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/interactions/orgs/#remove-interaction-restrictions-for-an-organization
   */
  "DELETE /orgs/:org/interaction-limits": {
    parameters: InteractionsRemoveRestrictionsForOrgEndpoint;
    request: InteractionsRemoveRestrictionsForOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#remove-a-member
   */
  "DELETE /orgs/:org/members/:username": {
    parameters: OrgsRemoveMemberEndpoint;
    request: OrgsRemoveMemberRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#remove-organization-membership
   */
  "DELETE /orgs/:org/memberships/:username": {
    parameters: OrgsRemoveMembershipEndpoint;
    request: OrgsRemoveMembershipRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#delete-an-organization-migration-archive
   */
  "DELETE /orgs/:org/migrations/:migration_id/archive": {
    parameters: MigrationsDeleteArchiveForOrgEndpoint;
    request: MigrationsDeleteArchiveForOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#unlock-an-organization-repository
   */
  "DELETE /orgs/:org/migrations/:migration_id/repos/:repo_name/lock": {
    parameters: MigrationsUnlockRepoForOrgEndpoint;
    request: MigrationsUnlockRepoForOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/outside_collaborators/#remove-outside-collaborator
   */
  "DELETE /orgs/:org/outside_collaborators/:username": {
    parameters: OrgsRemoveOutsideCollaboratorEndpoint;
    request: OrgsRemoveOutsideCollaboratorRequestOptions;
    response: OctokitResponse<OrgsRemoveOutsideCollaboratorResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#conceal-a-users-membership
   */
  "DELETE /orgs/:org/public_members/:username": {
    parameters: OrgsConcealMembershipEndpoint;
    request: OrgsConcealMembershipRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#delete-team
   */
  "DELETE /orgs/:org/teams/:team_slug": {
    parameters: TeamsDeleteInOrgEndpoint;
    request: TeamsDeleteInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#delete-a-discussion
   */
  "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
    parameters: TeamsDeleteDiscussionInOrgEndpoint;
    request: TeamsDeleteDiscussionInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#delete-a-comment
   */
  "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
    parameters: TeamsDeleteDiscussionCommentInOrgEndpoint;
    request: TeamsDeleteDiscussionCommentInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-team-discussion-comment-reaction
   */
  "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id": {
    parameters: ReactionsDeleteForTeamDiscussionCommentEndpoint;
    request: ReactionsDeleteForTeamDiscussionCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-team-discussion-reaction
   */
  "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions/:reaction_id": {
    parameters: ReactionsDeleteForTeamDiscussionEndpoint;
    request: ReactionsDeleteForTeamDiscussionRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#remove-team-membership
   */
  "DELETE /orgs/:org/teams/:team_slug/memberships/:username": {
    parameters: TeamsRemoveMembershipInOrgEndpoint;
    request: TeamsRemoveMembershipInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#remove-team-project
   */
  "DELETE /orgs/:org/teams/:team_slug/projects/:project_id": {
    parameters: TeamsRemoveProjectInOrgEndpoint;
    request: TeamsRemoveProjectInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#remove-team-repository
   */
  "DELETE /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
    parameters: TeamsRemoveRepoInOrgEndpoint;
    request: TeamsRemoveRepoInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#delete-a-project
   */
  "DELETE /projects/:project_id": {
    parameters: ProjectsDeleteEndpoint;
    request: ProjectsDeleteRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/projects/collaborators/#remove-user-as-a-collaborator
   */
  "DELETE /projects/:project_id/collaborators/:username": {
    parameters: ProjectsRemoveCollaboratorEndpoint;
    request: ProjectsRemoveCollaboratorRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/projects/columns/#delete-a-project-column
   */
  "DELETE /projects/columns/:column_id": {
    parameters: ProjectsDeleteColumnEndpoint;
    request: ProjectsDeleteColumnRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/projects/cards/#delete-a-project-card
   */
  "DELETE /projects/columns/cards/:card_id": {
    parameters: ProjectsDeleteCardEndpoint;
    request: ProjectsDeleteCardRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-a-reaction-legacy
   */
  "DELETE /reactions/:reaction_id": {
    parameters: ReactionsDeleteLegacyEndpoint;
    request: ReactionsDeleteLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#delete-a-repository
   */
  "DELETE /repos/:owner/:repo": {
    parameters: ReposDeleteEndpoint;
    request: ReposDeleteRequestOptions;
    response: OctokitResponse<ReposDeleteResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/artifacts/#delete-an-artifact
   */
  "DELETE /repos/:owner/:repo/actions/artifacts/:artifact_id": {
    parameters: ActionsDeleteArtifactEndpoint;
    request: ActionsDeleteArtifactRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#delete-a-self-hosted-runner-from-a-repository
   */
  "DELETE /repos/:owner/:repo/actions/runners/:runner_id": {
    parameters: ActionsDeleteSelfHostedRunnerFromRepoEndpoint;
    request: ActionsDeleteSelfHostedRunnerFromRepoRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#delete-workflow-run-logs
   */
  "DELETE /repos/:owner/:repo/actions/runs/:run_id/logs": {
    parameters: ActionsDeleteWorkflowRunLogsEndpoint;
    request: ActionsDeleteWorkflowRunLogsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/secrets/#delete-a-secret-from-a-repository
   */
  "DELETE /repos/:owner/:repo/actions/secrets/:name": {
    parameters: ActionsDeleteSecretFromRepoEndpoint;
    request: ActionsDeleteSecretFromRepoRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#disable-automated-security-fixes
   */
  "DELETE /repos/:owner/:repo/automated-security-fixes": {
    parameters: ReposDisableAutomatedSecurityFixesEndpoint;
    request: ReposDisableAutomatedSecurityFixesRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-branch-protection
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection": {
    parameters: ReposRemoveBranchProtectionEndpoint;
    request: ReposRemoveBranchProtectionRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-admin-enforcement-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
    parameters: ReposRemoveProtectedBranchAdminEnforcementEndpoint;
    request: ReposRemoveProtectedBranchAdminEnforcementRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-pull-request-review-enforcement-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
    parameters: ReposRemoveProtectedBranchPullRequestReviewEnforcementEndpoint;
    request: ReposRemoveProtectedBranchPullRequestReviewEnforcementRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-required-signatures-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
    parameters: ReposRemoveProtectedBranchRequiredSignaturesEndpoint;
    request: ReposRemoveProtectedBranchRequiredSignaturesRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-required-status-checks-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
    parameters: ReposRemoveProtectedBranchRequiredStatusChecksEndpoint;
    request: ReposRemoveProtectedBranchRequiredStatusChecksRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-required-status-checks-contexts-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
    parameters: ReposRemoveProtectedBranchRequiredStatusChecksContextsEndpoint;
    request: ReposRemoveProtectedBranchRequiredStatusChecksContextsRequestOptions;
    response: OctokitResponse<
      ReposRemoveProtectedBranchRequiredStatusChecksContextsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-restrictions-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions": {
    parameters: ReposRemoveProtectedBranchRestrictionsEndpoint;
    request: ReposRemoveProtectedBranchRestrictionsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-app-restrictions-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
    parameters: ReposRemoveProtectedBranchAppRestrictionsEndpoint;
    request: ReposRemoveProtectedBranchAppRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposRemoveProtectedBranchAppRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-team-restrictions-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
    parameters: ReposRemoveProtectedBranchTeamRestrictionsEndpoint;
    request: ReposRemoveProtectedBranchTeamRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposRemoveProtectedBranchTeamRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#remove-user-restrictions-of-protected-branch
   */
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
    parameters: ReposRemoveProtectedBranchUserRestrictionsEndpoint;
    request: ReposRemoveProtectedBranchUserRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposRemoveProtectedBranchUserRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/collaborators/#remove-user-as-a-collaborator
   */
  "DELETE /repos/:owner/:repo/collaborators/:username": {
    parameters: ReposRemoveCollaboratorEndpoint;
    request: ReposRemoveCollaboratorRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/comments/#delete-a-commit-comment
   */
  "DELETE /repos/:owner/:repo/comments/:comment_id": {
    parameters: ReposDeleteCommitCommentEndpoint;
    request: ReposDeleteCommitCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-a-commit-comment-reaction
   */
  "DELETE /repos/:owner/:repo/comments/:comment_id/reactions/:reaction_id": {
    parameters: ReactionsDeleteForCommitCommentEndpoint;
    request: ReactionsDeleteForCommitCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/contents/#delete-a-file
   */
  "DELETE /repos/:owner/:repo/contents/:path": {
    parameters: ReposDeleteFileEndpoint;
    request: ReposDeleteFileRequestOptions;
    response: OctokitResponse<ReposDeleteFileResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#delete-a-deployment
   */
  "DELETE /repos/:owner/:repo/deployments/:deployment_id": {
    parameters: ReposDeleteDeploymentEndpoint;
    request: ReposDeleteDeploymentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/downloads/#delete-a-download
   */
  "DELETE /repos/:owner/:repo/downloads/:download_id": {
    parameters: ReposDeleteDownloadEndpoint;
    request: ReposDeleteDownloadRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/git/refs/#delete-a-reference
   */
  "DELETE /repos/:owner/:repo/git/refs/:ref": {
    parameters: GitDeleteRefEndpoint;
    request: GitDeleteRefRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#delete-a-hook
   */
  "DELETE /repos/:owner/:repo/hooks/:hook_id": {
    parameters: ReposDeleteHookEndpoint;
    request: ReposDeleteHookRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#cancel-an-import
   */
  "DELETE /repos/:owner/:repo/import": {
    parameters: MigrationsCancelImportEndpoint;
    request: MigrationsCancelImportRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/interactions/repos/#remove-interaction-restrictions-for-a-repository
   */
  "DELETE /repos/:owner/:repo/interaction-limits": {
    parameters: InteractionsRemoveRestrictionsForRepoEndpoint;
    request: InteractionsRemoveRestrictionsForRepoRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/invitations/#delete-a-repository-invitation
   */
  "DELETE /repos/:owner/:repo/invitations/:invitation_id": {
    parameters: ReposDeleteInvitationEndpoint;
    request: ReposDeleteInvitationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/issues/assignees/#remove-assignees-from-an-issue
   */
  "DELETE /repos/:owner/:repo/issues/:issue_number/assignees": {
    parameters: IssuesRemoveAssigneesEndpoint;
    request: IssuesRemoveAssigneesRequestOptions;
    response: OctokitResponse<IssuesRemoveAssigneesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#remove-all-labels-from-an-issue
   */
  "DELETE /repos/:owner/:repo/issues/:issue_number/labels": {
    parameters: IssuesRemoveAllLabelsEndpoint;
    request: IssuesRemoveAllLabelsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#remove-a-label-from-an-issue
   */
  "DELETE /repos/:owner/:repo/issues/:issue_number/labels/:name": {
    parameters: IssuesRemoveLabelEndpoint;
    request: IssuesRemoveLabelRequestOptions;
    response: OctokitResponse<IssuesRemoveLabelResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#unlock-an-issue
   */
  "DELETE /repos/:owner/:repo/issues/:issue_number/lock": {
    parameters: IssuesUnlockEndpoint;
    request: IssuesUnlockRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-an-issue-reaction
   */
  "DELETE /repos/:owner/:repo/issues/:issue_number/reactions/:reaction_id": {
    parameters: ReactionsDeleteForIssueEndpoint;
    request: ReactionsDeleteForIssueRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/issues/comments/#delete-a-comment
   */
  "DELETE /repos/:owner/:repo/issues/comments/:comment_id": {
    parameters: IssuesDeleteCommentEndpoint;
    request: IssuesDeleteCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-an-issue-comment-reaction
   */
  "DELETE /repos/:owner/:repo/issues/comments/:comment_id/reactions/:reaction_id": {
    parameters: ReactionsDeleteForIssueCommentEndpoint;
    request: ReactionsDeleteForIssueCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/keys/#remove-a-deploy-key
   */
  "DELETE /repos/:owner/:repo/keys/:key_id": {
    parameters: ReposRemoveDeployKeyEndpoint;
    request: ReposRemoveDeployKeyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#delete-a-label
   */
  "DELETE /repos/:owner/:repo/labels/:name": {
    parameters: IssuesDeleteLabelEndpoint;
    request: IssuesDeleteLabelRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/issues/milestones/#delete-a-milestone
   */
  "DELETE /repos/:owner/:repo/milestones/:milestone_number": {
    parameters: IssuesDeleteMilestoneEndpoint;
    request: IssuesDeleteMilestoneRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#disable-a-pages-site
   */
  "DELETE /repos/:owner/:repo/pages": {
    parameters: ReposDisablePagesSiteEndpoint;
    request: ReposDisablePagesSiteRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/review_requests/#delete-a-review-request
   */
  "DELETE /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
    parameters: PullsDeleteReviewRequestEndpoint;
    request: PullsDeleteReviewRequestRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#delete-a-pending-review
   */
  "DELETE /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
    parameters: PullsDeletePendingReviewEndpoint;
    request: PullsDeletePendingReviewRequestOptions;
    response: OctokitResponse<PullsDeletePendingReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#delete-a-comment
   */
  "DELETE /repos/:owner/:repo/pulls/comments/:comment_id": {
    parameters: PullsDeleteCommentEndpoint;
    request: PullsDeleteCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#delete-a-pull-request-comment-reaction
   */
  "DELETE /repos/:owner/:repo/pulls/comments/:comment_id/reactions/:reaction_id": {
    parameters: ReactionsDeleteForPullRequestCommentEndpoint;
    request: ReactionsDeleteForPullRequestCommentRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#delete-a-release
   */
  "DELETE /repos/:owner/:repo/releases/:release_id": {
    parameters: ReposDeleteReleaseEndpoint;
    request: ReposDeleteReleaseRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#delete-a-release-asset
   */
  "DELETE /repos/:owner/:repo/releases/assets/:asset_id": {
    parameters: ReposDeleteReleaseAssetEndpoint;
    request: ReposDeleteReleaseAssetRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#delete-a-repository-subscription
   */
  "DELETE /repos/:owner/:repo/subscription": {
    parameters: ActivityDeleteRepoSubscriptionEndpoint;
    request: ActivityDeleteRepoSubscriptionRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#disable-vulnerability-alerts
   */
  "DELETE /repos/:owner/:repo/vulnerability-alerts": {
    parameters: ReposDisableVulnerabilityAlertsEndpoint;
    request: ReposDisableVulnerabilityAlertsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/scim/#remove-a-user-from-the-organization
   */
  "DELETE /scim/v2/organizations/:org/Users/:scim_user_id": {
    parameters: ScimRemoveUserFromOrgEndpoint;
    request: ScimRemoveUserFromOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#delete-team-legacy
   */
  "DELETE /teams/:team_id": {
    parameters: TeamsDeleteLegacyEndpoint;
    request: TeamsDeleteLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#delete-a-discussion-legacy
   */
  "DELETE /teams/:team_id/discussions/:discussion_number": {
    parameters: TeamsDeleteDiscussionLegacyEndpoint;
    request: TeamsDeleteDiscussionLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#delete-a-comment-legacy
   */
  "DELETE /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
    parameters: TeamsDeleteDiscussionCommentLegacyEndpoint;
    request: TeamsDeleteDiscussionCommentLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#remove-team-member-legacy
   */
  "DELETE /teams/:team_id/members/:username": {
    parameters: TeamsRemoveMemberLegacyEndpoint;
    request: TeamsRemoveMemberLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#remove-team-membership-legacy
   */
  "DELETE /teams/:team_id/memberships/:username": {
    parameters: TeamsRemoveMembershipLegacyEndpoint;
    request: TeamsRemoveMembershipLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#remove-team-project-legacy
   */
  "DELETE /teams/:team_id/projects/:project_id": {
    parameters: TeamsRemoveProjectLegacyEndpoint;
    request: TeamsRemoveProjectLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#remove-team-repository-legacy
   */
  "DELETE /teams/:team_id/repos/:owner/:repo": {
    parameters: TeamsRemoveRepoLegacyEndpoint;
    request: TeamsRemoveRepoLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/blocking/#unblock-a-user
   */
  "DELETE /user/blocks/:username": {
    parameters: UsersUnblockEndpoint;
    request: UsersUnblockRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/emails/#delete-email-addresses
   */
  "DELETE /user/emails": {
    parameters: UsersDeleteEmailsEndpoint;
    request: UsersDeleteEmailsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#unfollow-a-user
   */
  "DELETE /user/following/:username": {
    parameters: UsersUnfollowEndpoint;
    request: UsersUnfollowRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/gpg_keys/#delete-a-gpg-key
   */
  "DELETE /user/gpg_keys/:gpg_key_id": {
    parameters: UsersDeleteGpgKeyEndpoint;
    request: UsersDeleteGpgKeyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#remove-repository-from-installation
   */
  "DELETE /user/installations/:installation_id/repositories/:repository_id": {
    parameters: AppsRemoveRepoFromInstallationEndpoint;
    request: AppsRemoveRepoFromInstallationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/keys/#delete-a-public-key
   */
  "DELETE /user/keys/:key_id": {
    parameters: UsersDeletePublicKeyEndpoint;
    request: UsersDeletePublicKeyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#delete-a-user-migration-archive
   */
  "DELETE /user/migrations/:migration_id/archive": {
    parameters: MigrationsDeleteArchiveForAuthenticatedUserEndpoint;
    request: MigrationsDeleteArchiveForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#unlock-a-user-repository
   */
  "DELETE /user/migrations/:migration_id/repos/:repo_name/lock": {
    parameters: MigrationsUnlockRepoForAuthenticatedUserEndpoint;
    request: MigrationsUnlockRepoForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/invitations/#decline-a-repository-invitation
   */
  "DELETE /user/repository_invitations/:invitation_id": {
    parameters: ReposDeclineInvitationEndpoint;
    request: ReposDeclineInvitationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/starring/#unstar-a-repository-for-the-authenticated-user
   */
  "DELETE /user/starred/:owner/:repo": {
    parameters: ActivityUnstarRepoForAuthenticatedUserEndpoint;
    request: ActivityUnstarRepoForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#stop-watching-a-repository-legacy
   */
  "DELETE /user/subscriptions/:owner/:repo": {
    parameters: ActivityStopWatchingRepoLegacyEndpoint;
    request: ActivityStopWatchingRepoLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#get-the-authenticated-github-app
   */
  "GET /app": {
    parameters: AppsGetAuthenticatedEndpoint;
    request: AppsGetAuthenticatedRequestOptions;
    response: OctokitResponse<AppsGetAuthenticatedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#list-installations
   */
  "GET /app/installations": {
    parameters: AppsListInstallationsEndpoint;
    request: AppsListInstallationsRequestOptions;
    response: OctokitResponse<AppsListInstallationsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#get-an-installation
   */
  "GET /app/installations/:installation_id": {
    parameters: AppsGetInstallationEndpoint;
    request: AppsGetInstallationRequestOptions;
    response: OctokitResponse<AppsGetInstallationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#check-an-authorization
   */
  "GET /applications/:client_id/tokens/:access_token": {
    parameters: AppsCheckAuthorizationEndpoint;
    request: AppsCheckAuthorizationRequestOptions;
    response: OctokitResponse<AppsCheckAuthorizationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#list-your-grants
   */
  "GET /applications/grants": {
    parameters: OauthAuthorizationsListGrantsEndpoint;
    request: OauthAuthorizationsListGrantsRequestOptions;
    response: OctokitResponse<OauthAuthorizationsListGrantsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-grant
   */
  "GET /applications/grants/:grant_id": {
    parameters: OauthAuthorizationsGetGrantEndpoint;
    request: OauthAuthorizationsGetGrantRequestOptions;
    response: OctokitResponse<OauthAuthorizationsGetGrantResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#get-a-single-github-app
   */
  "GET /apps/:app_slug": {
    parameters: AppsGetBySlugEndpoint;
    request: AppsGetBySlugRequestOptions;
    response: OctokitResponse<AppsGetBySlugResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#list-your-authorizations
   */
  "GET /authorizations": {
    parameters: OauthAuthorizationsListAuthorizationsEndpoint;
    request: OauthAuthorizationsListAuthorizationsRequestOptions;
    response: OctokitResponse<
      OauthAuthorizationsListAuthorizationsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-authorization
   */
  "GET /authorizations/:authorization_id": {
    parameters: OauthAuthorizationsGetAuthorizationEndpoint;
    request: OauthAuthorizationsGetAuthorizationRequestOptions;
    response: OctokitResponse<OauthAuthorizationsGetAuthorizationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/codes_of_conduct/#list-all-codes-of-conduct
   */
  "GET /codes_of_conduct": {
    parameters: CodesOfConductGetAllCodesOfConductEndpoint;
    request: CodesOfConductGetAllCodesOfConductRequestOptions;
    response: OctokitResponse<CodesOfConductGetAllCodesOfConductResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/codes_of_conduct/#get-an-individual-code-of-conduct
   */
  "GET /codes_of_conduct/:key": {
    parameters: CodesOfConductGetConductCodeEndpoint;
    request: CodesOfConductGetConductCodeRequestOptions;
    response: OctokitResponse<CodesOfConductGetConductCodeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/emojis/#emojis
   */
  "GET /emojis": {
    parameters: EmojisGetEndpoint;
    request: EmojisGetRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-public-events
   */
  "GET /events": {
    parameters: ActivityListPublicEventsEndpoint;
    request: ActivityListPublicEventsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/feeds/#get-feeds
   */
  "GET /feeds": {
    parameters: ActivityGetFeedsEndpoint;
    request: ActivityGetFeedsRequestOptions;
    response: OctokitResponse<ActivityGetFeedsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#list-gists-for-the-authenticated-user
   */
  "GET /gists": {
    parameters: GistsListEndpoint;
    request: GistsListRequestOptions;
    response: OctokitResponse<GistsListResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#get-a-gist
   */
  "GET /gists/:gist_id": {
    parameters: GistsGetEndpoint;
    request: GistsGetRequestOptions;
    response: OctokitResponse<GistsGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#get-a-specific-revision-of-a-gist
   */
  "GET /gists/:gist_id/:sha": {
    parameters: GistsGetRevisionEndpoint;
    request: GistsGetRevisionRequestOptions;
    response: OctokitResponse<GistsGetRevisionResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/comments/#list-comments-on-a-gist
   */
  "GET /gists/:gist_id/comments": {
    parameters: GistsListCommentsEndpoint;
    request: GistsListCommentsRequestOptions;
    response: OctokitResponse<GistsListCommentsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/comments/#get-a-single-comment
   */
  "GET /gists/:gist_id/comments/:comment_id": {
    parameters: GistsGetCommentEndpoint;
    request: GistsGetCommentRequestOptions;
    response: OctokitResponse<GistsGetCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#list-gist-commits
   */
  "GET /gists/:gist_id/commits": {
    parameters: GistsListCommitsEndpoint;
    request: GistsListCommitsRequestOptions;
    response: OctokitResponse<GistsListCommitsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#list-gist-forks
   */
  "GET /gists/:gist_id/forks": {
    parameters: GistsListForksEndpoint;
    request: GistsListForksRequestOptions;
    response: OctokitResponse<GistsListForksResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#check-if-a-gist-is-starred
   */
  "GET /gists/:gist_id/star": {
    parameters: GistsCheckIsStarredEndpoint;
    request: GistsCheckIsStarredRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#list-public-gists
   */
  "GET /gists/public": {
    parameters: GistsListPublicEndpoint;
    request: GistsListPublicRequestOptions;
    response: OctokitResponse<GistsListPublicResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#list-starred-gists
   */
  "GET /gists/starred": {
    parameters: GistsListStarredEndpoint;
    request: GistsListStarredRequestOptions;
    response: OctokitResponse<GistsListStarredResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gitignore/#listing-available-templates
   */
  "GET /gitignore/templates": {
    parameters: GitignoreListTemplatesEndpoint;
    request: GitignoreListTemplatesRequestOptions;
    response: OctokitResponse<GitignoreListTemplatesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gitignore/#get-a-single-template
   */
  "GET /gitignore/templates/:name": {
    parameters: GitignoreGetTemplateEndpoint;
    request: GitignoreGetTemplateRequestOptions;
    response: OctokitResponse<GitignoreGetTemplateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#list-repositories
   */
  "GET /installation/repositories": {
    parameters: AppsListReposEndpoint;
    request: AppsListReposRequestOptions;
    response: OctokitResponse<AppsListReposResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#list-issues-assigned-to-the-authenticated-user
   */
  "GET /issues": {
    parameters: IssuesListEndpoint;
    request: IssuesListRequestOptions;
    response: OctokitResponse<IssuesListResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/legacy/#search-issues
   */
  "GET /legacy/issues/search/:owner/:repository/:state/:keyword": {
    parameters: SearchIssuesLegacyEndpoint;
    request: SearchIssuesLegacyRequestOptions;
    response: OctokitResponse<SearchIssuesLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/legacy/#search-repositories
   */
  "GET /legacy/repos/search/:keyword": {
    parameters: SearchReposLegacyEndpoint;
    request: SearchReposLegacyRequestOptions;
    response: OctokitResponse<SearchReposLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/legacy/#email-search
   */
  "GET /legacy/user/email/:email": {
    parameters: SearchEmailLegacyEndpoint;
    request: SearchEmailLegacyRequestOptions;
    response: OctokitResponse<SearchEmailLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/legacy/#search-users
   */
  "GET /legacy/user/search/:keyword": {
    parameters: SearchUsersLegacyEndpoint;
    request: SearchUsersLegacyRequestOptions;
    response: OctokitResponse<SearchUsersLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/licenses/#list-commonly-used-licenses
   */
  "GET /licenses": {
    parameters: LicensesListCommonlyUsedEndpoint;
    request: LicensesListCommonlyUsedRequestOptions;
    response: OctokitResponse<LicensesListCommonlyUsedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/licenses/#get-an-individual-license
   */
  "GET /licenses/:license": {
    parameters: LicensesGetEndpoint;
    request: LicensesGetRequestOptions;
    response: OctokitResponse<LicensesGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#get-a-subscription-plan-for-an-account
   */
  "GET /marketplace_listing/accounts/:account_id": {
    parameters: AppsGetSubscriptionPlanForAccountEndpoint;
    request: AppsGetSubscriptionPlanForAccountRequestOptions;
    response: OctokitResponse<AppsGetSubscriptionPlanForAccountResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#list-plans
   */
  "GET /marketplace_listing/plans": {
    parameters: AppsListPlansEndpoint;
    request: AppsListPlansRequestOptions;
    response: OctokitResponse<AppsListPlansResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#list-accounts-for-a-plan
   */
  "GET /marketplace_listing/plans/:plan_id/accounts": {
    parameters: AppsListAccountsForPlanEndpoint;
    request: AppsListAccountsForPlanRequestOptions;
    response: OctokitResponse<AppsListAccountsForPlanResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#get-a-subscription-plan-for-an-account-stubbed
   */
  "GET /marketplace_listing/stubbed/accounts/:account_id": {
    parameters: AppsGetSubscriptionPlanForAccountStubbedEndpoint;
    request: AppsGetSubscriptionPlanForAccountStubbedRequestOptions;
    response: OctokitResponse<
      AppsGetSubscriptionPlanForAccountStubbedResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#list-plans-stubbed
   */
  "GET /marketplace_listing/stubbed/plans": {
    parameters: AppsListPlansStubbedEndpoint;
    request: AppsListPlansStubbedRequestOptions;
    response: OctokitResponse<AppsListPlansStubbedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#list-accounts-for-a-plan-stubbed
   */
  "GET /marketplace_listing/stubbed/plans/:plan_id/accounts": {
    parameters: AppsListAccountsForPlanStubbedEndpoint;
    request: AppsListAccountsForPlanStubbedRequestOptions;
    response: OctokitResponse<AppsListAccountsForPlanStubbedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/meta/#meta
   */
  "GET /meta": {
    parameters: MetaGetEndpoint;
    request: MetaGetRequestOptions;
    response: OctokitResponse<MetaGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-network-of-repositories
   */
  "GET /networks/:owner/:repo/events": {
    parameters: ActivityListPublicEventsForRepoNetworkEndpoint;
    request: ActivityListPublicEventsForRepoNetworkRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#list-notifications-for-the-authenticated-user
   */
  "GET /notifications": {
    parameters: ActivityListNotificationsForAuthenticatedUserEndpoint;
    request: ActivityListNotificationsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      ActivityListNotificationsForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#get-a-thread
   */
  "GET /notifications/threads/:thread_id": {
    parameters: ActivityGetThreadEndpoint;
    request: ActivityGetThreadRequestOptions;
    response: OctokitResponse<ActivityGetThreadResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#get-a-thread-subscription-for-the-authenticated-user
   */
  "GET /notifications/threads/:thread_id/subscription": {
    parameters: ActivityGetThreadSubscriptionForAuthenticatedUserEndpoint;
    request: ActivityGetThreadSubscriptionForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      ActivityGetThreadSubscriptionForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#list-all-organizations
   */
  "GET /organizations": {
    parameters: OrgsListEndpoint;
    request: OrgsListRequestOptions;
    response: OctokitResponse<OrgsListResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#get-an-organization
   */
  "GET /orgs/:org": {
    parameters: OrgsGetEndpoint;
    request: OrgsGetRequestOptions;
    response: OctokitResponse<OrgsGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-self-hosted-runners-for-an-organization
   */
  "GET /orgs/:org/actions/runners": {
    parameters: ActionsListSelfHostedRunnersForOrgEndpoint;
    request: ActionsListSelfHostedRunnersForOrgRequestOptions;
    response: OctokitResponse<ActionsListSelfHostedRunnersForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#get-a-self-hosted-runner-for-an-organization
   */
  "GET /orgs/:org/actions/runners/:runner_id": {
    parameters: ActionsGetSelfHostedRunnerForOrgEndpoint;
    request: ActionsGetSelfHostedRunnerForOrgRequestOptions;
    response: OctokitResponse<ActionsGetSelfHostedRunnerForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-runner-applications-for-an-organization
   */
  "GET /orgs/:org/actions/runners/downloads": {
    parameters: ActionsListRunnerApplicationsForOrgEndpoint;
    request: ActionsListRunnerApplicationsForOrgRequestOptions;
    response: OctokitResponse<ActionsListRunnerApplicationsForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/blocking/#list-blocked-users
   */
  "GET /orgs/:org/blocks": {
    parameters: OrgsListBlockedUsersEndpoint;
    request: OrgsListBlockedUsersRequestOptions;
    response: OctokitResponse<OrgsListBlockedUsersResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/blocking/#check-whether-a-user-is-blocked-from-an-organization
   */
  "GET /orgs/:org/blocks/:username": {
    parameters: OrgsCheckBlockedUserEndpoint;
    request: OrgsCheckBlockedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#list-credential-authorizations-for-an-organization
   */
  "GET /orgs/:org/credential-authorizations": {
    parameters: OrgsListCredentialAuthorizationsEndpoint;
    request: OrgsListCredentialAuthorizationsRequestOptions;
    response: OctokitResponse<OrgsListCredentialAuthorizationsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-public-organization-events
   */
  "GET /orgs/:org/events": {
    parameters: ActivityListPublicOrgEventsEndpoint;
    request: ActivityListPublicOrgEventsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/hooks/#list-hooks
   */
  "GET /orgs/:org/hooks": {
    parameters: OrgsListHooksEndpoint;
    request: OrgsListHooksRequestOptions;
    response: OctokitResponse<OrgsListHooksResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/hooks/#get-single-hook
   */
  "GET /orgs/:org/hooks/:hook_id": {
    parameters: OrgsGetHookEndpoint;
    request: OrgsGetHookRequestOptions;
    response: OctokitResponse<OrgsGetHookResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#get-an-organization-installation
   */
  "GET /orgs/:org/installation": {
    parameters: AppsGetOrgInstallationEndpoint;
    request: AppsGetOrgInstallationRequestOptions;
    response: OctokitResponse<AppsGetOrgInstallationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#list-installations-for-an-organization
   */
  "GET /orgs/:org/installations": {
    parameters: OrgsListInstallationsEndpoint;
    request: OrgsListInstallationsRequestOptions;
    response: OctokitResponse<OrgsListInstallationsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/interactions/orgs/#get-interaction-restrictions-for-an-organization
   */
  "GET /orgs/:org/interaction-limits": {
    parameters: InteractionsGetRestrictionsForOrgEndpoint;
    request: InteractionsGetRestrictionsForOrgRequestOptions;
    response: OctokitResponse<InteractionsGetRestrictionsForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#list-pending-organization-invitations
   */
  "GET /orgs/:org/invitations": {
    parameters: OrgsListPendingInvitationsEndpoint;
    request: OrgsListPendingInvitationsRequestOptions;
    response: OctokitResponse<OrgsListPendingInvitationsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#list-organization-invitation-teams
   */
  "GET /orgs/:org/invitations/:invitation_id/teams": {
    parameters: OrgsListInvitationTeamsEndpoint;
    request: OrgsListInvitationTeamsRequestOptions;
    response: OctokitResponse<OrgsListInvitationTeamsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#list-organization-issues-assigned-to-the-authenticated-user
   */
  "GET /orgs/:org/issues": {
    parameters: IssuesListForOrgEndpoint;
    request: IssuesListForOrgRequestOptions;
    response: OctokitResponse<IssuesListForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#members-list
   */
  "GET /orgs/:org/members": {
    parameters: OrgsListMembersEndpoint;
    request: OrgsListMembersRequestOptions;
    response: OctokitResponse<OrgsListMembersResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#check-membership
   */
  "GET /orgs/:org/members/:username": {
    parameters: OrgsCheckMembershipEndpoint;
    request: OrgsCheckMembershipRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#get-organization-membership
   */
  "GET /orgs/:org/memberships/:username": {
    parameters: OrgsGetMembershipEndpoint;
    request: OrgsGetMembershipRequestOptions;
    response: OctokitResponse<OrgsGetMembershipResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#list-organization-migrations
   */
  "GET /orgs/:org/migrations": {
    parameters: MigrationsListForOrgEndpoint;
    request: MigrationsListForOrgRequestOptions;
    response: OctokitResponse<MigrationsListForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#get-the-status-of-an-organization-migration
   */
  "GET /orgs/:org/migrations/:migration_id": {
    parameters: MigrationsGetStatusForOrgEndpoint;
    request: MigrationsGetStatusForOrgRequestOptions;
    response: OctokitResponse<MigrationsGetStatusForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#download-an-organization-migration-archive
   */
  "GET /orgs/:org/migrations/:migration_id/archive": {
    parameters: MigrationsDownloadArchiveForOrgEndpoint;
    request: MigrationsDownloadArchiveForOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#list-repositories-in-an-organization-migration
   */
  "GET /orgs/:org/migrations/:migration_id/repositories": {
    parameters: MigrationsListReposForOrgEndpoint;
    request: MigrationsListReposForOrgRequestOptions;
    response: OctokitResponse<MigrationsListReposForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/outside_collaborators/#list-outside-collaborators
   */
  "GET /orgs/:org/outside_collaborators": {
    parameters: OrgsListOutsideCollaboratorsEndpoint;
    request: OrgsListOutsideCollaboratorsRequestOptions;
    response: OctokitResponse<OrgsListOutsideCollaboratorsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#list-organization-projects
   */
  "GET /orgs/:org/projects": {
    parameters: ProjectsListForOrgEndpoint;
    request: ProjectsListForOrgRequestOptions;
    response: OctokitResponse<ProjectsListForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#public-members-list
   */
  "GET /orgs/:org/public_members": {
    parameters: OrgsListPublicMembersEndpoint;
    request: OrgsListPublicMembersRequestOptions;
    response: OctokitResponse<OrgsListPublicMembersResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#check-public-membership
   */
  "GET /orgs/:org/public_members/:username": {
    parameters: OrgsCheckPublicMembershipEndpoint;
    request: OrgsCheckPublicMembershipRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-organization-repositories
   */
  "GET /orgs/:org/repos": {
    parameters: ReposListForOrgEndpoint;
    request: ReposListForOrgRequestOptions;
    response: OctokitResponse<ReposListForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-in-an-organization
   */
  "GET /orgs/:org/team-sync/groups": {
    parameters: TeamsListIdPGroupsForOrgEndpoint;
    request: TeamsListIdPGroupsForOrgRequestOptions;
    response: OctokitResponse<TeamsListIdPGroupsForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-teams
   */
  "GET /orgs/:org/teams": {
    parameters: TeamsListEndpoint;
    request: TeamsListRequestOptions;
    response: OctokitResponse<TeamsListResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#get-team-by-name
   */
  "GET /orgs/:org/teams/:team_slug": {
    parameters: TeamsGetByNameEndpoint;
    request: TeamsGetByNameRequestOptions;
    response: OctokitResponse<TeamsGetByNameResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#list-discussions
   */
  "GET /orgs/:org/teams/:team_slug/discussions": {
    parameters: TeamsListDiscussionsInOrgEndpoint;
    request: TeamsListDiscussionsInOrgRequestOptions;
    response: OctokitResponse<TeamsListDiscussionsInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#get-a-single-discussion
   */
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
    parameters: TeamsGetDiscussionInOrgEndpoint;
    request: TeamsGetDiscussionInOrgRequestOptions;
    response: OctokitResponse<TeamsGetDiscussionInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#list-comments
   */
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": {
    parameters: TeamsListDiscussionCommentsInOrgEndpoint;
    request: TeamsListDiscussionCommentsInOrgRequestOptions;
    response: OctokitResponse<TeamsListDiscussionCommentsInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#get-a-single-comment
   */
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
    parameters: TeamsGetDiscussionCommentInOrgEndpoint;
    request: TeamsGetDiscussionCommentInOrgRequestOptions;
    response: OctokitResponse<TeamsGetDiscussionCommentInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-comment
   */
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": {
    parameters: ReactionsListForTeamDiscussionCommentInOrgEndpoint;
    request: ReactionsListForTeamDiscussionCommentInOrgRequestOptions;
    response: OctokitResponse<
      ReactionsListForTeamDiscussionCommentInOrgResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion
   */
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": {
    parameters: ReactionsListForTeamDiscussionInOrgEndpoint;
    request: ReactionsListForTeamDiscussionInOrgRequestOptions;
    response: OctokitResponse<ReactionsListForTeamDiscussionInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#list-pending-team-invitations
   */
  "GET /orgs/:org/teams/:team_slug/invitations": {
    parameters: TeamsListPendingInvitationsInOrgEndpoint;
    request: TeamsListPendingInvitationsInOrgRequestOptions;
    response: OctokitResponse<TeamsListPendingInvitationsInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#list-team-members
   */
  "GET /orgs/:org/teams/:team_slug/members": {
    parameters: TeamsListMembersInOrgEndpoint;
    request: TeamsListMembersInOrgRequestOptions;
    response: OctokitResponse<TeamsListMembersInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#get-team-membership
   */
  "GET /orgs/:org/teams/:team_slug/memberships/:username": {
    parameters: TeamsGetMembershipInOrgEndpoint;
    request: TeamsGetMembershipInOrgRequestOptions;
    response: OctokitResponse<TeamsGetMembershipInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-team-projects
   */
  "GET /orgs/:org/teams/:team_slug/projects": {
    parameters: TeamsListProjectsInOrgEndpoint;
    request: TeamsListProjectsInOrgRequestOptions;
    response: OctokitResponse<TeamsListProjectsInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#review-a-team-project
   */
  "GET /orgs/:org/teams/:team_slug/projects/:project_id": {
    parameters: TeamsReviewProjectInOrgEndpoint;
    request: TeamsReviewProjectInOrgRequestOptions;
    response: OctokitResponse<TeamsReviewProjectInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-team-repos
   */
  "GET /orgs/:org/teams/:team_slug/repos": {
    parameters: TeamsListReposInOrgEndpoint;
    request: TeamsListReposInOrgRequestOptions;
    response: OctokitResponse<TeamsListReposInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#check-if-a-team-manages-a-repository
   */
  "GET /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
    parameters: TeamsCheckManagesRepoInOrgEndpoint;
    request: TeamsCheckManagesRepoInOrgRequestOptions;
    response: OctokitResponse<TeamsCheckManagesRepoInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-a-team
   */
  "GET /orgs/:org/teams/:team_slug/team-sync/group-mappings": {
    parameters: TeamsListIdPGroupsInOrgEndpoint;
    request: TeamsListIdPGroupsInOrgRequestOptions;
    response: OctokitResponse<TeamsListIdPGroupsInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-child-teams
   */
  "GET /orgs/:org/teams/:team_slug/teams": {
    parameters: TeamsListChildInOrgEndpoint;
    request: TeamsListChildInOrgRequestOptions;
    response: OctokitResponse<TeamsListChildInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#get-a-project
   */
  "GET /projects/:project_id": {
    parameters: ProjectsGetEndpoint;
    request: ProjectsGetRequestOptions;
    response: OctokitResponse<ProjectsGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/collaborators/#list-collaborators
   */
  "GET /projects/:project_id/collaborators": {
    parameters: ProjectsListCollaboratorsEndpoint;
    request: ProjectsListCollaboratorsRequestOptions;
    response: OctokitResponse<ProjectsListCollaboratorsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/collaborators/#review-a-users-permission-level
   */
  "GET /projects/:project_id/collaborators/:username/permission": {
    parameters: ProjectsReviewUserPermissionLevelEndpoint;
    request: ProjectsReviewUserPermissionLevelRequestOptions;
    response: OctokitResponse<ProjectsReviewUserPermissionLevelResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/columns/#list-project-columns
   */
  "GET /projects/:project_id/columns": {
    parameters: ProjectsListColumnsEndpoint;
    request: ProjectsListColumnsRequestOptions;
    response: OctokitResponse<ProjectsListColumnsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/columns/#get-a-project-column
   */
  "GET /projects/columns/:column_id": {
    parameters: ProjectsGetColumnEndpoint;
    request: ProjectsGetColumnRequestOptions;
    response: OctokitResponse<ProjectsGetColumnResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/cards/#list-project-cards
   */
  "GET /projects/columns/:column_id/cards": {
    parameters: ProjectsListCardsEndpoint;
    request: ProjectsListCardsRequestOptions;
    response: OctokitResponse<ProjectsListCardsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/cards/#get-a-project-card
   */
  "GET /projects/columns/cards/:card_id": {
    parameters: ProjectsGetCardEndpoint;
    request: ProjectsGetCardRequestOptions;
    response: OctokitResponse<ProjectsGetCardResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/rate_limit/#get-your-current-rate-limit-status
   */
  "GET /rate_limit": {
    parameters: RateLimitGetEndpoint;
    request: RateLimitGetRequestOptions;
    response: OctokitResponse<RateLimitGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#get-a-repository
   */
  "GET /repos/:owner/:repo": {
    parameters: ReposGetEndpoint;
    request: ReposGetRequestOptions;
    response: OctokitResponse<ReposGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/contents/#get-archive-link
   */
  "GET /repos/:owner/:repo/:archive_format/:ref": {
    parameters: ReposGetArchiveLinkEndpoint;
    request: ReposGetArchiveLinkRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/artifacts/#list-artifacts-for-a-repository
   */
  "GET /repos/:owner/:repo/actions/artifacts": {
    parameters: ActionsListArtifactsForRepoEndpoint;
    request: ActionsListArtifactsForRepoRequestOptions;
    response: OctokitResponse<ActionsListArtifactsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/artifacts/#get-an-artifact
   */
  "GET /repos/:owner/:repo/actions/artifacts/:artifact_id": {
    parameters: ActionsGetArtifactEndpoint;
    request: ActionsGetArtifactRequestOptions;
    response: OctokitResponse<ActionsGetArtifactResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/artifacts/#download-an-artifact
   */
  "GET /repos/:owner/:repo/actions/artifacts/:artifact_id/:archive_format": {
    parameters: ActionsDownloadArtifactEndpoint;
    request: ActionsDownloadArtifactRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-jobs/#get-a-workflow-job
   */
  "GET /repos/:owner/:repo/actions/jobs/:job_id": {
    parameters: ActionsGetWorkflowJobEndpoint;
    request: ActionsGetWorkflowJobRequestOptions;
    response: OctokitResponse<ActionsGetWorkflowJobResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-jobs/#list-workflow-job-logs
   */
  "GET /repos/:owner/:repo/actions/jobs/:job_id/logs": {
    parameters: ActionsListWorkflowJobLogsEndpoint;
    request: ActionsListWorkflowJobLogsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-self-hosted-runners-for-a-repository
   */
  "GET /repos/:owner/:repo/actions/runners": {
    parameters: ActionsListSelfHostedRunnersForRepoEndpoint;
    request: ActionsListSelfHostedRunnersForRepoRequestOptions;
    response: OctokitResponse<ActionsListSelfHostedRunnersForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#get-a-self-hosted-runner-for-a-repository
   */
  "GET /repos/:owner/:repo/actions/runners/:runner_id": {
    parameters: ActionsGetSelfHostedRunnerForRepoEndpoint;
    request: ActionsGetSelfHostedRunnerForRepoRequestOptions;
    response: OctokitResponse<ActionsGetSelfHostedRunnerForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-runner-applications-for-a-repository
   */
  "GET /repos/:owner/:repo/actions/runners/downloads": {
    parameters: ActionsListRunnerApplicationsForRepoEndpoint;
    request: ActionsListRunnerApplicationsForRepoRequestOptions;
    response: OctokitResponse<ActionsListRunnerApplicationsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#list-repository-workflow-runs
   */
  "GET /repos/:owner/:repo/actions/runs": {
    parameters: ActionsListRepoWorkflowRunsEndpoint;
    request: ActionsListRepoWorkflowRunsRequestOptions;
    response: OctokitResponse<ActionsListRepoWorkflowRunsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#get-a-workflow-run
   */
  "GET /repos/:owner/:repo/actions/runs/:run_id": {
    parameters: ActionsGetWorkflowRunEndpoint;
    request: ActionsGetWorkflowRunRequestOptions;
    response: OctokitResponse<ActionsGetWorkflowRunResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/artifacts/#list-workflow-run-artifacts
   */
  "GET /repos/:owner/:repo/actions/runs/:run_id/artifacts": {
    parameters: ActionsListWorkflowRunArtifactsEndpoint;
    request: ActionsListWorkflowRunArtifactsRequestOptions;
    response: OctokitResponse<ActionsListWorkflowRunArtifactsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-jobs/#list-jobs-for-a-workflow-run
   */
  "GET /repos/:owner/:repo/actions/runs/:run_id/jobs": {
    parameters: ActionsListJobsForWorkflowRunEndpoint;
    request: ActionsListJobsForWorkflowRunRequestOptions;
    response: OctokitResponse<ActionsListJobsForWorkflowRunResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-run-logs
   */
  "GET /repos/:owner/:repo/actions/runs/:run_id/logs": {
    parameters: ActionsListWorkflowRunLogsEndpoint;
    request: ActionsListWorkflowRunLogsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/secrets/#list-secrets-for-a-repository
   */
  "GET /repos/:owner/:repo/actions/secrets": {
    parameters: ActionsListSecretsForRepoEndpoint;
    request: ActionsListSecretsForRepoRequestOptions;
    response: OctokitResponse<ActionsListSecretsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/secrets/#get-a-secret
   */
  "GET /repos/:owner/:repo/actions/secrets/:name": {
    parameters: ActionsGetSecretEndpoint;
    request: ActionsGetSecretRequestOptions;
    response: OctokitResponse<ActionsGetSecretResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/secrets/#get-your-public-key
   */
  "GET /repos/:owner/:repo/actions/secrets/public-key": {
    parameters: ActionsGetPublicKeyEndpoint;
    request: ActionsGetPublicKeyRequestOptions;
    response: OctokitResponse<ActionsGetPublicKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflows/#list-repository-workflows
   */
  "GET /repos/:owner/:repo/actions/workflows": {
    parameters: ActionsListRepoWorkflowsEndpoint;
    request: ActionsListRepoWorkflowsRequestOptions;
    response: OctokitResponse<ActionsListRepoWorkflowsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflows/#get-a-workflow
   */
  "GET /repos/:owner/:repo/actions/workflows/:workflow_id": {
    parameters: ActionsGetWorkflowEndpoint;
    request: ActionsGetWorkflowRequestOptions;
    response: OctokitResponse<ActionsGetWorkflowResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-runs
   */
  "GET /repos/:owner/:repo/actions/workflows/:workflow_id/runs": {
    parameters: ActionsListWorkflowRunsEndpoint;
    request: ActionsListWorkflowRunsRequestOptions;
    response: OctokitResponse<ActionsListWorkflowRunsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/assignees/#list-assignees
   */
  "GET /repos/:owner/:repo/assignees": {
    parameters: IssuesListAssigneesEndpoint;
    request: IssuesListAssigneesRequestOptions;
    response: OctokitResponse<IssuesListAssigneesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/assignees/#check-assignee
   */
  "GET /repos/:owner/:repo/assignees/:assignee": {
    parameters: IssuesCheckAssigneeEndpoint;
    request: IssuesCheckAssigneeRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#list-branches
   */
  "GET /repos/:owner/:repo/branches": {
    parameters: ReposListBranchesEndpoint;
    request: ReposListBranchesRequestOptions;
    response: OctokitResponse<ReposListBranchesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-branch
   */
  "GET /repos/:owner/:repo/branches/:branch": {
    parameters: ReposGetBranchEndpoint;
    request: ReposGetBranchRequestOptions;
    response: OctokitResponse<ReposGetBranchResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-branch-protection
   */
  "GET /repos/:owner/:repo/branches/:branch/protection": {
    parameters: ReposGetBranchProtectionEndpoint;
    request: ReposGetBranchProtectionRequestOptions;
    response: OctokitResponse<ReposGetBranchProtectionResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-admin-enforcement-of-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
    parameters: ReposGetProtectedBranchAdminEnforcementEndpoint;
    request: ReposGetProtectedBranchAdminEnforcementRequestOptions;
    response: OctokitResponse<
      ReposGetProtectedBranchAdminEnforcementResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-pull-request-review-enforcement-of-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
    parameters: ReposGetProtectedBranchPullRequestReviewEnforcementEndpoint;
    request: ReposGetProtectedBranchPullRequestReviewEnforcementRequestOptions;
    response: OctokitResponse<
      ReposGetProtectedBranchPullRequestReviewEnforcementResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-required-signatures-of-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
    parameters: ReposGetProtectedBranchRequiredSignaturesEndpoint;
    request: ReposGetProtectedBranchRequiredSignaturesRequestOptions;
    response: OctokitResponse<
      ReposGetProtectedBranchRequiredSignaturesResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-required-status-checks-of-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
    parameters: ReposGetProtectedBranchRequiredStatusChecksEndpoint;
    request: ReposGetProtectedBranchRequiredStatusChecksRequestOptions;
    response: OctokitResponse<
      ReposGetProtectedBranchRequiredStatusChecksResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#list-required-status-checks-contexts-of-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
    parameters: ReposListProtectedBranchRequiredStatusChecksContextsEndpoint;
    request: ReposListProtectedBranchRequiredStatusChecksContextsRequestOptions;
    response: OctokitResponse<
      ReposListProtectedBranchRequiredStatusChecksContextsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#get-restrictions-of-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions": {
    parameters: ReposGetProtectedBranchRestrictionsEndpoint;
    request: ReposGetProtectedBranchRestrictionsRequestOptions;
    response: OctokitResponse<ReposGetProtectedBranchRestrictionsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#list-apps-with-access-to-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
    parameters: ReposGetAppsWithAccessToProtectedBranchEndpoint;
    request: ReposGetAppsWithAccessToProtectedBranchRequestOptions;
    response: OctokitResponse<
      ReposGetAppsWithAccessToProtectedBranchResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#list-teams-with-access-to-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
    parameters: ReposGetTeamsWithAccessToProtectedBranchEndpoint;
    request: ReposGetTeamsWithAccessToProtectedBranchRequestOptions;
    response: OctokitResponse<
      ReposGetTeamsWithAccessToProtectedBranchResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#list-users-with-access-to-protected-branch
   */
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
    parameters: ReposGetUsersWithAccessToProtectedBranchEndpoint;
    request: ReposGetUsersWithAccessToProtectedBranchRequestOptions;
    response: OctokitResponse<
      ReposGetUsersWithAccessToProtectedBranchResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/checks/runs/#get-a-check-run
   */
  "GET /repos/:owner/:repo/check-runs/:check_run_id": {
    parameters: ChecksGetEndpoint;
    request: ChecksGetRequestOptions;
    response: OctokitResponse<ChecksGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/runs/#list-check-run-annotations
   */
  "GET /repos/:owner/:repo/check-runs/:check_run_id/annotations": {
    parameters: ChecksListAnnotationsEndpoint;
    request: ChecksListAnnotationsRequestOptions;
    response: OctokitResponse<ChecksListAnnotationsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/suites/#get-a-check-suite
   */
  "GET /repos/:owner/:repo/check-suites/:check_suite_id": {
    parameters: ChecksGetSuiteEndpoint;
    request: ChecksGetSuiteRequestOptions;
    response: OctokitResponse<ChecksGetSuiteResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/runs/#list-check-runs-in-a-check-suite
   */
  "GET /repos/:owner/:repo/check-suites/:check_suite_id/check-runs": {
    parameters: ChecksListForSuiteEndpoint;
    request: ChecksListForSuiteRequestOptions;
    response: OctokitResponse<ChecksListForSuiteResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/collaborators/#list-collaborators
   */
  "GET /repos/:owner/:repo/collaborators": {
    parameters: ReposListCollaboratorsEndpoint;
    request: ReposListCollaboratorsRequestOptions;
    response: OctokitResponse<ReposListCollaboratorsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/collaborators/#check-if-a-user-is-a-collaborator
   */
  "GET /repos/:owner/:repo/collaborators/:username": {
    parameters: ReposCheckCollaboratorEndpoint;
    request: ReposCheckCollaboratorRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/collaborators/#review-a-users-permission-level
   */
  "GET /repos/:owner/:repo/collaborators/:username/permission": {
    parameters: ReposGetCollaboratorPermissionLevelEndpoint;
    request: ReposGetCollaboratorPermissionLevelRequestOptions;
    response: OctokitResponse<ReposGetCollaboratorPermissionLevelResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/comments/#list-commit-comments-for-a-repository
   */
  "GET /repos/:owner/:repo/comments": {
    parameters: ReposListCommitCommentsEndpoint;
    request: ReposListCommitCommentsRequestOptions;
    response: OctokitResponse<ReposListCommitCommentsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/comments/#get-a-single-commit-comment
   */
  "GET /repos/:owner/:repo/comments/:comment_id": {
    parameters: ReposGetCommitCommentEndpoint;
    request: ReposGetCommitCommentRequestOptions;
    response: OctokitResponse<ReposGetCommitCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-commit-comment
   */
  "GET /repos/:owner/:repo/comments/:comment_id/reactions": {
    parameters: ReactionsListForCommitCommentEndpoint;
    request: ReactionsListForCommitCommentRequestOptions;
    response: OctokitResponse<ReactionsListForCommitCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
   */
  "GET /repos/:owner/:repo/commits": {
    parameters: ReposListCommitsEndpoint;
    request: ReposListCommitsRequestOptions;
    response: OctokitResponse<ReposListCommitsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/commits/#list-branches-for-head-commit
   */
  "GET /repos/:owner/:repo/commits/:commit_sha/branches-where-head": {
    parameters: ReposListBranchesForHeadCommitEndpoint;
    request: ReposListBranchesForHeadCommitRequestOptions;
    response: OctokitResponse<ReposListBranchesForHeadCommitResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/comments/#list-comments-for-a-single-commit
   */
  "GET /repos/:owner/:repo/commits/:commit_sha/comments": {
    parameters: ReposListCommentsForCommitEndpoint;
    request: ReposListCommentsForCommitRequestOptions;
    response: OctokitResponse<ReposListCommentsForCommitResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/commits/#list-pull-requests-associated-with-commit
   */
  "GET /repos/:owner/:repo/commits/:commit_sha/pulls": {
    parameters: ReposListPullRequestsAssociatedWithCommitEndpoint;
    request: ReposListPullRequestsAssociatedWithCommitRequestOptions;
    response: OctokitResponse<
      ReposListPullRequestsAssociatedWithCommitResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/commits/#get-a-single-commit
   */
  "GET /repos/:owner/:repo/commits/:ref": {
    parameters: ReposGetCommitEndpoint;
    request: ReposGetCommitRequestOptions;
    response: OctokitResponse<ReposGetCommitResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/runs/#list-check-runs-for-a-git-reference
   */
  "GET /repos/:owner/:repo/commits/:ref/check-runs": {
    parameters: ChecksListForRefEndpoint;
    request: ChecksListForRefRequestOptions;
    response: OctokitResponse<ChecksListForRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/suites/#list-check-suites-for-a-git-reference
   */
  "GET /repos/:owner/:repo/commits/:ref/check-suites": {
    parameters: ChecksListSuitesForRefEndpoint;
    request: ChecksListSuitesForRefRequestOptions;
    response: OctokitResponse<ChecksListSuitesForRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statuses/#get-the-combined-status-for-a-specific-ref
   */
  "GET /repos/:owner/:repo/commits/:ref/status": {
    parameters: ReposGetCombinedStatusForRefEndpoint;
    request: ReposGetCombinedStatusForRefRequestOptions;
    response: OctokitResponse<ReposGetCombinedStatusForRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statuses/#list-statuses-for-a-specific-ref
   */
  "GET /repos/:owner/:repo/commits/:ref/statuses": {
    parameters: ReposListStatusesForRefEndpoint;
    request: ReposListStatusesForRefRequestOptions;
    response: OctokitResponse<ReposListStatusesForRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/codes_of_conduct/#get-the-contents-of-a-repositorys-code-of-conduct
   */
  "GET /repos/:owner/:repo/community/code_of_conduct": {
    parameters: CodesOfConductGetForRepoEndpoint;
    request: CodesOfConductGetForRepoRequestOptions;
    response: OctokitResponse<CodesOfConductGetForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/community/#retrieve-community-profile-metrics
   */
  "GET /repos/:owner/:repo/community/profile": {
    parameters: ReposRetrieveCommunityProfileMetricsEndpoint;
    request: ReposRetrieveCommunityProfileMetricsRequestOptions;
    response: OctokitResponse<ReposRetrieveCommunityProfileMetricsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/commits/#compare-two-commits
   */
  "GET /repos/:owner/:repo/compare/:base...:head": {
    parameters: ReposCompareCommitsEndpoint;
    request: ReposCompareCommitsRequestOptions;
    response: OctokitResponse<ReposCompareCommitsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/contents/#get-contents
   */
  "GET /repos/:owner/:repo/contents/:path": {
    parameters: ReposGetContentsEndpoint;
    request: ReposGetContentsRequestOptions;
    response: OctokitResponse<ReposGetContentsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-contributors
   */
  "GET /repos/:owner/:repo/contributors": {
    parameters: ReposListContributorsEndpoint;
    request: ReposListContributorsRequestOptions;
    response: OctokitResponse<ReposListContributorsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#list-deployments
   */
  "GET /repos/:owner/:repo/deployments": {
    parameters: ReposListDeploymentsEndpoint;
    request: ReposListDeploymentsRequestOptions;
    response: OctokitResponse<ReposListDeploymentsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#get-a-single-deployment
   */
  "GET /repos/:owner/:repo/deployments/:deployment_id": {
    parameters: ReposGetDeploymentEndpoint;
    request: ReposGetDeploymentRequestOptions;
    response: OctokitResponse<ReposGetDeploymentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#list-deployment-statuses
   */
  "GET /repos/:owner/:repo/deployments/:deployment_id/statuses": {
    parameters: ReposListDeploymentStatusesEndpoint;
    request: ReposListDeploymentStatusesRequestOptions;
    response: OctokitResponse<ReposListDeploymentStatusesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#get-a-single-deployment-status
   */
  "GET /repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id": {
    parameters: ReposGetDeploymentStatusEndpoint;
    request: ReposGetDeploymentStatusRequestOptions;
    response: OctokitResponse<ReposGetDeploymentStatusResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/downloads/#list-downloads-for-a-repository
   */
  "GET /repos/:owner/:repo/downloads": {
    parameters: ReposListDownloadsEndpoint;
    request: ReposListDownloadsRequestOptions;
    response: OctokitResponse<ReposListDownloadsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/downloads/#get-a-single-download
   */
  "GET /repos/:owner/:repo/downloads/:download_id": {
    parameters: ReposGetDownloadEndpoint;
    request: ReposGetDownloadRequestOptions;
    response: OctokitResponse<ReposGetDownloadResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-repository-events
   */
  "GET /repos/:owner/:repo/events": {
    parameters: ActivityListRepoEventsEndpoint;
    request: ActivityListRepoEventsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/forks/#list-forks
   */
  "GET /repos/:owner/:repo/forks": {
    parameters: ReposListForksEndpoint;
    request: ReposListForksRequestOptions;
    response: OctokitResponse<ReposListForksResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/blobs/#get-a-blob
   */
  "GET /repos/:owner/:repo/git/blobs/:file_sha": {
    parameters: GitGetBlobEndpoint;
    request: GitGetBlobRequestOptions;
    response: OctokitResponse<GitGetBlobResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/commits/#get-a-commit
   */
  "GET /repos/:owner/:repo/git/commits/:commit_sha": {
    parameters: GitGetCommitEndpoint;
    request: GitGetCommitRequestOptions;
    response: OctokitResponse<GitGetCommitResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/refs/#list-matching-references
   */
  "GET /repos/:owner/:repo/git/matching-refs/:ref": {
    parameters: GitListMatchingRefsEndpoint;
    request: GitListMatchingRefsRequestOptions;
    response: OctokitResponse<GitListMatchingRefsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/refs/#get-a-single-reference
   */
  "GET /repos/:owner/:repo/git/ref/:ref": {
    parameters: GitGetRefEndpoint;
    request: GitGetRefRequestOptions;
    response: OctokitResponse<GitGetRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/tags/#get-a-tag
   */
  "GET /repos/:owner/:repo/git/tags/:tag_sha": {
    parameters: GitGetTagEndpoint;
    request: GitGetTagRequestOptions;
    response: OctokitResponse<GitGetTagResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/trees/#get-a-tree
   */
  "GET /repos/:owner/:repo/git/trees/:tree_sha": {
    parameters: GitGetTreeEndpoint;
    request: GitGetTreeRequestOptions;
    response: OctokitResponse<GitGetTreeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#list-hooks
   */
  "GET /repos/:owner/:repo/hooks": {
    parameters: ReposListHooksEndpoint;
    request: ReposListHooksRequestOptions;
    response: OctokitResponse<ReposListHooksResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#get-single-hook
   */
  "GET /repos/:owner/:repo/hooks/:hook_id": {
    parameters: ReposGetHookEndpoint;
    request: ReposGetHookRequestOptions;
    response: OctokitResponse<ReposGetHookResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#get-import-progress
   */
  "GET /repos/:owner/:repo/import": {
    parameters: MigrationsGetImportProgressEndpoint;
    request: MigrationsGetImportProgressRequestOptions;
    response: OctokitResponse<MigrationsGetImportProgressResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#get-commit-authors
   */
  "GET /repos/:owner/:repo/import/authors": {
    parameters: MigrationsGetCommitAuthorsEndpoint;
    request: MigrationsGetCommitAuthorsRequestOptions;
    response: OctokitResponse<MigrationsGetCommitAuthorsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#get-large-files
   */
  "GET /repos/:owner/:repo/import/large_files": {
    parameters: MigrationsGetLargeFilesEndpoint;
    request: MigrationsGetLargeFilesRequestOptions;
    response: OctokitResponse<MigrationsGetLargeFilesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#get-a-repository-installation
   */
  "GET /repos/:owner/:repo/installation": {
    parameters: AppsGetRepoInstallationEndpoint;
    request: AppsGetRepoInstallationRequestOptions;
    response: OctokitResponse<AppsGetRepoInstallationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/interactions/repos/#get-interaction-restrictions-for-a-repository
   */
  "GET /repos/:owner/:repo/interaction-limits": {
    parameters: InteractionsGetRestrictionsForRepoEndpoint;
    request: InteractionsGetRestrictionsForRepoRequestOptions;
    response: OctokitResponse<InteractionsGetRestrictionsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/invitations/#list-invitations-for-a-repository
   */
  "GET /repos/:owner/:repo/invitations": {
    parameters: ReposListInvitationsEndpoint;
    request: ReposListInvitationsRequestOptions;
    response: OctokitResponse<ReposListInvitationsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#list-repository-issues
   */
  "GET /repos/:owner/:repo/issues": {
    parameters: IssuesListForRepoEndpoint;
    request: IssuesListForRepoRequestOptions;
    response: OctokitResponse<IssuesListForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#get-an-issue
   */
  "GET /repos/:owner/:repo/issues/:issue_number": {
    parameters: IssuesGetEndpoint;
    request: IssuesGetRequestOptions;
    response: OctokitResponse<IssuesGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/comments/#list-comments-on-an-issue
   */
  "GET /repos/:owner/:repo/issues/:issue_number/comments": {
    parameters: IssuesListCommentsEndpoint;
    request: IssuesListCommentsRequestOptions;
    response: OctokitResponse<IssuesListCommentsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/events/#list-events-for-an-issue
   */
  "GET /repos/:owner/:repo/issues/:issue_number/events": {
    parameters: IssuesListEventsEndpoint;
    request: IssuesListEventsRequestOptions;
    response: OctokitResponse<IssuesListEventsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#list-labels-on-an-issue
   */
  "GET /repos/:owner/:repo/issues/:issue_number/labels": {
    parameters: IssuesListLabelsOnIssueEndpoint;
    request: IssuesListLabelsOnIssueRequestOptions;
    response: OctokitResponse<IssuesListLabelsOnIssueResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue
   */
  "GET /repos/:owner/:repo/issues/:issue_number/reactions": {
    parameters: ReactionsListForIssueEndpoint;
    request: ReactionsListForIssueRequestOptions;
    response: OctokitResponse<ReactionsListForIssueResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/timeline/#list-events-for-an-issue
   */
  "GET /repos/:owner/:repo/issues/:issue_number/timeline": {
    parameters: IssuesListEventsForTimelineEndpoint;
    request: IssuesListEventsForTimelineRequestOptions;
    response: OctokitResponse<IssuesListEventsForTimelineResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/comments/#list-comments-in-a-repository
   */
  "GET /repos/:owner/:repo/issues/comments": {
    parameters: IssuesListCommentsForRepoEndpoint;
    request: IssuesListCommentsForRepoRequestOptions;
    response: OctokitResponse<IssuesListCommentsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/comments/#get-a-single-comment
   */
  "GET /repos/:owner/:repo/issues/comments/:comment_id": {
    parameters: IssuesGetCommentEndpoint;
    request: IssuesGetCommentRequestOptions;
    response: OctokitResponse<IssuesGetCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue-comment
   */
  "GET /repos/:owner/:repo/issues/comments/:comment_id/reactions": {
    parameters: ReactionsListForIssueCommentEndpoint;
    request: ReactionsListForIssueCommentRequestOptions;
    response: OctokitResponse<ReactionsListForIssueCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/events/#list-events-for-a-repository
   */
  "GET /repos/:owner/:repo/issues/events": {
    parameters: IssuesListEventsForRepoEndpoint;
    request: IssuesListEventsForRepoRequestOptions;
    response: OctokitResponse<IssuesListEventsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/events/#get-a-single-event
   */
  "GET /repos/:owner/:repo/issues/events/:event_id": {
    parameters: IssuesGetEventEndpoint;
    request: IssuesGetEventRequestOptions;
    response: OctokitResponse<IssuesGetEventResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/keys/#list-deploy-keys
   */
  "GET /repos/:owner/:repo/keys": {
    parameters: ReposListDeployKeysEndpoint;
    request: ReposListDeployKeysRequestOptions;
    response: OctokitResponse<ReposListDeployKeysResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/keys/#get-a-deploy-key
   */
  "GET /repos/:owner/:repo/keys/:key_id": {
    parameters: ReposGetDeployKeyEndpoint;
    request: ReposGetDeployKeyRequestOptions;
    response: OctokitResponse<ReposGetDeployKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#list-all-labels-for-this-repository
   */
  "GET /repos/:owner/:repo/labels": {
    parameters: IssuesListLabelsForRepoEndpoint;
    request: IssuesListLabelsForRepoRequestOptions;
    response: OctokitResponse<IssuesListLabelsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#get-a-single-label
   */
  "GET /repos/:owner/:repo/labels/:name": {
    parameters: IssuesGetLabelEndpoint;
    request: IssuesGetLabelRequestOptions;
    response: OctokitResponse<IssuesGetLabelResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-languages
   */
  "GET /repos/:owner/:repo/languages": {
    parameters: ReposListLanguagesEndpoint;
    request: ReposListLanguagesRequestOptions;
    response: OctokitResponse<ReposListLanguagesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/licenses/#get-the-contents-of-a-repositorys-license
   */
  "GET /repos/:owner/:repo/license": {
    parameters: LicensesGetForRepoEndpoint;
    request: LicensesGetForRepoRequestOptions;
    response: OctokitResponse<LicensesGetForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/milestones/#list-milestones-for-a-repository
   */
  "GET /repos/:owner/:repo/milestones": {
    parameters: IssuesListMilestonesForRepoEndpoint;
    request: IssuesListMilestonesForRepoRequestOptions;
    response: OctokitResponse<IssuesListMilestonesForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/milestones/#get-a-single-milestone
   */
  "GET /repos/:owner/:repo/milestones/:milestone_number": {
    parameters: IssuesGetMilestoneEndpoint;
    request: IssuesGetMilestoneRequestOptions;
    response: OctokitResponse<IssuesGetMilestoneResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#get-labels-for-every-issue-in-a-milestone
   */
  "GET /repos/:owner/:repo/milestones/:milestone_number/labels": {
    parameters: IssuesListLabelsForMilestoneEndpoint;
    request: IssuesListLabelsForMilestoneRequestOptions;
    response: OctokitResponse<IssuesListLabelsForMilestoneResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#list-repository-notifications-for-the-authenticated-user
   */
  "GET /repos/:owner/:repo/notifications": {
    parameters: ActivityListRepoNotificationsForAuthenticatedUserEndpoint;
    request: ActivityListRepoNotificationsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      ActivityListRepoNotificationsForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#get-information-about-a-pages-site
   */
  "GET /repos/:owner/:repo/pages": {
    parameters: ReposGetPagesEndpoint;
    request: ReposGetPagesRequestOptions;
    response: OctokitResponse<ReposGetPagesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#list-pages-builds
   */
  "GET /repos/:owner/:repo/pages/builds": {
    parameters: ReposListPagesBuildsEndpoint;
    request: ReposListPagesBuildsRequestOptions;
    response: OctokitResponse<ReposListPagesBuildsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#get-a-specific-pages-build
   */
  "GET /repos/:owner/:repo/pages/builds/:build_id": {
    parameters: ReposGetPagesBuildEndpoint;
    request: ReposGetPagesBuildRequestOptions;
    response: OctokitResponse<ReposGetPagesBuildResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#get-latest-pages-build
   */
  "GET /repos/:owner/:repo/pages/builds/latest": {
    parameters: ReposGetLatestPagesBuildEndpoint;
    request: ReposGetLatestPagesBuildRequestOptions;
    response: OctokitResponse<ReposGetLatestPagesBuildResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#list-repository-projects
   */
  "GET /repos/:owner/:repo/projects": {
    parameters: ProjectsListForRepoEndpoint;
    request: ProjectsListForRepoRequestOptions;
    response: OctokitResponse<ProjectsListForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#list-pull-requests
   */
  "GET /repos/:owner/:repo/pulls": {
    parameters: PullsListEndpoint;
    request: PullsListRequestOptions;
    response: OctokitResponse<PullsListResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#get-a-single-pull-request
   */
  "GET /repos/:owner/:repo/pulls/:pull_number": {
    parameters: PullsGetEndpoint;
    request: PullsGetRequestOptions;
    response: OctokitResponse<PullsGetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#list-comments-on-a-pull-request
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/comments": {
    parameters: PullsListCommentsEndpoint;
    request: PullsListCommentsRequestOptions;
    response: OctokitResponse<PullsListCommentsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#list-commits-on-a-pull-request
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/commits": {
    parameters: PullsListCommitsEndpoint;
    request: PullsListCommitsRequestOptions;
    response: OctokitResponse<PullsListCommitsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#list-pull-requests-files
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/files": {
    parameters: PullsListFilesEndpoint;
    request: PullsListFilesRequestOptions;
    response: OctokitResponse<PullsListFilesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#get-if-a-pull-request-has-been-merged
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/merge": {
    parameters: PullsCheckIfMergedEndpoint;
    request: PullsCheckIfMergedRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/review_requests/#list-review-requests
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
    parameters: PullsListReviewRequestsEndpoint;
    request: PullsListReviewRequestsRequestOptions;
    response: OctokitResponse<PullsListReviewRequestsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#list-reviews-on-a-pull-request
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/reviews": {
    parameters: PullsListReviewsEndpoint;
    request: PullsListReviewsRequestOptions;
    response: OctokitResponse<PullsListReviewsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#get-a-single-review
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
    parameters: PullsGetReviewEndpoint;
    request: PullsGetReviewRequestOptions;
    response: OctokitResponse<PullsGetReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#get-comments-for-a-single-review
   */
  "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments": {
    parameters: PullsGetCommentsForReviewEndpoint;
    request: PullsGetCommentsForReviewRequestOptions;
    response: OctokitResponse<PullsGetCommentsForReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#list-comments-in-a-repository
   */
  "GET /repos/:owner/:repo/pulls/comments": {
    parameters: PullsListCommentsForRepoEndpoint;
    request: PullsListCommentsForRepoRequestOptions;
    response: OctokitResponse<PullsListCommentsForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#get-a-single-comment
   */
  "GET /repos/:owner/:repo/pulls/comments/:comment_id": {
    parameters: PullsGetCommentEndpoint;
    request: PullsGetCommentRequestOptions;
    response: OctokitResponse<PullsGetCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-pull-request-review-comment
   */
  "GET /repos/:owner/:repo/pulls/comments/:comment_id/reactions": {
    parameters: ReactionsListForPullRequestReviewCommentEndpoint;
    request: ReactionsListForPullRequestReviewCommentRequestOptions;
    response: OctokitResponse<
      ReactionsListForPullRequestReviewCommentResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/contents/#get-the-readme
   */
  "GET /repos/:owner/:repo/readme": {
    parameters: ReposGetReadmeEndpoint;
    request: ReposGetReadmeRequestOptions;
    response: OctokitResponse<ReposGetReadmeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#list-releases-for-a-repository
   */
  "GET /repos/:owner/:repo/releases": {
    parameters: ReposListReleasesEndpoint;
    request: ReposListReleasesRequestOptions;
    response: OctokitResponse<ReposListReleasesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#get-a-single-release
   */
  "GET /repos/:owner/:repo/releases/:release_id": {
    parameters: ReposGetReleaseEndpoint;
    request: ReposGetReleaseRequestOptions;
    response: OctokitResponse<ReposGetReleaseResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#list-assets-for-a-release
   */
  "GET /repos/:owner/:repo/releases/:release_id/assets": {
    parameters: ReposListAssetsForReleaseEndpoint;
    request: ReposListAssetsForReleaseRequestOptions;
    response: OctokitResponse<ReposListAssetsForReleaseResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#get-a-single-release-asset
   */
  "GET /repos/:owner/:repo/releases/assets/:asset_id": {
    parameters: ReposGetReleaseAssetEndpoint;
    request: ReposGetReleaseAssetRequestOptions;
    response: OctokitResponse<ReposGetReleaseAssetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#get-the-latest-release
   */
  "GET /repos/:owner/:repo/releases/latest": {
    parameters: ReposGetLatestReleaseEndpoint;
    request: ReposGetLatestReleaseRequestOptions;
    response: OctokitResponse<ReposGetLatestReleaseResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#get-a-release-by-tag-name
   */
  "GET /repos/:owner/:repo/releases/tags/:tag": {
    parameters: ReposGetReleaseByTagEndpoint;
    request: ReposGetReleaseByTagRequestOptions;
    response: OctokitResponse<ReposGetReleaseByTagResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/starring/#list-stargazers
   */
  "GET /repos/:owner/:repo/stargazers": {
    parameters: ActivityListStargazersForRepoEndpoint;
    request: ActivityListStargazersForRepoRequestOptions;
    response: OctokitResponse<ActivityListStargazersForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-additions-and-deletions-per-week
   */
  "GET /repos/:owner/:repo/stats/code_frequency": {
    parameters: ReposGetCodeFrequencyStatsEndpoint;
    request: ReposGetCodeFrequencyStatsRequestOptions;
    response: OctokitResponse<ReposGetCodeFrequencyStatsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statistics/#get-the-last-year-of-commit-activity-data
   */
  "GET /repos/:owner/:repo/stats/commit_activity": {
    parameters: ReposGetCommitActivityStatsEndpoint;
    request: ReposGetCommitActivityStatsRequestOptions;
    response: OctokitResponse<ReposGetCommitActivityStatsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statistics/#get-contributors-list-with-additions-deletions-and-commit-counts
   */
  "GET /repos/:owner/:repo/stats/contributors": {
    parameters: ReposGetContributorsStatsEndpoint;
    request: ReposGetContributorsStatsRequestOptions;
    response: OctokitResponse<ReposGetContributorsStatsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statistics/#get-the-weekly-commit-count-for-the-repository-owner-and-everyone-else
   */
  "GET /repos/:owner/:repo/stats/participation": {
    parameters: ReposGetParticipationStatsEndpoint;
    request: ReposGetParticipationStatsRequestOptions;
    response: OctokitResponse<ReposGetParticipationStatsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-commits-per-hour-in-each-day
   */
  "GET /repos/:owner/:repo/stats/punch_card": {
    parameters: ReposGetPunchCardStatsEndpoint;
    request: ReposGetPunchCardStatsRequestOptions;
    response: OctokitResponse<ReposGetPunchCardStatsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#list-watchers
   */
  "GET /repos/:owner/:repo/subscribers": {
    parameters: ActivityListWatchersForRepoEndpoint;
    request: ActivityListWatchersForRepoRequestOptions;
    response: OctokitResponse<ActivityListWatchersForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#get-a-repository-subscription
   */
  "GET /repos/:owner/:repo/subscription": {
    parameters: ActivityGetRepoSubscriptionEndpoint;
    request: ActivityGetRepoSubscriptionRequestOptions;
    response: OctokitResponse<ActivityGetRepoSubscriptionResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-tags
   */
  "GET /repos/:owner/:repo/tags": {
    parameters: ReposListTagsEndpoint;
    request: ReposListTagsRequestOptions;
    response: OctokitResponse<ReposListTagsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-teams
   */
  "GET /repos/:owner/:repo/teams": {
    parameters: ReposListTeamsEndpoint;
    request: ReposListTeamsRequestOptions;
    response: OctokitResponse<ReposListTeamsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#get-all-repository-topics
   */
  "GET /repos/:owner/:repo/topics": {
    parameters: ReposGetAllTopicsEndpoint;
    request: ReposGetAllTopicsRequestOptions;
    response: OctokitResponse<ReposGetAllTopicsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/traffic/#clones
   */
  "GET /repos/:owner/:repo/traffic/clones": {
    parameters: ReposGetClonesEndpoint;
    request: ReposGetClonesRequestOptions;
    response: OctokitResponse<ReposGetClonesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/traffic/#list-paths
   */
  "GET /repos/:owner/:repo/traffic/popular/paths": {
    parameters: ReposGetTopPathsEndpoint;
    request: ReposGetTopPathsRequestOptions;
    response: OctokitResponse<ReposGetTopPathsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/traffic/#list-referrers
   */
  "GET /repos/:owner/:repo/traffic/popular/referrers": {
    parameters: ReposGetTopReferrersEndpoint;
    request: ReposGetTopReferrersRequestOptions;
    response: OctokitResponse<ReposGetTopReferrersResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/traffic/#views
   */
  "GET /repos/:owner/:repo/traffic/views": {
    parameters: ReposGetViewsEndpoint;
    request: ReposGetViewsRequestOptions;
    response: OctokitResponse<ReposGetViewsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#check-if-vulnerability-alerts-are-enabled-for-a-repository
   */
  "GET /repos/:owner/:repo/vulnerability-alerts": {
    parameters: ReposCheckVulnerabilityAlertsEndpoint;
    request: ReposCheckVulnerabilityAlertsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-public-repositories
   */
  "GET /repositories": {
    parameters: ReposListPublicEndpoint;
    request: ReposListPublicRequestOptions;
    response: OctokitResponse<ReposListPublicResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/scim/#get-a-list-of-provisioned-identities
   */
  "GET /scim/v2/organizations/:org/Users": {
    parameters: ScimListProvisionedIdentitiesEndpoint;
    request: ScimListProvisionedIdentitiesRequestOptions;
    response: OctokitResponse<ScimListProvisionedIdentitiesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/scim/#get-provisioning-details-for-a-single-user
   */
  "GET /scim/v2/organizations/:org/Users/:scim_user_id": {
    parameters: ScimGetProvisioningDetailsForUserEndpoint;
    request: ScimGetProvisioningDetailsForUserRequestOptions;
    response: OctokitResponse<ScimGetProvisioningDetailsForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-code
   */
  "GET /search/code": {
    parameters: SearchCodeEndpoint;
    request: SearchCodeRequestOptions;
    response: OctokitResponse<SearchCodeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-commits
   */
  "GET /search/commits": {
    parameters: SearchCommitsEndpoint;
    request: SearchCommitsRequestOptions;
    response: OctokitResponse<SearchCommitsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-issues-and-pull-requests
   */
  "GET /search/issues": {
    parameters: SearchIssuesAndPullRequestsEndpoint;
    request: SearchIssuesAndPullRequestsRequestOptions;
    response: OctokitResponse<SearchIssuesAndPullRequestsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-labels
   */
  "GET /search/labels": {
    parameters: SearchLabelsEndpoint;
    request: SearchLabelsRequestOptions;
    response: OctokitResponse<SearchLabelsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-repositories
   */
  "GET /search/repositories": {
    parameters: SearchReposEndpoint;
    request: SearchReposRequestOptions;
    response: OctokitResponse<SearchReposResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-topics
   */
  "GET /search/topics": {
    parameters: SearchTopicsEndpoint;
    request: SearchTopicsRequestOptions;
    response: OctokitResponse<SearchTopicsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/search/#search-users
   */
  "GET /search/users": {
    parameters: SearchUsersEndpoint;
    request: SearchUsersRequestOptions;
    response: OctokitResponse<SearchUsersResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#get-team-legacy
   */
  "GET /teams/:team_id": {
    parameters: TeamsGetLegacyEndpoint;
    request: TeamsGetLegacyRequestOptions;
    response: OctokitResponse<TeamsGetLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#list-discussions-legacy
   */
  "GET /teams/:team_id/discussions": {
    parameters: TeamsListDiscussionsLegacyEndpoint;
    request: TeamsListDiscussionsLegacyRequestOptions;
    response: OctokitResponse<TeamsListDiscussionsLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#get-a-single-discussion-legacy
   */
  "GET /teams/:team_id/discussions/:discussion_number": {
    parameters: TeamsGetDiscussionLegacyEndpoint;
    request: TeamsGetDiscussionLegacyRequestOptions;
    response: OctokitResponse<TeamsGetDiscussionLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#list-comments-legacy
   */
  "GET /teams/:team_id/discussions/:discussion_number/comments": {
    parameters: TeamsListDiscussionCommentsLegacyEndpoint;
    request: TeamsListDiscussionCommentsLegacyRequestOptions;
    response: OctokitResponse<TeamsListDiscussionCommentsLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#get-a-single-comment-legacy
   */
  "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
    parameters: TeamsGetDiscussionCommentLegacyEndpoint;
    request: TeamsGetDiscussionCommentLegacyRequestOptions;
    response: OctokitResponse<TeamsGetDiscussionCommentLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-comment-legacy
   */
  "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": {
    parameters: ReactionsListForTeamDiscussionCommentLegacyEndpoint;
    request: ReactionsListForTeamDiscussionCommentLegacyRequestOptions;
    response: OctokitResponse<
      ReactionsListForTeamDiscussionCommentLegacyResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-legacy
   */
  "GET /teams/:team_id/discussions/:discussion_number/reactions": {
    parameters: ReactionsListForTeamDiscussionLegacyEndpoint;
    request: ReactionsListForTeamDiscussionLegacyRequestOptions;
    response: OctokitResponse<ReactionsListForTeamDiscussionLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#list-pending-team-invitations-legacy
   */
  "GET /teams/:team_id/invitations": {
    parameters: TeamsListPendingInvitationsLegacyEndpoint;
    request: TeamsListPendingInvitationsLegacyRequestOptions;
    response: OctokitResponse<TeamsListPendingInvitationsLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#list-team-members-legacy
   */
  "GET /teams/:team_id/members": {
    parameters: TeamsListMembersLegacyEndpoint;
    request: TeamsListMembersLegacyRequestOptions;
    response: OctokitResponse<TeamsListMembersLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#get-team-member-legacy
   */
  "GET /teams/:team_id/members/:username": {
    parameters: TeamsGetMemberLegacyEndpoint;
    request: TeamsGetMemberLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#get-team-membership-legacy
   */
  "GET /teams/:team_id/memberships/:username": {
    parameters: TeamsGetMembershipLegacyEndpoint;
    request: TeamsGetMembershipLegacyRequestOptions;
    response: OctokitResponse<TeamsGetMembershipLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-team-projects-legacy
   */
  "GET /teams/:team_id/projects": {
    parameters: TeamsListProjectsLegacyEndpoint;
    request: TeamsListProjectsLegacyRequestOptions;
    response: OctokitResponse<TeamsListProjectsLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#review-a-team-project-legacy
   */
  "GET /teams/:team_id/projects/:project_id": {
    parameters: TeamsReviewProjectLegacyEndpoint;
    request: TeamsReviewProjectLegacyRequestOptions;
    response: OctokitResponse<TeamsReviewProjectLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-team-repos-legacy
   */
  "GET /teams/:team_id/repos": {
    parameters: TeamsListReposLegacyEndpoint;
    request: TeamsListReposLegacyRequestOptions;
    response: OctokitResponse<TeamsListReposLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#check-if-a-team-manages-a-repository-legacy
   */
  "GET /teams/:team_id/repos/:owner/:repo": {
    parameters: TeamsCheckManagesRepoLegacyEndpoint;
    request: TeamsCheckManagesRepoLegacyRequestOptions;
    response: OctokitResponse<TeamsCheckManagesRepoLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-a-team-legacy
   */
  "GET /teams/:team_id/team-sync/group-mappings": {
    parameters: TeamsListIdPGroupsForLegacyEndpoint;
    request: TeamsListIdPGroupsForLegacyRequestOptions;
    response: OctokitResponse<TeamsListIdPGroupsForLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-child-teams-legacy
   */
  "GET /teams/:team_id/teams": {
    parameters: TeamsListChildLegacyEndpoint;
    request: TeamsListChildLegacyRequestOptions;
    response: OctokitResponse<TeamsListChildLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/#get-the-authenticated-user
   */
  "GET /user": {
    parameters: UsersGetAuthenticatedEndpoint;
    request: UsersGetAuthenticatedRequestOptions;
    response: OctokitResponse<UsersGetAuthenticatedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#list-repositories-for-a-user-migration
   */
  "GET /user/:migration_id/repositories": {
    parameters: MigrationsListReposForUserEndpoint;
    request: MigrationsListReposForUserRequestOptions;
    response: OctokitResponse<MigrationsListReposForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/blocking/#list-blocked-users
   */
  "GET /user/blocks": {
    parameters: UsersListBlockedEndpoint;
    request: UsersListBlockedRequestOptions;
    response: OctokitResponse<UsersListBlockedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/blocking/#check-whether-youve-blocked-a-user
   */
  "GET /user/blocks/:username": {
    parameters: UsersCheckBlockedEndpoint;
    request: UsersCheckBlockedRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/emails/#list-email-addresses-for-a-user
   */
  "GET /user/emails": {
    parameters: UsersListEmailsEndpoint;
    request: UsersListEmailsRequestOptions;
    response: OctokitResponse<UsersListEmailsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#list-followers-of-the-authenticated-user
   */
  "GET /user/followers": {
    parameters: UsersListFollowersForAuthenticatedUserEndpoint;
    request: UsersListFollowersForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      UsersListFollowersForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#list-users-followed-by-the-authenticated-user
   */
  "GET /user/following": {
    parameters: UsersListFollowedByAuthenticatedEndpoint;
    request: UsersListFollowedByAuthenticatedRequestOptions;
    response: OctokitResponse<UsersListFollowedByAuthenticatedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#check-if-you-are-following-a-user
   */
  "GET /user/following/:username": {
    parameters: UsersCheckFollowingEndpoint;
    request: UsersCheckFollowingRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/gpg_keys/#list-your-gpg-keys
   */
  "GET /user/gpg_keys": {
    parameters: UsersListGpgKeysEndpoint;
    request: UsersListGpgKeysRequestOptions;
    response: OctokitResponse<UsersListGpgKeysResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/gpg_keys/#get-a-single-gpg-key
   */
  "GET /user/gpg_keys/:gpg_key_id": {
    parameters: UsersGetGpgKeyEndpoint;
    request: UsersGetGpgKeyRequestOptions;
    response: OctokitResponse<UsersGetGpgKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#list-installations-for-a-user
   */
  "GET /user/installations": {
    parameters: AppsListInstallationsForAuthenticatedUserEndpoint;
    request: AppsListInstallationsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      AppsListInstallationsForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#list-repositories-accessible-to-the-user-for-an-installation
   */
  "GET /user/installations/:installation_id/repositories": {
    parameters: AppsListInstallationReposForAuthenticatedUserEndpoint;
    request: AppsListInstallationReposForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      AppsListInstallationReposForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/issues/#list-user-account-issues-assigned-to-the-authenticated-user
   */
  "GET /user/issues": {
    parameters: IssuesListForAuthenticatedUserEndpoint;
    request: IssuesListForAuthenticatedUserRequestOptions;
    response: OctokitResponse<IssuesListForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/keys/#list-your-public-keys
   */
  "GET /user/keys": {
    parameters: UsersListPublicKeysEndpoint;
    request: UsersListPublicKeysRequestOptions;
    response: OctokitResponse<UsersListPublicKeysResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/keys/#get-a-single-public-key
   */
  "GET /user/keys/:key_id": {
    parameters: UsersGetPublicKeyEndpoint;
    request: UsersGetPublicKeyRequestOptions;
    response: OctokitResponse<UsersGetPublicKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#list-subscriptions-for-the-authenticated-user
   */
  "GET /user/marketplace_purchases": {
    parameters: AppsListSubscriptionsForAuthenticatedUserEndpoint;
    request: AppsListSubscriptionsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      AppsListSubscriptionsForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/apps/marketplace/#list-subscriptions-for-the-authenticated-user-stubbed
   */
  "GET /user/marketplace_purchases/stubbed": {
    parameters: AppsListSubscriptionsForAuthenticatedUserStubbedEndpoint;
    request: AppsListSubscriptionsForAuthenticatedUserStubbedRequestOptions;
    response: OctokitResponse<
      AppsListSubscriptionsForAuthenticatedUserStubbedResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#list-your-organization-memberships
   */
  "GET /user/memberships/orgs": {
    parameters: OrgsListMembershipsEndpoint;
    request: OrgsListMembershipsRequestOptions;
    response: OctokitResponse<OrgsListMembershipsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#get-your-organization-membership
   */
  "GET /user/memberships/orgs/:org": {
    parameters: OrgsGetMembershipForAuthenticatedUserEndpoint;
    request: OrgsGetMembershipForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      OrgsGetMembershipForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#list-user-migrations
   */
  "GET /user/migrations": {
    parameters: MigrationsListForAuthenticatedUserEndpoint;
    request: MigrationsListForAuthenticatedUserRequestOptions;
    response: OctokitResponse<MigrationsListForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#get-the-status-of-a-user-migration
   */
  "GET /user/migrations/:migration_id": {
    parameters: MigrationsGetStatusForAuthenticatedUserEndpoint;
    request: MigrationsGetStatusForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      MigrationsGetStatusForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#download-a-user-migration-archive
   */
  "GET /user/migrations/:migration_id/archive": {
    parameters: MigrationsGetArchiveForAuthenticatedUserEndpoint;
    request: MigrationsGetArchiveForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#list-your-organizations
   */
  "GET /user/orgs": {
    parameters: OrgsListForAuthenticatedUserEndpoint;
    request: OrgsListForAuthenticatedUserRequestOptions;
    response: OctokitResponse<OrgsListForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/emails/#list-public-email-addresses-for-a-user
   */
  "GET /user/public_emails": {
    parameters: UsersListPublicEmailsEndpoint;
    request: UsersListPublicEmailsRequestOptions;
    response: OctokitResponse<UsersListPublicEmailsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-repositories-for-the-authenticated-user
   */
  "GET /user/repos": {
    parameters: ReposListForAuthenticatedUserEndpoint;
    request: ReposListForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/invitations/#list-a-users-repository-invitations
   */
  "GET /user/repository_invitations": {
    parameters: ReposListInvitationsForAuthenticatedUserEndpoint;
    request: ReposListInvitationsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      ReposListInvitationsForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/activity/starring/#list-repositories-starred-by-the-authenticated-user
   */
  "GET /user/starred": {
    parameters: ActivityListReposStarredByAuthenticatedUserEndpoint;
    request: ActivityListReposStarredByAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      ActivityListReposStarredByAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/activity/starring/#check-if-a-repository-is-starred-by-the-authenticated-user
   */
  "GET /user/starred/:owner/:repo": {
    parameters: ActivityCheckRepoIsStarredByAuthenticatedUserEndpoint;
    request: ActivityCheckRepoIsStarredByAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#list-repositories-watched-by-the-authenticated-user
   */
  "GET /user/subscriptions": {
    parameters: ActivityListWatchedReposForAuthenticatedUserEndpoint;
    request: ActivityListWatchedReposForAuthenticatedUserRequestOptions;
    response: OctokitResponse<
      ActivityListWatchedReposForAuthenticatedUserResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#check-if-you-are-watching-a-repository-legacy
   */
  "GET /user/subscriptions/:owner/:repo": {
    parameters: ActivityCheckWatchingRepoLegacyEndpoint;
    request: ActivityCheckWatchingRepoLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#list-user-teams
   */
  "GET /user/teams": {
    parameters: TeamsListForAuthenticatedUserEndpoint;
    request: TeamsListForAuthenticatedUserRequestOptions;
    response: OctokitResponse<TeamsListForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/#get-all-users
   */
  "GET /users": {
    parameters: UsersListEndpoint;
    request: UsersListRequestOptions;
    response: OctokitResponse<UsersListResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/#get-a-single-user
   */
  "GET /users/:username": {
    parameters: UsersGetByUsernameEndpoint;
    request: UsersGetByUsernameRequestOptions;
    response: OctokitResponse<UsersGetByUsernameResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-events-for-the-authenticated-user
   */
  "GET /users/:username/events": {
    parameters: ActivityListEventsForAuthenticatedUserEndpoint;
    request: ActivityListEventsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-organization-events-for-the-authenticated-user
   */
  "GET /users/:username/events/orgs/:org": {
    parameters: ActivityListOrgEventsForAuthenticatedUserEndpoint;
    request: ActivityListOrgEventsForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-user
   */
  "GET /users/:username/events/public": {
    parameters: ActivityListPublicEventsForUserEndpoint;
    request: ActivityListPublicEventsForUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#list-followers-of-a-user
   */
  "GET /users/:username/followers": {
    parameters: UsersListFollowersForUserEndpoint;
    request: UsersListFollowersForUserRequestOptions;
    response: OctokitResponse<UsersListFollowersForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#list-users-followed-by-another-user
   */
  "GET /users/:username/following": {
    parameters: UsersListFollowingForUserEndpoint;
    request: UsersListFollowingForUserRequestOptions;
    response: OctokitResponse<UsersListFollowingForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#check-if-one-user-follows-another
   */
  "GET /users/:username/following/:target_user": {
    parameters: UsersCheckFollowingForUserEndpoint;
    request: UsersCheckFollowingForUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#list-gists-for-a-user
   */
  "GET /users/:username/gists": {
    parameters: GistsListForUserEndpoint;
    request: GistsListForUserRequestOptions;
    response: OctokitResponse<GistsListForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/gpg_keys/#list-gpg-keys-for-a-user
   */
  "GET /users/:username/gpg_keys": {
    parameters: UsersListGpgKeysForUserEndpoint;
    request: UsersListGpgKeysForUserRequestOptions;
    response: OctokitResponse<UsersListGpgKeysForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/#get-contextual-information-about-a-user
   */
  "GET /users/:username/hovercard": {
    parameters: UsersGetContextForUserEndpoint;
    request: UsersGetContextForUserRequestOptions;
    response: OctokitResponse<UsersGetContextForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#get-a-user-installation
   */
  "GET /users/:username/installation": {
    parameters: AppsGetUserInstallationEndpoint;
    request: AppsGetUserInstallationRequestOptions;
    response: OctokitResponse<AppsGetUserInstallationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/keys/#list-public-keys-for-a-user
   */
  "GET /users/:username/keys": {
    parameters: UsersListPublicKeysForUserEndpoint;
    request: UsersListPublicKeysForUserRequestOptions;
    response: OctokitResponse<UsersListPublicKeysForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#list-user-organizations
   */
  "GET /users/:username/orgs": {
    parameters: OrgsListForUserEndpoint;
    request: OrgsListForUserRequestOptions;
    response: OctokitResponse<OrgsListForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#list-user-projects
   */
  "GET /users/:username/projects": {
    parameters: ProjectsListForUserEndpoint;
    request: ProjectsListForUserRequestOptions;
    response: OctokitResponse<ProjectsListForUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-events-received-by-the-authenticated-user
   */
  "GET /users/:username/received_events": {
    parameters: ActivityListReceivedEventsForUserEndpoint;
    request: ActivityListReceivedEventsForUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/events/#list-public-events-received-by-a-user
   */
  "GET /users/:username/received_events/public": {
    parameters: ActivityListReceivedPublicEventsForUserEndpoint;
    request: ActivityListReceivedPublicEventsForUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#list-repositories-for-a-user
   */
  "GET /users/:username/repos": {
    parameters: ReposListForUserEndpoint;
    request: ReposListForUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/starring/#list-repositories-starred-by-a-user
   */
  "GET /users/:username/starred": {
    parameters: ActivityListReposStarredByUserEndpoint;
    request: ActivityListReposStarredByUserRequestOptions;
    response: OctokitResponse<ActivityListReposStarredByUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#list-repositories-watched-by-a-user
   */
  "GET /users/:username/subscriptions": {
    parameters: ActivityListReposWatchedByUserEndpoint;
    request: ActivityListReposWatchedByUserRequestOptions;
    response: OctokitResponse<ActivityListReposWatchedByUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#reset-a-token
   */
  "PATCH /applications/:client_id/token": {
    parameters: AppsResetTokenEndpoint;
    request: AppsResetTokenRequestOptions;
    response: OctokitResponse<AppsResetTokenResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#update-an-existing-authorization
   */
  "PATCH /authorizations/:authorization_id": {
    parameters: OauthAuthorizationsUpdateAuthorizationEndpoint;
    request: OauthAuthorizationsUpdateAuthorizationRequestOptions;
    response: OctokitResponse<
      OauthAuthorizationsUpdateAuthorizationResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/gists/#update-a-gist
   */
  "PATCH /gists/:gist_id": {
    parameters: GistsUpdateEndpoint;
    request: GistsUpdateRequestOptions;
    response: OctokitResponse<GistsUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/comments/#edit-a-comment
   */
  "PATCH /gists/:gist_id/comments/:comment_id": {
    parameters: GistsUpdateCommentEndpoint;
    request: GistsUpdateCommentRequestOptions;
    response: OctokitResponse<GistsUpdateCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#mark-a-thread-as-read
   */
  "PATCH /notifications/threads/:thread_id": {
    parameters: ActivityMarkThreadAsReadEndpoint;
    request: ActivityMarkThreadAsReadRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/#edit-an-organization
   */
  "PATCH /orgs/:org": {
    parameters: OrgsUpdateEndpoint;
    request: OrgsUpdateRequestOptions;
    response: OctokitResponse<OrgsUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/hooks/#edit-a-hook
   */
  "PATCH /orgs/:org/hooks/:hook_id": {
    parameters: OrgsUpdateHookEndpoint;
    request: OrgsUpdateHookRequestOptions;
    response: OctokitResponse<OrgsUpdateHookResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#edit-team
   */
  "PATCH /orgs/:org/teams/:team_slug": {
    parameters: TeamsUpdateInOrgEndpoint;
    request: TeamsUpdateInOrgRequestOptions;
    response: OctokitResponse<TeamsUpdateInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#edit-a-discussion
   */
  "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
    parameters: TeamsUpdateDiscussionInOrgEndpoint;
    request: TeamsUpdateDiscussionInOrgRequestOptions;
    response: OctokitResponse<TeamsUpdateDiscussionInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#edit-a-comment
   */
  "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
    parameters: TeamsUpdateDiscussionCommentInOrgEndpoint;
    request: TeamsUpdateDiscussionCommentInOrgRequestOptions;
    response: OctokitResponse<TeamsUpdateDiscussionCommentInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/team_sync/#create-or-update-idp-group-connections
   */
  "PATCH /orgs/:org/teams/:team_slug/team-sync/group-mappings": {
    parameters: TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint;
    request: TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions;
    response: OctokitResponse<
      TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/projects/#update-a-project
   */
  "PATCH /projects/:project_id": {
    parameters: ProjectsUpdateEndpoint;
    request: ProjectsUpdateRequestOptions;
    response: OctokitResponse<ProjectsUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/columns/#update-a-project-column
   */
  "PATCH /projects/columns/:column_id": {
    parameters: ProjectsUpdateColumnEndpoint;
    request: ProjectsUpdateColumnRequestOptions;
    response: OctokitResponse<ProjectsUpdateColumnResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/cards/#update-a-project-card
   */
  "PATCH /projects/columns/cards/:card_id": {
    parameters: ProjectsUpdateCardEndpoint;
    request: ProjectsUpdateCardRequestOptions;
    response: OctokitResponse<ProjectsUpdateCardResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#update-a-repository
   */
  "PATCH /repos/:owner/:repo": {
    parameters: ReposUpdateEndpoint;
    request: ReposUpdateRequestOptions;
    response: OctokitResponse<ReposUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#update-pull-request-review-enforcement-of-protected-branch
   */
  "PATCH /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
    parameters: ReposUpdateProtectedBranchPullRequestReviewEnforcementEndpoint;
    request: ReposUpdateProtectedBranchPullRequestReviewEnforcementRequestOptions;
    response: OctokitResponse<
      ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#update-required-status-checks-of-protected-branch
   */
  "PATCH /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
    parameters: ReposUpdateProtectedBranchRequiredStatusChecksEndpoint;
    request: ReposUpdateProtectedBranchRequiredStatusChecksRequestOptions;
    response: OctokitResponse<
      ReposUpdateProtectedBranchRequiredStatusChecksResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/checks/runs/#update-a-check-run
   */
  "PATCH /repos/:owner/:repo/check-runs/:check_run_id": {
    parameters: ChecksUpdateEndpoint;
    request: ChecksUpdateRequestOptions;
    response: OctokitResponse<ChecksUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/suites/#update-repository-preferences-for-check-suites
   */
  "PATCH /repos/:owner/:repo/check-suites/preferences": {
    parameters: ChecksSetSuitesPreferencesEndpoint;
    request: ChecksSetSuitesPreferencesRequestOptions;
    response: OctokitResponse<ChecksSetSuitesPreferencesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/comments/#update-a-commit-comment
   */
  "PATCH /repos/:owner/:repo/comments/:comment_id": {
    parameters: ReposUpdateCommitCommentEndpoint;
    request: ReposUpdateCommitCommentRequestOptions;
    response: OctokitResponse<ReposUpdateCommitCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/refs/#update-a-reference
   */
  "PATCH /repos/:owner/:repo/git/refs/:ref": {
    parameters: GitUpdateRefEndpoint;
    request: GitUpdateRefRequestOptions;
    response: OctokitResponse<GitUpdateRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#edit-a-hook
   */
  "PATCH /repos/:owner/:repo/hooks/:hook_id": {
    parameters: ReposUpdateHookEndpoint;
    request: ReposUpdateHookRequestOptions;
    response: OctokitResponse<ReposUpdateHookResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#update-existing-import
   */
  "PATCH /repos/:owner/:repo/import": {
    parameters: MigrationsUpdateImportEndpoint;
    request: MigrationsUpdateImportRequestOptions;
    response: OctokitResponse<MigrationsUpdateImportResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#map-a-commit-author
   */
  "PATCH /repos/:owner/:repo/import/authors/:author_id": {
    parameters: MigrationsMapCommitAuthorEndpoint;
    request: MigrationsMapCommitAuthorRequestOptions;
    response: OctokitResponse<MigrationsMapCommitAuthorResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#set-git-lfs-preference
   */
  "PATCH /repos/:owner/:repo/import/lfs": {
    parameters: MigrationsSetLfsPreferenceEndpoint;
    request: MigrationsSetLfsPreferenceRequestOptions;
    response: OctokitResponse<MigrationsSetLfsPreferenceResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/invitations/#update-a-repository-invitation
   */
  "PATCH /repos/:owner/:repo/invitations/:invitation_id": {
    parameters: ReposUpdateInvitationEndpoint;
    request: ReposUpdateInvitationRequestOptions;
    response: OctokitResponse<ReposUpdateInvitationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#update-an-issue
   */
  "PATCH /repos/:owner/:repo/issues/:issue_number": {
    parameters: IssuesUpdateEndpoint;
    request: IssuesUpdateRequestOptions;
    response: OctokitResponse<IssuesUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/comments/#edit-a-comment
   */
  "PATCH /repos/:owner/:repo/issues/comments/:comment_id": {
    parameters: IssuesUpdateCommentEndpoint;
    request: IssuesUpdateCommentRequestOptions;
    response: OctokitResponse<IssuesUpdateCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#update-a-label
   */
  "PATCH /repos/:owner/:repo/labels/:name": {
    parameters: IssuesUpdateLabelEndpoint;
    request: IssuesUpdateLabelRequestOptions;
    response: OctokitResponse<IssuesUpdateLabelResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/milestones/#update-a-milestone
   */
  "PATCH /repos/:owner/:repo/milestones/:milestone_number": {
    parameters: IssuesUpdateMilestoneEndpoint;
    request: IssuesUpdateMilestoneRequestOptions;
    response: OctokitResponse<IssuesUpdateMilestoneResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#update-a-pull-request
   */
  "PATCH /repos/:owner/:repo/pulls/:pull_number": {
    parameters: PullsUpdateEndpoint;
    request: PullsUpdateRequestOptions;
    response: OctokitResponse<PullsUpdateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#edit-a-comment
   */
  "PATCH /repos/:owner/:repo/pulls/comments/:comment_id": {
    parameters: PullsUpdateCommentEndpoint;
    request: PullsUpdateCommentRequestOptions;
    response: OctokitResponse<PullsUpdateCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#edit-a-release
   */
  "PATCH /repos/:owner/:repo/releases/:release_id": {
    parameters: ReposUpdateReleaseEndpoint;
    request: ReposUpdateReleaseRequestOptions;
    response: OctokitResponse<ReposUpdateReleaseResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#edit-a-release-asset
   */
  "PATCH /repos/:owner/:repo/releases/assets/:asset_id": {
    parameters: ReposUpdateReleaseAssetEndpoint;
    request: ReposUpdateReleaseAssetRequestOptions;
    response: OctokitResponse<ReposUpdateReleaseAssetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/scim/#update-a-user-attribute
   */
  "PATCH /scim/v2/organizations/:org/Users/:scim_user_id": {
    parameters: ScimUpdateUserAttributeEndpoint;
    request: ScimUpdateUserAttributeRequestOptions;
    response: OctokitResponse<ScimUpdateUserAttributeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#edit-team-legacy
   */
  "PATCH /teams/:team_id": {
    parameters: TeamsUpdateLegacyEndpoint;
    request: TeamsUpdateLegacyRequestOptions;
    response: OctokitResponse<TeamsUpdateLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#edit-a-discussion-legacy
   */
  "PATCH /teams/:team_id/discussions/:discussion_number": {
    parameters: TeamsUpdateDiscussionLegacyEndpoint;
    request: TeamsUpdateDiscussionLegacyRequestOptions;
    response: OctokitResponse<TeamsUpdateDiscussionLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#edit-a-comment-legacy
   */
  "PATCH /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
    parameters: TeamsUpdateDiscussionCommentLegacyEndpoint;
    request: TeamsUpdateDiscussionCommentLegacyRequestOptions;
    response: OctokitResponse<TeamsUpdateDiscussionCommentLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/team_sync/#create-or-update-idp-group-connections-legacy
   */
  "PATCH /teams/:team_id/team-sync/group-mappings": {
    parameters: TeamsCreateOrUpdateIdPGroupConnectionsLegacyEndpoint;
    request: TeamsCreateOrUpdateIdPGroupConnectionsLegacyRequestOptions;
    response: OctokitResponse<
      TeamsCreateOrUpdateIdPGroupConnectionsLegacyResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/users/#update-the-authenticated-user
   */
  "PATCH /user": {
    parameters: UsersUpdateAuthenticatedEndpoint;
    request: UsersUpdateAuthenticatedRequestOptions;
    response: OctokitResponse<UsersUpdateAuthenticatedResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/emails/#toggle-primary-email-visibility
   */
  "PATCH /user/email/visibility": {
    parameters: UsersTogglePrimaryEmailVisibilityEndpoint;
    request: UsersTogglePrimaryEmailVisibilityRequestOptions;
    response: OctokitResponse<UsersTogglePrimaryEmailVisibilityResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#edit-your-organization-membership
   */
  "PATCH /user/memberships/orgs/:org": {
    parameters: OrgsUpdateMembershipEndpoint;
    request: OrgsUpdateMembershipRequestOptions;
    response: OctokitResponse<OrgsUpdateMembershipResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/invitations/#accept-a-repository-invitation
   */
  "PATCH /user/repository_invitations/:invitation_id": {
    parameters: ReposAcceptInvitationEndpoint;
    request: ReposAcceptInvitationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#create-a-github-app-from-a-manifest
   */
  "POST /app-manifests/:code/conversions": {
    parameters: AppsCreateFromManifestEndpoint;
    request: AppsCreateFromManifestRequestOptions;
    response: OctokitResponse<AppsCreateFromManifestResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/#create-a-new-installation-token
   */
  "POST /app/installations/:installation_id/access_tokens": {
    parameters: AppsCreateInstallationTokenEndpoint;
    request: AppsCreateInstallationTokenRequestOptions;
    response: OctokitResponse<AppsCreateInstallationTokenResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#check-a-token
   */
  "POST /applications/:client_id/token": {
    parameters: AppsCheckTokenEndpoint;
    request: AppsCheckTokenRequestOptions;
    response: OctokitResponse<AppsCheckTokenResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/apps/oauth_applications/#reset-an-authorization
   */
  "POST /applications/:client_id/tokens/:access_token": {
    parameters: AppsResetAuthorizationEndpoint;
    request: AppsResetAuthorizationRequestOptions;
    response: OctokitResponse<AppsResetAuthorizationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization
   */
  "POST /authorizations": {
    parameters: OauthAuthorizationsCreateAuthorizationEndpoint;
    request: OauthAuthorizationsCreateAuthorizationRequestOptions;
    response: OctokitResponse<
      OauthAuthorizationsCreateAuthorizationResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#create-a-content-attachment
   */
  "POST /content_references/:content_reference_id/attachments": {
    parameters: AppsCreateContentAttachmentEndpoint;
    request: AppsCreateContentAttachmentRequestOptions;
    response: OctokitResponse<AppsCreateContentAttachmentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#create-a-gist
   */
  "POST /gists": {
    parameters: GistsCreateEndpoint;
    request: GistsCreateRequestOptions;
    response: OctokitResponse<GistsCreateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/comments/#create-a-comment
   */
  "POST /gists/:gist_id/comments": {
    parameters: GistsCreateCommentEndpoint;
    request: GistsCreateCommentRequestOptions;
    response: OctokitResponse<GistsCreateCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/gists/#fork-a-gist
   */
  "POST /gists/:gist_id/forks": {
    parameters: GistsForkEndpoint;
    request: GistsForkRequestOptions;
    response: OctokitResponse<GistsForkResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/markdown/#render-an-arbitrary-markdown-document
   */
  "POST /markdown": {
    parameters: MarkdownRenderEndpoint;
    request: MarkdownRenderRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/markdown/#render-a-markdown-document-in-raw-mode
   */
  "POST /markdown/raw": {
    parameters: MarkdownRenderRawEndpoint;
    request: MarkdownRenderRawRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-registration-token-for-an-organization
   */
  "POST /orgs/:org/actions/runners/registration-token": {
    parameters: ActionsCreateRegistrationTokenForOrgEndpoint;
    request: ActionsCreateRegistrationTokenForOrgRequestOptions;
    response: OctokitResponse<ActionsCreateRegistrationTokenForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-remove-token-for-an-organization
   */
  "POST /orgs/:org/actions/runners/remove-token": {
    parameters: ActionsCreateRemoveTokenForOrgEndpoint;
    request: ActionsCreateRemoveTokenForOrgRequestOptions;
    response: OctokitResponse<ActionsCreateRemoveTokenForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/hooks/#create-a-hook
   */
  "POST /orgs/:org/hooks": {
    parameters: OrgsCreateHookEndpoint;
    request: OrgsCreateHookRequestOptions;
    response: OctokitResponse<OrgsCreateHookResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/hooks/#ping-a-hook
   */
  "POST /orgs/:org/hooks/:hook_id/pings": {
    parameters: OrgsPingHookEndpoint;
    request: OrgsPingHookRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#create-organization-invitation
   */
  "POST /orgs/:org/invitations": {
    parameters: OrgsCreateInvitationEndpoint;
    request: OrgsCreateInvitationRequestOptions;
    response: OctokitResponse<OrgsCreateInvitationResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/orgs/#start-an-organization-migration
   */
  "POST /orgs/:org/migrations": {
    parameters: MigrationsStartForOrgEndpoint;
    request: MigrationsStartForOrgRequestOptions;
    response: OctokitResponse<MigrationsStartForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#create-an-organization-project
   */
  "POST /orgs/:org/projects": {
    parameters: ProjectsCreateForOrgEndpoint;
    request: ProjectsCreateForOrgRequestOptions;
    response: OctokitResponse<ProjectsCreateForOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#create-an-organization-repository
   */
  "POST /orgs/:org/repos": {
    parameters: ReposCreateInOrgEndpoint;
    request: ReposCreateInOrgRequestOptions;
    response: OctokitResponse<ReposCreateInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#create-team
   */
  "POST /orgs/:org/teams": {
    parameters: TeamsCreateEndpoint;
    request: TeamsCreateRequestOptions;
    response: OctokitResponse<TeamsCreateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#create-a-discussion
   */
  "POST /orgs/:org/teams/:team_slug/discussions": {
    parameters: TeamsCreateDiscussionInOrgEndpoint;
    request: TeamsCreateDiscussionInOrgRequestOptions;
    response: OctokitResponse<TeamsCreateDiscussionInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#create-a-comment
   */
  "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": {
    parameters: TeamsCreateDiscussionCommentInOrgEndpoint;
    request: TeamsCreateDiscussionCommentInOrgRequestOptions;
    response: OctokitResponse<TeamsCreateDiscussionCommentInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-comment
   */
  "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": {
    parameters: ReactionsCreateForTeamDiscussionCommentInOrgEndpoint;
    request: ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions;
    response: OctokitResponse<
      ReactionsCreateForTeamDiscussionCommentInOrgResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion
   */
  "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": {
    parameters: ReactionsCreateForTeamDiscussionInOrgEndpoint;
    request: ReactionsCreateForTeamDiscussionInOrgRequestOptions;
    response: OctokitResponse<
      ReactionsCreateForTeamDiscussionInOrgResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/projects/columns/#create-a-project-column
   */
  "POST /projects/:project_id/columns": {
    parameters: ProjectsCreateColumnEndpoint;
    request: ProjectsCreateColumnRequestOptions;
    response: OctokitResponse<ProjectsCreateColumnResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/cards/#create-a-project-card
   */
  "POST /projects/columns/:column_id/cards": {
    parameters: ProjectsCreateCardEndpoint;
    request: ProjectsCreateCardRequestOptions;
    response: OctokitResponse<ProjectsCreateCardResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/columns/#move-a-project-column
   */
  "POST /projects/columns/:column_id/moves": {
    parameters: ProjectsMoveColumnEndpoint;
    request: ProjectsMoveColumnRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/projects/cards/#move-a-project-card
   */
  "POST /projects/columns/cards/:card_id/moves": {
    parameters: ProjectsMoveCardEndpoint;
    request: ProjectsMoveCardRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-registration-token-for-a-repository
   */
  "POST /repos/:owner/:repo/actions/runners/registration-token": {
    parameters: ActionsCreateRegistrationTokenForRepoEndpoint;
    request: ActionsCreateRegistrationTokenForRepoRequestOptions;
    response: OctokitResponse<
      ActionsCreateRegistrationTokenForRepoResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-remove-token-for-a-repository
   */
  "POST /repos/:owner/:repo/actions/runners/remove-token": {
    parameters: ActionsCreateRemoveTokenForRepoEndpoint;
    request: ActionsCreateRemoveTokenForRepoRequestOptions;
    response: OctokitResponse<ActionsCreateRemoveTokenForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#cancel-a-workflow-run
   */
  "POST /repos/:owner/:repo/actions/runs/:run_id/cancel": {
    parameters: ActionsCancelWorkflowRunEndpoint;
    request: ActionsCancelWorkflowRunRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/workflow-runs/#re-run-a-workflow
   */
  "POST /repos/:owner/:repo/actions/runs/:run_id/rerun": {
    parameters: ActionsReRunWorkflowEndpoint;
    request: ActionsReRunWorkflowRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#add-admin-enforcement-of-protected-branch
   */
  "POST /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
    parameters: ReposAddProtectedBranchAdminEnforcementEndpoint;
    request: ReposAddProtectedBranchAdminEnforcementRequestOptions;
    response: OctokitResponse<
      ReposAddProtectedBranchAdminEnforcementResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#add-required-signatures-of-protected-branch
   */
  "POST /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
    parameters: ReposAddProtectedBranchRequiredSignaturesEndpoint;
    request: ReposAddProtectedBranchRequiredSignaturesRequestOptions;
    response: OctokitResponse<
      ReposAddProtectedBranchRequiredSignaturesResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#add-required-status-checks-contexts-of-protected-branch
   */
  "POST /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
    parameters: ReposAddProtectedBranchRequiredStatusChecksContextsEndpoint;
    request: ReposAddProtectedBranchRequiredStatusChecksContextsRequestOptions;
    response: OctokitResponse<
      ReposAddProtectedBranchRequiredStatusChecksContextsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#add-app-restrictions-of-protected-branch
   */
  "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
    parameters: ReposAddProtectedBranchAppRestrictionsEndpoint;
    request: ReposAddProtectedBranchAppRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposAddProtectedBranchAppRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#add-team-restrictions-of-protected-branch
   */
  "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
    parameters: ReposAddProtectedBranchTeamRestrictionsEndpoint;
    request: ReposAddProtectedBranchTeamRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposAddProtectedBranchTeamRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#add-user-restrictions-of-protected-branch
   */
  "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
    parameters: ReposAddProtectedBranchUserRestrictionsEndpoint;
    request: ReposAddProtectedBranchUserRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposAddProtectedBranchUserRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/checks/runs/#create-a-check-run
   */
  "POST /repos/:owner/:repo/check-runs": {
    parameters: ChecksCreateEndpoint;
    request: ChecksCreateRequestOptions;
    response: OctokitResponse<ChecksCreateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/suites/#create-a-check-suite
   */
  "POST /repos/:owner/:repo/check-suites": {
    parameters: ChecksCreateSuiteEndpoint;
    request: ChecksCreateSuiteRequestOptions;
    response: OctokitResponse<ChecksCreateSuiteResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/checks/suites/#rerequest-a-check-suite
   */
  "POST /repos/:owner/:repo/check-suites/:check_suite_id/rerequest": {
    parameters: ChecksRerequestSuiteEndpoint;
    request: ChecksRerequestSuiteRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-commit-comment
   */
  "POST /repos/:owner/:repo/comments/:comment_id/reactions": {
    parameters: ReactionsCreateForCommitCommentEndpoint;
    request: ReactionsCreateForCommitCommentRequestOptions;
    response: OctokitResponse<ReactionsCreateForCommitCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/comments/#create-a-commit-comment
   */
  "POST /repos/:owner/:repo/commits/:commit_sha/comments": {
    parameters: ReposCreateCommitCommentEndpoint;
    request: ReposCreateCommitCommentRequestOptions;
    response: OctokitResponse<ReposCreateCommitCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#create-a-deployment
   */
  "POST /repos/:owner/:repo/deployments": {
    parameters: ReposCreateDeploymentEndpoint;
    request: ReposCreateDeploymentRequestOptions;
    response: OctokitResponse<ReposCreateDeploymentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/deployments/#create-a-deployment-status
   */
  "POST /repos/:owner/:repo/deployments/:deployment_id/statuses": {
    parameters: ReposCreateDeploymentStatusEndpoint;
    request: ReposCreateDeploymentStatusRequestOptions;
    response: OctokitResponse<ReposCreateDeploymentStatusResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#create-a-repository-dispatch-event
   */
  "POST /repos/:owner/:repo/dispatches": {
    parameters: ReposCreateDispatchEventEndpoint;
    request: ReposCreateDispatchEventRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/forks/#create-a-fork
   */
  "POST /repos/:owner/:repo/forks": {
    parameters: ReposCreateForkEndpoint;
    request: ReposCreateForkRequestOptions;
    response: OctokitResponse<ReposCreateForkResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/blobs/#create-a-blob
   */
  "POST /repos/:owner/:repo/git/blobs": {
    parameters: GitCreateBlobEndpoint;
    request: GitCreateBlobRequestOptions;
    response: OctokitResponse<GitCreateBlobResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/commits/#create-a-commit
   */
  "POST /repos/:owner/:repo/git/commits": {
    parameters: GitCreateCommitEndpoint;
    request: GitCreateCommitRequestOptions;
    response: OctokitResponse<GitCreateCommitResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/refs/#create-a-reference
   */
  "POST /repos/:owner/:repo/git/refs": {
    parameters: GitCreateRefEndpoint;
    request: GitCreateRefRequestOptions;
    response: OctokitResponse<GitCreateRefResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/tags/#create-a-tag-object
   */
  "POST /repos/:owner/:repo/git/tags": {
    parameters: GitCreateTagEndpoint;
    request: GitCreateTagRequestOptions;
    response: OctokitResponse<GitCreateTagResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/git/trees/#create-a-tree
   */
  "POST /repos/:owner/:repo/git/trees": {
    parameters: GitCreateTreeEndpoint;
    request: GitCreateTreeRequestOptions;
    response: OctokitResponse<GitCreateTreeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#create-a-hook
   */
  "POST /repos/:owner/:repo/hooks": {
    parameters: ReposCreateHookEndpoint;
    request: ReposCreateHookRequestOptions;
    response: OctokitResponse<ReposCreateHookResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#ping-a-hook
   */
  "POST /repos/:owner/:repo/hooks/:hook_id/pings": {
    parameters: ReposPingHookEndpoint;
    request: ReposPingHookRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/hooks/#test-a-push-hook
   */
  "POST /repos/:owner/:repo/hooks/:hook_id/tests": {
    parameters: ReposTestPushHookEndpoint;
    request: ReposTestPushHookRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#create-an-issue
   */
  "POST /repos/:owner/:repo/issues": {
    parameters: IssuesCreateEndpoint;
    request: IssuesCreateRequestOptions;
    response: OctokitResponse<IssuesCreateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/assignees/#add-assignees-to-an-issue
   */
  "POST /repos/:owner/:repo/issues/:issue_number/assignees": {
    parameters: IssuesAddAssigneesEndpoint;
    request: IssuesAddAssigneesRequestOptions;
    response: OctokitResponse<IssuesAddAssigneesResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/comments/#create-a-comment
   */
  "POST /repos/:owner/:repo/issues/:issue_number/comments": {
    parameters: IssuesCreateCommentEndpoint;
    request: IssuesCreateCommentRequestOptions;
    response: OctokitResponse<IssuesCreateCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#add-labels-to-an-issue
   */
  "POST /repos/:owner/:repo/issues/:issue_number/labels": {
    parameters: IssuesAddLabelsEndpoint;
    request: IssuesAddLabelsRequestOptions;
    response: OctokitResponse<IssuesAddLabelsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue
   */
  "POST /repos/:owner/:repo/issues/:issue_number/reactions": {
    parameters: ReactionsCreateForIssueEndpoint;
    request: ReactionsCreateForIssueRequestOptions;
    response: OctokitResponse<ReactionsCreateForIssueResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue-comment
   */
  "POST /repos/:owner/:repo/issues/comments/:comment_id/reactions": {
    parameters: ReactionsCreateForIssueCommentEndpoint;
    request: ReactionsCreateForIssueCommentRequestOptions;
    response: OctokitResponse<ReactionsCreateForIssueCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/keys/#add-a-new-deploy-key
   */
  "POST /repos/:owner/:repo/keys": {
    parameters: ReposAddDeployKeyEndpoint;
    request: ReposAddDeployKeyRequestOptions;
    response: OctokitResponse<ReposAddDeployKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#create-a-label
   */
  "POST /repos/:owner/:repo/labels": {
    parameters: IssuesCreateLabelEndpoint;
    request: IssuesCreateLabelRequestOptions;
    response: OctokitResponse<IssuesCreateLabelResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/merging/#perform-a-merge
   */
  "POST /repos/:owner/:repo/merges": {
    parameters: ReposMergeEndpoint;
    request: ReposMergeRequestOptions;
    response: OctokitResponse<ReposMergeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/milestones/#create-a-milestone
   */
  "POST /repos/:owner/:repo/milestones": {
    parameters: IssuesCreateMilestoneEndpoint;
    request: IssuesCreateMilestoneRequestOptions;
    response: OctokitResponse<IssuesCreateMilestoneResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#enable-a-pages-site
   */
  "POST /repos/:owner/:repo/pages": {
    parameters: ReposEnablePagesSiteEndpoint;
    request: ReposEnablePagesSiteRequestOptions;
    response: OctokitResponse<ReposEnablePagesSiteResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#request-a-page-build
   */
  "POST /repos/:owner/:repo/pages/builds": {
    parameters: ReposRequestPageBuildEndpoint;
    request: ReposRequestPageBuildRequestOptions;
    response: OctokitResponse<ReposRequestPageBuildResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#create-a-repository-project
   */
  "POST /repos/:owner/:repo/projects": {
    parameters: ProjectsCreateForRepoEndpoint;
    request: ProjectsCreateForRepoRequestOptions;
    response: OctokitResponse<ProjectsCreateForRepoResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#create-a-pull-request
   */
  "POST /repos/:owner/:repo/pulls": {
    parameters: PullsCreateEndpoint;
    request: PullsCreateRequestOptions;
    response: OctokitResponse<PullsCreateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#create-a-comment
   */
  "POST /repos/:owner/:repo/pulls/:pull_number/comments": {
    parameters: PullsCreateCommentEndpoint;
    request: PullsCreateCommentRequestOptions;
    response: OctokitResponse<PullsCreateCommentResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/comments/#create-a-review-comment-reply
   */
  "POST /repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies": {
    parameters: PullsCreateReviewCommentReplyEndpoint;
    request: PullsCreateReviewCommentReplyRequestOptions;
    response: OctokitResponse<PullsCreateReviewCommentReplyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/review_requests/#create-a-review-request
   */
  "POST /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
    parameters: PullsCreateReviewRequestEndpoint;
    request: PullsCreateReviewRequestRequestOptions;
    response: OctokitResponse<PullsCreateReviewRequestResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#create-a-pull-request-review
   */
  "POST /repos/:owner/:repo/pulls/:pull_number/reviews": {
    parameters: PullsCreateReviewEndpoint;
    request: PullsCreateReviewRequestOptions;
    response: OctokitResponse<PullsCreateReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review
   */
  "POST /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events": {
    parameters: PullsSubmitReviewEndpoint;
    request: PullsSubmitReviewRequestOptions;
    response: OctokitResponse<PullsSubmitReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-pull-request-review-comment
   */
  "POST /repos/:owner/:repo/pulls/comments/:comment_id/reactions": {
    parameters: ReactionsCreateForPullRequestReviewCommentEndpoint;
    request: ReactionsCreateForPullRequestReviewCommentRequestOptions;
    response: OctokitResponse<
      ReactionsCreateForPullRequestReviewCommentResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#create-a-release
   */
  "POST /repos/:owner/:repo/releases": {
    parameters: ReposCreateReleaseEndpoint;
    request: ReposCreateReleaseRequestOptions;
    response: OctokitResponse<ReposCreateReleaseResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/releases/#upload-a-release-asset
   */
  "POST /repos/:owner/:repo/releases/:release_id/assets{?name,label}": {
    parameters: ReposUploadReleaseAssetEndpoint;
    request: ReposUploadReleaseAssetRequestOptions;
    response: OctokitResponse<ReposUploadReleaseAssetResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/statuses/#create-a-status
   */
  "POST /repos/:owner/:repo/statuses/:sha": {
    parameters: ReposCreateStatusEndpoint;
    request: ReposCreateStatusRequestOptions;
    response: OctokitResponse<ReposCreateStatusResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#transfer-a-repository
   */
  "POST /repos/:owner/:repo/transfer": {
    parameters: ReposTransferEndpoint;
    request: ReposTransferRequestOptions;
    response: OctokitResponse<ReposTransferResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#create-a-repository-using-a-template
   */
  "POST /repos/:template_owner/:template_repo/generate": {
    parameters: ReposCreateUsingTemplateEndpoint;
    request: ReposCreateUsingTemplateRequestOptions;
    response: OctokitResponse<ReposCreateUsingTemplateResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/scim/#provision-and-invite-users
   */
  "POST /scim/v2/organizations/:org/Users": {
    parameters: ScimProvisionAndInviteUsersEndpoint;
    request: ScimProvisionAndInviteUsersRequestOptions;
    response: OctokitResponse<ScimProvisionAndInviteUsersResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussions/#create-a-discussion-legacy
   */
  "POST /teams/:team_id/discussions": {
    parameters: TeamsCreateDiscussionLegacyEndpoint;
    request: TeamsCreateDiscussionLegacyRequestOptions;
    response: OctokitResponse<TeamsCreateDiscussionLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/discussion_comments/#create-a-comment-legacy
   */
  "POST /teams/:team_id/discussions/:discussion_number/comments": {
    parameters: TeamsCreateDiscussionCommentLegacyEndpoint;
    request: TeamsCreateDiscussionCommentLegacyRequestOptions;
    response: OctokitResponse<TeamsCreateDiscussionCommentLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-comment-legacy
   */
  "POST /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": {
    parameters: ReactionsCreateForTeamDiscussionCommentLegacyEndpoint;
    request: ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions;
    response: OctokitResponse<
      ReactionsCreateForTeamDiscussionCommentLegacyResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-legacy
   */
  "POST /teams/:team_id/discussions/:discussion_number/reactions": {
    parameters: ReactionsCreateForTeamDiscussionLegacyEndpoint;
    request: ReactionsCreateForTeamDiscussionLegacyRequestOptions;
    response: OctokitResponse<
      ReactionsCreateForTeamDiscussionLegacyResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/users/emails/#add-email-addresses
   */
  "POST /user/emails": {
    parameters: UsersAddEmailsEndpoint;
    request: UsersAddEmailsRequestOptions;
    response: OctokitResponse<UsersAddEmailsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/gpg_keys/#create-a-gpg-key
   */
  "POST /user/gpg_keys": {
    parameters: UsersCreateGpgKeyEndpoint;
    request: UsersCreateGpgKeyRequestOptions;
    response: OctokitResponse<UsersCreateGpgKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/users/keys/#create-a-public-key
   */
  "POST /user/keys": {
    parameters: UsersCreatePublicKeyEndpoint;
    request: UsersCreatePublicKeyRequestOptions;
    response: OctokitResponse<UsersCreatePublicKeyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/users/#start-a-user-migration
   */
  "POST /user/migrations": {
    parameters: MigrationsStartForAuthenticatedUserEndpoint;
    request: MigrationsStartForAuthenticatedUserRequestOptions;
    response: OctokitResponse<MigrationsStartForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/projects/#create-a-user-project
   */
  "POST /user/projects": {
    parameters: ProjectsCreateForAuthenticatedUserEndpoint;
    request: ProjectsCreateForAuthenticatedUserRequestOptions;
    response: OctokitResponse<ProjectsCreateForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#create-a-repository-for-the-authenticated-user
   */
  "POST /user/repos": {
    parameters: ReposCreateForAuthenticatedUserEndpoint;
    request: ReposCreateForAuthenticatedUserRequestOptions;
    response: OctokitResponse<ReposCreateForAuthenticatedUserResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app
   */
  "PUT /authorizations/clients/:client_id": {
    parameters: OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint;
    request: OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions;
    response: OctokitResponse<
      OauthAuthorizationsGetOrCreateAuthorizationForAppResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint
   */
  "PUT /authorizations/clients/:client_id/:fingerprint": {
    parameters: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint;
    request: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions;
    response: OctokitResponse<
      OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/gists/#star-a-gist
   */
  "PUT /gists/:gist_id/star": {
    parameters: GistsStarEndpoint;
    request: GistsStarRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#mark-notifications-as-read
   */
  "PUT /notifications": {
    parameters: ActivityMarkNotificationsAsReadEndpoint;
    request: ActivityMarkNotificationsAsReadRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#set-a-thread-subscription
   */
  "PUT /notifications/threads/:thread_id/subscription": {
    parameters: ActivitySetThreadSubscriptionEndpoint;
    request: ActivitySetThreadSubscriptionRequestOptions;
    response: OctokitResponse<ActivitySetThreadSubscriptionResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/blocking/#block-a-user
   */
  "PUT /orgs/:org/blocks/:username": {
    parameters: OrgsBlockUserEndpoint;
    request: OrgsBlockUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/interactions/orgs/#add-or-update-interaction-restrictions-for-an-organization
   */
  "PUT /orgs/:org/interaction-limits": {
    parameters: InteractionsAddOrUpdateRestrictionsForOrgEndpoint;
    request: InteractionsAddOrUpdateRestrictionsForOrgRequestOptions;
    response: OctokitResponse<
      InteractionsAddOrUpdateRestrictionsForOrgResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#add-or-update-organization-membership
   */
  "PUT /orgs/:org/memberships/:username": {
    parameters: OrgsAddOrUpdateMembershipEndpoint;
    request: OrgsAddOrUpdateMembershipRequestOptions;
    response: OctokitResponse<OrgsAddOrUpdateMembershipResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/orgs/outside_collaborators/#convert-member-to-outside-collaborator
   */
  "PUT /orgs/:org/outside_collaborators/:username": {
    parameters: OrgsConvertMemberToOutsideCollaboratorEndpoint;
    request: OrgsConvertMemberToOutsideCollaboratorRequestOptions;
    response: OctokitResponse<
      OrgsConvertMemberToOutsideCollaboratorResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/orgs/members/#publicize-a-users-membership
   */
  "PUT /orgs/:org/public_members/:username": {
    parameters: OrgsPublicizeMembershipEndpoint;
    request: OrgsPublicizeMembershipRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#add-or-update-team-membership
   */
  "PUT /orgs/:org/teams/:team_slug/memberships/:username": {
    parameters: TeamsAddOrUpdateMembershipInOrgEndpoint;
    request: TeamsAddOrUpdateMembershipInOrgRequestOptions;
    response: OctokitResponse<TeamsAddOrUpdateMembershipInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#add-or-update-team-project
   */
  "PUT /orgs/:org/teams/:team_slug/projects/:project_id": {
    parameters: TeamsAddOrUpdateProjectInOrgEndpoint;
    request: TeamsAddOrUpdateProjectInOrgRequestOptions;
    response: OctokitResponse<TeamsAddOrUpdateProjectInOrgResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#add-or-update-team-repository
   */
  "PUT /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
    parameters: TeamsAddOrUpdateRepoInOrgEndpoint;
    request: TeamsAddOrUpdateRepoInOrgRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator
   */
  "PUT /projects/:project_id/collaborators/:username": {
    parameters: ProjectsAddCollaboratorEndpoint;
    request: ProjectsAddCollaboratorRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/actions/secrets/#create-or-update-a-secret-for-a-repository
   */
  "PUT /repos/:owner/:repo/actions/secrets/:name": {
    parameters: ActionsCreateOrUpdateSecretForRepoEndpoint;
    request: ActionsCreateOrUpdateSecretForRepoRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#enable-automated-security-fixes
   */
  "PUT /repos/:owner/:repo/automated-security-fixes": {
    parameters: ReposEnableAutomatedSecurityFixesEndpoint;
    request: ReposEnableAutomatedSecurityFixesRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#update-branch-protection
   */
  "PUT /repos/:owner/:repo/branches/:branch/protection": {
    parameters: ReposUpdateBranchProtectionEndpoint;
    request: ReposUpdateBranchProtectionRequestOptions;
    response: OctokitResponse<ReposUpdateBranchProtectionResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#replace-required-status-checks-contexts-of-protected-branch
   */
  "PUT /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
    parameters: ReposReplaceProtectedBranchRequiredStatusChecksContextsEndpoint;
    request: ReposReplaceProtectedBranchRequiredStatusChecksContextsRequestOptions;
    response: OctokitResponse<
      ReposReplaceProtectedBranchRequiredStatusChecksContextsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#replace-app-restrictions-of-protected-branch
   */
  "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
    parameters: ReposReplaceProtectedBranchAppRestrictionsEndpoint;
    request: ReposReplaceProtectedBranchAppRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposReplaceProtectedBranchAppRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#replace-team-restrictions-of-protected-branch
   */
  "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
    parameters: ReposReplaceProtectedBranchTeamRestrictionsEndpoint;
    request: ReposReplaceProtectedBranchTeamRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposReplaceProtectedBranchTeamRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/branches/#replace-user-restrictions-of-protected-branch
   */
  "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
    parameters: ReposReplaceProtectedBranchUserRestrictionsEndpoint;
    request: ReposReplaceProtectedBranchUserRestrictionsRequestOptions;
    response: OctokitResponse<
      ReposReplaceProtectedBranchUserRestrictionsResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/repos/collaborators/#add-user-as-a-collaborator
   */
  "PUT /repos/:owner/:repo/collaborators/:username": {
    parameters: ReposAddCollaboratorEndpoint;
    request: ReposAddCollaboratorRequestOptions;
    response: OctokitResponse<ReposAddCollaboratorResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/contents/#create-or-update-a-file
   */
  "PUT /repos/:owner/:repo/contents/:path": {
    parameters: ReposCreateOrUpdateFileEndpoint;
    request: ReposCreateOrUpdateFileRequestOptions;
    response: OctokitResponse<ReposCreateOrUpdateFileResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/migrations/source_imports/#start-an-import
   */
  "PUT /repos/:owner/:repo/import": {
    parameters: MigrationsStartImportEndpoint;
    request: MigrationsStartImportRequestOptions;
    response: OctokitResponse<MigrationsStartImportResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/interactions/repos/#add-or-update-interaction-restrictions-for-a-repository
   */
  "PUT /repos/:owner/:repo/interaction-limits": {
    parameters: InteractionsAddOrUpdateRestrictionsForRepoEndpoint;
    request: InteractionsAddOrUpdateRestrictionsForRepoRequestOptions;
    response: OctokitResponse<
      InteractionsAddOrUpdateRestrictionsForRepoResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/issues/labels/#replace-all-labels-for-an-issue
   */
  "PUT /repos/:owner/:repo/issues/:issue_number/labels": {
    parameters: IssuesReplaceAllLabelsEndpoint;
    request: IssuesReplaceAllLabelsRequestOptions;
    response: OctokitResponse<IssuesReplaceAllLabelsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/issues/#lock-an-issue
   */
  "PUT /repos/:owner/:repo/issues/:issue_number/lock": {
    parameters: IssuesLockEndpoint;
    request: IssuesLockRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/notifications/#mark-repository-notifications-as-read
   */
  "PUT /repos/:owner/:repo/notifications": {
    parameters: ActivityMarkRepoNotificationsAsReadEndpoint;
    request: ActivityMarkRepoNotificationsAsReadRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/repos/pages/#update-information-about-a-pages-site
   */
  "PUT /repos/:owner/:repo/pages": {
    parameters: ReposUpdateInformationAboutPagesSiteEndpoint;
    request: ReposUpdateInformationAboutPagesSiteRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#merge-a-pull-request-merge-button
   */
  "PUT /repos/:owner/:repo/pulls/:pull_number/merge": {
    parameters: PullsMergeEndpoint;
    request: PullsMergeRequestOptions;
    response: OctokitResponse<PullsMergeResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#update-a-pull-request-review
   */
  "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
    parameters: PullsUpdateReviewEndpoint;
    request: PullsUpdateReviewRequestOptions;
    response: OctokitResponse<PullsUpdateReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/reviews/#dismiss-a-pull-request-review
   */
  "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals": {
    parameters: PullsDismissReviewEndpoint;
    request: PullsDismissReviewRequestOptions;
    response: OctokitResponse<PullsDismissReviewResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/pulls/#update-a-pull-request-branch
   */
  "PUT /repos/:owner/:repo/pulls/:pull_number/update-branch": {
    parameters: PullsUpdateBranchEndpoint;
    request: PullsUpdateBranchRequestOptions;
    response: OctokitResponse<PullsUpdateBranchResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#set-a-repository-subscription
   */
  "PUT /repos/:owner/:repo/subscription": {
    parameters: ActivitySetRepoSubscriptionEndpoint;
    request: ActivitySetRepoSubscriptionRequestOptions;
    response: OctokitResponse<ActivitySetRepoSubscriptionResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#replace-all-repository-topics
   */
  "PUT /repos/:owner/:repo/topics": {
    parameters: ReposReplaceAllTopicsEndpoint;
    request: ReposReplaceAllTopicsRequestOptions;
    response: OctokitResponse<ReposReplaceAllTopicsResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/repos/#enable-vulnerability-alerts
   */
  "PUT /repos/:owner/:repo/vulnerability-alerts": {
    parameters: ReposEnableVulnerabilityAlertsEndpoint;
    request: ReposEnableVulnerabilityAlertsRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/scim/#replace-a-provisioned-users-information
   */
  "PUT /scim/v2/organizations/:org/Users/:scim_user_id": {
    parameters: ScimReplaceProvisionedUserInformationEndpoint;
    request: ScimReplaceProvisionedUserInformationRequestOptions;
    response: OctokitResponse<
      ScimReplaceProvisionedUserInformationResponseData
    >;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#add-team-member-legacy
   */
  "PUT /teams/:team_id/members/:username": {
    parameters: TeamsAddMemberLegacyEndpoint;
    request: TeamsAddMemberLegacyRequestOptions;
    response: OctokitResponse<TeamsAddMemberLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/members/#add-or-update-team-membership-legacy
   */
  "PUT /teams/:team_id/memberships/:username": {
    parameters: TeamsAddOrUpdateMembershipLegacyEndpoint;
    request: TeamsAddOrUpdateMembershipLegacyRequestOptions;
    response: OctokitResponse<TeamsAddOrUpdateMembershipLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#add-or-update-team-project-legacy
   */
  "PUT /teams/:team_id/projects/:project_id": {
    parameters: TeamsAddOrUpdateProjectLegacyEndpoint;
    request: TeamsAddOrUpdateProjectLegacyRequestOptions;
    response: OctokitResponse<TeamsAddOrUpdateProjectLegacyResponseData>;
  };
  /**
   * @see https://developer.github.com/v3/teams/#add-or-update-team-repository-legacy
   */
  "PUT /teams/:team_id/repos/:owner/:repo": {
    parameters: TeamsAddOrUpdateRepoLegacyEndpoint;
    request: TeamsAddOrUpdateRepoLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/blocking/#block-a-user
   */
  "PUT /user/blocks/:username": {
    parameters: UsersBlockEndpoint;
    request: UsersBlockRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/users/followers/#follow-a-user
   */
  "PUT /user/following/:username": {
    parameters: UsersFollowEndpoint;
    request: UsersFollowRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/apps/installations/#add-repository-to-installation
   */
  "PUT /user/installations/:installation_id/repositories/:repository_id": {
    parameters: AppsAddRepoToInstallationEndpoint;
    request: AppsAddRepoToInstallationRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/starring/#star-a-repository-for-the-authenticated-user
   */
  "PUT /user/starred/:owner/:repo": {
    parameters: ActivityStarRepoForAuthenticatedUserEndpoint;
    request: ActivityStarRepoForAuthenticatedUserRequestOptions;
    response: OctokitResponse<any>;
  };
  /**
   * @see https://developer.github.com/v3/activity/watching/#watch-a-repository-legacy
   */
  "PUT /user/subscriptions/:owner/:repo": {
    parameters: ActivityWatchRepoLegacyEndpoint;
    request: ActivityWatchRepoLegacyRequestOptions;
    response: OctokitResponse<any>;
  };
}

type AppsGetAuthenticatedEndpoint = {} & RequiredPreview<"machine-man">;

type AppsGetAuthenticatedRequestOptions = {
  method: "GET";
  url: "/app";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetAuthenticatedResponseDataPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type AppsGetAuthenticatedResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type AppsGetAuthenticatedResponseData = {
  id: number;
  slug: string;
  node_id: string;
  owner: AppsGetAuthenticatedResponseDataOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: AppsGetAuthenticatedResponseDataPermissions;
  events: Array<string>;
  installations_count: number;
};

type AppsCreateFromManifestEndpoint = {
  /**
   * code parameter
   */
  code: string;
};

type AppsCreateFromManifestRequestOptions = {
  method: "POST";
  url: "/app-manifests/:code/conversions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCreateFromManifestResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsCreateFromManifestResponseData = {
  id: number;
  node_id: string;
  owner: AppsCreateFromManifestResponseDataOwner;
  name: string;
  description: null;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  client_id: string;
  client_secret: string;
  webhook_secret: string;
  pem: string;
};

type AppsListInstallationsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"machine-man">;

type AppsListInstallationsRequestOptions = {
  method: "GET";
  url: "/app/installations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListInstallationsResponseDataItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type AppsListInstallationsResponseDataItemAccount = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type AppsListInstallationsResponseDataItem = {
  id: number;
  account: AppsListInstallationsResponseDataItemAccount;
  access_tokens_url: string;
  repositories_url: string;
  html_url: string;
  app_id: number;
  target_id: number;
  target_type: string;
  permissions: AppsListInstallationsResponseDataItemPermissions;
  events: Array<string>;
  single_file_name: string;
  repository_selection: string;
};
type AppsListInstallationsResponseData = Array<
  AppsListInstallationsResponseDataItem
>;

type AppsGetInstallationEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
} & RequiredPreview<"machine-man">;

type AppsGetInstallationRequestOptions = {
  method: "GET";
  url: "/app/installations/:installation_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetInstallationResponseDataPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type AppsGetInstallationResponseDataAccount = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type AppsGetInstallationResponseData = {
  id: number;
  account: AppsGetInstallationResponseDataAccount;
  access_tokens_url: string;
  repositories_url: string;
  html_url: string;
  app_id: number;
  target_id: number;
  target_type: string;
  permissions: AppsGetInstallationResponseDataPermissions;
  events: Array<string>;
  single_file_name: string;
  repository_selection: string;
};

type AppsDeleteInstallationEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
} & RequiredPreview<"machine-man">;

type AppsDeleteInstallationRequestOptions = {
  method: "DELETE";
  url: "/app/installations/:installation_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsCreateInstallationTokenEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
  /**
   * The `id`s of the repositories that the installation token can access. Providing repository `id`s restricts the access of an installation token to specific repositories. You can use the "[List repositories](https://developer.github.com/v3/apps/installations/#list-repositories)" endpoint to get the `id` of all repositories that an installation can access. For example, you can select specific repositories when creating an installation token to restrict the number of repositories that can be cloned using the token.
   */
  repository_ids?: number[];
  /**
   * The permissions granted to the access token. The permissions object includes the permission names and their access type. For a complete list of permissions and allowable values, see "[GitHub App permissions](https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url-parameters/#github-app-permissions)."
   */
  permissions?: AppsCreateInstallationTokenParamsPermissions;
} & RequiredPreview<"machine-man">;

type AppsCreateInstallationTokenRequestOptions = {
  method: "POST";
  url: "/app/installations/:installation_id/access_tokens";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCreateInstallationTokenResponseDataRepositoriesItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type AppsCreateInstallationTokenResponseDataRepositoriesItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsCreateInstallationTokenResponseDataRepositoriesItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: AppsCreateInstallationTokenResponseDataRepositoriesItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: AppsCreateInstallationTokenResponseDataRepositoriesItemPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type AppsCreateInstallationTokenResponseDataPermissions = {
  issues: string;
  contents: string;
};
type AppsCreateInstallationTokenResponseData = {
  token: string;
  expires_at: string;
  permissions: AppsCreateInstallationTokenResponseDataPermissions;
  repositories: Array<AppsCreateInstallationTokenResponseDataRepositoriesItem>;
};

type OauthAuthorizationsListGrantsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OauthAuthorizationsListGrantsRequestOptions = {
  method: "GET";
  url: "/applications/grants";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsListGrantsResponseDataItemApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsListGrantsResponseDataItem = {
  id: number;
  url: string;
  app: OauthAuthorizationsListGrantsResponseDataItemApp;
  created_at: string;
  updated_at: string;
  scopes: Array<string>;
};
type OauthAuthorizationsListGrantsResponseData = Array<
  OauthAuthorizationsListGrantsResponseDataItem
>;

type OauthAuthorizationsGetGrantEndpoint = {
  /**
   * grant_id parameter
   */
  grant_id: number;
};

type OauthAuthorizationsGetGrantRequestOptions = {
  method: "GET";
  url: "/applications/grants/:grant_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetGrantResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsGetGrantResponseData = {
  id: number;
  url: string;
  app: OauthAuthorizationsGetGrantResponseDataApp;
  created_at: string;
  updated_at: string;
  scopes: Array<string>;
};

type OauthAuthorizationsDeleteGrantEndpoint = {
  /**
   * grant_id parameter
   */
  grant_id: number;
};

type OauthAuthorizationsDeleteGrantRequestOptions = {
  method: "DELETE";
  url: "/applications/grants/:grant_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsDeleteAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};

type AppsDeleteAuthorizationRequestOptions = {
  method: "DELETE";
  url: "/applications/:client_id/grant";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsRevokeGrantForApplicationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};

type AppsRevokeGrantForApplicationRequestOptions = {
  method: "DELETE";
  url: "/applications/:client_id/grants/:access_token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsCheckTokenEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};

type AppsCheckTokenRequestOptions = {
  method: "POST";
  url: "/applications/:client_id/token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCheckTokenResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsCheckTokenResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type AppsCheckTokenResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: AppsCheckTokenResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
  user: AppsCheckTokenResponseDataUser;
};

type AppsResetTokenEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};

type AppsResetTokenRequestOptions = {
  method: "PATCH";
  url: "/applications/:client_id/token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsResetTokenResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsResetTokenResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type AppsResetTokenResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: AppsResetTokenResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
  user: AppsResetTokenResponseDataUser;
};

type AppsDeleteTokenEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};

type AppsDeleteTokenRequestOptions = {
  method: "DELETE";
  url: "/applications/:client_id/token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsCheckAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};

type AppsCheckAuthorizationRequestOptions = {
  method: "GET";
  url: "/applications/:client_id/tokens/:access_token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCheckAuthorizationResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsCheckAuthorizationResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type AppsCheckAuthorizationResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: AppsCheckAuthorizationResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
  user: AppsCheckAuthorizationResponseDataUser;
};

type AppsResetAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};

type AppsResetAuthorizationRequestOptions = {
  method: "POST";
  url: "/applications/:client_id/tokens/:access_token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsResetAuthorizationResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsResetAuthorizationResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type AppsResetAuthorizationResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: AppsResetAuthorizationResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
  user: AppsResetAuthorizationResponseDataUser;
};

type AppsRevokeAuthorizationForApplicationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};

type AppsRevokeAuthorizationForApplicationRequestOptions = {
  method: "DELETE";
  url: "/applications/:client_id/tokens/:access_token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsGetBySlugEndpoint = {
  /**
   * app_slug parameter
   */
  app_slug: string;
} & RequiredPreview<"machine-man">;

type AppsGetBySlugRequestOptions = {
  method: "GET";
  url: "/apps/:app_slug";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetBySlugResponseDataPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type AppsGetBySlugResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type AppsGetBySlugResponseData = {
  id: number;
  slug: string;
  node_id: string;
  owner: AppsGetBySlugResponseDataOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: AppsGetBySlugResponseDataPermissions;
  events: Array<string>;
};

type OauthAuthorizationsListAuthorizationsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OauthAuthorizationsListAuthorizationsRequestOptions = {
  method: "GET";
  url: "/authorizations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsListAuthorizationsResponseDataItemApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsListAuthorizationsResponseDataItem = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: OauthAuthorizationsListAuthorizationsResponseDataItemApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
};
type OauthAuthorizationsListAuthorizationsResponseData = Array<
  OauthAuthorizationsListAuthorizationsResponseDataItem
>;

type OauthAuthorizationsCreateAuthorizationEndpoint = {
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
   */
  note: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
  /**
   * The 20 character OAuth app client key for which to create the token.
   */
  client_id?: string;
  /**
   * The 40 character OAuth app client secret for which to create the token.
   */
  client_secret?: string;
  /**
   * A unique string to distinguish an authorization from others created for the same client ID and user.
   */
  fingerprint?: string;
};

type OauthAuthorizationsCreateAuthorizationRequestOptions = {
  method: "POST";
  url: "/authorizations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsCreateAuthorizationResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsCreateAuthorizationResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: OauthAuthorizationsCreateAuthorizationResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
};

type OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The 40 character OAuth app client secret associated with the client ID specified in the URL.
   */
  client_secret: string;
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
  /**
   * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
   */
  fingerprint?: string;
};

type OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions = {
  method: "PUT";
  url: "/authorizations/clients/:client_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: OauthAuthorizationsGetOrCreateAuthorizationForAppResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
};

type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * fingerprint parameter
   */
  fingerprint: string;
  /**
   * The 40 character OAuth app client secret associated with the client ID specified in the URL.
   */
  client_secret: string;
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
};

type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions = {
  method: "PUT";
  url: "/authorizations/clients/:client_id/:fingerprint";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
};

type OauthAuthorizationsGetAuthorizationEndpoint = {
  /**
   * authorization_id parameter
   */
  authorization_id: number;
};

type OauthAuthorizationsGetAuthorizationRequestOptions = {
  method: "GET";
  url: "/authorizations/:authorization_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetAuthorizationResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsGetAuthorizationResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: OauthAuthorizationsGetAuthorizationResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
};

type OauthAuthorizationsUpdateAuthorizationEndpoint = {
  /**
   * authorization_id parameter
   */
  authorization_id: number;
  /**
   * Replaces the authorization scopes with these.
   */
  scopes?: string[];
  /**
   * A list of scopes to add to this authorization.
   */
  add_scopes?: string[];
  /**
   * A list of scopes to remove from this authorization.
   */
  remove_scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
  /**
   * A unique string to distinguish an authorization from others created for the same client ID and user.
   */
  fingerprint?: string;
};

type OauthAuthorizationsUpdateAuthorizationRequestOptions = {
  method: "PATCH";
  url: "/authorizations/:authorization_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsUpdateAuthorizationResponseDataApp = {
  url: string;
  name: string;
  client_id: string;
};
type OauthAuthorizationsUpdateAuthorizationResponseData = {
  id: number;
  url: string;
  scopes: Array<string>;
  token: string;
  token_last_eight: string;
  hashed_token: string;
  app: OauthAuthorizationsUpdateAuthorizationResponseDataApp;
  note: string;
  note_url: string;
  updated_at: string;
  created_at: string;
  fingerprint: string;
};

type OauthAuthorizationsDeleteAuthorizationEndpoint = {
  /**
   * authorization_id parameter
   */
  authorization_id: number;
};

type OauthAuthorizationsDeleteAuthorizationRequestOptions = {
  method: "DELETE";
  url: "/authorizations/:authorization_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type CodesOfConductGetAllCodesOfConductEndpoint = {} & RequiredPreview<
  "scarlet-witch"
>;

type CodesOfConductGetAllCodesOfConductRequestOptions = {
  method: "GET";
  url: "/codes_of_conduct";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type CodesOfConductGetAllCodesOfConductResponseDataItem = {
  key: string;
  name: string;
  url: string;
};
type CodesOfConductGetAllCodesOfConductResponseData = Array<
  CodesOfConductGetAllCodesOfConductResponseDataItem
>;

type CodesOfConductGetConductCodeEndpoint = {
  /**
   * key parameter
   */
  key: string;
} & RequiredPreview<"scarlet-witch">;

type CodesOfConductGetConductCodeRequestOptions = {
  method: "GET";
  url: "/codes_of_conduct/:key";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type CodesOfConductGetConductCodeResponseData = {
  key: string;
  name: string;
  url: string;
  body: string;
};

type AppsCreateContentAttachmentEndpoint = {
  /**
   * content_reference_id parameter
   */
  content_reference_id: number;
  /**
   * The title of the content attachment displayed in the body or comment of an issue or pull request.
   */
  title: string;
  /**
   * The body text of the content attachment displayed in the body or comment of an issue or pull request. This parameter supports markdown.
   */
  body: string;
} & RequiredPreview<"corsair">;

type AppsCreateContentAttachmentRequestOptions = {
  method: "POST";
  url: "/content_references/:content_reference_id/attachments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCreateContentAttachmentResponseData = {
  id: number;
  title: string;
  body: string;
};

type EmojisGetEndpoint = {};

type EmojisGetRequestOptions = {
  method: "GET";
  url: "/emojis";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityListPublicEventsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListPublicEventsRequestOptions = {
  method: "GET";
  url: "/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityGetFeedsEndpoint = {};

type ActivityGetFeedsRequestOptions = {
  method: "GET";
  url: "/feeds";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetFeedsResponseDataLinksSecurityAdvisories = {
  href: string;
  type: string;
};
type ActivityGetFeedsResponseDataLinksCurrentUserOrganizationsItem = {
  href: string;
  type: string;
};
type ActivityGetFeedsResponseDataLinksCurrentUserOrganization = {
  href: string;
  type: string;
};
type ActivityGetFeedsResponseDataLinksCurrentUserActor = {
  href: string;
  type: string;
};
type ActivityGetFeedsResponseDataLinksCurrentUser = {
  href: string;
  type: string;
};
type ActivityGetFeedsResponseDataLinksCurrentUserPublic = {
  href: string;
  type: string;
};
type ActivityGetFeedsResponseDataLinksUser = { href: string; type: string };
type ActivityGetFeedsResponseDataLinksTimeline = { href: string; type: string };
type ActivityGetFeedsResponseDataLinks = {
  timeline: ActivityGetFeedsResponseDataLinksTimeline;
  user: ActivityGetFeedsResponseDataLinksUser;
  current_user_public: ActivityGetFeedsResponseDataLinksCurrentUserPublic;
  current_user: ActivityGetFeedsResponseDataLinksCurrentUser;
  current_user_actor: ActivityGetFeedsResponseDataLinksCurrentUserActor;
  current_user_organization: ActivityGetFeedsResponseDataLinksCurrentUserOrganization;
  current_user_organizations: Array<
    ActivityGetFeedsResponseDataLinksCurrentUserOrganizationsItem
  >;
  security_advisories: ActivityGetFeedsResponseDataLinksSecurityAdvisories;
};
type ActivityGetFeedsResponseData = {
  timeline_url: string;
  user_url: string;
  current_user_public_url: string;
  current_user_url: string;
  current_user_actor_url: string;
  current_user_organization_url: string;
  current_user_organization_urls: Array<string>;
  security_advisories_url: string;
  _links: ActivityGetFeedsResponseDataLinks;
};

type GistsListEndpoint = {
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GistsListRequestOptions = {
  method: "GET";
  url: "/gists";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsListResponseDataItemFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
};
type GistsListResponseDataItemFiles = {
  "hello_world.rb": GistsListResponseDataItemFilesHelloWorldRb;
};
type GistsListResponseDataItem = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsListResponseDataItemFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsListResponseDataItemOwner;
  truncated: boolean;
};
type GistsListResponseData = Array<GistsListResponseDataItem>;

type GistsCreateEndpoint = {
  /**
   * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
   */
  files: GistsCreateParamsFiles;
  /**
   * A descriptive name for this gist.
   */
  description?: string;
  /**
   * When `true`, the gist will be public and available for anyone to see.
   */
  public?: boolean;
};

type GistsCreateRequestOptions = {
  method: "POST";
  url: "/gists";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsCreateResponseDataHistoryItemChangeStatus = {
  deletions: number;
  additions: number;
  total: number;
};
type GistsCreateResponseDataHistoryItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsCreateResponseDataHistoryItem = {
  url: string;
  version: string;
  user: GistsCreateResponseDataHistoryItemUser;
  change_status: GistsCreateResponseDataHistoryItemChangeStatus;
  committed_at: string;
};
type GistsCreateResponseDataForksItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsCreateResponseDataForksItem = {
  user: GistsCreateResponseDataForksItemUser;
  url: string;
  id: string;
  created_at: string;
  updated_at: string;
};
type GistsCreateResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsCreateResponseDataFilesHelloWorldPythonTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsCreateResponseDataFilesHelloWorldRubyTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsCreateResponseDataFilesHelloWorldPy = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsCreateResponseDataFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsCreateResponseDataFiles = {
  "hello_world.rb": GistsCreateResponseDataFilesHelloWorldRb;
  "hello_world.py": GistsCreateResponseDataFilesHelloWorldPy;
  "hello_world_ruby.txt": GistsCreateResponseDataFilesHelloWorldRubyTxt;
  "hello_world_python.txt": GistsCreateResponseDataFilesHelloWorldPythonTxt;
};
type GistsCreateResponseData = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsCreateResponseDataFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsCreateResponseDataOwner;
  truncated: boolean;
  forks: Array<GistsCreateResponseDataForksItem>;
  history: Array<GistsCreateResponseDataHistoryItem>;
};

type GistsListPublicEndpoint = {
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GistsListPublicRequestOptions = {
  method: "GET";
  url: "/gists/public";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListPublicResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsListPublicResponseDataItemFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
};
type GistsListPublicResponseDataItemFiles = {
  "hello_world.rb": GistsListPublicResponseDataItemFilesHelloWorldRb;
};
type GistsListPublicResponseDataItem = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsListPublicResponseDataItemFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsListPublicResponseDataItemOwner;
  truncated: boolean;
};
type GistsListPublicResponseData = Array<GistsListPublicResponseDataItem>;

type GistsListStarredEndpoint = {
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GistsListStarredRequestOptions = {
  method: "GET";
  url: "/gists/starred";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListStarredResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsListStarredResponseDataItemFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
};
type GistsListStarredResponseDataItemFiles = {
  "hello_world.rb": GistsListStarredResponseDataItemFilesHelloWorldRb;
};
type GistsListStarredResponseDataItem = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsListStarredResponseDataItemFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsListStarredResponseDataItemOwner;
  truncated: boolean;
};
type GistsListStarredResponseData = Array<GistsListStarredResponseDataItem>;

type GistsGetEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};

type GistsGetRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsGetResponseDataHistoryItemChangeStatus = {
  deletions: number;
  additions: number;
  total: number;
};
type GistsGetResponseDataHistoryItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetResponseDataHistoryItem = {
  url: string;
  version: string;
  user: GistsGetResponseDataHistoryItemUser;
  change_status: GistsGetResponseDataHistoryItemChangeStatus;
  committed_at: string;
};
type GistsGetResponseDataForksItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetResponseDataForksItem = {
  user: GistsGetResponseDataForksItemUser;
  url: string;
  id: string;
  created_at: string;
  updated_at: string;
};
type GistsGetResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetResponseDataFilesHelloWorldPythonTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetResponseDataFilesHelloWorldRubyTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetResponseDataFilesHelloWorldPy = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetResponseDataFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetResponseDataFiles = {
  "hello_world.rb": GistsGetResponseDataFilesHelloWorldRb;
  "hello_world.py": GistsGetResponseDataFilesHelloWorldPy;
  "hello_world_ruby.txt": GistsGetResponseDataFilesHelloWorldRubyTxt;
  "hello_world_python.txt": GistsGetResponseDataFilesHelloWorldPythonTxt;
};
type GistsGetResponseData = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsGetResponseDataFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsGetResponseDataOwner;
  truncated: boolean;
  forks: Array<GistsGetResponseDataForksItem>;
  history: Array<GistsGetResponseDataHistoryItem>;
};

type GistsUpdateEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * A descriptive name for this gist.
   */
  description?: string;
  /**
   * The filenames and content that make up this gist.
   */
  files?: GistsUpdateParamsFiles;
};

type GistsUpdateRequestOptions = {
  method: "PATCH";
  url: "/gists/:gist_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsUpdateResponseDataHistoryItemChangeStatus = {
  deletions: number;
  additions: number;
  total: number;
};
type GistsUpdateResponseDataHistoryItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsUpdateResponseDataHistoryItem = {
  url: string;
  version: string;
  user: GistsUpdateResponseDataHistoryItemUser;
  change_status: GistsUpdateResponseDataHistoryItemChangeStatus;
  committed_at: string;
};
type GistsUpdateResponseDataForksItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsUpdateResponseDataForksItem = {
  user: GistsUpdateResponseDataForksItemUser;
  url: string;
  id: string;
  created_at: string;
  updated_at: string;
};
type GistsUpdateResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsUpdateResponseDataFilesNewFileTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsUpdateResponseDataFilesHelloWorldMd = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsUpdateResponseDataFilesHelloWorldPy = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsUpdateResponseDataFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsUpdateResponseDataFiles = {
  "hello_world.rb": GistsUpdateResponseDataFilesHelloWorldRb;
  "hello_world.py": GistsUpdateResponseDataFilesHelloWorldPy;
  "hello_world.md": GistsUpdateResponseDataFilesHelloWorldMd;
  "new_file.txt": GistsUpdateResponseDataFilesNewFileTxt;
};
type GistsUpdateResponseData = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsUpdateResponseDataFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsUpdateResponseDataOwner;
  truncated: boolean;
  forks: Array<GistsUpdateResponseDataForksItem>;
  history: Array<GistsUpdateResponseDataHistoryItem>;
};

type GistsDeleteEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};

type GistsDeleteRequestOptions = {
  method: "DELETE";
  url: "/gists/:gist_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type GistsListCommentsEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GistsListCommentsRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListCommentsResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsListCommentsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  body: string;
  user: GistsListCommentsResponseDataItemUser;
  created_at: string;
  updated_at: string;
};
type GistsListCommentsResponseData = Array<GistsListCommentsResponseDataItem>;

type GistsCreateCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * The comment text.
   */
  body: string;
};

type GistsCreateCommentRequestOptions = {
  method: "POST";
  url: "/gists/:gist_id/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsCreateCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsCreateCommentResponseData = {
  id: number;
  node_id: string;
  url: string;
  body: string;
  user: GistsCreateCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type GistsGetCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type GistsGetCommentRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsGetCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetCommentResponseData = {
  id: number;
  node_id: string;
  url: string;
  body: string;
  user: GistsGetCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type GistsUpdateCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The comment text.
   */
  body: string;
};

type GistsUpdateCommentRequestOptions = {
  method: "PATCH";
  url: "/gists/:gist_id/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsUpdateCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsUpdateCommentResponseData = {
  id: number;
  node_id: string;
  url: string;
  body: string;
  user: GistsUpdateCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type GistsDeleteCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type GistsDeleteCommentRequestOptions = {
  method: "DELETE";
  url: "/gists/:gist_id/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type GistsListCommitsEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GistsListCommitsRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id/commits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListCommitsResponseDataItemChangeStatus = {
  deletions: number;
  additions: number;
  total: number;
};
type GistsListCommitsResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsListCommitsResponseDataItem = {
  url: string;
  version: string;
  user: GistsListCommitsResponseDataItemUser;
  change_status: GistsListCommitsResponseDataItemChangeStatus;
  committed_at: string;
};
type GistsListCommitsResponseData = Array<GistsListCommitsResponseDataItem>;

type GistsForkEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};

type GistsForkRequestOptions = {
  method: "POST";
  url: "/gists/:gist_id/forks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsForkResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsForkResponseDataFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
};
type GistsForkResponseDataFiles = {
  "hello_world.rb": GistsForkResponseDataFilesHelloWorldRb;
};
type GistsForkResponseData = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsForkResponseDataFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsForkResponseDataOwner;
  truncated: boolean;
};

type GistsListForksEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GistsListForksRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id/forks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListForksResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsListForksResponseDataItem = {
  user: GistsListForksResponseDataItemUser;
  url: string;
  id: string;
  created_at: string;
  updated_at: string;
};
type GistsListForksResponseData = Array<GistsListForksResponseDataItem>;

type GistsStarEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};

type GistsStarRequestOptions = {
  method: "PUT";
  url: "/gists/:gist_id/star";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type GistsUnstarEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};

type GistsUnstarRequestOptions = {
  method: "DELETE";
  url: "/gists/:gist_id/star";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type GistsCheckIsStarredEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};

type GistsCheckIsStarredRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id/star";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type GistsGetRevisionEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * sha parameter
   */
  sha: string;
};

type GistsGetRevisionRequestOptions = {
  method: "GET";
  url: "/gists/:gist_id/:sha";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsGetRevisionResponseDataHistoryItemChangeStatus = {
  deletions: number;
  additions: number;
  total: number;
};
type GistsGetRevisionResponseDataHistoryItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetRevisionResponseDataHistoryItem = {
  url: string;
  version: string;
  user: GistsGetRevisionResponseDataHistoryItemUser;
  change_status: GistsGetRevisionResponseDataHistoryItemChangeStatus;
  committed_at: string;
};
type GistsGetRevisionResponseDataForksItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetRevisionResponseDataForksItem = {
  user: GistsGetRevisionResponseDataForksItemUser;
  url: string;
  id: string;
  created_at: string;
  updated_at: string;
};
type GistsGetRevisionResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type GistsGetRevisionResponseDataFilesHelloWorldPythonTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetRevisionResponseDataFilesHelloWorldRubyTxt = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetRevisionResponseDataFilesHelloWorldPy = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetRevisionResponseDataFilesHelloWorldRb = {
  filename: string;
  type: string;
  language: string;
  raw_url: string;
  size: number;
  truncated: boolean;
  content: string;
};
type GistsGetRevisionResponseDataFiles = {
  "hello_world.rb": GistsGetRevisionResponseDataFilesHelloWorldRb;
  "hello_world.py": GistsGetRevisionResponseDataFilesHelloWorldPy;
  "hello_world_ruby.txt": GistsGetRevisionResponseDataFilesHelloWorldRubyTxt;
  "hello_world_python.txt": GistsGetRevisionResponseDataFilesHelloWorldPythonTxt;
};
type GistsGetRevisionResponseData = {
  url: string;
  forks_url: string;
  commits_url: string;
  id: string;
  node_id: string;
  git_pull_url: string;
  git_push_url: string;
  html_url: string;
  files: GistsGetRevisionResponseDataFiles;
  public: boolean;
  created_at: string;
  updated_at: string;
  description: string;
  comments: number;
  user: null;
  comments_url: string;
  owner: GistsGetRevisionResponseDataOwner;
  truncated: boolean;
  forks: Array<GistsGetRevisionResponseDataForksItem>;
  history: Array<GistsGetRevisionResponseDataHistoryItem>;
};

type GitignoreListTemplatesEndpoint = {};

type GitignoreListTemplatesRequestOptions = {
  method: "GET";
  url: "/gitignore/templates";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitignoreListTemplatesResponseData = Array<string>;

type GitignoreGetTemplateEndpoint = {
  /**
   * name parameter
   */
  name: string;
};

type GitignoreGetTemplateRequestOptions = {
  method: "GET";
  url: "/gitignore/templates/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitignoreGetTemplateResponseData = { name: string; source: string };

type AppsListReposEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"machine-man">;

type AppsListReposRequestOptions = {
  method: "GET";
  url: "/installation/repositories";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListReposResponseDataRepositoriesItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsListReposResponseDataRepositoriesItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: AppsListReposResponseDataRepositoriesItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type AppsListReposResponseData = {
  total_count: number;
  repositories: Array<AppsListReposResponseDataRepositoriesItem>;
};

type AppsRevokeInstallationTokenEndpoint = {};

type AppsRevokeInstallationTokenRequestOptions = {
  method: "DELETE";
  url: "/installation/token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesListEndpoint = {
  /**
   * Indicates which sorts of issues to return. Can be one of:
   * \* `assigned`: Issues assigned to you
   * \* `created`: Issues created by you
   * \* `mentioned`: Issues mentioning you
   * \* `subscribed`: Issues you're subscribed to updates for
   * \* `all`: All issues the authenticated user can see, regardless of participation or creation
   */
  filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListRequestOptions = {
  method: "GET";
  url: "/issues";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListResponseDataItemRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type IssuesListResponseDataItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListResponseDataItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: IssuesListResponseDataItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: IssuesListResponseDataItemRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type IssuesListResponseDataItemPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesListResponseDataItemMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListResponseDataItemMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesListResponseDataItemMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesListResponseDataItemAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListResponseDataItemAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListResponseDataItemLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesListResponseDataItemUser;
  labels: Array<IssuesListResponseDataItemLabelsItem>;
  assignee: IssuesListResponseDataItemAssignee;
  assignees: Array<IssuesListResponseDataItemAssigneesItem>;
  milestone: IssuesListResponseDataItemMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesListResponseDataItemPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
  repository: IssuesListResponseDataItemRepository;
};
type IssuesListResponseData = Array<IssuesListResponseDataItem>;

type SearchIssuesLegacyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repository parameter
   */
  repository: string;
  /**
   * Indicates the state of the issues to return. Can be either `open` or `closed`.
   */
  state: "open" | "closed";
  /**
   * The search term.
   */
  keyword: string;
};

type SearchIssuesLegacyRequestOptions = {
  method: "GET";
  url: "/legacy/issues/search/:owner/:repository/:state/:keyword";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchIssuesLegacyResponseDataIssuesItem = {
  gravatar_id: string;
  position: number;
  number: number;
  votes: number;
  created_at: string;
  comments: number;
  body: string;
  title: string;
  updated_at: string;
  html_url: string;
  user: string;
  labels: Array<string>;
  state: string;
};
type SearchIssuesLegacyResponseData = {
  issues: Array<SearchIssuesLegacyResponseDataIssuesItem>;
};

type SearchReposLegacyEndpoint = {
  /**
   * The search term.
   */
  keyword: string;
  /**
   * Filter results by language.
   */
  language?: string;
  /**
   * The page number to fetch.
   */
  start_page?: string;
  /**
   * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
   */
  sort?: "stars" | "forks" | "updated";
  /**
   * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
   */
  order?: "asc" | "desc";
};

type SearchReposLegacyRequestOptions = {
  method: "GET";
  url: "/legacy/repos/search/:keyword";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchReposLegacyResponseDataRepositoriesItem = {
  type: string;
  created: string;
  watchers: number;
  has_downloads: boolean;
  username: string;
  homepage: string;
  url: string;
  fork: boolean;
  has_issues: boolean;
  has_wiki: boolean;
  forks: number;
  size: number;
  private: boolean;
  followers: number;
  name: string;
  owner: string;
  open_issues: number;
  pushed_at: string;
  score: number;
  pushed: string;
  description: string;
  language: string;
  created_at: string;
};
type SearchReposLegacyResponseData = {
  repositories: Array<SearchReposLegacyResponseDataRepositoriesItem>;
};

type SearchEmailLegacyEndpoint = {
  /**
   * The email address.
   */
  email: string;
};

type SearchEmailLegacyRequestOptions = {
  method: "GET";
  url: "/legacy/user/email/:email";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchEmailLegacyResponseDataUser = {
  public_repo_count: number;
  public_gist_count: number;
  followers_count: number;
  following_count: number;
  created: string;
  created_at: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  id: number;
  login: string;
  type: string;
  gravatar_id: string;
};
type SearchEmailLegacyResponseData = {
  user: SearchEmailLegacyResponseDataUser;
};

type SearchUsersLegacyEndpoint = {
  /**
   * The search term.
   */
  keyword: string;
  /**
   * The page number to fetch.
   */
  start_page?: string;
  /**
   * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
   */
  sort?: "stars" | "forks" | "updated";
  /**
   * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
   */
  order?: "asc" | "desc";
};

type SearchUsersLegacyRequestOptions = {
  method: "GET";
  url: "/legacy/user/search/:keyword";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchUsersLegacyResponseDataUsersItem = {
  gravatar_id: string;
  name: string;
  created_at: string;
  location: string;
  public_repo_count: number;
  followers: number;
  language: string;
  fullname: string;
  username: string;
  id: string;
  repos: number;
  type: string;
  followers_count: number;
  login: string;
  score: number;
  created: string;
};
type SearchUsersLegacyResponseData = {
  users: Array<SearchUsersLegacyResponseDataUsersItem>;
};

type LicensesListCommonlyUsedEndpoint = {};

type LicensesListCommonlyUsedRequestOptions = {
  method: "GET";
  url: "/licenses";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesListCommonlyUsedResponseDataItem = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id?: string;
};
type LicensesListCommonlyUsedResponseData = Array<
  LicensesListCommonlyUsedResponseDataItem
>;

type LicensesGetEndpoint = {
  /**
   * license parameter
   */
  license: string;
};

type LicensesGetRequestOptions = {
  method: "GET";
  url: "/licenses/:license";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesGetResponseData = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
  html_url: string;
  description: string;
  implementation: string;
  permissions: Array<string>;
  conditions: Array<string>;
  limitations: Array<string>;
  body: string;
  featured: boolean;
};

type MarkdownRenderEndpoint = {
  /**
   * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
   */
  text: string;
  /**
   * The rendering mode. Can be either:
   * \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.
   * \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
   */
  mode?: "markdown" | "gfm";
  /**
   * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
   */
  context?: string;
};

type MarkdownRenderRequestOptions = {
  method: "POST";
  url: "/markdown";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MarkdownRenderRawEndpoint = {
  /**
   * data parameter
   */
  data: string;
} & { headers: { "content-type": "text/plain; charset=utf-8" } };
type MarkdownRenderRawRequestOptions = {
  method: "POST";
  url: "/markdown/raw";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsGetSubscriptionPlanForAccountEndpoint = {
  /**
   * account_id parameter
   */
  account_id: number;
};

type AppsGetSubscriptionPlanForAccountRequestOptions = {
  method: "GET";
  url: "/marketplace_listing/accounts/:account_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchasePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  unit_name: null;
  state: string;
  bullets: Array<string>;
};
type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchase = {
  billing_cycle: string;
  next_billing_date: string;
  unit_count: null;
  on_free_trial: boolean;
  free_trial_ends_on: string;
  updated_at: string;
  plan: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchasePlan;
};
type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChangePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  state: string;
  unit_name: null;
  bullets: Array<string>;
};
type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChange = {
  effective_date: string;
  unit_count: null;
  id: number;
  plan: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChangePlan;
};
type AppsGetSubscriptionPlanForAccountResponseData = {
  url: string;
  type: string;
  id: number;
  login: string;
  email: null;
  organization_billing_email: string;
  marketplace_pending_change: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChange;
  marketplace_purchase: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchase;
};

type AppsListPlansEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type AppsListPlansRequestOptions = {
  method: "GET";
  url: "/marketplace_listing/plans";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListPlansResponseDataItem = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  unit_name: null;
  state: string;
  bullets: Array<string>;
};
type AppsListPlansResponseData = Array<AppsListPlansResponseDataItem>;

type AppsListAccountsForPlanEndpoint = {
  /**
   * plan_id parameter
   */
  plan_id: number;
  /**
   * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
   */
  sort?: "created" | "updated";
  /**
   * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type AppsListAccountsForPlanRequestOptions = {
  method: "GET";
  url: "/marketplace_listing/plans/:plan_id/accounts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListAccountsForPlanResponseDataItemMarketplacePurchasePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  unit_name: null;
  state: string;
  bullets: Array<string>;
};
type AppsListAccountsForPlanResponseDataItemMarketplacePurchase = {
  billing_cycle: string;
  next_billing_date: string;
  unit_count: null;
  on_free_trial: boolean;
  free_trial_ends_on: string;
  updated_at: string;
  plan: AppsListAccountsForPlanResponseDataItemMarketplacePurchasePlan;
};
type AppsListAccountsForPlanResponseDataItemMarketplacePendingChangePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  state: string;
  unit_name: null;
  bullets: Array<string>;
};
type AppsListAccountsForPlanResponseDataItemMarketplacePendingChange = {
  effective_date: string;
  unit_count: null;
  id: number;
  plan: AppsListAccountsForPlanResponseDataItemMarketplacePendingChangePlan;
};
type AppsListAccountsForPlanResponseDataItem = {
  url: string;
  type: string;
  id: number;
  login: string;
  email: null;
  organization_billing_email: string;
  marketplace_pending_change: AppsListAccountsForPlanResponseDataItemMarketplacePendingChange;
  marketplace_purchase: AppsListAccountsForPlanResponseDataItemMarketplacePurchase;
};
type AppsListAccountsForPlanResponseData = Array<
  AppsListAccountsForPlanResponseDataItem
>;

type AppsGetSubscriptionPlanForAccountStubbedEndpoint = {
  /**
   * account_id parameter
   */
  account_id: number;
};

type AppsGetSubscriptionPlanForAccountStubbedRequestOptions = {
  method: "GET";
  url: "/marketplace_listing/stubbed/accounts/:account_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchasePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  unit_name: null;
  state: string;
  bullets: Array<string>;
};
type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchase = {
  billing_cycle: string;
  next_billing_date: string;
  unit_count: null;
  on_free_trial: boolean;
  free_trial_ends_on: string;
  updated_at: string;
  plan: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchasePlan;
};
type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChangePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  state: string;
  unit_name: null;
  bullets: Array<string>;
};
type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChange = {
  effective_date: string;
  unit_count: null;
  id: number;
  plan: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChangePlan;
};
type AppsGetSubscriptionPlanForAccountStubbedResponseData = {
  url: string;
  type: string;
  id: number;
  login: string;
  email: null;
  organization_billing_email: string;
  marketplace_pending_change: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChange;
  marketplace_purchase: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchase;
};

type AppsListPlansStubbedEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type AppsListPlansStubbedRequestOptions = {
  method: "GET";
  url: "/marketplace_listing/stubbed/plans";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListPlansStubbedResponseDataItem = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  unit_name: null;
  state: string;
  bullets: Array<string>;
};
type AppsListPlansStubbedResponseData = Array<
  AppsListPlansStubbedResponseDataItem
>;

type AppsListAccountsForPlanStubbedEndpoint = {
  /**
   * plan_id parameter
   */
  plan_id: number;
  /**
   * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
   */
  sort?: "created" | "updated";
  /**
   * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type AppsListAccountsForPlanStubbedRequestOptions = {
  method: "GET";
  url: "/marketplace_listing/stubbed/plans/:plan_id/accounts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchasePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  unit_name: null;
  state: string;
  bullets: Array<string>;
};
type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchase = {
  billing_cycle: string;
  next_billing_date: string;
  unit_count: null;
  on_free_trial: boolean;
  free_trial_ends_on: string;
  updated_at: string;
  plan: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchasePlan;
};
type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChangePlan = {
  url: string;
  accounts_url: string;
  id: number;
  number: number;
  name: string;
  description: string;
  monthly_price_in_cents: number;
  yearly_price_in_cents: number;
  price_model: string;
  has_free_trial: boolean;
  state: string;
  unit_name: null;
  bullets: Array<string>;
};
type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChange = {
  effective_date: string;
  unit_count: null;
  id: number;
  plan: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChangePlan;
};
type AppsListAccountsForPlanStubbedResponseDataItem = {
  url: string;
  type: string;
  id: number;
  login: string;
  email: null;
  organization_billing_email: string;
  marketplace_pending_change: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChange;
  marketplace_purchase: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchase;
};
type AppsListAccountsForPlanStubbedResponseData = Array<
  AppsListAccountsForPlanStubbedResponseDataItem
>;

type MetaGetEndpoint = {};

type MetaGetRequestOptions = {
  method: "GET";
  url: "/meta";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MetaGetResponseDataSshKeyFingerprints = {
  MD5_RSA: string;
  MD5_DSA: string;
  SHA256_RSA: string;
  SHA256_DSA: string;
};
type MetaGetResponseData = {
  verifiable_password_authentication: boolean;
  ssh_key_fingerprints: MetaGetResponseDataSshKeyFingerprints;
  hooks: Array<string>;
  web: Array<string>;
  api: Array<string>;
  git: Array<string>;
  pages: Array<string>;
  importer: Array<string>;
};

type ActivityListPublicEventsForRepoNetworkEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListPublicEventsForRepoNetworkRequestOptions = {
  method: "GET";
  url: "/networks/:owner/:repo/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityListNotificationsForAuthenticatedUserEndpoint = {
  /**
   * If `true`, show notifications marked as read.
   */
  all?: boolean;
  /**
   * If `true`, only shows notifications in which the user is directly participating or mentioned.
   */
  participating?: boolean;
  /**
   * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  before?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListNotificationsForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: "/notifications";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListNotificationsForAuthenticatedUserResponseDataItemSubject = {
  title: string;
  url: string;
  latest_comment_url: string;
  type: string;
};
type ActivityListNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActivityListNotificationsForAuthenticatedUserResponseDataItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ActivityListNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ActivityListNotificationsForAuthenticatedUserResponseDataItem = {
  id: string;
  repository: ActivityListNotificationsForAuthenticatedUserResponseDataItemRepository;
  subject: ActivityListNotificationsForAuthenticatedUserResponseDataItemSubject;
  reason: string;
  unread: boolean;
  updated_at: string;
  last_read_at: string;
  url: string;
};
type ActivityListNotificationsForAuthenticatedUserResponseData = Array<
  ActivityListNotificationsForAuthenticatedUserResponseDataItem
>;

type ActivityMarkNotificationsAsReadEndpoint = {
  /**
   * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
   */
  last_read_at?: string;
};

type ActivityMarkNotificationsAsReadRequestOptions = {
  method: "PUT";
  url: "/notifications";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityGetThreadEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};

type ActivityGetThreadRequestOptions = {
  method: "GET";
  url: "/notifications/threads/:thread_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetThreadResponseDataSubject = {
  title: string;
  url: string;
  latest_comment_url: string;
  type: string;
};
type ActivityGetThreadResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActivityGetThreadResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ActivityGetThreadResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ActivityGetThreadResponseData = {
  id: string;
  repository: ActivityGetThreadResponseDataRepository;
  subject: ActivityGetThreadResponseDataSubject;
  reason: string;
  unread: boolean;
  updated_at: string;
  last_read_at: string;
  url: string;
};

type ActivityMarkThreadAsReadEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};

type ActivityMarkThreadAsReadRequestOptions = {
  method: "PATCH";
  url: "/notifications/threads/:thread_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityGetThreadSubscriptionForAuthenticatedUserEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};

type ActivityGetThreadSubscriptionForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: "/notifications/threads/:thread_id/subscription";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetThreadSubscriptionForAuthenticatedUserResponseData = {
  subscribed: boolean;
  ignored: boolean;
  reason: null;
  created_at: string;
  url: string;
  thread_url: string;
};

type ActivitySetThreadSubscriptionEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
  /**
   * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
   */
  ignored?: boolean;
};

type ActivitySetThreadSubscriptionRequestOptions = {
  method: "PUT";
  url: "/notifications/threads/:thread_id/subscription";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivitySetThreadSubscriptionResponseData = {
  subscribed: boolean;
  ignored: boolean;
  reason: null;
  created_at: string;
  url: string;
  thread_url: string;
};

type ActivityDeleteThreadSubscriptionEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};

type ActivityDeleteThreadSubscriptionRequestOptions = {
  method: "DELETE";
  url: "/notifications/threads/:thread_id/subscription";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsListEndpoint = {
  /**
   * The integer ID of the last organization that you've seen.
   */
  since?: number;
};

type OrgsListRequestOptions = {
  method: "GET";
  url: "/organizations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type OrgsListResponseData = Array<OrgsListResponseDataItem>;

type OrgsGetEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type OrgsGetRequestOptions = {
  method: "GET";
  url: "/orgs/:org";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetResponseDataPlan = {
  name: string;
  space: number;
  private_repos: number;
  filled_seats?: number;
  seats?: number;
};
type OrgsGetResponseData = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
  total_private_repos?: number;
  owned_private_repos?: number;
  private_gists?: number;
  disk_usage?: number;
  collaborators?: number;
  billing_email?: string;
  plan: OrgsGetResponseDataPlan;
  default_repository_permission?: string;
  members_can_create_repositories?: boolean;
  two_factor_requirement_enabled?: boolean;
  members_allowed_repository_creation_type?: string;
  members_can_create_public_repositories?: boolean;
  members_can_create_private_repositories?: boolean;
  members_can_create_internal_repositories?: boolean;
};

type OrgsUpdateEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Billing email address. This address is not publicized.
   */
  billing_email?: string;
  /**
   * The company name.
   */
  company?: string;
  /**
   * The publicly visible email address.
   */
  email?: string;
  /**
   * The location.
   */
  location?: string;
  /**
   * The shorthand name of the company.
   */
  name?: string;
  /**
   * The description of the company.
   */
  description?: string;
  /**
   * Toggles whether an organization can use organization projects.
   */
  has_organization_projects?: boolean;
  /**
   * Toggles whether repositories that belong to the organization can use repository projects.
   */
  has_repository_projects?: boolean;
  /**
   * Default permission level members have for organization repositories:
   * \* `read` - can pull, but not push to or administer this repository.
   * \* `write` - can pull and push, but not administer this repository.
   * \* `admin` - can pull, push, and administer this repository.
   * \* `none` - no permissions granted by default.
   */
  default_repository_permission?: "read" | "write" | "admin" | "none";
  /**
   * Toggles the ability of non-admin organization members to create repositories. Can be one of:
   * \* `true` - all organization members can create repositories.
   * \* `false` - only organization owners can create repositories.
   * Default: `true`
   * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
   */
  members_can_create_repositories?: boolean;
  /**
   * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. Can be one of:
   * \* `true` - all organization members can create internal repositories.
   * \* `false` - only organization owners can create internal repositories.
   * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
   */
  members_can_create_internal_repositories?: boolean;
  /**
   * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
   * \* `true` - all organization members can create private repositories.
   * \* `false` - only organization owners can create private repositories.
   * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
   */
  members_can_create_private_repositories?: boolean;
  /**
   * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
   * \* `true` - all organization members can create public repositories.
   * \* `false` - only organization owners can create public repositories.
   * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
   */
  members_can_create_public_repositories?: boolean;
  /**
   * Specifies which types of repositories non-admin organization members can create. Can be one of:
   * \* `all` - all organization members can create public and private repositories.
   * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
   * \* `none` - only admin members can create repositories.
   * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See [this note](https://developer.github.com/v3/orgs/#members_can_create_repositories) for details.
   */
  members_allowed_repository_creation_type?: "all" | "private" | "none";
};

type OrgsUpdateRequestOptions = {
  method: "PATCH";
  url: "/orgs/:org";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsUpdateResponseDataPlan = {
  name: string;
  space: number;
  private_repos: number;
};
type OrgsUpdateResponseData = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
  total_private_repos: number;
  owned_private_repos: number;
  private_gists: number;
  disk_usage: number;
  collaborators: number;
  billing_email: string;
  plan: OrgsUpdateResponseDataPlan;
  default_repository_permission: string;
  members_can_create_repositories: boolean;
  two_factor_requirement_enabled: boolean;
  members_allowed_repository_creation_type: string;
  members_can_create_public_repositories: boolean;
  members_can_create_private_repositories: boolean;
  members_can_create_internal_repositories: boolean;
};

type ActionsListSelfHostedRunnersForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListSelfHostedRunnersForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/actions/runners";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListSelfHostedRunnersForOrgResponseDataRunnersItem = {
  id: number;
  name: string;
  os: string;
  status: string;
};
type ActionsListSelfHostedRunnersForOrgResponseData = {
  total_count: number;
  runners: Array<ActionsListSelfHostedRunnersForOrgResponseDataRunnersItem>;
};

type ActionsListRunnerApplicationsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type ActionsListRunnerApplicationsForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/actions/runners/downloads";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListRunnerApplicationsForOrgResponseDataItem = {
  os: string;
  architecture: string;
  download_url: string;
  filename: string;
};
type ActionsListRunnerApplicationsForOrgResponseData = Array<
  ActionsListRunnerApplicationsForOrgResponseDataItem
>;

type ActionsCreateRegistrationTokenForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type ActionsCreateRegistrationTokenForOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/actions/runners/registration-token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsCreateRegistrationTokenForOrgResponseData = {
  token: string;
  expires_at: string;
};

type ActionsCreateRemoveTokenForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type ActionsCreateRemoveTokenForOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/actions/runners/remove-token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsCreateRemoveTokenForOrgResponseData = {
  token: string;
  expires_at: string;
};

type ActionsGetSelfHostedRunnerForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * runner_id parameter
   */
  runner_id: number;
};

type ActionsGetSelfHostedRunnerForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/actions/runners/:runner_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetSelfHostedRunnerForOrgResponseData = {
  id: number;
  name: string;
  os: string;
  status: string;
};

type ActionsDeleteSelfHostedRunnerFromOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * runner_id parameter
   */
  runner_id: number;
};

type ActionsDeleteSelfHostedRunnerFromOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/actions/runners/:runner_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsListBlockedUsersEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type OrgsListBlockedUsersRequestOptions = {
  method: "GET";
  url: "/orgs/:org/blocks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListBlockedUsersResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsListBlockedUsersResponseData = Array<
  OrgsListBlockedUsersResponseDataItem
>;

type OrgsCheckBlockedUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsCheckBlockedUserRequestOptions = {
  method: "GET";
  url: "/orgs/:org/blocks/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsBlockUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsBlockUserRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/blocks/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsUnblockUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsUnblockUserRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/blocks/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsListCredentialAuthorizationsEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type OrgsListCredentialAuthorizationsRequestOptions = {
  method: "GET";
  url: "/orgs/:org/credential-authorizations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListCredentialAuthorizationsResponseDataItem = {
  login: string;
  credential_id: string;
  credential_type: string;
  token_last_eight: string;
  credential_authorized_at: string;
  scopes: Array<string>;
};
type OrgsListCredentialAuthorizationsResponseData = Array<
  OrgsListCredentialAuthorizationsResponseDataItem
>;

type OrgsRemoveCredentialAuthorizationEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * credential_id parameter
   */
  credential_id: number;
};

type OrgsRemoveCredentialAuthorizationRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/credential-authorizations/:credential_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityListPublicOrgEventsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListPublicOrgEventsRequestOptions = {
  method: "GET";
  url: "/orgs/:org/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsListHooksEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OrgsListHooksRequestOptions = {
  method: "GET";
  url: "/orgs/:org/hooks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListHooksResponseDataItemConfig = {
  url: string;
  content_type: string;
};
type OrgsListHooksResponseDataItem = {
  id: number;
  url: string;
  ping_url: string;
  name: string;
  events: Array<string>;
  active: boolean;
  config: OrgsListHooksResponseDataItemConfig;
  updated_at: string;
  created_at: string;
};
type OrgsListHooksResponseData = Array<OrgsListHooksResponseDataItem>;

type OrgsCreateHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Must be passed as "web".
   */
  name: string;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#create-hook-config-params).
   */
  config: OrgsCreateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
   */
  events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};

type OrgsCreateHookRequestOptions = {
  method: "POST";
  url: "/orgs/:org/hooks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCreateHookResponseDataConfig = { url: string; content_type: string };
type OrgsCreateHookResponseData = {
  id: number;
  url: string;
  ping_url: string;
  name: string;
  events: Array<string>;
  active: boolean;
  config: OrgsCreateHookResponseDataConfig;
  updated_at: string;
  created_at: string;
};

type OrgsGetHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type OrgsGetHookRequestOptions = {
  method: "GET";
  url: "/orgs/:org/hooks/:hook_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetHookResponseDataConfig = { url: string; content_type: string };
type OrgsGetHookResponseData = {
  id: number;
  url: string;
  ping_url: string;
  name: string;
  events: Array<string>;
  active: boolean;
  config: OrgsGetHookResponseDataConfig;
  updated_at: string;
  created_at: string;
};

type OrgsUpdateHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#update-hook-config-params).
   */
  config?: OrgsUpdateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
   */
  events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};

type OrgsUpdateHookRequestOptions = {
  method: "PATCH";
  url: "/orgs/:org/hooks/:hook_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsUpdateHookResponseDataConfig = { url: string; content_type: string };
type OrgsUpdateHookResponseData = {
  id: number;
  url: string;
  ping_url: string;
  name: string;
  events: Array<string>;
  active: boolean;
  config: OrgsUpdateHookResponseDataConfig;
  updated_at: string;
  created_at: string;
};

type OrgsDeleteHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type OrgsDeleteHookRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/hooks/:hook_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsPingHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type OrgsPingHookRequestOptions = {
  method: "POST";
  url: "/orgs/:org/hooks/:hook_id/pings";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type AppsGetOrgInstallationEndpoint = {
  /**
   * org parameter
   */
  org: string;
} & RequiredPreview<"machine-man">;

type AppsGetOrgInstallationRequestOptions = {
  method: "GET";
  url: "/orgs/:org/installation";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetOrgInstallationResponseDataPermissions = {
  checks: string;
  metadata: string;
  contents: string;
};
type AppsGetOrgInstallationResponseDataAccount = {
  login: string;
  id: number;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsGetOrgInstallationResponseData = {
  id: number;
  account: AppsGetOrgInstallationResponseDataAccount;
  repository_selection: string;
  access_tokens_url: string;
  repositories_url: string;
  html_url: string;
  app_id: number;
  target_id: number;
  target_type: string;
  permissions: AppsGetOrgInstallationResponseDataPermissions;
  events: Array<string>;
  created_at: string;
  updated_at: string;
  single_file_name: null;
};

type OrgsListInstallationsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"machine-man">;

type OrgsListInstallationsRequestOptions = {
  method: "GET";
  url: "/orgs/:org/installations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListInstallationsResponseDataInstallationsItemPermissions = {
  deployments: string;
  metadata: string;
  pull_requests: string;
  statuses: string;
};
type OrgsListInstallationsResponseDataInstallationsItemAccount = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsListInstallationsResponseDataInstallationsItem = {
  id: number;
  account: OrgsListInstallationsResponseDataInstallationsItemAccount;
  repository_selection: string;
  access_tokens_url: string;
  repositories_url: string;
  html_url: string;
  app_id: number;
  target_id: number;
  target_type: string;
  permissions: OrgsListInstallationsResponseDataInstallationsItemPermissions;
  events: Array<string>;
  created_at: string;
  updated_at: string;
  single_file_name: null;
};
type OrgsListInstallationsResponseData = {
  total_count: number;
  installations: Array<OrgsListInstallationsResponseDataInstallationsItem>;
};

type InteractionsGetRestrictionsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
} & RequiredPreview<"sombra">;

type InteractionsGetRestrictionsForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/interaction-limits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsGetRestrictionsForOrgResponseData = {
  limit: string;
  origin: string;
  expires_at: string;
};

type InteractionsAddOrUpdateRestrictionsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Specifies the group of GitHub users who can comment, open issues, or create pull requests in public repositories for the given organization. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
   */
  limit: "existing_users" | "contributors_only" | "collaborators_only";
} & RequiredPreview<"sombra">;

type InteractionsAddOrUpdateRestrictionsForOrgRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/interaction-limits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsAddOrUpdateRestrictionsForOrgResponseData = {
  limit: string;
  origin: string;
  expires_at: string;
};

type InteractionsRemoveRestrictionsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
} & RequiredPreview<"sombra">;

type InteractionsRemoveRestrictionsForOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/interaction-limits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsListPendingInvitationsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OrgsListPendingInvitationsRequestOptions = {
  method: "GET";
  url: "/orgs/:org/invitations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListPendingInvitationsResponseDataItemInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsListPendingInvitationsResponseDataItem = {
  id: number;
  login: string;
  email: string;
  role: string;
  created_at: string;
  inviter: OrgsListPendingInvitationsResponseDataItemInviter;
  team_count: number;
  invitation_team_url: string;
};
type OrgsListPendingInvitationsResponseData = Array<
  OrgsListPendingInvitationsResponseDataItem
>;

type OrgsCreateInvitationEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
   */
  invitee_id?: number;
  /**
   * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
   */
  email?: string;
  /**
   * Specify role for new member. Can be one of:
   * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
   * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
   * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
   */
  role?: "admin" | "direct_member" | "billing_manager";
  /**
   * Specify IDs for the teams you want to invite new members to.
   */
  team_ids?: number[];
};

type OrgsCreateInvitationRequestOptions = {
  method: "POST";
  url: "/orgs/:org/invitations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCreateInvitationResponseDataInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsCreateInvitationResponseData = {
  id: number;
  login: string;
  email: string;
  role: string;
  created_at: string;
  inviter: OrgsCreateInvitationResponseDataInviter;
  team_count: number;
  invitation_team_url: string;
};

type OrgsListInvitationTeamsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * invitation_id parameter
   */
  invitation_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OrgsListInvitationTeamsRequestOptions = {
  method: "GET";
  url: "/orgs/:org/invitations/:invitation_id/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListInvitationTeamsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type OrgsListInvitationTeamsResponseData = Array<
  OrgsListInvitationTeamsResponseDataItem
>;

type IssuesListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Indicates which sorts of issues to return. Can be one of:
   * \* `assigned`: Issues assigned to you
   * \* `created`: Issues created by you
   * \* `mentioned`: Issues mentioning you
   * \* `subscribed`: Issues you're subscribed to updates for
   * \* `all`: All issues the authenticated user can see, regardless of participation or creation
   */
  filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/issues";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListForOrgResponseDataItemRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type IssuesListForOrgResponseDataItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForOrgResponseDataItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: IssuesListForOrgResponseDataItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: IssuesListForOrgResponseDataItemRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type IssuesListForOrgResponseDataItemPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesListForOrgResponseDataItemMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForOrgResponseDataItemMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesListForOrgResponseDataItemMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesListForOrgResponseDataItemAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForOrgResponseDataItemAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForOrgResponseDataItemLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListForOrgResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForOrgResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesListForOrgResponseDataItemUser;
  labels: Array<IssuesListForOrgResponseDataItemLabelsItem>;
  assignee: IssuesListForOrgResponseDataItemAssignee;
  assignees: Array<IssuesListForOrgResponseDataItemAssigneesItem>;
  milestone: IssuesListForOrgResponseDataItemMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesListForOrgResponseDataItemPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
  repository: IssuesListForOrgResponseDataItemRepository;
};
type IssuesListForOrgResponseData = Array<IssuesListForOrgResponseDataItem>;

type OrgsListMembersEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Filter members returned in the list. Can be one of:
   * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
   * \* `all` - All members the authenticated user can see.
   */
  filter?: "2fa_disabled" | "all";
  /**
   * Filter members returned by their role. Can be one of:
   * \* `all` - All members of the organization, regardless of role.
   * \* `admin` - Organization owners.
   * \* `member` - Non-owner organization members.
   */
  role?: "all" | "admin" | "member";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OrgsListMembersRequestOptions = {
  method: "GET";
  url: "/orgs/:org/members";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListMembersResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsListMembersResponseData = Array<OrgsListMembersResponseDataItem>;

type OrgsCheckMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsCheckMembershipRequestOptions = {
  method: "GET";
  url: "/orgs/:org/members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsRemoveMemberEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsRemoveMemberRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsGetMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsGetMembershipRequestOptions = {
  method: "GET";
  url: "/orgs/:org/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetMembershipResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsGetMembershipResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type OrgsGetMembershipResponseData = {
  url: string;
  state: string;
  role: string;
  organization_url: string;
  organization: OrgsGetMembershipResponseDataOrganization;
  user: OrgsGetMembershipResponseDataUser;
};

type OrgsAddOrUpdateMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role to give the user in the organization. Can be one of:
   * \* `admin` - The user will become an owner of the organization.
   * \* `member` - The user will become a non-owner member of the organization.
   */
  role?: "admin" | "member";
};

type OrgsAddOrUpdateMembershipRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsAddOrUpdateMembershipResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsAddOrUpdateMembershipResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type OrgsAddOrUpdateMembershipResponseData = {
  url: string;
  state: string;
  role: string;
  organization_url: string;
  organization: OrgsAddOrUpdateMembershipResponseDataOrganization;
  user: OrgsAddOrUpdateMembershipResponseDataUser;
};

type OrgsRemoveMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsRemoveMembershipRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MigrationsStartForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * A list of arrays indicating which repositories should be migrated.
   */
  repositories: string[];
  /**
   * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
   */
  lock_repositories?: boolean;
  /**
   * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
   */
  exclude_attachments?: boolean;
};

type MigrationsStartForOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/migrations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsStartForOrgResponseDataRepositoriesItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type MigrationsStartForOrgResponseDataRepositoriesItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type MigrationsStartForOrgResponseDataRepositoriesItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: MigrationsStartForOrgResponseDataRepositoriesItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: MigrationsStartForOrgResponseDataRepositoriesItemPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type MigrationsStartForOrgResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type MigrationsStartForOrgResponseData = {
  id: number;
  owner: MigrationsStartForOrgResponseDataOwner;
  guid: string;
  state: string;
  lock_repositories: boolean;
  exclude_attachments: boolean;
  repositories: Array<MigrationsStartForOrgResponseDataRepositoriesItem>;
  url: string;
  created_at: string;
  updated_at: string;
};

type MigrationsListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"wyandotte">;

type MigrationsListForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/migrations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsListForOrgResponseDataItemRepositoriesItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type MigrationsListForOrgResponseDataItemRepositoriesItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type MigrationsListForOrgResponseDataItemRepositoriesItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: MigrationsListForOrgResponseDataItemRepositoriesItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: MigrationsListForOrgResponseDataItemRepositoriesItemPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type MigrationsListForOrgResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type MigrationsListForOrgResponseDataItem = {
  id: number;
  owner: MigrationsListForOrgResponseDataItemOwner;
  guid: string;
  state: string;
  lock_repositories: boolean;
  exclude_attachments: boolean;
  repositories: Array<MigrationsListForOrgResponseDataItemRepositoriesItem>;
  url: string;
  created_at: string;
  updated_at: string;
};
type MigrationsListForOrgResponseData = Array<
  MigrationsListForOrgResponseDataItem
>;

type MigrationsGetStatusForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
} & RequiredPreview<"wyandotte">;

type MigrationsGetStatusForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/migrations/:migration_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetStatusForOrgResponseDataRepositoriesItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type MigrationsGetStatusForOrgResponseDataRepositoriesItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type MigrationsGetStatusForOrgResponseDataRepositoriesItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: MigrationsGetStatusForOrgResponseDataRepositoriesItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: MigrationsGetStatusForOrgResponseDataRepositoriesItemPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type MigrationsGetStatusForOrgResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type MigrationsGetStatusForOrgResponseData = {
  id: number;
  owner: MigrationsGetStatusForOrgResponseDataOwner;
  guid: string;
  state: string;
  lock_repositories: boolean;
  exclude_attachments: boolean;
  repositories: Array<MigrationsGetStatusForOrgResponseDataRepositoriesItem>;
  url: string;
  created_at: string;
  updated_at: string;
};

type MigrationsDownloadArchiveForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
} & RequiredPreview<"wyandotte">;

type MigrationsDownloadArchiveForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/migrations/:migration_id/archive";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MigrationsDeleteArchiveForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
} & RequiredPreview<"wyandotte">;

type MigrationsDeleteArchiveForOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/migrations/:migration_id/archive";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MigrationsUnlockRepoForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
  /**
   * repo_name parameter
   */
  repo_name: string;
} & RequiredPreview<"wyandotte">;

type MigrationsUnlockRepoForOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/migrations/:migration_id/repos/:repo_name/lock";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MigrationsListReposForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"wyandotte">;

type MigrationsListReposForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/migrations/:migration_id/repositories";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsListReposForOrgResponseDataItemLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type MigrationsListReposForOrgResponseDataItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type MigrationsListReposForOrgResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type MigrationsListReposForOrgResponseDataItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: MigrationsListReposForOrgResponseDataItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: MigrationsListReposForOrgResponseDataItemPermissions;
  template_repository: null;
  temp_clone_token: string;
  subscribers_count: number;
  network_count: number;
  license: MigrationsListReposForOrgResponseDataItemLicense;
};
type MigrationsListReposForOrgResponseData = Array<
  MigrationsListReposForOrgResponseDataItem
>;

type OrgsListOutsideCollaboratorsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Filter the list of outside collaborators. Can be one of:
   * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
   * \* `all`: All outside collaborators.
   */
  filter?: "2fa_disabled" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OrgsListOutsideCollaboratorsRequestOptions = {
  method: "GET";
  url: "/orgs/:org/outside_collaborators";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListOutsideCollaboratorsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsListOutsideCollaboratorsResponseData = Array<
  OrgsListOutsideCollaboratorsResponseDataItem
>;

type OrgsRemoveOutsideCollaboratorEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsRemoveOutsideCollaboratorRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/outside_collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsRemoveOutsideCollaboratorResponseData = {
  message: string;
  documentation_url: string;
};

type OrgsConvertMemberToOutsideCollaboratorEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsConvertMemberToOutsideCollaboratorRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/outside_collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsConvertMemberToOutsideCollaboratorResponseData = {
  message: string;
  documentation_url: string;
};

type ProjectsListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type ProjectsListForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/projects";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListForOrgResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsListForOrgResponseDataItem = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: ProjectsListForOrgResponseDataItemCreator;
  created_at: string;
  updated_at: string;
};
type ProjectsListForOrgResponseData = Array<ProjectsListForOrgResponseDataItem>;

type ProjectsCreateForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The name of the project.
   */
  name: string;
  /**
   * The description of the project.
   */
  body?: string;
} & RequiredPreview<"inertia">;

type ProjectsCreateForOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/projects";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateForOrgResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsCreateForOrgResponseData = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: ProjectsCreateForOrgResponseDataCreator;
  created_at: string;
  updated_at: string;
};

type OrgsListPublicMembersEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type OrgsListPublicMembersRequestOptions = {
  method: "GET";
  url: "/orgs/:org/public_members";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListPublicMembersResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type OrgsListPublicMembersResponseData = Array<
  OrgsListPublicMembersResponseDataItem
>;

type OrgsCheckPublicMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsCheckPublicMembershipRequestOptions = {
  method: "GET";
  url: "/orgs/:org/public_members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsPublicizeMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsPublicizeMembershipRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/public_members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type OrgsConcealMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};

type OrgsConcealMembershipRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/public_members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`.
   */
  type?:
    | "all"
    | "public"
    | "private"
    | "forks"
    | "sources"
    | "member"
    | "internal";
  /**
   * Can be one of `created`, `updated`, `pushed`, `full_name`.
   */
  sort?: "created" | "updated" | "pushed" | "full_name";
  /**
   * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/repos";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListForOrgResponseDataItemLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type ReposListForOrgResponseDataItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposListForOrgResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListForOrgResponseDataItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposListForOrgResponseDataItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposListForOrgResponseDataItemPermissions;
  template_repository: null;
  temp_clone_token: string;
  subscribers_count: number;
  network_count: number;
  license: ReposListForOrgResponseDataItemLicense;
};
type ReposListForOrgResponseData = Array<ReposListForOrgResponseDataItem>;

type ReposCreateInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The name of the repository.
   */
  name: string;
  /**
   * A short description of the repository.
   */
  description?: string;
  /**
   * A URL with more information about the repository.
   */
  homepage?: string;
  /**
   * Either `true` to create a private repository or `false` to create a public one.
   */
  private?: boolean;
  /**
   * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)" in the GitHub Help documentation.
   * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
   */
  visibility?: "public" | "private" | "visibility" | "internal";
  /**
   * Either `true` to enable issues for this repository or `false` to disable them.
   */
  has_issues?: boolean;
  /**
   * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
   */
  has_projects?: boolean;
  /**
   * Either `true` to enable the wiki for this repository or `false` to disable it.
   */
  has_wiki?: boolean;
  /**
   * Either `true` to make this repo available as a template repository or `false` to prevent it.
   */
  is_template?: boolean;
  /**
   * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
   */
  team_id?: number;
  /**
   * Pass `true` to create an initial commit with empty README.
   */
  auto_init?: boolean;
  /**
   * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
   */
  gitignore_template?: string;
  /**
   * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
   */
  license_template?: string;
  /**
   * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
   */
  allow_squash_merge?: boolean;
  /**
   * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
   */
  allow_merge_commit?: boolean;
  /**
   * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
   */
  allow_rebase_merge?: boolean;
  /**
   * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
   */
  delete_branch_on_merge?: boolean;
};

type ReposCreateInOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/repos";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateInOrgResponseDataPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposCreateInOrgResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateInOrgResponseData = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposCreateInOrgResponseDataOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposCreateInOrgResponseDataPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};

type TeamsListIdPGroupsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListIdPGroupsForOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/team-sync/groups";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsForOrgResponseDataGroupsItem = {
  group_id: string;
  group_name: string;
  group_description: string;
};
type TeamsListIdPGroupsForOrgResponseData = {
  groups: Array<TeamsListIdPGroupsForOrgResponseDataGroupsItem>;
};

type TeamsListEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type TeamsListResponseData = Array<TeamsListResponseDataItem>;

type TeamsCreateEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * List GitHub IDs for organization members who will become team maintainers.
   */
  maintainers?: string[];
  /**
   * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
   */
  repo_names?: string[];
  /**
   * The level of privacy this team should have. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * Default: `secret`
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   * Default for child team: `closed`
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};

type TeamsCreateRequestOptions = {
  method: "POST";
  url: "/orgs/:org/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
};
type TeamsCreateResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
  members_count: number;
  repos_count: number;
  created_at: string;
  updated_at: string;
  organization: TeamsCreateResponseDataOrganization;
};

type TeamsGetByNameEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
};

type TeamsGetByNameRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetByNameResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
};
type TeamsGetByNameResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
  members_count: number;
  repos_count: number;
  created_at: string;
  updated_at: string;
  organization: TeamsGetByNameResponseDataOrganization;
};

type TeamsUpdateInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};

type TeamsUpdateInOrgRequestOptions = {
  method: "PATCH";
  url: "/orgs/:org/teams/:team_slug";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateInOrgResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
};
type TeamsUpdateInOrgResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
  members_count: number;
  repos_count: number;
  created_at: string;
  updated_at: string;
  organization: TeamsUpdateInOrgResponseDataOrganization;
};

type TeamsDeleteInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
};

type TeamsDeleteInOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListDiscussionsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListDiscussionsInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/discussions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionsInOrgResponseDataItemReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsListDiscussionsInOrgResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListDiscussionsInOrgResponseDataItem = {
  author: TeamsListDiscussionsInOrgResponseDataItemAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: null;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsListDiscussionsInOrgResponseDataItemReactions;
};
type TeamsListDiscussionsInOrgResponseData = Array<
  TeamsListDiscussionsInOrgResponseDataItem
>;

type TeamsCreateDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * The discussion post's title.
   */
  title: string;
  /**
   * The discussion post's body text.
   */
  body: string;
  /**
   * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
   */
  private?: boolean;
};

type TeamsCreateDiscussionInOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/teams/:team_slug/discussions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionInOrgResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsCreateDiscussionInOrgResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCreateDiscussionInOrgResponseData = {
  author: TeamsCreateDiscussionInOrgResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: null;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsCreateDiscussionInOrgResponseDataReactions;
};

type TeamsGetDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};

type TeamsGetDiscussionInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionInOrgResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsGetDiscussionInOrgResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsGetDiscussionInOrgResponseData = {
  author: TeamsGetDiscussionInOrgResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: null;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsGetDiscussionInOrgResponseDataReactions;
};

type TeamsUpdateDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion post's title.
   */
  title?: string;
  /**
   * The discussion post's body text.
   */
  body?: string;
};

type TeamsUpdateDiscussionInOrgRequestOptions = {
  method: "PATCH";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionInOrgResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsUpdateDiscussionInOrgResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsUpdateDiscussionInOrgResponseData = {
  author: TeamsUpdateDiscussionInOrgResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: string;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsUpdateDiscussionInOrgResponseDataReactions;
};

type TeamsDeleteDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};

type TeamsDeleteDiscussionInOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListDiscussionCommentsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListDiscussionCommentsInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionCommentsInOrgResponseDataItemReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsListDiscussionCommentsInOrgResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListDiscussionCommentsInOrgResponseDataItem = {
  author: TeamsListDiscussionCommentsInOrgResponseDataItemAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: null;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsListDiscussionCommentsInOrgResponseDataItemReactions;
};
type TeamsListDiscussionCommentsInOrgResponseData = Array<
  TeamsListDiscussionCommentsInOrgResponseDataItem
>;

type TeamsCreateDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};

type TeamsCreateDiscussionCommentInOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionCommentInOrgResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsCreateDiscussionCommentInOrgResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCreateDiscussionCommentInOrgResponseData = {
  author: TeamsCreateDiscussionCommentInOrgResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: null;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsCreateDiscussionCommentInOrgResponseDataReactions;
};

type TeamsGetDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};

type TeamsGetDiscussionCommentInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionCommentInOrgResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsGetDiscussionCommentInOrgResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsGetDiscussionCommentInOrgResponseData = {
  author: TeamsGetDiscussionCommentInOrgResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: null;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsGetDiscussionCommentInOrgResponseDataReactions;
};

type TeamsUpdateDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};

type TeamsUpdateDiscussionCommentInOrgRequestOptions = {
  method: "PATCH";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionCommentInOrgResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsUpdateDiscussionCommentInOrgResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsUpdateDiscussionCommentInOrgResponseData = {
  author: TeamsUpdateDiscussionCommentInOrgResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: string;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsUpdateDiscussionCommentInOrgResponseDataReactions;
};

type TeamsDeleteDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};

type TeamsDeleteDiscussionCommentInOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForTeamDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForTeamDiscussionCommentInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionCommentInOrgResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForTeamDiscussionCommentInOrgResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForTeamDiscussionCommentInOrgResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForTeamDiscussionCommentInOrgResponseData = Array<
  ReactionsListForTeamDiscussionCommentInOrgResponseDataItem
>;

type ReactionsCreateForTeamDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionCommentInOrgResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForTeamDiscussionCommentInOrgResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForTeamDiscussionCommentInOrgResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsDeleteForTeamDiscussionCommentEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteForTeamDiscussionCommentRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForTeamDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForTeamDiscussionInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionInOrgResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForTeamDiscussionInOrgResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForTeamDiscussionInOrgResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForTeamDiscussionInOrgResponseData = Array<
  ReactionsListForTeamDiscussionInOrgResponseDataItem
>;

type ReactionsCreateForTeamDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForTeamDiscussionInOrgRequestOptions = {
  method: "POST";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionInOrgResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForTeamDiscussionInOrgResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForTeamDiscussionInOrgResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsDeleteForTeamDiscussionEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteForTeamDiscussionRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListPendingInvitationsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListPendingInvitationsInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/invitations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListPendingInvitationsInOrgResponseDataItemInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListPendingInvitationsInOrgResponseDataItem = {
  id: number;
  login: string;
  email: string;
  role: string;
  created_at: string;
  inviter: TeamsListPendingInvitationsInOrgResponseDataItemInviter;
  team_count: number;
  invitation_team_url: string;
};
type TeamsListPendingInvitationsInOrgResponseData = Array<
  TeamsListPendingInvitationsInOrgResponseDataItem
>;

type TeamsListMembersInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Filters members returned by their role in the team. Can be one of:
   * \* `member` - normal members of the team.
   * \* `maintainer` - team maintainers.
   * \* `all` - all members of the team.
   */
  role?: "member" | "maintainer" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListMembersInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/members";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListMembersInOrgResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListMembersInOrgResponseData = Array<
  TeamsListMembersInOrgResponseDataItem
>;

type TeamsGetMembershipInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * username parameter
   */
  username: string;
};

type TeamsGetMembershipInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMembershipInOrgResponseData = {
  url: string;
  role: string;
  state: string;
};

type TeamsAddOrUpdateMembershipInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role that this user should have in the team. Can be one of:
   * \* `member` - a normal member of the team.
   * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
   */
  role?: "member" | "maintainer";
};

type TeamsAddOrUpdateMembershipInOrgRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/teams/:team_slug/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateMembershipInOrgResponseData = {
  url: string;
  role: string;
  state: string;
};

type TeamsRemoveMembershipInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * username parameter
   */
  username: string;
};

type TeamsRemoveMembershipInOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListProjectsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type TeamsListProjectsInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/projects";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListProjectsInOrgResponseDataItemPermissions = {
  read: boolean;
  write: boolean;
  admin: boolean;
};
type TeamsListProjectsInOrgResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListProjectsInOrgResponseDataItem = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: TeamsListProjectsInOrgResponseDataItemCreator;
  created_at: string;
  updated_at: string;
  organization_permission: string;
  private: boolean;
  permissions: TeamsListProjectsInOrgResponseDataItemPermissions;
};
type TeamsListProjectsInOrgResponseData = Array<
  TeamsListProjectsInOrgResponseDataItem
>;

type TeamsReviewProjectInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * project_id parameter
   */
  project_id: number;
} & RequiredPreview<"inertia">;

type TeamsReviewProjectInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsReviewProjectInOrgResponseDataPermissions = {
  read: boolean;
  write: boolean;
  admin: boolean;
};
type TeamsReviewProjectInOrgResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsReviewProjectInOrgResponseData = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: TeamsReviewProjectInOrgResponseDataCreator;
  created_at: string;
  updated_at: string;
  organization_permission: string;
  private: boolean;
  permissions: TeamsReviewProjectInOrgResponseDataPermissions;
};

type TeamsAddOrUpdateProjectInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The permission to grant to the team for this project. Can be one of:
   * \* `read` - team members can read, but not write to or administer this project.
   * \* `write` - team members can read and write, but not administer this project.
   * \* `admin` - team members can read, write and administer this project.
   * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
   */
  permission?: "read" | "write" | "admin";
} & RequiredPreview<"inertia">;

type TeamsAddOrUpdateProjectInOrgRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/teams/:team_slug/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateProjectInOrgResponseData = {
  message: string;
  documentation_url: string;
};

type TeamsRemoveProjectInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * project_id parameter
   */
  project_id: number;
};

type TeamsRemoveProjectInOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListReposInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListReposInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/repos";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListReposInOrgResponseDataItemLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type TeamsListReposInOrgResponseDataItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type TeamsListReposInOrgResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListReposInOrgResponseDataItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: TeamsListReposInOrgResponseDataItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: TeamsListReposInOrgResponseDataItemPermissions;
  template_repository: null;
  temp_clone_token: string;
  subscribers_count: number;
  network_count: number;
  license: TeamsListReposInOrgResponseDataItemLicense;
};
type TeamsListReposInOrgResponseData = Array<
  TeamsListReposInOrgResponseDataItem
>;

type TeamsCheckManagesRepoInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type TeamsCheckManagesRepoInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCheckManagesRepoInOrgResponseDataPermissions = {
  pull: boolean;
  triage: boolean;
  push: boolean;
  maintain: boolean;
  admin: boolean;
};
type TeamsCheckManagesRepoInOrgResponseDataSourcePermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type TeamsCheckManagesRepoInOrgResponseDataSourceOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCheckManagesRepoInOrgResponseDataSource = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: TeamsCheckManagesRepoInOrgResponseDataSourceOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: TeamsCheckManagesRepoInOrgResponseDataSourcePermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type TeamsCheckManagesRepoInOrgResponseDataParentPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type TeamsCheckManagesRepoInOrgResponseDataParentOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCheckManagesRepoInOrgResponseDataParent = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: TeamsCheckManagesRepoInOrgResponseDataParentOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: TeamsCheckManagesRepoInOrgResponseDataParentPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type TeamsCheckManagesRepoInOrgResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCheckManagesRepoInOrgResponseData = {
  organization: TeamsCheckManagesRepoInOrgResponseDataOrganization;
  parent: TeamsCheckManagesRepoInOrgResponseDataParent;
  source: TeamsCheckManagesRepoInOrgResponseDataSource;
  permissions: TeamsCheckManagesRepoInOrgResponseDataPermissions;
};

type TeamsAddOrUpdateRepoInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The permission to grant the team on this repository. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer this repository.
   * \* `push` - team members can pull and push, but not administer this repository.
   * \* `admin` - team members can pull, push and administer this repository.
   * \* `maintain` - team members can manage the repository without access to sensitive or destructive actions. Recommended for project managers. Only applies to repositories owned by organizations.
   * \* `triage` - team members can proactively manage issues and pull requests without write access. Recommended for contributors who triage a repository. Only applies to repositories owned by organizations.
   *
   * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
   */
  permission?: "pull" | "push" | "admin" | "maintain" | "triage";
};

type TeamsAddOrUpdateRepoInOrgRequestOptions = {
  method: "PUT";
  url: "/orgs/:org/teams/:team_slug/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsRemoveRepoInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type TeamsRemoveRepoInOrgRequestOptions = {
  method: "DELETE";
  url: "/orgs/:org/teams/:team_slug/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListIdPGroupsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
};

type TeamsListIdPGroupsInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/team-sync/group-mappings";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsInOrgResponseDataGroupsItem = {
  group_id: string;
  group_name: string;
  group_description: string;
};
type TeamsListIdPGroupsInOrgResponseData = {
  groups: Array<TeamsListIdPGroupsInOrgResponseDataGroupsItem>;
};

type TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
   */
  groups: TeamsCreateOrUpdateIdPGroupConnectionsInOrgParamsGroups[];
};

type TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions = {
  method: "PATCH";
  url: "/orgs/:org/teams/:team_slug/team-sync/group-mappings";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseDataGroups = {
  group_id: string;
  group_name: string;
  group_description: string;
};
type TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseData = {
  groups: TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseDataGroups;
};

type TeamsListChildInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListChildInOrgRequestOptions = {
  method: "GET";
  url: "/orgs/:org/teams/:team_slug/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListChildInOrgResponseDataItemParent = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
};
type TeamsListChildInOrgResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: TeamsListChildInOrgResponseDataItemParent;
};
type TeamsListChildInOrgResponseData = Array<
  TeamsListChildInOrgResponseDataItem
>;

type ProjectsGetCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
} & RequiredPreview<"inertia">;

type ProjectsGetCardRequestOptions = {
  method: "GET";
  url: "/projects/columns/cards/:card_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsGetCardResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsGetCardResponseData = {
  url: string;
  id: number;
  node_id: string;
  note: string;
  creator: ProjectsGetCardResponseDataCreator;
  created_at: string;
  updated_at: string;
  archived: boolean;
  column_url: string;
  content_url: string;
  project_url: string;
};

type ProjectsUpdateCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
  /**
   * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
   */
  note?: string;
  /**
   * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
   */
  archived?: boolean;
} & RequiredPreview<"inertia">;

type ProjectsUpdateCardRequestOptions = {
  method: "PATCH";
  url: "/projects/columns/cards/:card_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsUpdateCardResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsUpdateCardResponseData = {
  url: string;
  id: number;
  node_id: string;
  note: string;
  creator: ProjectsUpdateCardResponseDataCreator;
  created_at: string;
  updated_at: string;
  archived: boolean;
  column_url: string;
  content_url: string;
  project_url: string;
};

type ProjectsDeleteCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
} & RequiredPreview<"inertia">;

type ProjectsDeleteCardRequestOptions = {
  method: "DELETE";
  url: "/projects/columns/cards/:card_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsMoveCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
  /**
   * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
   */
  position: string;
  /**
   * The `id` value of a column in the same project.
   */
  column_id?: number;
} & RequiredPreview<"inertia">;

type ProjectsMoveCardRequestOptions = {
  method: "POST";
  url: "/projects/columns/cards/:card_id/moves";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsGetColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
} & RequiredPreview<"inertia">;

type ProjectsGetColumnRequestOptions = {
  method: "GET";
  url: "/projects/columns/:column_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsGetColumnResponseData = {
  url: string;
  project_url: string;
  cards_url: string;
  id: number;
  node_id: string;
  name: string;
  created_at: string;
  updated_at: string;
};

type ProjectsUpdateColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * The new name of the column.
   */
  name: string;
} & RequiredPreview<"inertia">;

type ProjectsUpdateColumnRequestOptions = {
  method: "PATCH";
  url: "/projects/columns/:column_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsUpdateColumnResponseData = {
  url: string;
  project_url: string;
  cards_url: string;
  id: number;
  node_id: string;
  name: string;
  created_at: string;
  updated_at: string;
};

type ProjectsDeleteColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
} & RequiredPreview<"inertia">;

type ProjectsDeleteColumnRequestOptions = {
  method: "DELETE";
  url: "/projects/columns/:column_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsListCardsEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
   */
  archived_state?: "all" | "archived" | "not_archived";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type ProjectsListCardsRequestOptions = {
  method: "GET";
  url: "/projects/columns/:column_id/cards";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListCardsResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsListCardsResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  note: string;
  creator: ProjectsListCardsResponseDataItemCreator;
  created_at: string;
  updated_at: string;
  archived: boolean;
  column_url: string;
  content_url: string;
  project_url: string;
};
type ProjectsListCardsResponseData = Array<ProjectsListCardsResponseDataItem>;

type ProjectsCreateCardEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
   */
  note?: string;
  /**
   * The issue or pull request id you want to associate with this card. You can use the [List repository issues](https://developer.github.com/v3/issues/#list-repository-issues) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.
   * **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
   */
  content_id?: number;
  /**
   * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
   */
  content_type?: string;
} & RequiredPreview<"inertia">;

type ProjectsCreateCardRequestOptions = {
  method: "POST";
  url: "/projects/columns/:column_id/cards";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateCardResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsCreateCardResponseData = {
  url: string;
  id: number;
  node_id: string;
  note: string;
  creator: ProjectsCreateCardResponseDataCreator;
  created_at: string;
  updated_at: string;
  archived: boolean;
  column_url: string;
  content_url: string;
  project_url: string;
};

type ProjectsMoveColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
   */
  position: string;
} & RequiredPreview<"inertia">;

type ProjectsMoveColumnRequestOptions = {
  method: "POST";
  url: "/projects/columns/:column_id/moves";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsGetEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
} & RequiredPreview<"inertia">;

type ProjectsGetRequestOptions = {
  method: "GET";
  url: "/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsGetResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsGetResponseData = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: ProjectsGetResponseDataCreator;
  created_at: string;
  updated_at: string;
};

type ProjectsUpdateEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The name of the project.
   */
  name?: string;
  /**
   * The description of the project.
   */
  body?: string;
  /**
   * State of the project. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * The permission level that determines whether all members of the project's organization can see and/or make changes to the project. Setting `organization_permission` is only available for organization projects. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. For information on changing access for a team or collaborator, see [Add or update team project](https://developer.github.com/v3/teams/#add-or-update-team-project) or [Add user as a collaborator](https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator).
   *
   * **Note:** Updating a project's `organization_permission` requires `admin` access to the project.
   *
   * Can be one of:
   * \* `read` - Organization members can read, but not write to or administer this project.
   * \* `write` - Organization members can read and write, but not administer this project.
   * \* `admin` - Organization members can read, write and administer this project.
   * \* `none` - Organization members can only see this project if it is public.
   */
  organization_permission?: string;
  /**
   * Sets the visibility of a project board. Setting `private` is only available for organization and user projects. **Note:** Updating a project's visibility requires `admin` access to the project.
   *
   * Can be one of:
   * \* `false` - Anyone can see the project.
   * \* `true` - Only the user can view a project board created on a user account. Organization members with the appropriate `organization_permission` can see project boards in an organization account.
   */
  private?: boolean;
} & RequiredPreview<"inertia">;

type ProjectsUpdateRequestOptions = {
  method: "PATCH";
  url: "/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsUpdateResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsUpdateResponseData = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: ProjectsUpdateResponseDataCreator;
  created_at: string;
  updated_at: string;
};

type ProjectsDeleteEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
} & RequiredPreview<"inertia">;

type ProjectsDeleteRequestOptions = {
  method: "DELETE";
  url: "/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsListCollaboratorsEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * Filters the collaborators by their affiliation. Can be one of:
   * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
   * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
   * \* `all`: All collaborators the authenticated user can see.
   */
  affiliation?: "outside" | "direct" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type ProjectsListCollaboratorsRequestOptions = {
  method: "GET";
  url: "/projects/:project_id/collaborators";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListCollaboratorsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsListCollaboratorsResponseData = Array<
  ProjectsListCollaboratorsResponseDataItem
>;

type ProjectsAddCollaboratorEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * username parameter
   */
  username: string;
  /**
   * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:
   * \* `read` - can read, but not write to or administer this project.
   * \* `write` - can read and write, but not administer this project.
   * \* `admin` - can read, write and administer this project.
   */
  permission?: "read" | "write" | "admin";
} & RequiredPreview<"inertia">;

type ProjectsAddCollaboratorRequestOptions = {
  method: "PUT";
  url: "/projects/:project_id/collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsRemoveCollaboratorEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * username parameter
   */
  username: string;
} & RequiredPreview<"inertia">;

type ProjectsRemoveCollaboratorRequestOptions = {
  method: "DELETE";
  url: "/projects/:project_id/collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ProjectsReviewUserPermissionLevelEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * username parameter
   */
  username: string;
} & RequiredPreview<"inertia">;

type ProjectsReviewUserPermissionLevelRequestOptions = {
  method: "GET";
  url: "/projects/:project_id/collaborators/:username/permission";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsReviewUserPermissionLevelResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsReviewUserPermissionLevelResponseData = {
  permission: string;
  user: ProjectsReviewUserPermissionLevelResponseDataUser;
};

type ProjectsListColumnsEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type ProjectsListColumnsRequestOptions = {
  method: "GET";
  url: "/projects/:project_id/columns";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListColumnsResponseDataItem = {
  url: string;
  project_url: string;
  cards_url: string;
  id: number;
  node_id: string;
  name: string;
  created_at: string;
  updated_at: string;
};
type ProjectsListColumnsResponseData = Array<
  ProjectsListColumnsResponseDataItem
>;

type ProjectsCreateColumnEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The name of the column.
   */
  name: string;
} & RequiredPreview<"inertia">;

type ProjectsCreateColumnRequestOptions = {
  method: "POST";
  url: "/projects/:project_id/columns";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateColumnResponseData = {
  url: string;
  project_url: string;
  cards_url: string;
  id: number;
  node_id: string;
  name: string;
  created_at: string;
  updated_at: string;
};

type RateLimitGetEndpoint = {};

type RateLimitGetRequestOptions = {
  method: "GET";
  url: "/rate_limit";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type RateLimitGetResponseDataRate = {
  limit: number;
  remaining: number;
  reset: number;
};
type RateLimitGetResponseDataResourcesIntegrationManifest = {
  limit: number;
  remaining: number;
  reset: number;
};
type RateLimitGetResponseDataResourcesGraphql = {
  limit: number;
  remaining: number;
  reset: number;
};
type RateLimitGetResponseDataResourcesSearch = {
  limit: number;
  remaining: number;
  reset: number;
};
type RateLimitGetResponseDataResourcesCore = {
  limit: number;
  remaining: number;
  reset: number;
};
type RateLimitGetResponseDataResources = {
  core: RateLimitGetResponseDataResourcesCore;
  search: RateLimitGetResponseDataResourcesSearch;
  graphql: RateLimitGetResponseDataResourcesGraphql;
  integration_manifest: RateLimitGetResponseDataResourcesIntegrationManifest;
};
type RateLimitGetResponseData = {
  resources: RateLimitGetResponseDataResources;
  rate: RateLimitGetResponseDataRate;
};

type ReactionsDeleteLegacyEndpoint = {
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteLegacyRequestOptions = {
  method: "DELETE";
  url: "/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetResponseDataCodeOfConduct = {
  key: string;
  name: string;
  url: string;
};
type ReposGetResponseDataSourcePermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposGetResponseDataSourceOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetResponseDataSource = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposGetResponseDataSourceOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposGetResponseDataSourcePermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposGetResponseDataParentPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposGetResponseDataParentOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetResponseDataParent = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposGetResponseDataParentOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposGetResponseDataParentPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposGetResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetResponseDataLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type ReposGetResponseDataPermissions = {
  pull: boolean;
  triage: boolean;
  push: boolean;
  maintain: boolean;
  admin: boolean;
};
type ReposGetResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetResponseData = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposGetResponseDataOwner;
  private: boolean;
  html_url: string;
  description: string | null;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string | null;
  hooks_url: string;
  svn_url: string;
  homepage: string | null;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template?: boolean;
  topics?: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived?: boolean;
  disabled?: boolean;
  visibility?: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions?: ReposGetResponseDataPermissions;
  allow_rebase_merge?: boolean;
  template_repository?: null;
  temp_clone_token?: string;
  allow_squash_merge?: boolean;
  allow_merge_commit?: boolean;
  subscribers_count: number;
  network_count: number;
  license?: ReposGetResponseDataLicense;
  organization?: ReposGetResponseDataOrganization;
  parent?: ReposGetResponseDataParent;
  source?: ReposGetResponseDataSource;
  forks?: number;
  open_issues?: number;
  watchers?: number;
  code_of_conduct?: ReposGetResponseDataCodeOfConduct;
};

type ReposUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the repository.
   */
  name?: string;
  /**
   * A short description of the repository.
   */
  description?: string;
  /**
   * A URL with more information about the repository.
   */
  homepage?: string;
  /**
   * Either `true` to make the repository private or `false` to make it public. Default: `false`.
   * **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
   */
  private?: boolean;
  /**
   * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. The `visibility` parameter overrides the `private` parameter when you use both along with the `nebula-preview` preview header.
   */
  visibility?: "public" | "private" | "visibility" | "internal";
  /**
   * Either `true` to enable issues for this repository or `false` to disable them.
   */
  has_issues?: boolean;
  /**
   * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
   */
  has_projects?: boolean;
  /**
   * Either `true` to enable the wiki for this repository or `false` to disable it.
   */
  has_wiki?: boolean;
  /**
   * Either `true` to make this repo available as a template repository or `false` to prevent it.
   */
  is_template?: boolean;
  /**
   * Updates the default branch for this repository.
   */
  default_branch?: string;
  /**
   * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
   */
  allow_squash_merge?: boolean;
  /**
   * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
   */
  allow_merge_commit?: boolean;
  /**
   * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
   */
  allow_rebase_merge?: boolean;
  /**
   * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
   */
  delete_branch_on_merge?: boolean;
  /**
   * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
   */
  archived?: boolean;
};

type ReposUpdateRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateResponseDataSourcePermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposUpdateResponseDataSourceOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateResponseDataSource = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposUpdateResponseDataSourceOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposUpdateResponseDataSourcePermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposUpdateResponseDataParentPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposUpdateResponseDataParentOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateResponseDataParent = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposUpdateResponseDataParentOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposUpdateResponseDataParentPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposUpdateResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateResponseDataPermissions = {
  pull: boolean;
  triage: boolean;
  push: boolean;
  maintain: boolean;
  admin: boolean;
};
type ReposUpdateResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateResponseData = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposUpdateResponseDataOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposUpdateResponseDataPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
  organization: ReposUpdateResponseDataOrganization;
  parent: ReposUpdateResponseDataParent;
  source: ReposUpdateResponseDataSource;
};

type ReposDeleteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposDeleteRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteResponseData = { message: string; documentation_url: string };

type ActionsListArtifactsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListArtifactsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/artifacts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListArtifactsForRepoResponseDataArtifactsItem = {
  id: number;
  node_id: string;
  name: string;
  size_in_bytes: number;
  url: string;
  archive_download_url: string;
  expired: boolean;
  created_at: string;
  expires_at: string;
};
type ActionsListArtifactsForRepoResponseData = {
  total_count: number;
  artifacts: Array<ActionsListArtifactsForRepoResponseDataArtifactsItem>;
};

type ActionsGetArtifactEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * artifact_id parameter
   */
  artifact_id: number;
};

type ActionsGetArtifactRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/artifacts/:artifact_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetArtifactResponseData = {
  id: number;
  node_id: string;
  name: string;
  size_in_bytes: number;
  url: string;
  archive_download_url: string;
  expired: boolean;
  created_at: string;
  expires_at: string;
};

type ActionsDeleteArtifactEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * artifact_id parameter
   */
  artifact_id: number;
};

type ActionsDeleteArtifactRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/actions/artifacts/:artifact_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsDownloadArtifactEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * artifact_id parameter
   */
  artifact_id: number;
  /**
   * archive_format parameter
   */
  archive_format: string;
};

type ActionsDownloadArtifactRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/artifacts/:artifact_id/:archive_format";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsGetWorkflowJobEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * job_id parameter
   */
  job_id: number;
};

type ActionsGetWorkflowJobRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/jobs/:job_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetWorkflowJobResponseDataStepsItem = {
  name: string;
  status: string;
  conclusion: string;
  number: number;
  started_at: string;
  completed_at: string;
};
type ActionsGetWorkflowJobResponseData = {
  id: number;
  run_id: number;
  run_url: string;
  node_id: string;
  head_sha: string;
  url: string;
  html_url: string;
  status: string;
  conclusion: string;
  started_at: string;
  completed_at: string;
  name: string;
  steps: Array<ActionsGetWorkflowJobResponseDataStepsItem>;
  check_run_url: string;
};

type ActionsListWorkflowJobLogsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * job_id parameter
   */
  job_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListWorkflowJobLogsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/jobs/:job_id/logs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsListSelfHostedRunnersForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListSelfHostedRunnersForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runners";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListSelfHostedRunnersForRepoResponseDataRunnersItem = {
  id: number;
  name: string;
  os: string;
  status: string;
};
type ActionsListSelfHostedRunnersForRepoResponseData = {
  total_count: number;
  runners: Array<ActionsListSelfHostedRunnersForRepoResponseDataRunnersItem>;
};

type ActionsListRunnerApplicationsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ActionsListRunnerApplicationsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runners/downloads";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListRunnerApplicationsForRepoResponseDataItem = {
  os: string;
  architecture: string;
  download_url: string;
  filename: string;
};
type ActionsListRunnerApplicationsForRepoResponseData = Array<
  ActionsListRunnerApplicationsForRepoResponseDataItem
>;

type ActionsCreateRegistrationTokenForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ActionsCreateRegistrationTokenForRepoRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/actions/runners/registration-token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsCreateRegistrationTokenForRepoResponseData = {
  token: string;
  expires_at: string;
};

type ActionsCreateRemoveTokenForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ActionsCreateRemoveTokenForRepoRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/actions/runners/remove-token";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsCreateRemoveTokenForRepoResponseData = {
  token: string;
  expires_at: string;
};

type ActionsGetSelfHostedRunnerForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * runner_id parameter
   */
  runner_id: number;
};

type ActionsGetSelfHostedRunnerForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runners/:runner_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetSelfHostedRunnerForRepoResponseData = {
  id: number;
  name: string;
  os: string;
  status: string;
};

type ActionsDeleteSelfHostedRunnerFromRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * runner_id parameter
   */
  runner_id: number;
};

type ActionsDeleteSelfHostedRunnerFromRepoRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/actions/runners/:runner_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsListRepoWorkflowRunsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
   */
  actor?: string;
  /**
   * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
   */
  branch?: string;
  /**
   * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
   */
  event?: string;
  /**
   * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
   */
  status?: "completed" | "status" | "conclusion";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListRepoWorkflowRunsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  private: boolean;
  owner: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner;
  html_url: string;
  description: null;
  fork: boolean;
  url: string;
  forks_url: string;
  keys_url: string;
  collaborators_url: string;
  teams_url: string;
  hooks_url: string;
  issue_events_url: string;
  events_url: string;
  assignees_url: string;
  branches_url: string;
  tags_url: string;
  blobs_url: string;
  git_tags_url: string;
  git_refs_url: string;
  trees_url: string;
  statuses_url: string;
  languages_url: string;
  stargazers_url: string;
  contributors_url: string;
  subscribers_url: string;
  subscription_url: string;
  commits_url: string;
  git_commits_url: string;
  comments_url: string;
  issue_comment_url: string;
  contents_url: string;
  compare_url: string;
  merges_url: string;
  archive_url: string;
  downloads_url: string;
  issues_url: string;
  pulls_url: string;
  milestones_url: string;
  notifications_url: string;
  labels_url: string;
  releases_url: string;
  deployments_url: string;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter = {
  name: string;
  email: string;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor = {
  name: string;
  email: string;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommit = {
  id: string;
  tree_id: string;
  message: string;
  timestamp: string;
  author: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor;
  committer: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter;
};
type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItem = {
  id: number;
  node_id: string;
  head_branch: string;
  head_sha: string;
  run_number: number;
  event: string;
  status: string;
  conclusion: null;
  url: string;
  html_url: string;
  pull_requests: Array<any>;
  created_at: string;
  updated_at: string;
  jobs_url: string;
  logs_url: string;
  check_suite_url: string;
  artifacts_url: string;
  cancel_url: string;
  rerun_url: string;
  workflow_url: string;
  head_commit: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommit;
  repository: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepository;
  head_repository: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepository;
};
type ActionsListRepoWorkflowRunsResponseData = {
  total_count: number;
  workflow_runs: Array<ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItem>;
};

type ActionsGetWorkflowRunEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
};

type ActionsGetWorkflowRunRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runs/:run_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetWorkflowRunResponseDataHeadRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActionsGetWorkflowRunResponseDataHeadRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  private: boolean;
  owner: ActionsGetWorkflowRunResponseDataHeadRepositoryOwner;
  html_url: string;
  description: null;
  fork: boolean;
  url: string;
  forks_url: string;
  keys_url: string;
  collaborators_url: string;
  teams_url: string;
  hooks_url: string;
  issue_events_url: string;
  events_url: string;
  assignees_url: string;
  branches_url: string;
  tags_url: string;
  blobs_url: string;
  git_tags_url: string;
  git_refs_url: string;
  trees_url: string;
  statuses_url: string;
  languages_url: string;
  stargazers_url: string;
  contributors_url: string;
  subscribers_url: string;
  subscription_url: string;
  commits_url: string;
  git_commits_url: string;
  comments_url: string;
  issue_comment_url: string;
  contents_url: string;
  compare_url: string;
  merges_url: string;
  archive_url: string;
  downloads_url: string;
  issues_url: string;
  pulls_url: string;
  milestones_url: string;
  notifications_url: string;
  labels_url: string;
  releases_url: string;
  deployments_url: string;
};
type ActionsGetWorkflowRunResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActionsGetWorkflowRunResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ActionsGetWorkflowRunResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ActionsGetWorkflowRunResponseDataHeadCommitCommitter = {
  name: string;
  email: string;
};
type ActionsGetWorkflowRunResponseDataHeadCommitAuthor = {
  name: string;
  email: string;
};
type ActionsGetWorkflowRunResponseDataHeadCommit = {
  id: string;
  tree_id: string;
  message: string;
  timestamp: string;
  author: ActionsGetWorkflowRunResponseDataHeadCommitAuthor;
  committer: ActionsGetWorkflowRunResponseDataHeadCommitCommitter;
};
type ActionsGetWorkflowRunResponseData = {
  id: number;
  node_id: string;
  head_branch: string;
  head_sha: string;
  run_number: number;
  event: string;
  status: string;
  conclusion: null;
  url: string;
  html_url: string;
  pull_requests: Array<any>;
  created_at: string;
  updated_at: string;
  jobs_url: string;
  logs_url: string;
  check_suite_url: string;
  artifacts_url: string;
  cancel_url: string;
  rerun_url: string;
  workflow_url: string;
  head_commit: ActionsGetWorkflowRunResponseDataHeadCommit;
  repository: ActionsGetWorkflowRunResponseDataRepository;
  head_repository: ActionsGetWorkflowRunResponseDataHeadRepository;
};

type ActionsListWorkflowRunArtifactsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListWorkflowRunArtifactsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runs/:run_id/artifacts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListWorkflowRunArtifactsResponseDataArtifactsItem = {
  id: number;
  node_id: string;
  name: string;
  size_in_bytes: number;
  url: string;
  archive_download_url: string;
  expired: boolean;
  created_at: string;
  expires_at: string;
};
type ActionsListWorkflowRunArtifactsResponseData = {
  total_count: number;
  artifacts: Array<ActionsListWorkflowRunArtifactsResponseDataArtifactsItem>;
};

type ActionsCancelWorkflowRunEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
};

type ActionsCancelWorkflowRunRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/actions/runs/:run_id/cancel";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsListJobsForWorkflowRunEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
  /**
   * Filters jobs by their `completed_at` timestamp. Can be one of:
   * \* `latest`: Returns jobs from the most recent execution of the workflow run.
   * \* `all`: Returns all jobs for a workflow run, including from old executions of the workflow run.
   */
  filter?: "latest" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListJobsForWorkflowRunRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runs/:run_id/jobs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListJobsForWorkflowRunResponseDataJobsItemStepsItem = {
  name: string;
  status: string;
  conclusion: string;
  number: number;
  started_at: string;
  completed_at: string;
};
type ActionsListJobsForWorkflowRunResponseDataJobsItem = {
  id: number;
  run_id: number;
  run_url: string;
  node_id: string;
  head_sha: string;
  url: string;
  html_url: string;
  status: string;
  conclusion: string;
  started_at: string;
  completed_at: string;
  name: string;
  steps: Array<ActionsListJobsForWorkflowRunResponseDataJobsItemStepsItem>;
  check_run_url: string;
};
type ActionsListJobsForWorkflowRunResponseData = {
  total_count: number;
  jobs: Array<ActionsListJobsForWorkflowRunResponseDataJobsItem>;
};

type ActionsListWorkflowRunLogsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListWorkflowRunLogsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/runs/:run_id/logs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsDeleteWorkflowRunLogsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
};

type ActionsDeleteWorkflowRunLogsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/actions/runs/:run_id/logs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsReRunWorkflowEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * run_id parameter
   */
  run_id: number;
};

type ActionsReRunWorkflowRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/actions/runs/:run_id/rerun";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsListSecretsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListSecretsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/secrets";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListSecretsForRepoResponseDataSecretsItem = {
  name: string;
  created_at: string;
  updated_at: string;
};
type ActionsListSecretsForRepoResponseData = {
  total_count: number;
  secrets: Array<ActionsListSecretsForRepoResponseDataSecretsItem>;
};

type ActionsGetPublicKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ActionsGetPublicKeyRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/secrets/public-key";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetPublicKeyResponseData = { key_id: string; key: string };

type ActionsGetSecretEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
};

type ActionsGetSecretRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/secrets/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetSecretResponseData = {
  name: string;
  created_at: string;
  updated_at: string;
};

type ActionsCreateOrUpdateSecretForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
  /**
   * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get your public key](https://developer.github.com/v3/actions/secrets/#get-your-public-key) endpoint.
   */
  encrypted_value?: string;
  /**
   * ID of the key you used to encrypt the secret.
   */
  key_id?: string;
};

type ActionsCreateOrUpdateSecretForRepoRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/actions/secrets/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsDeleteSecretFromRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
};

type ActionsDeleteSecretFromRepoRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/actions/secrets/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActionsListRepoWorkflowsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListRepoWorkflowsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/workflows";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListRepoWorkflowsResponseDataWorkflowsItem = {
  id: number;
  node_id: string;
  name: string;
  path: string;
  state: string;
  created_at: string;
  updated_at: string;
  url: string;
  html_url: string;
  badge_url: string;
};
type ActionsListRepoWorkflowsResponseData = {
  total_count: number;
  workflows: Array<ActionsListRepoWorkflowsResponseDataWorkflowsItem>;
};

type ActionsGetWorkflowEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * workflow_id parameter
   */
  workflow_id: number;
};

type ActionsGetWorkflowRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/workflows/:workflow_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsGetWorkflowResponseData = {
  id: number;
  node_id: string;
  name: string;
  path: string;
  state: string;
  created_at: string;
  updated_at: string;
  url: string;
  html_url: string;
  badge_url: string;
};

type ActionsListWorkflowRunsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * workflow_id parameter
   */
  workflow_id: number;
  /**
   * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
   */
  actor?: string;
  /**
   * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
   */
  branch?: string;
  /**
   * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
   */
  event?: string;
  /**
   * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
   */
  status?: "completed" | "status" | "conclusion";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActionsListWorkflowRunsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/actions/workflows/:workflow_id/runs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  private: boolean;
  owner: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner;
  html_url: string;
  description: null;
  fork: boolean;
  url: string;
  forks_url: string;
  keys_url: string;
  collaborators_url: string;
  teams_url: string;
  hooks_url: string;
  issue_events_url: string;
  events_url: string;
  assignees_url: string;
  branches_url: string;
  tags_url: string;
  blobs_url: string;
  git_tags_url: string;
  git_refs_url: string;
  trees_url: string;
  statuses_url: string;
  languages_url: string;
  stargazers_url: string;
  contributors_url: string;
  subscribers_url: string;
  subscription_url: string;
  commits_url: string;
  git_commits_url: string;
  comments_url: string;
  issue_comment_url: string;
  contents_url: string;
  compare_url: string;
  merges_url: string;
  archive_url: string;
  downloads_url: string;
  issues_url: string;
  pulls_url: string;
  milestones_url: string;
  notifications_url: string;
  labels_url: string;
  releases_url: string;
  deployments_url: string;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter = {
  name: string;
  email: string;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor = {
  name: string;
  email: string;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommit = {
  id: string;
  tree_id: string;
  message: string;
  timestamp: string;
  author: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor;
  committer: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter;
};
type ActionsListWorkflowRunsResponseDataWorkflowRunsItem = {
  id: number;
  node_id: string;
  head_branch: string;
  head_sha: string;
  run_number: number;
  event: string;
  status: string;
  conclusion: null;
  url: string;
  html_url: string;
  pull_requests: Array<any>;
  created_at: string;
  updated_at: string;
  jobs_url: string;
  logs_url: string;
  check_suite_url: string;
  artifacts_url: string;
  cancel_url: string;
  rerun_url: string;
  workflow_url: string;
  head_commit: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommit;
  repository: ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepository;
  head_repository: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepository;
};
type ActionsListWorkflowRunsResponseData = {
  total_count: number;
  workflow_runs: Array<ActionsListWorkflowRunsResponseDataWorkflowRunsItem>;
};

type IssuesListAssigneesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListAssigneesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/assignees";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListAssigneesResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListAssigneesResponseData = Array<
  IssuesListAssigneesResponseDataItem
>;

type IssuesCheckAssigneeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * assignee parameter
   */
  assignee: string;
};

type IssuesCheckAssigneeRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/assignees/:assignee";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposEnableAutomatedSecurityFixesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"london">;

type ReposEnableAutomatedSecurityFixesRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/automated-security-fixes";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposDisableAutomatedSecurityFixesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"london">;

type ReposDisableAutomatedSecurityFixesRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/automated-security-fixes";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListBranchesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
   */
  protected?: boolean;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListBranchesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListBranchesResponseDataItemProtectionRequiredStatusChecks = {
  enforcement_level: string;
  contexts: Array<string>;
};
type ReposListBranchesResponseDataItemProtection = {
  enabled: boolean;
  required_status_checks: ReposListBranchesResponseDataItemProtectionRequiredStatusChecks;
};
type ReposListBranchesResponseDataItemCommit = { sha: string; url: string };
type ReposListBranchesResponseDataItem = {
  name: string;
  commit: ReposListBranchesResponseDataItemCommit;
  protected: boolean;
  protection: ReposListBranchesResponseDataItemProtection;
  protection_url: string;
};
type ReposListBranchesResponseData = Array<ReposListBranchesResponseDataItem>;

type ReposGetBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetBranchRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetBranchResponseDataProtectionRequiredStatusChecks = {
  enforcement_level: string;
  contexts: Array<string>;
};
type ReposGetBranchResponseDataProtection = {
  enabled: boolean;
  required_status_checks: ReposGetBranchResponseDataProtectionRequiredStatusChecks;
};
type ReposGetBranchResponseDataLinks = { html: string; self: string };
type ReposGetBranchResponseDataCommitCommitter = {
  gravatar_id: string;
  avatar_url: string;
  url: string;
  id: number;
  login: string;
};
type ReposGetBranchResponseDataCommitParentsItem = { sha: string; url: string };
type ReposGetBranchResponseDataCommitAuthor = {
  gravatar_id: string;
  avatar_url: string;
  url: string;
  id: number;
  login: string;
};
type ReposGetBranchResponseDataCommitCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposGetBranchResponseDataCommitCommitCommitter = {
  name: string;
  date: string;
  email: string;
};
type ReposGetBranchResponseDataCommitCommitTree = { sha: string; url: string };
type ReposGetBranchResponseDataCommitCommitAuthor = {
  name: string;
  date: string;
  email: string;
};
type ReposGetBranchResponseDataCommitCommit = {
  author: ReposGetBranchResponseDataCommitCommitAuthor;
  url: string;
  message: string;
  tree: ReposGetBranchResponseDataCommitCommitTree;
  committer: ReposGetBranchResponseDataCommitCommitCommitter;
  verification: ReposGetBranchResponseDataCommitCommitVerification;
};
type ReposGetBranchResponseDataCommit = {
  sha: string;
  node_id: string;
  commit: ReposGetBranchResponseDataCommitCommit;
  author: ReposGetBranchResponseDataCommitAuthor;
  parents: Array<ReposGetBranchResponseDataCommitParentsItem>;
  url: string;
  committer: ReposGetBranchResponseDataCommitCommitter;
};
type ReposGetBranchResponseData = {
  name: string;
  commit: ReposGetBranchResponseDataCommit;
  _links: ReposGetBranchResponseDataLinks;
  protected: boolean;
  protection: ReposGetBranchResponseDataProtection;
  protection_url: string;
};

type ReposGetBranchProtectionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetBranchProtectionRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetBranchProtectionResponseDataAllowDeletions = { enabled: boolean };
type ReposGetBranchProtectionResponseDataAllowForcePushes = {
  enabled: boolean;
};
type ReposGetBranchProtectionResponseDataRequiredLinearHistory = {
  enabled: boolean;
};
type ReposGetBranchProtectionResponseDataRestrictionsAppsItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposGetBranchProtectionResponseDataRestrictionsAppsItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposGetBranchProtectionResponseDataRestrictionsAppsItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposGetBranchProtectionResponseDataRestrictionsAppsItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposGetBranchProtectionResponseDataRestrictionsAppsItemPermissions;
  events: Array<string>;
};
type ReposGetBranchProtectionResponseDataRestrictionsTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposGetBranchProtectionResponseDataRestrictionsUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetBranchProtectionResponseDataRestrictions = {
  url: string;
  users_url: string;
  teams_url: string;
  apps_url: string;
  users: Array<ReposGetBranchProtectionResponseDataRestrictionsUsersItem>;
  teams: Array<ReposGetBranchProtectionResponseDataRestrictionsTeamsItem>;
  apps: Array<ReposGetBranchProtectionResponseDataRestrictionsAppsItem>;
};
type ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions = {
  url: string;
  users_url: string;
  teams_url: string;
  users: Array<
    ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem
  >;
  teams: Array<
    ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem
  >;
};
type ReposGetBranchProtectionResponseDataRequiredPullRequestReviews = {
  url: string;
  dismissal_restrictions: ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions;
  dismiss_stale_reviews: boolean;
  require_code_owner_reviews: boolean;
  required_approving_review_count: number;
};
type ReposGetBranchProtectionResponseDataEnforceAdmins = {
  url: string;
  enabled: boolean;
};
type ReposGetBranchProtectionResponseDataRequiredStatusChecks = {
  url: string;
  strict: boolean;
  contexts: Array<string>;
  contexts_url: string;
};
type ReposGetBranchProtectionResponseData = {
  url: string;
  required_status_checks: ReposGetBranchProtectionResponseDataRequiredStatusChecks;
  enforce_admins: ReposGetBranchProtectionResponseDataEnforceAdmins;
  required_pull_request_reviews: ReposGetBranchProtectionResponseDataRequiredPullRequestReviews;
  restrictions: ReposGetBranchProtectionResponseDataRestrictions;
  required_linear_history: ReposGetBranchProtectionResponseDataRequiredLinearHistory;
  allow_force_pushes: ReposGetBranchProtectionResponseDataAllowForcePushes;
  allow_deletions: ReposGetBranchProtectionResponseDataAllowDeletions;
};

type ReposUpdateBranchProtectionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * Require status checks to pass before merging. Set to `null` to disable.
   */
  required_status_checks: ReposUpdateBranchProtectionParamsRequiredStatusChecks | null;
  /**
   * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
   */
  enforce_admins: boolean | null;
  /**
   * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
   */
  required_pull_request_reviews: ReposUpdateBranchProtectionParamsRequiredPullRequestReviews | null;
  /**
   * Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
   */
  restrictions: ReposUpdateBranchProtectionParamsRestrictions | null;
  /**
   * Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.
   */
  required_linear_history?: boolean;
  /**
   * Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."
   */
  allow_force_pushes?: boolean | null;
  /**
   * Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.
   */
  allow_deletions?: boolean;
};

type ReposUpdateBranchProtectionRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/branches/:branch/protection";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateBranchProtectionResponseDataAllowDeletions = {
  enabled: boolean;
};
type ReposUpdateBranchProtectionResponseDataAllowForcePushes = {
  enabled: boolean;
};
type ReposUpdateBranchProtectionResponseDataRequiredLinearHistory = {
  enabled: boolean;
};
type ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposUpdateBranchProtectionResponseDataRestrictionsAppsItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemPermissions;
  events: Array<string>;
};
type ReposUpdateBranchProtectionResponseDataRestrictionsTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposUpdateBranchProtectionResponseDataRestrictionsUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateBranchProtectionResponseDataRestrictions = {
  url: string;
  users_url: string;
  teams_url: string;
  apps_url: string;
  users: Array<ReposUpdateBranchProtectionResponseDataRestrictionsUsersItem>;
  teams: Array<ReposUpdateBranchProtectionResponseDataRestrictionsTeamsItem>;
  apps: Array<ReposUpdateBranchProtectionResponseDataRestrictionsAppsItem>;
};
type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions = {
  url: string;
  users_url: string;
  teams_url: string;
  users: Array<
    ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem
  >;
  teams: Array<
    ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem
  >;
};
type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviews = {
  url: string;
  dismissal_restrictions: ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions;
  dismiss_stale_reviews: boolean;
  require_code_owner_reviews: boolean;
  required_approving_review_count: number;
};
type ReposUpdateBranchProtectionResponseDataEnforceAdmins = {
  url: string;
  enabled: boolean;
};
type ReposUpdateBranchProtectionResponseDataRequiredStatusChecks = {
  url: string;
  strict: boolean;
  contexts: Array<string>;
  contexts_url: string;
};
type ReposUpdateBranchProtectionResponseData = {
  url: string;
  required_status_checks: ReposUpdateBranchProtectionResponseDataRequiredStatusChecks;
  enforce_admins: ReposUpdateBranchProtectionResponseDataEnforceAdmins;
  required_pull_request_reviews: ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviews;
  restrictions: ReposUpdateBranchProtectionResponseDataRestrictions;
  required_linear_history: ReposUpdateBranchProtectionResponseDataRequiredLinearHistory;
  allow_force_pushes: ReposUpdateBranchProtectionResponseDataAllowForcePushes;
  allow_deletions: ReposUpdateBranchProtectionResponseDataAllowDeletions;
};

type ReposRemoveBranchProtectionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposRemoveBranchProtectionRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetProtectedBranchAdminEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetProtectedBranchAdminEnforcementRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchAdminEnforcementResponseData = {
  url: string;
  enabled: boolean;
};

type ReposAddProtectedBranchAdminEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposAddProtectedBranchAdminEnforcementRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchAdminEnforcementResponseData = {
  url: string;
  enabled: boolean;
};

type ReposRemoveProtectedBranchAdminEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposRemoveProtectedBranchAdminEnforcementRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetProtectedBranchPullRequestReviewEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetProtectedBranchPullRequestReviewEnforcementRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions = {
  url: string;
  users_url: string;
  teams_url: string;
  users: Array<
    ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem
  >;
  teams: Array<
    ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem
  >;
};
type ReposGetProtectedBranchPullRequestReviewEnforcementResponseData = {
  url: string;
  dismissal_restrictions: ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions;
  dismiss_stale_reviews: boolean;
  require_code_owner_reviews: boolean;
  required_approving_review_count: number;
};

type ReposUpdateProtectedBranchPullRequestReviewEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
   */
  dismissal_restrictions?: ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions;
  /**
   * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
   */
  dismiss_stale_reviews?: boolean;
  /**
   * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
   */
  require_code_owner_reviews?: boolean;
  /**
   * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
   */
  required_approving_review_count?: number;
};

type ReposUpdateProtectedBranchPullRequestReviewEnforcementRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions = {
  url: string;
  users_url: string;
  teams_url: string;
  users: Array<
    ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem
  >;
  teams: Array<
    ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem
  >;
};
type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseData = {
  url: string;
  dismissal_restrictions: ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions;
  dismiss_stale_reviews: boolean;
  require_code_owner_reviews: boolean;
  required_approving_review_count: number;
};

type ReposRemoveProtectedBranchPullRequestReviewEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposRemoveProtectedBranchPullRequestReviewEnforcementRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetProtectedBranchRequiredSignaturesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
} & RequiredPreview<"zzzax">;

type ReposGetProtectedBranchRequiredSignaturesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchRequiredSignaturesResponseData = {
  url: string;
  enabled: boolean;
};

type ReposAddProtectedBranchRequiredSignaturesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
} & RequiredPreview<"zzzax">;

type ReposAddProtectedBranchRequiredSignaturesRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchRequiredSignaturesResponseData = {
  url: string;
  enabled: boolean;
};

type ReposRemoveProtectedBranchRequiredSignaturesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
} & RequiredPreview<"zzzax">;

type ReposRemoveProtectedBranchRequiredSignaturesRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetProtectedBranchRequiredStatusChecksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetProtectedBranchRequiredStatusChecksRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchRequiredStatusChecksResponseData = {
  url: string;
  strict: boolean;
  contexts: Array<string>;
  contexts_url: string;
};

type ReposUpdateProtectedBranchRequiredStatusChecksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * Require branches to be up to date before merging.
   */
  strict?: boolean;
  /**
   * The list of status checks to require in order to merge into this branch
   */
  contexts?: string[];
};

type ReposUpdateProtectedBranchRequiredStatusChecksRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateProtectedBranchRequiredStatusChecksResponseData = {
  url: string;
  strict: boolean;
  contexts: Array<string>;
  contexts_url: string;
};

type ReposRemoveProtectedBranchRequiredStatusChecksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposRemoveProtectedBranchRequiredStatusChecksRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposListProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListProtectedBranchRequiredStatusChecksContextsResponseData = Array<
  string
>;

type ReposReplaceProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * contexts parameter
   */
  contexts: string[];
};

type ReposReplaceProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchRequiredStatusChecksContextsResponseData = Array<
  string
>;

type ReposAddProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * contexts parameter
   */
  contexts: string[];
};

type ReposAddProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchRequiredStatusChecksContextsResponseData = Array<
  string
>;

type ReposRemoveProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * contexts parameter
   */
  contexts: string[];
};

type ReposRemoveProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchRequiredStatusChecksContextsResponseData = Array<
  string
>;

type ReposGetProtectedBranchRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetProtectedBranchRestrictionsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchRestrictionsResponseDataAppsItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposGetProtectedBranchRestrictionsResponseDataAppsItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposGetProtectedBranchRestrictionsResponseDataAppsItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposGetProtectedBranchRestrictionsResponseDataAppsItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposGetProtectedBranchRestrictionsResponseDataAppsItemPermissions;
  events: Array<string>;
};
type ReposGetProtectedBranchRestrictionsResponseDataTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposGetProtectedBranchRestrictionsResponseDataUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetProtectedBranchRestrictionsResponseData = {
  url: string;
  users_url: string;
  teams_url: string;
  apps_url: string;
  users: Array<ReposGetProtectedBranchRestrictionsResponseDataUsersItem>;
  teams: Array<ReposGetProtectedBranchRestrictionsResponseDataTeamsItem>;
  apps: Array<ReposGetProtectedBranchRestrictionsResponseDataAppsItem>;
};

type ReposRemoveProtectedBranchRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposRemoveProtectedBranchRestrictionsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetAppsWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetAppsWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetAppsWithAccessToProtectedBranchResponseDataItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposGetAppsWithAccessToProtectedBranchResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposGetAppsWithAccessToProtectedBranchResponseDataItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposGetAppsWithAccessToProtectedBranchResponseDataItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposGetAppsWithAccessToProtectedBranchResponseDataItemPermissions;
  events: Array<string>;
};
type ReposGetAppsWithAccessToProtectedBranchResponseData = Array<
  ReposGetAppsWithAccessToProtectedBranchResponseDataItem
>;

type ReposReplaceProtectedBranchAppRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * apps parameter
   */
  apps: string[];
};

type ReposReplaceProtectedBranchAppRestrictionsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchAppRestrictionsResponseDataItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposReplaceProtectedBranchAppRestrictionsResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposReplaceProtectedBranchAppRestrictionsResponseDataItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposReplaceProtectedBranchAppRestrictionsResponseDataItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposReplaceProtectedBranchAppRestrictionsResponseDataItemPermissions;
  events: Array<string>;
};
type ReposReplaceProtectedBranchAppRestrictionsResponseData = Array<
  ReposReplaceProtectedBranchAppRestrictionsResponseDataItem
>;

type ReposAddProtectedBranchAppRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * apps parameter
   */
  apps: string[];
};

type ReposAddProtectedBranchAppRestrictionsRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchAppRestrictionsResponseDataItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposAddProtectedBranchAppRestrictionsResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposAddProtectedBranchAppRestrictionsResponseDataItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposAddProtectedBranchAppRestrictionsResponseDataItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposAddProtectedBranchAppRestrictionsResponseDataItemPermissions;
  events: Array<string>;
};
type ReposAddProtectedBranchAppRestrictionsResponseData = Array<
  ReposAddProtectedBranchAppRestrictionsResponseDataItem
>;

type ReposRemoveProtectedBranchAppRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * apps parameter
   */
  apps: string[];
};

type ReposRemoveProtectedBranchAppRestrictionsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchAppRestrictionsResponseDataItemPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ReposRemoveProtectedBranchAppRestrictionsResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ReposRemoveProtectedBranchAppRestrictionsResponseDataItem = {
  id: number;
  slug: string;
  node_id: string;
  owner: ReposRemoveProtectedBranchAppRestrictionsResponseDataItemOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ReposRemoveProtectedBranchAppRestrictionsResponseDataItemPermissions;
  events: Array<string>;
};
type ReposRemoveProtectedBranchAppRestrictionsResponseData = Array<
  ReposRemoveProtectedBranchAppRestrictionsResponseDataItem
>;

type ReposGetTeamsWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetTeamsWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetTeamsWithAccessToProtectedBranchResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposGetTeamsWithAccessToProtectedBranchResponseData = Array<
  ReposGetTeamsWithAccessToProtectedBranchResponseDataItem
>;

type ReposReplaceProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * teams parameter
   */
  teams: string[];
};

type ReposReplaceProtectedBranchTeamRestrictionsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchTeamRestrictionsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposReplaceProtectedBranchTeamRestrictionsResponseData = Array<
  ReposReplaceProtectedBranchTeamRestrictionsResponseDataItem
>;

type ReposAddProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * teams parameter
   */
  teams: string[];
};

type ReposAddProtectedBranchTeamRestrictionsRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchTeamRestrictionsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposAddProtectedBranchTeamRestrictionsResponseData = Array<
  ReposAddProtectedBranchTeamRestrictionsResponseDataItem
>;

type ReposRemoveProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * teams parameter
   */
  teams: string[];
};

type ReposRemoveProtectedBranchTeamRestrictionsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchTeamRestrictionsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposRemoveProtectedBranchTeamRestrictionsResponseData = Array<
  ReposRemoveProtectedBranchTeamRestrictionsResponseDataItem
>;

type ReposGetUsersWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};

type ReposGetUsersWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetUsersWithAccessToProtectedBranchResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetUsersWithAccessToProtectedBranchResponseData = Array<
  ReposGetUsersWithAccessToProtectedBranchResponseDataItem
>;

type ReposReplaceProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * users parameter
   */
  users: string[];
};

type ReposReplaceProtectedBranchUserRestrictionsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchUserRestrictionsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposReplaceProtectedBranchUserRestrictionsResponseData = Array<
  ReposReplaceProtectedBranchUserRestrictionsResponseDataItem
>;

type ReposAddProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * users parameter
   */
  users: string[];
};

type ReposAddProtectedBranchUserRestrictionsRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchUserRestrictionsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposAddProtectedBranchUserRestrictionsResponseData = Array<
  ReposAddProtectedBranchUserRestrictionsResponseDataItem
>;

type ReposRemoveProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * users parameter
   */
  users: string[];
};

type ReposRemoveProtectedBranchUserRestrictionsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchUserRestrictionsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposRemoveProtectedBranchUserRestrictionsResponseData = Array<
  ReposRemoveProtectedBranchUserRestrictionsResponseDataItem
>;

type ChecksCreateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the check. For example, "code-coverage".
   */
  name: string;
  /**
   * The SHA of the commit.
   */
  head_sha: string;
  /**
   * The URL of the integrator's site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.
   */
  details_url?: string;
  /**
   * A reference for the run on the integrator's system.
   */
  external_id?: string;
  /**
   * The current status. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  started_at?: string;
  /**
   * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
   * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
   */
  conclusion?:
    | "success"
    | "failure"
    | "neutral"
    | "cancelled"
    | "timed_out"
    | "action_required";
  /**
   * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  completed_at?: string;
  /**
   * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object) description.
   */
  output?: ChecksCreateParamsOutput;
  /**
   * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://developer.github.com/v3/activity/events/types/#checkrunevent) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
   */
  actions?: ChecksCreateParamsActions[];
} & RequiredPreview<"antiope">;

type ChecksCreateRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/check-runs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksCreateResponseDataPullRequestsItemBaseRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksCreateResponseDataPullRequestsItemBase = {
  ref: string;
  sha: string;
  repo: ChecksCreateResponseDataPullRequestsItemBaseRepo;
};
type ChecksCreateResponseDataPullRequestsItemHeadRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksCreateResponseDataPullRequestsItemHead = {
  ref: string;
  sha: string;
  repo: ChecksCreateResponseDataPullRequestsItemHeadRepo;
};
type ChecksCreateResponseDataPullRequestsItem = {
  url: string;
  id: number;
  number: number;
  head: ChecksCreateResponseDataPullRequestsItemHead;
  base: ChecksCreateResponseDataPullRequestsItemBase;
};
type ChecksCreateResponseDataAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksCreateResponseDataAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksCreateResponseDataApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksCreateResponseDataAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksCreateResponseDataAppPermissions;
  events: Array<string>;
};
type ChecksCreateResponseDataCheckSuite = { id: number };
type ChecksCreateResponseDataOutput = {
  title: string;
  summary: string;
  text: string;
  annotations_count?: number;
  annotations_url?: string;
};
type ChecksCreateResponseData = {
  id: number;
  head_sha: string;
  node_id: string;
  external_id: string;
  url: string;
  html_url: string;
  details_url: string;
  status: string;
  conclusion: null | string;
  started_at: string;
  completed_at: null | string;
  output: ChecksCreateResponseDataOutput;
  name: string;
  check_suite: ChecksCreateResponseDataCheckSuite;
  app: ChecksCreateResponseDataApp;
  pull_requests: Array<ChecksCreateResponseDataPullRequestsItem>;
};

type ChecksUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_run_id parameter
   */
  check_run_id: number;
  /**
   * The name of the check. For example, "code-coverage".
   */
  name?: string;
  /**
   * The URL of the integrator's site that has the full details of the check.
   */
  details_url?: string;
  /**
   * A reference for the run on the integrator's system.
   */
  external_id?: string;
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  started_at?: string;
  /**
   * The current status. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`.
   * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
   */
  conclusion?:
    | "success"
    | "failure"
    | "neutral"
    | "cancelled"
    | "timed_out"
    | "action_required";
  /**
   * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  completed_at?: string;
  /**
   * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object-1) description.
   */
  output?: ChecksUpdateParamsOutput;
  /**
   * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
   */
  actions?: ChecksUpdateParamsActions[];
} & RequiredPreview<"antiope">;

type ChecksUpdateRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/check-runs/:check_run_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksUpdateResponseDataPullRequestsItemBaseRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksUpdateResponseDataPullRequestsItemBase = {
  ref: string;
  sha: string;
  repo: ChecksUpdateResponseDataPullRequestsItemBaseRepo;
};
type ChecksUpdateResponseDataPullRequestsItemHeadRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksUpdateResponseDataPullRequestsItemHead = {
  ref: string;
  sha: string;
  repo: ChecksUpdateResponseDataPullRequestsItemHeadRepo;
};
type ChecksUpdateResponseDataPullRequestsItem = {
  url: string;
  id: number;
  number: number;
  head: ChecksUpdateResponseDataPullRequestsItemHead;
  base: ChecksUpdateResponseDataPullRequestsItemBase;
};
type ChecksUpdateResponseDataAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksUpdateResponseDataAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksUpdateResponseDataApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksUpdateResponseDataAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksUpdateResponseDataAppPermissions;
  events: Array<string>;
};
type ChecksUpdateResponseDataCheckSuite = { id: number };
type ChecksUpdateResponseDataOutput = {
  title: string;
  summary: string;
  text: string;
  annotations_count: number;
  annotations_url: string;
};
type ChecksUpdateResponseData = {
  id: number;
  head_sha: string;
  node_id: string;
  external_id: string;
  url: string;
  html_url: string;
  details_url: string;
  status: string;
  conclusion: string;
  started_at: string;
  completed_at: string;
  output: ChecksUpdateResponseDataOutput;
  name: string;
  check_suite: ChecksUpdateResponseDataCheckSuite;
  app: ChecksUpdateResponseDataApp;
  pull_requests: Array<ChecksUpdateResponseDataPullRequestsItem>;
};

type ChecksGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_run_id parameter
   */
  check_run_id: number;
} & RequiredPreview<"antiope">;

type ChecksGetRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/check-runs/:check_run_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksGetResponseDataPullRequestsItemBaseRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksGetResponseDataPullRequestsItemBase = {
  ref: string;
  sha: string;
  repo: ChecksGetResponseDataPullRequestsItemBaseRepo;
};
type ChecksGetResponseDataPullRequestsItemHeadRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksGetResponseDataPullRequestsItemHead = {
  ref: string;
  sha: string;
  repo: ChecksGetResponseDataPullRequestsItemHeadRepo;
};
type ChecksGetResponseDataPullRequestsItem = {
  url: string;
  id: number;
  number: number;
  head: ChecksGetResponseDataPullRequestsItemHead;
  base: ChecksGetResponseDataPullRequestsItemBase;
};
type ChecksGetResponseDataAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksGetResponseDataAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksGetResponseDataApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksGetResponseDataAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksGetResponseDataAppPermissions;
  events: Array<string>;
};
type ChecksGetResponseDataCheckSuite = { id: number };
type ChecksGetResponseDataOutput = {
  title: string;
  summary: string;
  text: string;
  annotations_count: number;
  annotations_url: string;
};
type ChecksGetResponseData = {
  id: number;
  head_sha: string;
  node_id: string;
  external_id: string;
  url: string;
  html_url: string;
  details_url: string;
  status: string;
  conclusion: string;
  started_at: string;
  completed_at: string;
  output: ChecksGetResponseDataOutput;
  name: string;
  check_suite: ChecksGetResponseDataCheckSuite;
  app: ChecksGetResponseDataApp;
  pull_requests: Array<ChecksGetResponseDataPullRequestsItem>;
};

type ChecksListAnnotationsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_run_id parameter
   */
  check_run_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"antiope">;

type ChecksListAnnotationsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/check-runs/:check_run_id/annotations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListAnnotationsResponseDataItem = {
  path: string;
  start_line: number;
  end_line: number;
  start_column: number;
  end_column: number;
  annotation_level: string;
  title: string;
  message: string;
  raw_details: string;
};
type ChecksListAnnotationsResponseData = Array<
  ChecksListAnnotationsResponseDataItem
>;

type ChecksCreateSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The sha of the head commit.
   */
  head_sha: string;
} & RequiredPreview<"antiope">;

type ChecksCreateSuiteRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/check-suites";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksCreateSuiteResponseDataRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ChecksCreateSuiteResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ChecksCreateSuiteResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ChecksCreateSuiteResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksCreateSuiteResponseDataRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ChecksCreateSuiteResponseDataAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksCreateSuiteResponseDataAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksCreateSuiteResponseDataApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksCreateSuiteResponseDataAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksCreateSuiteResponseDataAppPermissions;
  events: Array<string>;
};
type ChecksCreateSuiteResponseData = {
  id: number;
  node_id: string;
  head_branch: string;
  head_sha: string;
  status: string;
  conclusion: string;
  url: string;
  before: string;
  after: string;
  pull_requests: Array<any>;
  app: ChecksCreateSuiteResponseDataApp;
  repository: ChecksCreateSuiteResponseDataRepository;
};

type ChecksSetSuitesPreferencesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://developer.github.com/v3/checks/suites/#auto_trigger_checks-object) description for details.
   */
  auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];
} & RequiredPreview<"antiope">;

type ChecksSetSuitesPreferencesRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/check-suites/preferences";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksSetSuitesPreferencesResponseDataRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ChecksSetSuitesPreferencesResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ChecksSetSuitesPreferencesResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ChecksSetSuitesPreferencesResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksSetSuitesPreferencesResponseDataRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ChecksSetSuitesPreferencesResponseDataPreferencesAutoTriggerChecksItem = {
  app_id: number;
  setting: boolean;
};
type ChecksSetSuitesPreferencesResponseDataPreferences = {
  auto_trigger_checks: Array<
    ChecksSetSuitesPreferencesResponseDataPreferencesAutoTriggerChecksItem
  >;
};
type ChecksSetSuitesPreferencesResponseData = {
  preferences: ChecksSetSuitesPreferencesResponseDataPreferences;
  repository: ChecksSetSuitesPreferencesResponseDataRepository;
};

type ChecksGetSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_suite_id parameter
   */
  check_suite_id: number;
} & RequiredPreview<"antiope">;

type ChecksGetSuiteRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/check-suites/:check_suite_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksGetSuiteResponseDataRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ChecksGetSuiteResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ChecksGetSuiteResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ChecksGetSuiteResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksGetSuiteResponseDataRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ChecksGetSuiteResponseDataAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksGetSuiteResponseDataAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksGetSuiteResponseDataApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksGetSuiteResponseDataAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksGetSuiteResponseDataAppPermissions;
  events: Array<string>;
};
type ChecksGetSuiteResponseData = {
  id: number;
  node_id: string;
  head_branch: string;
  head_sha: string;
  status: string;
  conclusion: string;
  url: string;
  before: string;
  after: string;
  pull_requests: Array<any>;
  app: ChecksGetSuiteResponseDataApp;
  repository: ChecksGetSuiteResponseDataRepository;
};

type ChecksListForSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_suite_id parameter
   */
  check_suite_id: number;
  /**
   * Returns check runs with the specified `name`.
   */
  check_name?: string;
  /**
   * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
   */
  filter?: "latest" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"antiope">;

type ChecksListForSuiteRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/check-suites/:check_suite_id/check-runs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBaseRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBase = {
  ref: string;
  sha: string;
  repo: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBaseRepo;
};
type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHeadRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHead = {
  ref: string;
  sha: string;
  repo: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHeadRepo;
};
type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItem = {
  url: string;
  id: number;
  number: number;
  head: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHead;
  base: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBase;
};
type ChecksListForSuiteResponseDataCheckRunsItemAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksListForSuiteResponseDataCheckRunsItemAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksListForSuiteResponseDataCheckRunsItemApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksListForSuiteResponseDataCheckRunsItemAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksListForSuiteResponseDataCheckRunsItemAppPermissions;
  events: Array<string>;
};
type ChecksListForSuiteResponseDataCheckRunsItemCheckSuite = { id: number };
type ChecksListForSuiteResponseDataCheckRunsItemOutput = {
  title: string;
  summary: string;
  text: string;
  annotations_count: number;
  annotations_url: string;
};
type ChecksListForSuiteResponseDataCheckRunsItem = {
  id: number;
  head_sha: string;
  node_id: string;
  external_id: string;
  url: string;
  html_url: string;
  details_url: string;
  status: string;
  conclusion: string;
  started_at: string;
  completed_at: string;
  output: ChecksListForSuiteResponseDataCheckRunsItemOutput;
  name: string;
  check_suite: ChecksListForSuiteResponseDataCheckRunsItemCheckSuite;
  app: ChecksListForSuiteResponseDataCheckRunsItemApp;
  pull_requests: Array<
    ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItem
  >;
};
type ChecksListForSuiteResponseData = {
  total_count: number;
  check_runs: Array<ChecksListForSuiteResponseDataCheckRunsItem>;
};

type ChecksRerequestSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_suite_id parameter
   */
  check_suite_id: number;
} & RequiredPreview<"antiope">;

type ChecksRerequestSuiteRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/check-suites/:check_suite_id/rerequest";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListCollaboratorsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Filter collaborators returned by their affiliation. Can be one of:
   * \* `outside`: All outside collaborators of an organization-owned repository.
   * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
   * \* `all`: All collaborators the authenticated user can see.
   */
  affiliation?: "outside" | "direct" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListCollaboratorsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/collaborators";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCollaboratorsResponseDataItemPermissions = {
  pull: boolean;
  push: boolean;
  admin: boolean;
};
type ReposListCollaboratorsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
  permissions: ReposListCollaboratorsResponseDataItemPermissions;
};
type ReposListCollaboratorsResponseData = Array<
  ReposListCollaboratorsResponseDataItem
>;

type ReposCheckCollaboratorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
};

type ReposCheckCollaboratorRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposAddCollaboratorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
  /**
   * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
   * \* `pull` - can pull, but not push to or administer this repository.
   * \* `push` - can pull and push, but not administer this repository.
   * \* `admin` - can pull, push and administer this repository.
   * \* `maintain` - Recommended for project managers who need to manage the repository without access to sensitive or destructive actions.
   * \* `triage` - Recommended for contributors who need to proactively manage issues and pull requests without write access.
   */
  permission?: "pull" | "push" | "admin" | "maintain" | "triage";
};

type ReposAddCollaboratorRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddCollaboratorResponseDataInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposAddCollaboratorResponseDataInvitee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposAddCollaboratorResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposAddCollaboratorResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposAddCollaboratorResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ReposAddCollaboratorResponseData = {
  id: number;
  repository: ReposAddCollaboratorResponseDataRepository;
  invitee: ReposAddCollaboratorResponseDataInvitee;
  inviter: ReposAddCollaboratorResponseDataInviter;
  permissions: string;
  created_at: string;
  url: string;
  html_url: string;
};

type ReposRemoveCollaboratorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
};

type ReposRemoveCollaboratorRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/collaborators/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetCollaboratorPermissionLevelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
};

type ReposGetCollaboratorPermissionLevelRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/collaborators/:username/permission";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCollaboratorPermissionLevelResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetCollaboratorPermissionLevelResponseData = {
  permission: string;
  user: ReposGetCollaboratorPermissionLevelResponseDataUser;
};

type ReposListCommitCommentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListCommitCommentsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCommitCommentsResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListCommitCommentsResponseDataItem = {
  html_url: string;
  url: string;
  id: number;
  node_id: string;
  body: string;
  path: string;
  position: number;
  line: number;
  commit_id: string;
  user: ReposListCommitCommentsResponseDataItemUser;
  created_at: string;
  updated_at: string;
};
type ReposListCommitCommentsResponseData = Array<
  ReposListCommitCommentsResponseDataItem
>;

type ReposGetCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type ReposGetCommitCommentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCommitCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetCommitCommentResponseData = {
  html_url: string;
  url: string;
  id: number;
  node_id: string;
  body: string;
  path: string;
  position: number;
  line: number;
  commit_id: string;
  user: ReposGetCommitCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type ReposUpdateCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The contents of the comment
   */
  body: string;
};

type ReposUpdateCommitCommentRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateCommitCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateCommitCommentResponseData = {
  html_url: string;
  url: string;
  id: number;
  node_id: string;
  body: string;
  path: string;
  position: number;
  line: number;
  commit_id: string;
  user: ReposUpdateCommitCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type ReposDeleteCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type ReposDeleteCommitCommentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForCommitCommentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/comments/:comment_id/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForCommitCommentResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForCommitCommentResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForCommitCommentResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForCommitCommentResponseData = Array<
  ReactionsListForCommitCommentResponseDataItem
>;

type ReactionsCreateForCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForCommitCommentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/comments/:comment_id/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForCommitCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForCommitCommentResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForCommitCommentResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsDeleteForCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteForCommitCommentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/comments/:comment_id/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListCommitsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
   */
  sha?: string;
  /**
   * Only commits containing this file path will be returned.
   */
  path?: string;
  /**
   * GitHub login or email address by which to filter by commit author.
   */
  author?: string;
  /**
   * Only commits after this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  until?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListCommitsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCommitsResponseDataItemParentsItem = { url: string; sha: string };
type ReposListCommitsResponseDataItemCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListCommitsResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListCommitsResponseDataItemCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposListCommitsResponseDataItemCommitTree = { url: string; sha: string };
type ReposListCommitsResponseDataItemCommitCommitter = {
  name: string;
  email: string;
  date: string;
};
type ReposListCommitsResponseDataItemCommitAuthor = {
  name: string;
  email: string;
  date: string;
};
type ReposListCommitsResponseDataItemCommit = {
  url: string;
  author: ReposListCommitsResponseDataItemCommitAuthor;
  committer: ReposListCommitsResponseDataItemCommitCommitter;
  message: string;
  tree: ReposListCommitsResponseDataItemCommitTree;
  comment_count: number;
  verification: ReposListCommitsResponseDataItemCommitVerification;
};
type ReposListCommitsResponseDataItem = {
  url: string;
  sha: string;
  node_id: string;
  html_url: string;
  comments_url: string;
  commit: ReposListCommitsResponseDataItemCommit;
  author: ReposListCommitsResponseDataItemAuthor;
  committer: ReposListCommitsResponseDataItemCommitter;
  parents: Array<ReposListCommitsResponseDataItemParentsItem>;
};
type ReposListCommitsResponseData = Array<ReposListCommitsResponseDataItem>;

type ReposListBranchesForHeadCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
} & RequiredPreview<"groot">;

type ReposListBranchesForHeadCommitRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:commit_sha/branches-where-head";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListBranchesForHeadCommitResponseDataItemCommit = {
  sha: string;
  url: string;
};
type ReposListBranchesForHeadCommitResponseDataItem = {
  name: string;
  commit: ReposListBranchesForHeadCommitResponseDataItemCommit;
  protected: string;
};
type ReposListBranchesForHeadCommitResponseData = Array<
  ReposListBranchesForHeadCommitResponseDataItem
>;

type ReposListCommentsForCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListCommentsForCommitRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:commit_sha/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCommentsForCommitResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListCommentsForCommitResponseDataItem = {
  html_url: string;
  url: string;
  id: number;
  node_id: string;
  body: string;
  path: string;
  position: number;
  line: number;
  commit_id: string;
  user: ReposListCommentsForCommitResponseDataItemUser;
  created_at: string;
  updated_at: string;
};
type ReposListCommentsForCommitResponseData = Array<
  ReposListCommentsForCommitResponseDataItem
>;

type ReposCreateCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
  /**
   * The contents of the comment.
   */
  body: string;
  /**
   * Relative path of the file to comment on.
   */
  path?: string;
  /**
   * Line index in the diff to comment on.
   */
  position?: number;
  /**
   * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
   */
  line?: number;
};

type ReposCreateCommitCommentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/commits/:commit_sha/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateCommitCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateCommitCommentResponseData = {
  html_url: string;
  url: string;
  id: number;
  node_id: string;
  body: string;
  path: string;
  position: number;
  line: number;
  commit_id: string;
  user: ReposCreateCommitCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type ReposListPullRequestsAssociatedWithCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"groot">;

type ReposListPullRequestsAssociatedWithCommitRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:commit_sha/pulls";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksStatuses = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksCommits = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComment = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComments = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksComments = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksIssue = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksHtml = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksSelf = {
  href: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinks = {
  self: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksSelf;
  html: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksHtml;
  issue: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksIssue;
  comments: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksComments;
  review_comments: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComments;
  review_comment: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComment;
  commits: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksCommits;
  statuses: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksStatuses;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemBase = {
  label: string;
  ref: string;
  sha: string;
  user: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseUser;
  repo: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepo;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemHead = {
  label: string;
  ref: string;
  sha: string;
  user: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadUser;
  repo: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepo;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedReviewersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  number: number;
  state: string;
  locked: boolean;
  title: string;
  user: ReposListPullRequestsAssociatedWithCommitResponseDataItemUser;
  body: string;
  labels: Array<
    ReposListPullRequestsAssociatedWithCommitResponseDataItemLabelsItem
  >;
  milestone: ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestone;
  active_lock_reason: string;
  created_at: string;
  updated_at: string;
  closed_at: string;
  merged_at: string;
  merge_commit_sha: string;
  assignee: ReposListPullRequestsAssociatedWithCommitResponseDataItemAssignee;
  assignees: Array<
    ReposListPullRequestsAssociatedWithCommitResponseDataItemAssigneesItem
  >;
  requested_reviewers: Array<
    ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedReviewersItem
  >;
  requested_teams: Array<
    ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedTeamsItem
  >;
  head: ReposListPullRequestsAssociatedWithCommitResponseDataItemHead;
  base: ReposListPullRequestsAssociatedWithCommitResponseDataItemBase;
  _links: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinks;
  author_association: string;
  draft: boolean;
};
type ReposListPullRequestsAssociatedWithCommitResponseData = Array<
  ReposListPullRequestsAssociatedWithCommitResponseDataItem
>;

type ReposGetCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};

type ReposGetCommitRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:ref";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCommitResponseDataFilesItem = {
  filename: string;
  additions: number;
  deletions: number;
  changes: number;
  status: string;
  raw_url: string;
  blob_url: string;
  patch: string;
};
type ReposGetCommitResponseDataStats = {
  additions: number;
  deletions: number;
  total: number;
};
type ReposGetCommitResponseDataParentsItem = { url: string; sha: string };
type ReposGetCommitResponseDataCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetCommitResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetCommitResponseDataCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposGetCommitResponseDataCommitTree = { url: string; sha: string };
type ReposGetCommitResponseDataCommitCommitter = {
  name: string;
  email: string;
  date: string;
};
type ReposGetCommitResponseDataCommitAuthor = {
  name: string;
  email: string;
  date: string;
};
type ReposGetCommitResponseDataCommit = {
  url: string;
  author: ReposGetCommitResponseDataCommitAuthor;
  committer: ReposGetCommitResponseDataCommitCommitter;
  message: string;
  tree: ReposGetCommitResponseDataCommitTree;
  comment_count: number;
  verification: ReposGetCommitResponseDataCommitVerification;
};
type ReposGetCommitResponseData = {
  url: string;
  sha: string;
  node_id: string;
  html_url: string;
  comments_url: string;
  commit: ReposGetCommitResponseDataCommit;
  author: ReposGetCommitResponseDataAuthor;
  committer: ReposGetCommitResponseDataCommitter;
  parents: Array<ReposGetCommitResponseDataParentsItem>;
  stats: ReposGetCommitResponseDataStats;
  files: Array<ReposGetCommitResponseDataFilesItem>;
};

type ChecksListForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Returns check runs with the specified `name`.
   */
  check_name?: string;
  /**
   * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
   */
  filter?: "latest" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"antiope">;

type ChecksListForRefRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:ref/check-runs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBaseRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBase = {
  ref: string;
  sha: string;
  repo: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBaseRepo;
};
type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHeadRepo = {
  id: number;
  url: string;
  name: string;
};
type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHead = {
  ref: string;
  sha: string;
  repo: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHeadRepo;
};
type ChecksListForRefResponseDataCheckRunsItemPullRequestsItem = {
  url: string;
  id: number;
  number: number;
  head: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHead;
  base: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBase;
};
type ChecksListForRefResponseDataCheckRunsItemAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksListForRefResponseDataCheckRunsItemAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksListForRefResponseDataCheckRunsItemApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksListForRefResponseDataCheckRunsItemAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksListForRefResponseDataCheckRunsItemAppPermissions;
  events: Array<string>;
};
type ChecksListForRefResponseDataCheckRunsItemCheckSuite = { id: number };
type ChecksListForRefResponseDataCheckRunsItemOutput = {
  title: string;
  summary: string;
  text: string;
  annotations_count: number;
  annotations_url: string;
};
type ChecksListForRefResponseDataCheckRunsItem = {
  id: number;
  head_sha: string;
  node_id: string;
  external_id: string;
  url: string;
  html_url: string;
  details_url: string;
  status: string;
  conclusion: string;
  started_at: string;
  completed_at: string;
  output: ChecksListForRefResponseDataCheckRunsItemOutput;
  name: string;
  check_suite: ChecksListForRefResponseDataCheckRunsItemCheckSuite;
  app: ChecksListForRefResponseDataCheckRunsItemApp;
  pull_requests: Array<
    ChecksListForRefResponseDataCheckRunsItemPullRequestsItem
  >;
};
type ChecksListForRefResponseData = {
  total_count: number;
  check_runs: Array<ChecksListForRefResponseDataCheckRunsItem>;
};

type ChecksListSuitesForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Filters check suites by GitHub App `id`.
   */
  app_id?: number;
  /**
   * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
   */
  check_name?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"antiope">;

type ChecksListSuitesForRefRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:ref/check-suites";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItemAppPermissions = {
  metadata: string;
  contents: string;
  issues: string;
  single_file: string;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItemAppOwner = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItemApp = {
  id: number;
  slug: string;
  node_id: string;
  owner: ChecksListSuitesForRefResponseDataCheckSuitesItemAppOwner;
  name: string;
  description: string;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  permissions: ChecksListSuitesForRefResponseDataCheckSuitesItemAppPermissions;
  events: Array<string>;
};
type ChecksListSuitesForRefResponseDataCheckSuitesItem = {
  id: number;
  node_id: string;
  head_branch: string;
  head_sha: string;
  status: string;
  conclusion: string;
  url: string;
  before: string;
  after: string;
  pull_requests: Array<any>;
  app: ChecksListSuitesForRefResponseDataCheckSuitesItemApp;
  repository: ChecksListSuitesForRefResponseDataCheckSuitesItemRepository;
};
type ChecksListSuitesForRefResponseData = {
  total_count: number;
  check_suites: Array<ChecksListSuitesForRefResponseDataCheckSuitesItem>;
};

type ReposGetCombinedStatusForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};

type ReposGetCombinedStatusForRefRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:ref/status";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCombinedStatusForRefResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetCombinedStatusForRefResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposGetCombinedStatusForRefResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ReposGetCombinedStatusForRefResponseDataStatusesItem = {
  url: string;
  avatar_url: string;
  id: number;
  node_id: string;
  state: string;
  description: string;
  target_url: string;
  context: string;
  created_at: string;
  updated_at: string;
};
type ReposGetCombinedStatusForRefResponseData = {
  state: string;
  statuses: Array<ReposGetCombinedStatusForRefResponseDataStatusesItem>;
  sha: string;
  total_count: number;
  repository: ReposGetCombinedStatusForRefResponseDataRepository;
  commit_url: string;
  url: string;
};

type ReposListStatusesForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListStatusesForRefRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/commits/:ref/statuses";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListStatusesForRefResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListStatusesForRefResponseDataItem = {
  url: string;
  avatar_url: string;
  id: number;
  node_id: string;
  state: string;
  description: string;
  target_url: string;
  context: string;
  created_at: string;
  updated_at: string;
  creator: ReposListStatusesForRefResponseDataItemCreator;
};
type ReposListStatusesForRefResponseData = Array<
  ReposListStatusesForRefResponseDataItem
>;

type CodesOfConductGetForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"scarlet-witch">;

type CodesOfConductGetForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/community/code_of_conduct";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type CodesOfConductGetForRepoResponseData = {
  key: string;
  name: string;
  url: string;
  body: string;
};

type ReposRetrieveCommunityProfileMetricsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposRetrieveCommunityProfileMetricsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/community/profile";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFilesReadme = {
  url: string;
  html_url: string;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFilesLicense = {
  name: string;
  key: string;
  spdx_id: string;
  url: string;
  html_url: string;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFilesPullRequestTemplate = {
  url: string;
  html_url: string;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFilesIssueTemplate = {
  url: string;
  html_url: string;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFilesContributing = {
  url: string;
  html_url: string;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFilesCodeOfConduct = {
  name: string;
  key: string;
  url: string;
  html_url: string;
};
type ReposRetrieveCommunityProfileMetricsResponseDataFiles = {
  code_of_conduct: ReposRetrieveCommunityProfileMetricsResponseDataFilesCodeOfConduct;
  contributing: ReposRetrieveCommunityProfileMetricsResponseDataFilesContributing;
  issue_template: ReposRetrieveCommunityProfileMetricsResponseDataFilesIssueTemplate;
  pull_request_template: ReposRetrieveCommunityProfileMetricsResponseDataFilesPullRequestTemplate;
  license: ReposRetrieveCommunityProfileMetricsResponseDataFilesLicense;
  readme: ReposRetrieveCommunityProfileMetricsResponseDataFilesReadme;
};
type ReposRetrieveCommunityProfileMetricsResponseData = {
  health_percentage: number;
  description: string;
  documentation: boolean;
  files: ReposRetrieveCommunityProfileMetricsResponseDataFiles;
  updated_at: string;
};

type ReposCompareCommitsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * base parameter
   */
  base: string;
  /**
   * head parameter
   */
  head: string;
};

type ReposCompareCommitsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/compare/:base...:head";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCompareCommitsResponseDataFilesItem = {
  sha: string;
  filename: string;
  status: string;
  additions: number;
  deletions: number;
  changes: number;
  blob_url: string;
  raw_url: string;
  contents_url: string;
  patch: string;
};
type ReposCompareCommitsResponseDataCommitsItemParentsItem = {
  url: string;
  sha: string;
};
type ReposCompareCommitsResponseDataCommitsItemCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCompareCommitsResponseDataCommitsItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCompareCommitsResponseDataCommitsItemCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposCompareCommitsResponseDataCommitsItemCommitTree = {
  url: string;
  sha: string;
};
type ReposCompareCommitsResponseDataCommitsItemCommitCommitter = {
  name: string;
  email: string;
  date: string;
};
type ReposCompareCommitsResponseDataCommitsItemCommitAuthor = {
  name: string;
  email: string;
  date: string;
};
type ReposCompareCommitsResponseDataCommitsItemCommit = {
  url: string;
  author: ReposCompareCommitsResponseDataCommitsItemCommitAuthor;
  committer: ReposCompareCommitsResponseDataCommitsItemCommitCommitter;
  message: string;
  tree: ReposCompareCommitsResponseDataCommitsItemCommitTree;
  comment_count: number;
  verification: ReposCompareCommitsResponseDataCommitsItemCommitVerification;
};
type ReposCompareCommitsResponseDataCommitsItem = {
  url: string;
  sha: string;
  node_id: string;
  html_url: string;
  comments_url: string;
  commit: ReposCompareCommitsResponseDataCommitsItemCommit;
  author: ReposCompareCommitsResponseDataCommitsItemAuthor;
  committer: ReposCompareCommitsResponseDataCommitsItemCommitter;
  parents: Array<ReposCompareCommitsResponseDataCommitsItemParentsItem>;
};
type ReposCompareCommitsResponseDataMergeBaseCommitParentsItem = {
  url: string;
  sha: string;
};
type ReposCompareCommitsResponseDataMergeBaseCommitCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCompareCommitsResponseDataMergeBaseCommitAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCompareCommitsResponseDataMergeBaseCommitCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposCompareCommitsResponseDataMergeBaseCommitCommitTree = {
  url: string;
  sha: string;
};
type ReposCompareCommitsResponseDataMergeBaseCommitCommitCommitter = {
  name: string;
  email: string;
  date: string;
};
type ReposCompareCommitsResponseDataMergeBaseCommitCommitAuthor = {
  name: string;
  email: string;
  date: string;
};
type ReposCompareCommitsResponseDataMergeBaseCommitCommit = {
  url: string;
  author: ReposCompareCommitsResponseDataMergeBaseCommitCommitAuthor;
  committer: ReposCompareCommitsResponseDataMergeBaseCommitCommitCommitter;
  message: string;
  tree: ReposCompareCommitsResponseDataMergeBaseCommitCommitTree;
  comment_count: number;
  verification: ReposCompareCommitsResponseDataMergeBaseCommitCommitVerification;
};
type ReposCompareCommitsResponseDataMergeBaseCommit = {
  url: string;
  sha: string;
  node_id: string;
  html_url: string;
  comments_url: string;
  commit: ReposCompareCommitsResponseDataMergeBaseCommitCommit;
  author: ReposCompareCommitsResponseDataMergeBaseCommitAuthor;
  committer: ReposCompareCommitsResponseDataMergeBaseCommitCommitter;
  parents: Array<ReposCompareCommitsResponseDataMergeBaseCommitParentsItem>;
};
type ReposCompareCommitsResponseDataBaseCommitParentsItem = {
  url: string;
  sha: string;
};
type ReposCompareCommitsResponseDataBaseCommitCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCompareCommitsResponseDataBaseCommitAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCompareCommitsResponseDataBaseCommitCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposCompareCommitsResponseDataBaseCommitCommitTree = {
  url: string;
  sha: string;
};
type ReposCompareCommitsResponseDataBaseCommitCommitCommitter = {
  name: string;
  email: string;
  date: string;
};
type ReposCompareCommitsResponseDataBaseCommitCommitAuthor = {
  name: string;
  email: string;
  date: string;
};
type ReposCompareCommitsResponseDataBaseCommitCommit = {
  url: string;
  author: ReposCompareCommitsResponseDataBaseCommitCommitAuthor;
  committer: ReposCompareCommitsResponseDataBaseCommitCommitCommitter;
  message: string;
  tree: ReposCompareCommitsResponseDataBaseCommitCommitTree;
  comment_count: number;
  verification: ReposCompareCommitsResponseDataBaseCommitCommitVerification;
};
type ReposCompareCommitsResponseDataBaseCommit = {
  url: string;
  sha: string;
  node_id: string;
  html_url: string;
  comments_url: string;
  commit: ReposCompareCommitsResponseDataBaseCommitCommit;
  author: ReposCompareCommitsResponseDataBaseCommitAuthor;
  committer: ReposCompareCommitsResponseDataBaseCommitCommitter;
  parents: Array<ReposCompareCommitsResponseDataBaseCommitParentsItem>;
};
type ReposCompareCommitsResponseData = {
  url: string;
  html_url: string;
  permalink_url: string;
  diff_url: string;
  patch_url: string;
  base_commit: ReposCompareCommitsResponseDataBaseCommit;
  merge_base_commit: ReposCompareCommitsResponseDataMergeBaseCommit;
  status: string;
  ahead_by: number;
  behind_by: number;
  total_commits: number;
  commits: Array<ReposCompareCommitsResponseDataCommitsItem>;
  files: Array<ReposCompareCommitsResponseDataFilesItem>;
};

type ReposGetContentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
   */
  ref?: string;
};

type ReposGetContentsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/contents/:path";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetContentsResponseDataItemLinks = {
  self: string;
  git: string;
  html: string;
};
type ReposGetContentsResponseDataItem = {
  type: string;
  size: number;
  name: string;
  path: string;
  sha: string;
  url: string;
  git_url: string;
  html_url: string;
  download_url: string | null;
  _links: ReposGetContentsResponseDataItemLinks;
};
type ReposGetContentsResponseDataLinks = {
  git: string;
  self: string;
  html: string;
};
type ReposGetContentsResponseData =
  | {
      type: string;
      encoding?: string;
      size: number;
      name: string;
      path: string;
      content?: string;
      sha: string;
      url: string;
      git_url: string;
      html_url: string;
      download_url: string | null;
      _links: ReposGetContentsResponseDataLinks;
      target?: string;
      submodule_git_url?: string;
    }
  | Array<ReposGetContentsResponseDataItem>;

type ReposCreateOrUpdateFileEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The new file content, using Base64 encoding.
   */
  content: string;
  /**
   * **Required if you are updating a file**. The blob SHA of the file being replaced.
   */
  sha?: string;
  /**
   * The branch name. Default: the repository’s default branch (usually `master`)
   */
  branch?: string;
  /**
   * The person that committed the file. Default: the authenticated user.
   */
  committer?: ReposCreateOrUpdateFileParamsCommitter;
  /**
   * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
   */
  author?: ReposCreateOrUpdateFileParamsAuthor;
};

type ReposCreateOrUpdateFileRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/contents/:path";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateOrUpdateFileResponseDataCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposCreateOrUpdateFileResponseDataCommitParentsItem = {
  url: string;
  html_url: string;
  sha: string;
};
type ReposCreateOrUpdateFileResponseDataCommitTree = {
  url: string;
  sha: string;
};
type ReposCreateOrUpdateFileResponseDataCommitCommitter = {
  date: string;
  name: string;
  email: string;
};
type ReposCreateOrUpdateFileResponseDataCommitAuthor = {
  date: string;
  name: string;
  email: string;
};
type ReposCreateOrUpdateFileResponseDataCommit = {
  sha: string;
  node_id: string;
  url: string;
  html_url: string;
  author: ReposCreateOrUpdateFileResponseDataCommitAuthor;
  committer: ReposCreateOrUpdateFileResponseDataCommitCommitter;
  message: string;
  tree: ReposCreateOrUpdateFileResponseDataCommitTree;
  parents: Array<ReposCreateOrUpdateFileResponseDataCommitParentsItem>;
  verification: ReposCreateOrUpdateFileResponseDataCommitVerification;
};
type ReposCreateOrUpdateFileResponseDataContentLinks = {
  self: string;
  git: string;
  html: string;
};
type ReposCreateOrUpdateFileResponseDataContent = {
  name: string;
  path: string;
  sha: string;
  size: number;
  url: string;
  html_url: string;
  git_url: string;
  download_url: string;
  type: string;
  _links: ReposCreateOrUpdateFileResponseDataContentLinks;
};
type ReposCreateOrUpdateFileResponseData = {
  content: ReposCreateOrUpdateFileResponseDataContent;
  commit: ReposCreateOrUpdateFileResponseDataCommit;
};

type ReposDeleteFileEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The blob SHA of the file being replaced.
   */
  sha: string;
  /**
   * The branch name. Default: the repository’s default branch (usually `master`)
   */
  branch?: string;
  /**
   * object containing information about the committer.
   */
  committer?: ReposDeleteFileParamsCommitter;
  /**
   * object containing information about the author.
   */
  author?: ReposDeleteFileParamsAuthor;
};

type ReposDeleteFileRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/contents/:path";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteFileResponseDataCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposDeleteFileResponseDataCommitParentsItem = {
  url: string;
  html_url: string;
  sha: string;
};
type ReposDeleteFileResponseDataCommitTree = { url: string; sha: string };
type ReposDeleteFileResponseDataCommitCommitter = {
  date: string;
  name: string;
  email: string;
};
type ReposDeleteFileResponseDataCommitAuthor = {
  date: string;
  name: string;
  email: string;
};
type ReposDeleteFileResponseDataCommit = {
  sha: string;
  node_id: string;
  url: string;
  html_url: string;
  author: ReposDeleteFileResponseDataCommitAuthor;
  committer: ReposDeleteFileResponseDataCommitCommitter;
  message: string;
  tree: ReposDeleteFileResponseDataCommitTree;
  parents: Array<ReposDeleteFileResponseDataCommitParentsItem>;
  verification: ReposDeleteFileResponseDataCommitVerification;
};
type ReposDeleteFileResponseData = {
  content: null;
  commit: ReposDeleteFileResponseDataCommit;
};

type ReposListContributorsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Set to `1` or `true` to include anonymous contributors in results.
   */
  anon?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListContributorsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/contributors";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListContributorsResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
  contributions: number;
};
type ReposListContributorsResponseData = Array<
  ReposListContributorsResponseDataItem
>;

type ReposListDeploymentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The SHA recorded at creation time.
   */
  sha?: string;
  /**
   * The name of the ref. This can be a branch, tag, or SHA.
   */
  ref?: string;
  /**
   * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
   */
  task?: string;
  /**
   * The name of the environment that was deployed to (e.g., `staging` or `production`).
   */
  environment?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListDeploymentsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/deployments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDeploymentsResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListDeploymentsResponseDataItemPayload = { deploy: string };
type ReposListDeploymentsResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  sha: string;
  ref: string;
  task: string;
  payload: ReposListDeploymentsResponseDataItemPayload;
  original_environment: string;
  environment: string;
  description: string;
  creator: ReposListDeploymentsResponseDataItemCreator;
  created_at: string;
  updated_at: string;
  statuses_url: string;
  repository_url: string;
  transient_environment: boolean;
  production_environment: boolean;
};
type ReposListDeploymentsResponseData = Array<
  ReposListDeploymentsResponseDataItem
>;

type ReposCreateDeploymentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The ref to deploy. This can be a branch, tag, or SHA.
   */
  ref: string;
  /**
   * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
   */
  task?: string;
  /**
   * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
   */
  auto_merge?: boolean;
  /**
   * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
   */
  required_contexts?: string[];
  /**
   * JSON payload with extra information about the deployment.
   */
  payload?: string;
  /**
   * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
   */
  environment?: string;
  /**
   * Short description of the deployment.
   */
  description?: string;
  /**
   * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  transient_environment?: boolean;
  /**
   * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  production_environment?: boolean;
};

type ReposCreateDeploymentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/deployments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateDeploymentResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateDeploymentResponseDataPayload = { deploy: string };
type ReposCreateDeploymentResponseData = {
  url: string;
  id: number;
  node_id: string;
  sha: string;
  ref: string;
  task: string;
  payload: ReposCreateDeploymentResponseDataPayload;
  original_environment: string;
  environment: string;
  description: string;
  creator: ReposCreateDeploymentResponseDataCreator;
  created_at: string;
  updated_at: string;
  statuses_url: string;
  repository_url: string;
  transient_environment: boolean;
  production_environment: boolean;
};

type ReposGetDeploymentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
};

type ReposGetDeploymentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/deployments/:deployment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDeploymentResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetDeploymentResponseDataPayload = { deploy: string };
type ReposGetDeploymentResponseData = {
  url: string;
  id: number;
  node_id: string;
  sha: string;
  ref: string;
  task: string;
  payload: ReposGetDeploymentResponseDataPayload;
  original_environment: string;
  environment: string;
  description: string;
  creator: ReposGetDeploymentResponseDataCreator;
  created_at: string;
  updated_at: string;
  statuses_url: string;
  repository_url: string;
  transient_environment: boolean;
  production_environment: boolean;
};

type ReposDeleteDeploymentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
};

type ReposDeleteDeploymentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/deployments/:deployment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListDeploymentStatusesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListDeploymentStatusesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/deployments/:deployment_id/statuses";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDeploymentStatusesResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListDeploymentStatusesResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  state: string;
  creator: ReposListDeploymentStatusesResponseDataItemCreator;
  description: string;
  environment: string;
  target_url: string;
  created_at: string;
  updated_at: string;
  deployment_url: string;
  repository_url: string;
  environment_url: string;
  log_url: string;
};
type ReposListDeploymentStatusesResponseData = Array<
  ReposListDeploymentStatusesResponseDataItem
>;

type ReposCreateDeploymentStatusEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
  /**
   * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
   */
  state:
    | "error"
    | "failure"
    | "inactive"
    | "in_progress"
    | "queued"
    | "pending"
    | "success";
  /**
   * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
   */
  target_url?: string;
  /**
   * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  log_url?: string;
  /**
   * A short description of the status. The maximum description length is 140 characters.
   */
  description?: string;
  /**
   * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
   */
  environment?: "production" | "staging" | "qa";
  /**
   * Sets the URL for accessing your environment. Default: `""`
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  environment_url?: string;
  /**
   * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
   * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  auto_inactive?: boolean;
};

type ReposCreateDeploymentStatusRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/deployments/:deployment_id/statuses";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateDeploymentStatusResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateDeploymentStatusResponseData = {
  url: string;
  id: number;
  node_id: string;
  state: string;
  creator: ReposCreateDeploymentStatusResponseDataCreator;
  description: string;
  environment: string;
  target_url: string;
  created_at: string;
  updated_at: string;
  deployment_url: string;
  repository_url: string;
  environment_url: string;
  log_url: string;
};

type ReposGetDeploymentStatusEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
  /**
   * status_id parameter
   */
  status_id: number;
};

type ReposGetDeploymentStatusRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDeploymentStatusResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetDeploymentStatusResponseData = {
  url: string;
  id: number;
  node_id: string;
  state: string;
  creator: ReposGetDeploymentStatusResponseDataCreator;
  description: string;
  environment: string;
  target_url: string;
  created_at: string;
  updated_at: string;
  deployment_url: string;
  repository_url: string;
  environment_url: string;
  log_url: string;
};

type ReposCreateDispatchEventEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * **Required:** A custom webhook event name.
   */
  event_type?: string;
  /**
   * JSON payload with extra information about the webhook event that your action or worklow may use.
   */
  client_payload?: ReposCreateDispatchEventParamsClientPayload;
};

type ReposCreateDispatchEventRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/dispatches";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListDownloadsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListDownloadsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/downloads";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDownloadsResponseDataItem = {
  url: string;
  html_url: string;
  id: number;
  name: string;
  description: string;
  size: number;
  download_count: number;
  content_type: string;
};
type ReposListDownloadsResponseData = Array<ReposListDownloadsResponseDataItem>;

type ReposGetDownloadEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * download_id parameter
   */
  download_id: number;
};

type ReposGetDownloadRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/downloads/:download_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDownloadResponseData = {
  url: string;
  html_url: string;
  id: number;
  name: string;
  description: string;
  size: number;
  download_count: number;
  content_type: string;
};

type ReposDeleteDownloadEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * download_id parameter
   */
  download_id: number;
};

type ReposDeleteDownloadRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/downloads/:download_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ActivityListRepoEventsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListRepoEventsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListForksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
   */
  sort?: "newest" | "oldest" | "stargazers";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListForksRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/forks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListForksResponseDataItemLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type ReposListForksResponseDataItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposListForksResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListForksResponseDataItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposListForksResponseDataItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposListForksResponseDataItemPermissions;
  template_repository: null;
  temp_clone_token: string;
  subscribers_count: number;
  network_count: number;
  license: ReposListForksResponseDataItemLicense;
};
type ReposListForksResponseData = Array<ReposListForksResponseDataItem>;

type ReposCreateForkEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Optional parameter to specify the organization name if forking into an organization.
   */
  organization?: string;
};

type ReposCreateForkRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/forks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateForkResponseDataPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposCreateForkResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateForkResponseData = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposCreateForkResponseDataOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposCreateForkResponseDataPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};

type GitCreateBlobEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The new blob's content.
   */
  content: string;
  /**
   * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
   */
  encoding?: string;
};

type GitCreateBlobRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/git/blobs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateBlobResponseData = { url: string; sha: string };

type GitGetBlobEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * file_sha parameter
   */
  file_sha: string;
};

type GitGetBlobRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/git/blobs/:file_sha";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetBlobResponseData = {
  content: string;
  encoding: string;
  url: string;
  sha: string;
  size: number;
};

type GitCreateCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The commit message
   */
  message: string;
  /**
   * The SHA of the tree object this commit points to
   */
  tree: string;
  /**
   * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
   */
  parents: string[];
  /**
   * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
   */
  author?: GitCreateCommitParamsAuthor;
  /**
   * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
   */
  committer?: GitCreateCommitParamsCommitter;
  /**
   * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
   */
  signature?: string;
};

type GitCreateCommitRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/git/commits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateCommitResponseDataVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type GitCreateCommitResponseDataParentsItem = { url: string; sha: string };
type GitCreateCommitResponseDataTree = { url: string; sha: string };
type GitCreateCommitResponseDataCommitter = {
  date: string;
  name: string;
  email: string;
};
type GitCreateCommitResponseDataAuthor = {
  date: string;
  name: string;
  email: string;
};
type GitCreateCommitResponseData = {
  sha: string;
  node_id: string;
  url: string;
  author: GitCreateCommitResponseDataAuthor;
  committer: GitCreateCommitResponseDataCommitter;
  message: string;
  tree: GitCreateCommitResponseDataTree;
  parents: Array<GitCreateCommitResponseDataParentsItem>;
  verification: GitCreateCommitResponseDataVerification;
};

type GitGetCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
};

type GitGetCommitRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/git/commits/:commit_sha";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetCommitResponseDataVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type GitGetCommitResponseDataParentsItem = { url: string; sha: string };
type GitGetCommitResponseDataTree = { url: string; sha: string };
type GitGetCommitResponseDataCommitter = {
  date: string;
  name: string;
  email: string;
};
type GitGetCommitResponseDataAuthor = {
  date: string;
  name: string;
  email: string;
};
type GitGetCommitResponseData = {
  sha: string;
  url: string;
  author: GitGetCommitResponseDataAuthor;
  committer: GitGetCommitResponseDataCommitter;
  message: string;
  tree: GitGetCommitResponseDataTree;
  parents: Array<GitGetCommitResponseDataParentsItem>;
  verification: GitGetCommitResponseDataVerification;
};

type GitListMatchingRefsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type GitListMatchingRefsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/git/matching-refs/:ref";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitListMatchingRefsResponseDataItemObject = {
  type: string;
  sha: string;
  url: string;
};
type GitListMatchingRefsResponseDataItem = {
  ref: string;
  node_id: string;
  url: string;
  object: GitListMatchingRefsResponseDataItemObject;
};
type GitListMatchingRefsResponseData = Array<
  GitListMatchingRefsResponseDataItem
>;

type GitGetRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};

type GitGetRefRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/git/ref/:ref";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetRefResponseDataObject = { type: string; sha: string; url: string };
type GitGetRefResponseData = {
  ref: string;
  node_id: string;
  url: string;
  object: GitGetRefResponseDataObject;
};

type GitCreateRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
   */
  ref: string;
  /**
   * The SHA1 value for this reference.
   */
  sha: string;
};

type GitCreateRefRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/git/refs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateRefResponseDataObject = {
  type: string;
  sha: string;
  url: string;
};
type GitCreateRefResponseData = {
  ref: string;
  node_id: string;
  url: string;
  object: GitCreateRefResponseDataObject;
};

type GitUpdateRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * The SHA1 value to set this reference to
   */
  sha: string;
  /**
   * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
   */
  force?: boolean;
};

type GitUpdateRefRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/git/refs/:ref";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitUpdateRefResponseDataObject = {
  type: string;
  sha: string;
  url: string;
};
type GitUpdateRefResponseData = {
  ref: string;
  node_id: string;
  url: string;
  object: GitUpdateRefResponseDataObject;
};

type GitDeleteRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};

type GitDeleteRefRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/git/refs/:ref";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type GitCreateTagEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The tag's name. This is typically a version (e.g., "v0.0.1").
   */
  tag: string;
  /**
   * The tag message.
   */
  message: string;
  /**
   * The SHA of the git object this is tagging.
   */
  object: string;
  /**
   * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
   */
  type: "commit" | "tree" | "blob";
  /**
   * An object with information about the individual creating the tag.
   */
  tagger?: GitCreateTagParamsTagger;
};

type GitCreateTagRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/git/tags";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateTagResponseDataVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type GitCreateTagResponseDataObject = {
  type: string;
  sha: string;
  url: string;
};
type GitCreateTagResponseDataTagger = {
  name: string;
  email: string;
  date: string;
};
type GitCreateTagResponseData = {
  node_id: string;
  tag: string;
  sha: string;
  url: string;
  message: string;
  tagger: GitCreateTagResponseDataTagger;
  object: GitCreateTagResponseDataObject;
  verification: GitCreateTagResponseDataVerification;
};

type GitGetTagEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * tag_sha parameter
   */
  tag_sha: string;
};

type GitGetTagRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/git/tags/:tag_sha";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetTagResponseDataVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type GitGetTagResponseDataObject = { type: string; sha: string; url: string };
type GitGetTagResponseDataTagger = {
  name: string;
  email: string;
  date: string;
};
type GitGetTagResponseData = {
  node_id: string;
  tag: string;
  sha: string;
  url: string;
  message: string;
  tagger: GitGetTagResponseDataTagger;
  object: GitGetTagResponseDataObject;
  verification: GitGetTagResponseDataVerification;
};

type GitCreateTreeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
   */
  tree: GitCreateTreeParamsTree[];
  /**
   * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
   */
  base_tree?: string;
};

type GitCreateTreeRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/git/trees";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateTreeResponseDataTreeItem = {
  path: string;
  mode: string;
  type: string;
  size: number;
  sha: string;
  url: string;
};
type GitCreateTreeResponseData = {
  sha: string;
  url: string;
  tree: Array<GitCreateTreeResponseDataTreeItem>;
};

type GitGetTreeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * tree_sha parameter
   */
  tree_sha: string;
  /**
   * recursive parameter
   */
  recursive?: "1";
};

type GitGetTreeRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/git/trees/:tree_sha";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetTreeResponseDataTreeItem = {
  path: string;
  mode: string;
  type: string;
  size?: number;
  sha: string;
  url: string;
};
type GitGetTreeResponseData = {
  sha: string;
  url: string;
  tree: Array<GitGetTreeResponseDataTreeItem>;
  truncated: boolean;
};

type ReposListHooksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListHooksRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/hooks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListHooksResponseDataItemLastResponse = {
  code: null;
  status: string;
  message: null;
};
type ReposListHooksResponseDataItemConfig = {
  content_type: string;
  insecure_ssl: string;
  url: string;
};
type ReposListHooksResponseDataItem = {
  type: string;
  id: number;
  name: string;
  active: boolean;
  events: Array<string>;
  config: ReposListHooksResponseDataItemConfig;
  updated_at: string;
  created_at: string;
  url: string;
  test_url: string;
  ping_url: string;
  last_response: ReposListHooksResponseDataItemLastResponse;
};
type ReposListHooksResponseData = Array<ReposListHooksResponseDataItem>;

type ReposCreateHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
   */
  name?: string;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
   */
  config: ReposCreateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
   */
  events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};

type ReposCreateHookRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/hooks";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateHookResponseDataLastResponse = {
  code: null;
  status: string;
  message: null;
};
type ReposCreateHookResponseDataConfig = {
  content_type: string;
  insecure_ssl: string;
  url: string;
};
type ReposCreateHookResponseData = {
  type: string;
  id: number;
  name: string;
  active: boolean;
  events: Array<string>;
  config: ReposCreateHookResponseDataConfig;
  updated_at: string;
  created_at: string;
  url: string;
  test_url: string;
  ping_url: string;
  last_response: ReposCreateHookResponseDataLastResponse;
};

type ReposGetHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type ReposGetHookRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/hooks/:hook_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetHookResponseDataLastResponse = {
  code: null;
  status: string;
  message: null;
};
type ReposGetHookResponseDataConfig = {
  content_type: string;
  insecure_ssl: string;
  url: string;
};
type ReposGetHookResponseData = {
  type: string;
  id: number;
  name: string;
  active: boolean;
  events: Array<string>;
  config: ReposGetHookResponseDataConfig;
  updated_at: string;
  created_at: string;
  url: string;
  test_url: string;
  ping_url: string;
  last_response: ReposGetHookResponseDataLastResponse;
};

type ReposUpdateHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
   */
  config?: ReposUpdateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for. This replaces the entire array of events.
   */
  events?: string[];
  /**
   * Determines a list of events to be added to the list of events that the Hook triggers for.
   */
  add_events?: string[];
  /**
   * Determines a list of events to be removed from the list of events that the Hook triggers for.
   */
  remove_events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};

type ReposUpdateHookRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/hooks/:hook_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateHookResponseDataLastResponse = {
  code: null;
  status: string;
  message: null;
};
type ReposUpdateHookResponseDataConfig = {
  content_type: string;
  insecure_ssl: string;
  url: string;
};
type ReposUpdateHookResponseData = {
  type: string;
  id: number;
  name: string;
  active: boolean;
  events: Array<string>;
  config: ReposUpdateHookResponseDataConfig;
  updated_at: string;
  created_at: string;
  url: string;
  test_url: string;
  ping_url: string;
  last_response: ReposUpdateHookResponseDataLastResponse;
};

type ReposDeleteHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type ReposDeleteHookRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/hooks/:hook_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposPingHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type ReposPingHookRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/hooks/:hook_id/pings";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposTestPushHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};

type ReposTestPushHookRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/hooks/:hook_id/tests";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MigrationsStartImportEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The URL of the originating repository.
   */
  vcs_url: string;
  /**
   * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
   */
  vcs?: "subversion" | "git" | "mercurial" | "tfvc";
  /**
   * If authentication is required, the username to provide to `vcs_url`.
   */
  vcs_username?: string;
  /**
   * If authentication is required, the password to provide to `vcs_url`.
   */
  vcs_password?: string;
  /**
   * For a tfvc import, the name of the project that is being imported.
   */
  tfvc_project?: string;
};

type MigrationsStartImportRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/import";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsStartImportResponseData = {
  vcs: string;
  use_lfs: string;
  vcs_url: string;
  status: string;
  status_text: string;
  has_large_files: boolean;
  large_files_size: number;
  large_files_count: number;
  authors_count: number;
  percent: number;
  commit_count: number;
  url: string;
  html_url: string;
  authors_url: string;
  repository_url: string;
};

type MigrationsGetImportProgressEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type MigrationsGetImportProgressRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/import";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetImportProgressResponseData = {
  vcs: string;
  use_lfs: string;
  vcs_url: string;
  status: string;
  status_text: string;
  has_large_files: boolean;
  large_files_size: number;
  large_files_count: number;
  authors_count: number;
  url: string;
  html_url: string;
  authors_url: string;
  repository_url: string;
};

type MigrationsUpdateImportEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The username to provide to the originating repository.
   */
  vcs_username?: string;
  /**
   * The password to provide to the originating repository.
   */
  vcs_password?: string;
};

type MigrationsUpdateImportRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/import";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsUpdateImportResponseData = {
  vcs: string;
  use_lfs: string;
  vcs_url: string;
  status: string;
  url: string;
  html_url: string;
  authors_url: string;
  repository_url: string;
  tfvc_project?: string;
  status_text?: string;
  has_large_files?: boolean;
  large_files_size?: number;
  large_files_count?: number;
  authors_count?: number;
  percent?: number;
  commit_count?: number;
};

type MigrationsCancelImportEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type MigrationsCancelImportRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/import";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type MigrationsGetCommitAuthorsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
   */
  since?: string;
};

type MigrationsGetCommitAuthorsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/import/authors";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetCommitAuthorsResponseDataItem = {
  id: number;
  remote_id: string;
  remote_name: string;
  email: string;
  name: string;
  url: string;
  import_url: string;
};
type MigrationsGetCommitAuthorsResponseData = Array<
  MigrationsGetCommitAuthorsResponseDataItem
>;

type MigrationsMapCommitAuthorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * author_id parameter
   */
  author_id: number;
  /**
   * The new Git author email.
   */
  email?: string;
  /**
   * The new Git author name.
   */
  name?: string;
};

type MigrationsMapCommitAuthorRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/import/authors/:author_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsMapCommitAuthorResponseData = {
  id: number;
  remote_id: string;
  remote_name: string;
  email: string;
  name: string;
  url: string;
  import_url: string;
};

type MigrationsGetLargeFilesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type MigrationsGetLargeFilesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/import/large_files";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetLargeFilesResponseDataItem = {
  ref_name: string;
  path: string;
  oid: string;
  size: number;
};
type MigrationsGetLargeFilesResponseData = Array<
  MigrationsGetLargeFilesResponseDataItem
>;

type MigrationsSetLfsPreferenceEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
   */
  use_lfs: "opt_in" | "opt_out";
};

type MigrationsSetLfsPreferenceRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/import/lfs";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsSetLfsPreferenceResponseData = {
  vcs: string;
  use_lfs: string;
  vcs_url: string;
  status: string;
  status_text: string;
  has_large_files: boolean;
  large_files_size: number;
  large_files_count: number;
  authors_count: number;
  url: string;
  html_url: string;
  authors_url: string;
  repository_url: string;
};

type AppsGetRepoInstallationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"machine-man">;

type AppsGetRepoInstallationRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/installation";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetRepoInstallationResponseDataPermissions = {
  checks: string;
  metadata: string;
  contents: string;
};
type AppsGetRepoInstallationResponseDataAccount = {
  login: string;
  id: number;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type AppsGetRepoInstallationResponseData = {
  id: number;
  account: AppsGetRepoInstallationResponseDataAccount;
  repository_selection: string;
  access_tokens_url: string;
  repositories_url: string;
  html_url: string;
  app_id: number;
  target_id: number;
  target_type: string;
  permissions: AppsGetRepoInstallationResponseDataPermissions;
  events: Array<string>;
  created_at: string;
  updated_at: string;
  single_file_name: null;
};

type InteractionsGetRestrictionsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"sombra">;

type InteractionsGetRestrictionsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/interaction-limits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsGetRestrictionsForRepoResponseData = {
  limit: string;
  origin: string;
  expires_at: string;
};

type InteractionsAddOrUpdateRestrictionsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Specifies the group of GitHub users who can comment, open issues, or create pull requests for the given repository. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
   */
  limit: "existing_users" | "contributors_only" | "collaborators_only";
} & RequiredPreview<"sombra">;

type InteractionsAddOrUpdateRestrictionsForRepoRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/interaction-limits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsAddOrUpdateRestrictionsForRepoResponseData = {
  limit: string;
  origin: string;
  expires_at: string;
};

type InteractionsRemoveRestrictionsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"sombra">;

type InteractionsRemoveRestrictionsForRepoRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/interaction-limits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListInvitationsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListInvitationsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/invitations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListInvitationsResponseDataItemInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListInvitationsResponseDataItemInvitee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListInvitationsResponseDataItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListInvitationsResponseDataItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposListInvitationsResponseDataItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ReposListInvitationsResponseDataItem = {
  id: number;
  repository: ReposListInvitationsResponseDataItemRepository;
  invitee: ReposListInvitationsResponseDataItemInvitee;
  inviter: ReposListInvitationsResponseDataItemInviter;
  permissions: string;
  created_at: string;
  url: string;
  html_url: string;
};
type ReposListInvitationsResponseData = Array<
  ReposListInvitationsResponseDataItem
>;

type ReposDeleteInvitationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * invitation_id parameter
   */
  invitation_id: number;
};

type ReposDeleteInvitationRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/invitations/:invitation_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposUpdateInvitationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * invitation_id parameter
   */
  invitation_id: number;
  /**
   * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, `maintain`, `triage`, and `admin`.
   */
  permissions?: "read" | "write" | "maintain" | "triage" | "admin";
};

type ReposUpdateInvitationRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/invitations/:invitation_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateInvitationResponseDataInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateInvitationResponseDataInvitee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateInvitationResponseDataRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateInvitationResponseDataRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposUpdateInvitationResponseDataRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ReposUpdateInvitationResponseData = {
  id: number;
  repository: ReposUpdateInvitationResponseDataRepository;
  invitee: ReposUpdateInvitationResponseDataInvitee;
  inviter: ReposUpdateInvitationResponseDataInviter;
  permissions: string;
  created_at: string;
  url: string;
  html_url: string;
};

type IssuesListForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
   */
  milestone?: string;
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
   */
  assignee?: string;
  /**
   * The user that created the issue.
   */
  creator?: string;
  /**
   * A user that's mentioned in the issue.
   */
  mentioned?: string;
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListForRepoResponseDataItemPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesListForRepoResponseDataItemMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForRepoResponseDataItemMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesListForRepoResponseDataItemMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesListForRepoResponseDataItemAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForRepoResponseDataItemAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForRepoResponseDataItemLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListForRepoResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListForRepoResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesListForRepoResponseDataItemUser;
  labels: Array<IssuesListForRepoResponseDataItemLabelsItem>;
  assignee: IssuesListForRepoResponseDataItemAssignee;
  assignees: Array<IssuesListForRepoResponseDataItemAssigneesItem>;
  milestone: IssuesListForRepoResponseDataItemMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesListForRepoResponseDataItemPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
};
type IssuesListForRepoResponseData = Array<IssuesListForRepoResponseDataItem>;

type IssuesCreateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The title of the issue.
   */
  title: string;
  /**
   * The contents of the issue.
   */
  body?: string;
  /**
   * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
   */
  assignee?: string;
  /**
   * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
   */
  milestone?: number;
  /**
   * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
   */
  labels?: string[];
  /**
   * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
   */
  assignees?: string[];
};

type IssuesCreateRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/issues";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateResponseDataClosedBy = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateResponseDataPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesCreateResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesCreateResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesCreateResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesCreateResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateResponseData = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesCreateResponseDataUser;
  labels: Array<IssuesCreateResponseDataLabelsItem>;
  assignee: IssuesCreateResponseDataAssignee;
  assignees: Array<IssuesCreateResponseDataAssigneesItem>;
  milestone: IssuesCreateResponseDataMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesCreateResponseDataPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
  closed_by: IssuesCreateResponseDataClosedBy;
};

type IssuesListCommentsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Either `created` or `updated`.
   */
  sort?: "created" | "updated";
  /**
   * Either `asc` or `desc`. Ignored without the `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListCommentsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListCommentsForRepoResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListCommentsForRepoResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  body: string;
  user: IssuesListCommentsForRepoResponseDataItemUser;
  created_at: string;
  updated_at: string;
};
type IssuesListCommentsForRepoResponseData = Array<
  IssuesListCommentsForRepoResponseDataItem
>;

type IssuesGetCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type IssuesGetCommentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetCommentResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  body: string;
  user: IssuesGetCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type IssuesUpdateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The contents of the comment.
   */
  body: string;
};

type IssuesUpdateCommentRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/issues/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateCommentResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  body: string;
  user: IssuesUpdateCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type IssuesDeleteCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type IssuesDeleteCommentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForIssueCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForIssueCommentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForIssueCommentResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForIssueCommentResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForIssueCommentResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForIssueCommentResponseData = Array<
  ReactionsListForIssueCommentResponseDataItem
>;

type ReactionsCreateForIssueCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForIssueCommentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForIssueCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForIssueCommentResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForIssueCommentResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsDeleteForIssueCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteForIssueCommentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesListEventsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListEventsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEventsForRepoResponseDataItemIssuePullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesListEventsForRepoResponseDataItemIssueMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsForRepoResponseDataItemIssueMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesListEventsForRepoResponseDataItemIssueMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesListEventsForRepoResponseDataItemIssueAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsForRepoResponseDataItemIssueAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsForRepoResponseDataItemIssueLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListEventsForRepoResponseDataItemIssueUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsForRepoResponseDataItemIssue = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesListEventsForRepoResponseDataItemIssueUser;
  labels: Array<IssuesListEventsForRepoResponseDataItemIssueLabelsItem>;
  assignee: IssuesListEventsForRepoResponseDataItemIssueAssignee;
  assignees: Array<IssuesListEventsForRepoResponseDataItemIssueAssigneesItem>;
  milestone: IssuesListEventsForRepoResponseDataItemIssueMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesListEventsForRepoResponseDataItemIssuePullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
};
type IssuesListEventsForRepoResponseDataItemActor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsForRepoResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  actor: IssuesListEventsForRepoResponseDataItemActor;
  event: string;
  commit_id: string;
  commit_url: string;
  created_at: string;
  issue: IssuesListEventsForRepoResponseDataItemIssue;
};
type IssuesListEventsForRepoResponseData = Array<
  IssuesListEventsForRepoResponseDataItem
>;

type IssuesGetEventEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * event_id parameter
   */
  event_id: number;
};

type IssuesGetEventRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/events/:event_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetEventResponseDataIssuePullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesGetEventResponseDataIssueMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetEventResponseDataIssueMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesGetEventResponseDataIssueMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesGetEventResponseDataIssueAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetEventResponseDataIssueAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetEventResponseDataIssueLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesGetEventResponseDataIssueUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetEventResponseDataIssue = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesGetEventResponseDataIssueUser;
  labels: Array<IssuesGetEventResponseDataIssueLabelsItem>;
  assignee: IssuesGetEventResponseDataIssueAssignee;
  assignees: Array<IssuesGetEventResponseDataIssueAssigneesItem>;
  milestone: IssuesGetEventResponseDataIssueMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesGetEventResponseDataIssuePullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
};
type IssuesGetEventResponseDataActor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetEventResponseData = {
  id: number;
  node_id: string;
  url: string;
  actor: IssuesGetEventResponseDataActor;
  event: string;
  commit_id: string;
  commit_url: string;
  created_at: string;
  issue: IssuesGetEventResponseDataIssue;
};

type IssuesGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
};

type IssuesGetRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/:issue_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetResponseDataClosedBy = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetResponseDataPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesGetResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesGetResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesGetResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesGetResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetResponseData = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesGetResponseDataUser;
  labels: Array<IssuesGetResponseDataLabelsItem>;
  assignee: IssuesGetResponseDataAssignee;
  assignees: Array<IssuesGetResponseDataAssigneesItem>;
  milestone: IssuesGetResponseDataMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesGetResponseDataPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
  closed_by: IssuesGetResponseDataClosedBy;
};

type IssuesUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The title of the issue.
   */
  title?: string;
  /**
   * The contents of the issue.
   */
  body?: string;
  /**
   * Login for the user that this issue should be assigned to. **This field is deprecated.**
   */
  assignee?: string;
  /**
   * State of the issue. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
   */
  milestone?: number | null;
  /**
   * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
   */
  labels?: string[];
  /**
   * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
   */
  assignees?: string[];
};

type IssuesUpdateRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/issues/:issue_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateResponseDataClosedBy = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateResponseDataPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesUpdateResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesUpdateResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesUpdateResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesUpdateResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateResponseData = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesUpdateResponseDataUser;
  labels: Array<IssuesUpdateResponseDataLabelsItem>;
  assignee: IssuesUpdateResponseDataAssignee;
  assignees: Array<IssuesUpdateResponseDataAssigneesItem>;
  milestone: IssuesUpdateResponseDataMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesUpdateResponseDataPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
  closed_by: IssuesUpdateResponseDataClosedBy;
};

type IssuesAddAssigneesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
   */
  assignees?: string[];
};

type IssuesAddAssigneesRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/issues/:issue_number/assignees";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesAddAssigneesResponseDataPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesAddAssigneesResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesAddAssigneesResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesAddAssigneesResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesAddAssigneesResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesAddAssigneesResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesAddAssigneesResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesAddAssigneesResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesAddAssigneesResponseData = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesAddAssigneesResponseDataUser;
  labels: Array<IssuesAddAssigneesResponseDataLabelsItem>;
  assignee: IssuesAddAssigneesResponseDataAssignee;
  assignees: Array<IssuesAddAssigneesResponseDataAssigneesItem>;
  milestone: IssuesAddAssigneesResponseDataMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesAddAssigneesResponseDataPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
};

type IssuesRemoveAssigneesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
   */
  assignees?: string[];
};

type IssuesRemoveAssigneesRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/:issue_number/assignees";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesRemoveAssigneesResponseDataPullRequest = {
  url: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
};
type IssuesRemoveAssigneesResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesRemoveAssigneesResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesRemoveAssigneesResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesRemoveAssigneesResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesRemoveAssigneesResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesRemoveAssigneesResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesRemoveAssigneesResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesRemoveAssigneesResponseData = {
  id: number;
  node_id: string;
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  number: number;
  state: string;
  title: string;
  body: string;
  user: IssuesRemoveAssigneesResponseDataUser;
  labels: Array<IssuesRemoveAssigneesResponseDataLabelsItem>;
  assignee: IssuesRemoveAssigneesResponseDataAssignee;
  assignees: Array<IssuesRemoveAssigneesResponseDataAssigneesItem>;
  milestone: IssuesRemoveAssigneesResponseDataMilestone;
  locked: boolean;
  active_lock_reason: string;
  comments: number;
  pull_request: IssuesRemoveAssigneesResponseDataPullRequest;
  closed_at: null;
  created_at: string;
  updated_at: string;
};

type IssuesListCommentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListCommentsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/:issue_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListCommentsResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListCommentsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  body: string;
  user: IssuesListCommentsResponseDataItemUser;
  created_at: string;
  updated_at: string;
};
type IssuesListCommentsResponseData = Array<IssuesListCommentsResponseDataItem>;

type IssuesCreateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The contents of the comment.
   */
  body: string;
};

type IssuesCreateCommentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/issues/:issue_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateCommentResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  body: string;
  user: IssuesCreateCommentResponseDataUser;
  created_at: string;
  updated_at: string;
};

type IssuesListEventsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListEventsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/:issue_number/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEventsResponseDataItemActor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  actor: IssuesListEventsResponseDataItemActor;
  event: string;
  commit_id: string;
  commit_url: string;
  created_at: string;
};
type IssuesListEventsResponseData = Array<IssuesListEventsResponseDataItem>;

type IssuesListLabelsOnIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListLabelsOnIssueRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/:issue_number/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListLabelsOnIssueResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListLabelsOnIssueResponseData = Array<
  IssuesListLabelsOnIssueResponseDataItem
>;

type IssuesAddLabelsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
   */
  labels: string[];
};

type IssuesAddLabelsRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/issues/:issue_number/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesAddLabelsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesAddLabelsResponseData = Array<IssuesAddLabelsResponseDataItem>;

type IssuesReplaceAllLabelsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
   */
  labels?: string[];
};

type IssuesReplaceAllLabelsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/issues/:issue_number/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesReplaceAllLabelsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesReplaceAllLabelsResponseData = Array<
  IssuesReplaceAllLabelsResponseDataItem
>;

type IssuesRemoveAllLabelsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
};

type IssuesRemoveAllLabelsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/:issue_number/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesRemoveLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * name parameter
   */
  name: string;
};

type IssuesRemoveLabelRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/:issue_number/labels/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesRemoveLabelResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesRemoveLabelResponseData = Array<IssuesRemoveLabelResponseDataItem>;

type IssuesLockEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
   * \* `off-topic`
   * \* `too heated`
   * \* `resolved`
   * \* `spam`
   */
  lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
};

type IssuesLockRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/issues/:issue_number/lock";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesUnlockEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
};

type IssuesUnlockRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/:issue_number/lock";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForIssueRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/:issue_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForIssueResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForIssueResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForIssueResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForIssueResponseData = Array<
  ReactionsListForIssueResponseDataItem
>;

type ReactionsCreateForIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForIssueRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/issues/:issue_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForIssueResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForIssueResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForIssueResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsDeleteForIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteForIssueRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/issues/:issue_number/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesListEventsForTimelineEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"mockingbird">;

type IssuesListEventsForTimelineRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/issues/:issue_number/timeline";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEventsForTimelineResponseDataItemActor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListEventsForTimelineResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  actor: IssuesListEventsForTimelineResponseDataItemActor;
  event: string;
  commit_id: string;
  commit_url: string;
  created_at: string;
};
type IssuesListEventsForTimelineResponseData = Array<
  IssuesListEventsForTimelineResponseDataItem
>;

type ReposListDeployKeysEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListDeployKeysRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/keys";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDeployKeysResponseDataItem = {
  id: number;
  key: string;
  url: string;
  title: string;
  verified: boolean;
  created_at: string;
  read_only: boolean;
};
type ReposListDeployKeysResponseData = Array<
  ReposListDeployKeysResponseDataItem
>;

type ReposAddDeployKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * A name for the key.
   */
  title?: string;
  /**
   * The contents of the key.
   */
  key: string;
  /**
   * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
   *
   * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
   */
  read_only?: boolean;
};

type ReposAddDeployKeyRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/keys";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddDeployKeyResponseData = {
  id: number;
  key: string;
  url: string;
  title: string;
  verified: boolean;
  created_at: string;
  read_only: boolean;
};

type ReposGetDeployKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * key_id parameter
   */
  key_id: number;
};

type ReposGetDeployKeyRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/keys/:key_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDeployKeyResponseData = {
  id: number;
  key: string;
  url: string;
  title: string;
  verified: boolean;
  created_at: string;
  read_only: boolean;
};

type ReposRemoveDeployKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * key_id parameter
   */
  key_id: number;
};

type ReposRemoveDeployKeyRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/keys/:key_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesListLabelsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListLabelsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListLabelsForRepoResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListLabelsForRepoResponseData = Array<
  IssuesListLabelsForRepoResponseDataItem
>;

type IssuesCreateLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
   */
  name: string;
  /**
   * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
   */
  color: string;
  /**
   * A short description of the label.
   */
  description?: string;
};

type IssuesCreateLabelRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateLabelResponseData = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};

type IssuesGetLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
};

type IssuesGetLabelRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/labels/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetLabelResponseData = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};

type IssuesUpdateLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
  /**
   * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
   */
  new_name?: string;
  /**
   * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
   */
  color?: string;
  /**
   * A short description of the label.
   */
  description?: string;
};

type IssuesUpdateLabelRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/labels/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateLabelResponseData = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};

type IssuesDeleteLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
};

type IssuesDeleteLabelRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/labels/:name";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListLanguagesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposListLanguagesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/languages";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListLanguagesResponseData = { C: number; Python: number };

type LicensesGetForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type LicensesGetForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/license";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesGetForRepoResponseDataLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type LicensesGetForRepoResponseDataLinks = {
  self: string;
  git: string;
  html: string;
};
type LicensesGetForRepoResponseData = {
  name: string;
  path: string;
  sha: string;
  size: number;
  url: string;
  html_url: string;
  git_url: string;
  download_url: string;
  type: string;
  content: string;
  encoding: string;
  _links: LicensesGetForRepoResponseDataLinks;
  license: LicensesGetForRepoResponseDataLicense;
};

type ReposMergeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the base branch that the head will be merged into.
   */
  base: string;
  /**
   * The head to merge. This can be a branch name or a commit SHA1.
   */
  head: string;
  /**
   * Commit message to use for the merge commit. If omitted, a default message will be used.
   */
  commit_message?: string;
};

type ReposMergeRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/merges";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposMergeResponseDataParentsItem = { sha: string; url: string };
type ReposMergeResponseDataCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposMergeResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposMergeResponseDataCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type ReposMergeResponseDataCommitTree = { sha: string; url: string };
type ReposMergeResponseDataCommitCommitter = {
  name: string;
  date: string;
  email: string;
};
type ReposMergeResponseDataCommitAuthor = {
  name: string;
  date: string;
  email: string;
};
type ReposMergeResponseDataCommit = {
  author: ReposMergeResponseDataCommitAuthor;
  committer: ReposMergeResponseDataCommitCommitter;
  message: string;
  tree: ReposMergeResponseDataCommitTree;
  url: string;
  comment_count: number;
  verification: ReposMergeResponseDataCommitVerification;
};
type ReposMergeResponseData = {
  sha: string;
  node_id: string;
  commit: ReposMergeResponseDataCommit;
  url: string;
  html_url: string;
  comments_url: string;
  author: ReposMergeResponseDataAuthor;
  committer: ReposMergeResponseDataCommitter;
  parents: Array<ReposMergeResponseDataParentsItem>;
};

type IssuesListMilestonesForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The state of the milestone. Either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * What to sort results by. Either `due_on` or `completeness`.
   */
  sort?: "due_on" | "completeness";
  /**
   * The direction of the sort. Either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListMilestonesForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/milestones";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListMilestonesForRepoResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesListMilestonesForRepoResponseDataItem = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesListMilestonesForRepoResponseDataItemCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type IssuesListMilestonesForRepoResponseData = Array<
  IssuesListMilestonesForRepoResponseDataItem
>;

type IssuesCreateMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The title of the milestone.
   */
  title: string;
  /**
   * The state of the milestone. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * A description of the milestone.
   */
  description?: string;
  /**
   * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  due_on?: string;
};

type IssuesCreateMilestoneRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/milestones";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateMilestoneResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesCreateMilestoneResponseData = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesCreateMilestoneResponseDataCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};

type IssuesGetMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
};

type IssuesGetMilestoneRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/milestones/:milestone_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetMilestoneResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesGetMilestoneResponseData = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesGetMilestoneResponseDataCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};

type IssuesUpdateMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
  /**
   * The title of the milestone.
   */
  title?: string;
  /**
   * The state of the milestone. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * A description of the milestone.
   */
  description?: string;
  /**
   * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  due_on?: string;
};

type IssuesUpdateMilestoneRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/milestones/:milestone_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateMilestoneResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type IssuesUpdateMilestoneResponseData = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: IssuesUpdateMilestoneResponseDataCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};

type IssuesDeleteMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
};

type IssuesDeleteMilestoneRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/milestones/:milestone_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type IssuesListLabelsForMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type IssuesListLabelsForMilestoneRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/milestones/:milestone_number/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListLabelsForMilestoneResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type IssuesListLabelsForMilestoneResponseData = Array<
  IssuesListLabelsForMilestoneResponseDataItem
>;

type ActivityListRepoNotificationsForAuthenticatedUserEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * If `true`, show notifications marked as read.
   */
  all?: boolean;
  /**
   * If `true`, only shows notifications in which the user is directly participating or mentioned.
   */
  participating?: boolean;
  /**
   * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  before?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListRepoNotificationsForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/notifications";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemSubject = {
  title: string;
  url: string;
  latest_comment_url: string;
  type: string;
};
type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItem = {
  id: string;
  repository: ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepository;
  subject: ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemSubject;
  reason: string;
  unread: boolean;
  updated_at: string;
  last_read_at: string;
  url: string;
};
type ActivityListRepoNotificationsForAuthenticatedUserResponseData = Array<
  ActivityListRepoNotificationsForAuthenticatedUserResponseDataItem
>;

type ActivityMarkRepoNotificationsAsReadEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
   */
  last_read_at?: string;
};

type ActivityMarkRepoNotificationsAsReadRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/notifications";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetPagesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetPagesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pages";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetPagesResponseDataSource = { branch: string; directory: string };
type ReposGetPagesResponseData = {
  url: string;
  status: string;
  cname: string;
  custom_404: boolean;
  html_url: string;
  source: ReposGetPagesResponseDataSource;
};

type ReposEnablePagesSiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * source parameter
   */
  source?: ReposEnablePagesSiteParamsSource;
} & RequiredPreview<"switcheroo">;

type ReposEnablePagesSiteRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pages";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposEnablePagesSiteResponseDataSource = {
  branch: string;
  directory: string;
};
type ReposEnablePagesSiteResponseData = {
  url: string;
  status: string;
  cname: string;
  custom_404: boolean;
  html_url: string;
  source: ReposEnablePagesSiteResponseDataSource;
};

type ReposDisablePagesSiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"switcheroo">;

type ReposDisablePagesSiteRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/pages";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposUpdateInformationAboutPagesSiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
   */
  cname?: string;
  /**
   * Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `"gh-pages"`, `"master"`, and `"master /docs"`.
   */
  source?: '"gh-pages"' | '"master"' | '"master /docs"';
};

type ReposUpdateInformationAboutPagesSiteRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/pages";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposRequestPageBuildEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposRequestPageBuildRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pages/builds";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRequestPageBuildResponseData = { url: string; status: string };

type ReposListPagesBuildsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListPagesBuildsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pages/builds";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListPagesBuildsResponseDataItemPusher = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPagesBuildsResponseDataItemError = { message: null };
type ReposListPagesBuildsResponseDataItem = {
  url: string;
  status: string;
  error: ReposListPagesBuildsResponseDataItemError;
  pusher: ReposListPagesBuildsResponseDataItemPusher;
  commit: string;
  duration: number;
  created_at: string;
  updated_at: string;
};
type ReposListPagesBuildsResponseData = Array<
  ReposListPagesBuildsResponseDataItem
>;

type ReposGetLatestPagesBuildEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetLatestPagesBuildRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pages/builds/latest";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetLatestPagesBuildResponseDataPusher = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetLatestPagesBuildResponseDataError = { message: null };
type ReposGetLatestPagesBuildResponseData = {
  url: string;
  status: string;
  error: ReposGetLatestPagesBuildResponseDataError;
  pusher: ReposGetLatestPagesBuildResponseDataPusher;
  commit: string;
  duration: number;
  created_at: string;
  updated_at: string;
};

type ReposGetPagesBuildEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * build_id parameter
   */
  build_id: number;
};

type ReposGetPagesBuildRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pages/builds/:build_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetPagesBuildResponseDataPusher = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetPagesBuildResponseDataError = { message: null };
type ReposGetPagesBuildResponseData = {
  url: string;
  status: string;
  error: ReposGetPagesBuildResponseDataError;
  pusher: ReposGetPagesBuildResponseDataPusher;
  commit: string;
  duration: number;
  created_at: string;
  updated_at: string;
};

type ProjectsListForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type ProjectsListForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/projects";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListForRepoResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsListForRepoResponseDataItem = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: ProjectsListForRepoResponseDataItemCreator;
  created_at: string;
  updated_at: string;
};
type ProjectsListForRepoResponseData = Array<
  ProjectsListForRepoResponseDataItem
>;

type ProjectsCreateForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the project.
   */
  name: string;
  /**
   * The description of the project.
   */
  body?: string;
} & RequiredPreview<"inertia">;

type ProjectsCreateForRepoRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/projects";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateForRepoResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ProjectsCreateForRepoResponseData = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: ProjectsCreateForRepoResponseDataCreator;
  created_at: string;
  updated_at: string;
};

type PullsListEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Either `open`, `closed`, or `all` to filter by state.
   */
  state?: "open" | "closed" | "all";
  /**
   * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
   */
  head?: string;
  /**
   * Filter pulls by base branch name. Example: `gh-pages`.
   */
  base?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
   */
  sort?: "created" | "updated" | "popularity" | "long-running";
  /**
   * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListResponseDataItemLinksStatuses = { href: string };
type PullsListResponseDataItemLinksCommits = { href: string };
type PullsListResponseDataItemLinksReviewComment = { href: string };
type PullsListResponseDataItemLinksReviewComments = { href: string };
type PullsListResponseDataItemLinksComments = { href: string };
type PullsListResponseDataItemLinksIssue = { href: string };
type PullsListResponseDataItemLinksHtml = { href: string };
type PullsListResponseDataItemLinksSelf = { href: string };
type PullsListResponseDataItemLinks = {
  self: PullsListResponseDataItemLinksSelf;
  html: PullsListResponseDataItemLinksHtml;
  issue: PullsListResponseDataItemLinksIssue;
  comments: PullsListResponseDataItemLinksComments;
  review_comments: PullsListResponseDataItemLinksReviewComments;
  review_comment: PullsListResponseDataItemLinksReviewComment;
  commits: PullsListResponseDataItemLinksCommits;
  statuses: PullsListResponseDataItemLinksStatuses;
};
type PullsListResponseDataItemBaseRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsListResponseDataItemBaseRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemBaseRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsListResponseDataItemBaseRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsListResponseDataItemBaseRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsListResponseDataItemBaseUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemBase = {
  label: string;
  ref: string;
  sha: string;
  user: PullsListResponseDataItemBaseUser;
  repo: PullsListResponseDataItemBaseRepo;
};
type PullsListResponseDataItemHeadRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsListResponseDataItemHeadRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemHeadRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsListResponseDataItemHeadRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsListResponseDataItemHeadRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsListResponseDataItemHeadUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemHead = {
  label: string;
  ref: string;
  sha: string;
  user: PullsListResponseDataItemHeadUser;
  repo: PullsListResponseDataItemHeadRepo;
};
type PullsListResponseDataItemRequestedTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type PullsListResponseDataItemRequestedReviewersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItemMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: PullsListResponseDataItemMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type PullsListResponseDataItemLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type PullsListResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  number: number;
  state: string;
  locked: boolean;
  title: string;
  user: PullsListResponseDataItemUser;
  body: string;
  labels: Array<PullsListResponseDataItemLabelsItem>;
  milestone: PullsListResponseDataItemMilestone;
  active_lock_reason: string;
  created_at: string;
  updated_at: string;
  closed_at: string;
  merged_at: string;
  merge_commit_sha: string;
  assignee: PullsListResponseDataItemAssignee;
  assignees: Array<PullsListResponseDataItemAssigneesItem>;
  requested_reviewers: Array<PullsListResponseDataItemRequestedReviewersItem>;
  requested_teams: Array<PullsListResponseDataItemRequestedTeamsItem>;
  head: PullsListResponseDataItemHead;
  base: PullsListResponseDataItemBase;
  _links: PullsListResponseDataItemLinks;
  author_association: string;
  draft: boolean;
};
type PullsListResponseData = Array<PullsListResponseDataItem>;

type PullsCreateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The title of the new pull request.
   */
  title: string;
  /**
   * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
   */
  head: string;
  /**
   * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
   */
  base: string;
  /**
   * The contents of the pull request.
   */
  body?: string;
  /**
   * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
   */
  maintainer_can_modify?: boolean;
  /**
   * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
   */
  draft?: boolean;
};

type PullsCreateRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateResponseDataMergedBy = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataLinksStatuses = { href: string };
type PullsCreateResponseDataLinksCommits = { href: string };
type PullsCreateResponseDataLinksReviewComment = { href: string };
type PullsCreateResponseDataLinksReviewComments = { href: string };
type PullsCreateResponseDataLinksComments = { href: string };
type PullsCreateResponseDataLinksIssue = { href: string };
type PullsCreateResponseDataLinksHtml = { href: string };
type PullsCreateResponseDataLinksSelf = { href: string };
type PullsCreateResponseDataLinks = {
  self: PullsCreateResponseDataLinksSelf;
  html: PullsCreateResponseDataLinksHtml;
  issue: PullsCreateResponseDataLinksIssue;
  comments: PullsCreateResponseDataLinksComments;
  review_comments: PullsCreateResponseDataLinksReviewComments;
  review_comment: PullsCreateResponseDataLinksReviewComment;
  commits: PullsCreateResponseDataLinksCommits;
  statuses: PullsCreateResponseDataLinksStatuses;
};
type PullsCreateResponseDataBaseRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsCreateResponseDataBaseRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataBaseRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsCreateResponseDataBaseRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsCreateResponseDataBaseRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsCreateResponseDataBaseUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataBase = {
  label: string;
  ref: string;
  sha: string;
  user: PullsCreateResponseDataBaseUser;
  repo: PullsCreateResponseDataBaseRepo;
};
type PullsCreateResponseDataHeadRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsCreateResponseDataHeadRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataHeadRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsCreateResponseDataHeadRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsCreateResponseDataHeadRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsCreateResponseDataHeadUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataHead = {
  label: string;
  ref: string;
  sha: string;
  user: PullsCreateResponseDataHeadUser;
  repo: PullsCreateResponseDataHeadRepo;
};
type PullsCreateResponseDataRequestedTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type PullsCreateResponseDataRequestedReviewersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: PullsCreateResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type PullsCreateResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type PullsCreateResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateResponseData = {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  number: number;
  state: string;
  locked: boolean;
  title: string;
  user: PullsCreateResponseDataUser;
  body: string;
  labels: Array<PullsCreateResponseDataLabelsItem>;
  milestone: PullsCreateResponseDataMilestone;
  active_lock_reason: string;
  created_at: string;
  updated_at: string;
  closed_at: string;
  merged_at: string;
  merge_commit_sha: string;
  assignee: PullsCreateResponseDataAssignee;
  assignees: Array<PullsCreateResponseDataAssigneesItem>;
  requested_reviewers: Array<PullsCreateResponseDataRequestedReviewersItem>;
  requested_teams: Array<PullsCreateResponseDataRequestedTeamsItem>;
  head: PullsCreateResponseDataHead;
  base: PullsCreateResponseDataBase;
  _links: PullsCreateResponseDataLinks;
  author_association: string;
  draft: boolean;
  merged: boolean;
  mergeable: boolean;
  rebaseable: boolean;
  mergeable_state: string;
  merged_by: PullsCreateResponseDataMergedBy;
  comments: number;
  review_comments: number;
  maintainer_can_modify: boolean;
  commits: number;
  additions: number;
  deletions: number;
  changed_files: number;
};

type PullsListCommentsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Can be either `created` or `updated` comments.
   */
  sort?: "created" | "updated";
  /**
   * Can be either `asc` or `desc`. Ignored without `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListCommentsForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListCommentsForRepoResponseDataItemLinksPullRequest = {
  href: string;
};
type PullsListCommentsForRepoResponseDataItemLinksHtml = { href: string };
type PullsListCommentsForRepoResponseDataItemLinksSelf = { href: string };
type PullsListCommentsForRepoResponseDataItemLinks = {
  self: PullsListCommentsForRepoResponseDataItemLinksSelf;
  html: PullsListCommentsForRepoResponseDataItemLinksHtml;
  pull_request: PullsListCommentsForRepoResponseDataItemLinksPullRequest;
};
type PullsListCommentsForRepoResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListCommentsForRepoResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  pull_request_review_id: number;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  in_reply_to_id: number;
  user: PullsListCommentsForRepoResponseDataItemUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsListCommentsForRepoResponseDataItemLinks;
  start_line: number;
  original_start_line: number;
  start_side: string;
  line: number;
  original_line: number;
  side: string;
};
type PullsListCommentsForRepoResponseData = Array<
  PullsListCommentsForRepoResponseDataItem
>;

type PullsGetCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type PullsGetCommentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetCommentResponseDataLinksPullRequest = { href: string };
type PullsGetCommentResponseDataLinksHtml = { href: string };
type PullsGetCommentResponseDataLinksSelf = { href: string };
type PullsGetCommentResponseDataLinks = {
  self: PullsGetCommentResponseDataLinksSelf;
  html: PullsGetCommentResponseDataLinksHtml;
  pull_request: PullsGetCommentResponseDataLinksPullRequest;
};
type PullsGetCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetCommentResponseData = {
  url: string;
  id: number;
  node_id: string;
  pull_request_review_id: number;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  in_reply_to_id: number;
  user: PullsGetCommentResponseDataUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsGetCommentResponseDataLinks;
  start_line: number;
  original_start_line: number;
  start_side: string;
  line: number;
  original_line: number;
  side: string;
};

type PullsUpdateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The text of the reply to the review comment.
   */
  body: string;
};

type PullsUpdateCommentRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/pulls/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateCommentResponseDataLinksPullRequest = { href: string };
type PullsUpdateCommentResponseDataLinksHtml = { href: string };
type PullsUpdateCommentResponseDataLinksSelf = { href: string };
type PullsUpdateCommentResponseDataLinks = {
  self: PullsUpdateCommentResponseDataLinksSelf;
  html: PullsUpdateCommentResponseDataLinksHtml;
  pull_request: PullsUpdateCommentResponseDataLinksPullRequest;
};
type PullsUpdateCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateCommentResponseData = {
  url: string;
  id: number;
  node_id: string;
  pull_request_review_id: number;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  in_reply_to_id: number;
  user: PullsUpdateCommentResponseDataUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsUpdateCommentResponseDataLinks;
  start_line: number;
  original_start_line: number;
  start_side: string;
  line: number;
  original_line: number;
  side: string;
};

type PullsDeleteCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};

type PullsDeleteCommentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/pulls/comments/:comment_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForPullRequestReviewCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForPullRequestReviewCommentRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForPullRequestReviewCommentResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForPullRequestReviewCommentResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForPullRequestReviewCommentResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForPullRequestReviewCommentResponseData = Array<
  ReactionsListForPullRequestReviewCommentResponseDataItem
>;

type ReactionsCreateForPullRequestReviewCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForPullRequestReviewCommentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForPullRequestReviewCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForPullRequestReviewCommentResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForPullRequestReviewCommentResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsDeleteForPullRequestCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * reaction_id parameter
   */
  reaction_id: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsDeleteForPullRequestCommentRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions/:reaction_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type PullsGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
};

type PullsGetRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetResponseDataMergedBy = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataLinksStatuses = { href: string };
type PullsGetResponseDataLinksCommits = { href: string };
type PullsGetResponseDataLinksReviewComment = { href: string };
type PullsGetResponseDataLinksReviewComments = { href: string };
type PullsGetResponseDataLinksComments = { href: string };
type PullsGetResponseDataLinksIssue = { href: string };
type PullsGetResponseDataLinksHtml = { href: string };
type PullsGetResponseDataLinksSelf = { href: string };
type PullsGetResponseDataLinks = {
  self: PullsGetResponseDataLinksSelf;
  html: PullsGetResponseDataLinksHtml;
  issue: PullsGetResponseDataLinksIssue;
  comments: PullsGetResponseDataLinksComments;
  review_comments: PullsGetResponseDataLinksReviewComments;
  review_comment: PullsGetResponseDataLinksReviewComment;
  commits: PullsGetResponseDataLinksCommits;
  statuses: PullsGetResponseDataLinksStatuses;
};
type PullsGetResponseDataBaseRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsGetResponseDataBaseRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataBaseRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsGetResponseDataBaseRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsGetResponseDataBaseRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsGetResponseDataBaseUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataBase = {
  label: string;
  ref: string;
  sha: string;
  user: PullsGetResponseDataBaseUser;
  repo: PullsGetResponseDataBaseRepo;
};
type PullsGetResponseDataHeadRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsGetResponseDataHeadRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataHeadRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsGetResponseDataHeadRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsGetResponseDataHeadRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsGetResponseDataHeadUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataHead = {
  label: string;
  ref: string;
  sha: string;
  user: PullsGetResponseDataHeadUser;
  repo: PullsGetResponseDataHeadRepo;
};
type PullsGetResponseDataRequestedTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type PullsGetResponseDataRequestedReviewersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: PullsGetResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type PullsGetResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type PullsGetResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetResponseData = {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  number: number;
  state: string;
  locked: boolean;
  title: string;
  user: PullsGetResponseDataUser;
  body: string;
  labels: Array<PullsGetResponseDataLabelsItem>;
  milestone: PullsGetResponseDataMilestone;
  active_lock_reason: string;
  created_at: string;
  updated_at: string;
  closed_at: string;
  merged_at: string;
  merge_commit_sha: string;
  assignee: PullsGetResponseDataAssignee;
  assignees: Array<PullsGetResponseDataAssigneesItem>;
  requested_reviewers: Array<PullsGetResponseDataRequestedReviewersItem>;
  requested_teams: Array<PullsGetResponseDataRequestedTeamsItem>;
  head: PullsGetResponseDataHead;
  base: PullsGetResponseDataBase;
  _links: PullsGetResponseDataLinks;
  author_association: string;
  draft: boolean;
  merged: boolean;
  mergeable: boolean;
  rebaseable: boolean;
  mergeable_state: string;
  merged_by: PullsGetResponseDataMergedBy;
  comments: number;
  review_comments: number;
  maintainer_can_modify: boolean;
  commits: number;
  additions: number;
  deletions: number;
  changed_files: number;
};

type PullsUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The title of the pull request.
   */
  title?: string;
  /**
   * The contents of the pull request.
   */
  body?: string;
  /**
   * State of this Pull Request. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
   */
  base?: string;
  /**
   * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
   */
  maintainer_can_modify?: boolean;
};

type PullsUpdateRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/pulls/:pull_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateResponseDataMergedBy = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataLinksStatuses = { href: string };
type PullsUpdateResponseDataLinksCommits = { href: string };
type PullsUpdateResponseDataLinksReviewComment = { href: string };
type PullsUpdateResponseDataLinksReviewComments = { href: string };
type PullsUpdateResponseDataLinksComments = { href: string };
type PullsUpdateResponseDataLinksIssue = { href: string };
type PullsUpdateResponseDataLinksHtml = { href: string };
type PullsUpdateResponseDataLinksSelf = { href: string };
type PullsUpdateResponseDataLinks = {
  self: PullsUpdateResponseDataLinksSelf;
  html: PullsUpdateResponseDataLinksHtml;
  issue: PullsUpdateResponseDataLinksIssue;
  comments: PullsUpdateResponseDataLinksComments;
  review_comments: PullsUpdateResponseDataLinksReviewComments;
  review_comment: PullsUpdateResponseDataLinksReviewComment;
  commits: PullsUpdateResponseDataLinksCommits;
  statuses: PullsUpdateResponseDataLinksStatuses;
};
type PullsUpdateResponseDataBaseRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsUpdateResponseDataBaseRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataBaseRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsUpdateResponseDataBaseRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsUpdateResponseDataBaseRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsUpdateResponseDataBaseUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataBase = {
  label: string;
  ref: string;
  sha: string;
  user: PullsUpdateResponseDataBaseUser;
  repo: PullsUpdateResponseDataBaseRepo;
};
type PullsUpdateResponseDataHeadRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsUpdateResponseDataHeadRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataHeadRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsUpdateResponseDataHeadRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsUpdateResponseDataHeadRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsUpdateResponseDataHeadUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataHead = {
  label: string;
  ref: string;
  sha: string;
  user: PullsUpdateResponseDataHeadUser;
  repo: PullsUpdateResponseDataHeadRepo;
};
type PullsUpdateResponseDataRequestedTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type PullsUpdateResponseDataRequestedReviewersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: PullsUpdateResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type PullsUpdateResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type PullsUpdateResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateResponseData = {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  number: number;
  state: string;
  locked: boolean;
  title: string;
  user: PullsUpdateResponseDataUser;
  body: string;
  labels: Array<PullsUpdateResponseDataLabelsItem>;
  milestone: PullsUpdateResponseDataMilestone;
  active_lock_reason: string;
  created_at: string;
  updated_at: string;
  closed_at: string;
  merged_at: string;
  merge_commit_sha: string;
  assignee: PullsUpdateResponseDataAssignee;
  assignees: Array<PullsUpdateResponseDataAssigneesItem>;
  requested_reviewers: Array<PullsUpdateResponseDataRequestedReviewersItem>;
  requested_teams: Array<PullsUpdateResponseDataRequestedTeamsItem>;
  head: PullsUpdateResponseDataHead;
  base: PullsUpdateResponseDataBase;
  _links: PullsUpdateResponseDataLinks;
  author_association: string;
  draft: boolean;
  merged: boolean;
  mergeable: boolean;
  rebaseable: boolean;
  mergeable_state: string;
  merged_by: PullsUpdateResponseDataMergedBy;
  comments: number;
  review_comments: number;
  maintainer_can_modify: boolean;
  commits: number;
  additions: number;
  deletions: number;
  changed_files: number;
};

type PullsListCommentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Can be either `created` or `updated` comments.
   */
  sort?: "created" | "updated";
  /**
   * Can be either `asc` or `desc`. Ignored without `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListCommentsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListCommentsResponseDataItemLinksPullRequest = { href: string };
type PullsListCommentsResponseDataItemLinksHtml = { href: string };
type PullsListCommentsResponseDataItemLinksSelf = { href: string };
type PullsListCommentsResponseDataItemLinks = {
  self: PullsListCommentsResponseDataItemLinksSelf;
  html: PullsListCommentsResponseDataItemLinksHtml;
  pull_request: PullsListCommentsResponseDataItemLinksPullRequest;
};
type PullsListCommentsResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListCommentsResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  pull_request_review_id: number;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  in_reply_to_id: number;
  user: PullsListCommentsResponseDataItemUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsListCommentsResponseDataItemLinks;
  start_line: number;
  original_start_line: number;
  start_side: string;
  line: number;
  original_line: number;
  side: string;
};
type PullsListCommentsResponseData = Array<PullsListCommentsResponseDataItem>;

type PullsCreateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The text of the review comment.
   */
  body: string;
  /**
   * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
   */
  commit_id: string;
  /**
   * The relative path to the file that necessitates a comment.
   */
  path: string;
  /**
   * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
   */
  position?: number;
  /**
   * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
   */
  side?: "LEFT" | "RIGHT";
  /**
   * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
   */
  line?: number;
  /**
   * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
   */
  start_line?: number;
  /**
   * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
   */
  start_side?: "LEFT" | "RIGHT" | "side";
};

type PullsCreateCommentRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls/:pull_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateCommentResponseDataLinksPullRequest = { href: string };
type PullsCreateCommentResponseDataLinksHtml = { href: string };
type PullsCreateCommentResponseDataLinksSelf = { href: string };
type PullsCreateCommentResponseDataLinks = {
  self: PullsCreateCommentResponseDataLinksSelf;
  html: PullsCreateCommentResponseDataLinksHtml;
  pull_request: PullsCreateCommentResponseDataLinksPullRequest;
};
type PullsCreateCommentResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateCommentResponseData = {
  url: string;
  id: number;
  node_id: string;
  pull_request_review_id: number;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  in_reply_to_id: number;
  user: PullsCreateCommentResponseDataUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsCreateCommentResponseDataLinks;
  start_line: number;
  original_start_line: number;
  start_side: string;
  line: number;
  original_line: number;
  side: string;
};

type PullsCreateReviewCommentReplyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The text of the review comment.
   */
  body: string;
};

type PullsCreateReviewCommentReplyRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateReviewCommentReplyResponseDataLinksPullRequest = {
  href: string;
};
type PullsCreateReviewCommentReplyResponseDataLinksHtml = { href: string };
type PullsCreateReviewCommentReplyResponseDataLinksSelf = { href: string };
type PullsCreateReviewCommentReplyResponseDataLinks = {
  self: PullsCreateReviewCommentReplyResponseDataLinksSelf;
  html: PullsCreateReviewCommentReplyResponseDataLinksHtml;
  pull_request: PullsCreateReviewCommentReplyResponseDataLinksPullRequest;
};
type PullsCreateReviewCommentReplyResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewCommentReplyResponseData = {
  url: string;
  pull_request_review_id: number;
  id: number;
  node_id: string;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  user: PullsCreateReviewCommentReplyResponseDataUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsCreateReviewCommentReplyResponseDataLinks;
};

type PullsListCommitsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListCommitsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/commits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListCommitsResponseDataItemParentsItem = { url: string; sha: string };
type PullsListCommitsResponseDataItemCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListCommitsResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListCommitsResponseDataItemCommitVerification = {
  verified: boolean;
  reason: string;
  signature: null;
  payload: null;
};
type PullsListCommitsResponseDataItemCommitTree = { url: string; sha: string };
type PullsListCommitsResponseDataItemCommitCommitter = {
  name: string;
  email: string;
  date: string;
};
type PullsListCommitsResponseDataItemCommitAuthor = {
  name: string;
  email: string;
  date: string;
};
type PullsListCommitsResponseDataItemCommit = {
  url: string;
  author: PullsListCommitsResponseDataItemCommitAuthor;
  committer: PullsListCommitsResponseDataItemCommitCommitter;
  message: string;
  tree: PullsListCommitsResponseDataItemCommitTree;
  comment_count: number;
  verification: PullsListCommitsResponseDataItemCommitVerification;
};
type PullsListCommitsResponseDataItem = {
  url: string;
  sha: string;
  node_id: string;
  html_url: string;
  comments_url: string;
  commit: PullsListCommitsResponseDataItemCommit;
  author: PullsListCommitsResponseDataItemAuthor;
  committer: PullsListCommitsResponseDataItemCommitter;
  parents: Array<PullsListCommitsResponseDataItemParentsItem>;
};
type PullsListCommitsResponseData = Array<PullsListCommitsResponseDataItem>;

type PullsListFilesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListFilesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/files";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListFilesResponseDataItem = {
  sha: string;
  filename: string;
  status: string;
  additions: number;
  deletions: number;
  changes: number;
  blob_url: string;
  raw_url: string;
  contents_url: string;
  patch: string;
};
type PullsListFilesResponseData = Array<PullsListFilesResponseDataItem>;

type PullsCheckIfMergedEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
};

type PullsCheckIfMergedRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/merge";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type PullsMergeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Title for the automatic commit message.
   */
  commit_title?: string;
  /**
   * Extra detail to append to automatic commit message.
   */
  commit_message?: string;
  /**
   * SHA that pull request head must match to allow merge.
   */
  sha?: string;
  /**
   * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
   */
  merge_method?: "merge" | "squash" | "rebase";
};

type PullsMergeRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/pulls/:pull_number/merge";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsMergeResponseData = { sha: string; merged: boolean; message: string };

type PullsListReviewRequestsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListReviewRequestsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListReviewRequestsResponseDataTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type PullsListReviewRequestsResponseDataUsersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListReviewRequestsResponseData = {
  users: Array<PullsListReviewRequestsResponseDataUsersItem>;
  teams: Array<PullsListReviewRequestsResponseDataTeamsItem>;
};

type PullsCreateReviewRequestEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * An array of user `login`s that will be requested.
   */
  reviewers?: string[];
  /**
   * An array of team `slug`s that will be requested.
   */
  team_reviewers?: string[];
};

type PullsCreateReviewRequestRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateReviewRequestResponseDataLinksStatuses = { href: string };
type PullsCreateReviewRequestResponseDataLinksCommits = { href: string };
type PullsCreateReviewRequestResponseDataLinksReviewComment = { href: string };
type PullsCreateReviewRequestResponseDataLinksReviewComments = { href: string };
type PullsCreateReviewRequestResponseDataLinksComments = { href: string };
type PullsCreateReviewRequestResponseDataLinksIssue = { href: string };
type PullsCreateReviewRequestResponseDataLinksHtml = { href: string };
type PullsCreateReviewRequestResponseDataLinksSelf = { href: string };
type PullsCreateReviewRequestResponseDataLinks = {
  self: PullsCreateReviewRequestResponseDataLinksSelf;
  html: PullsCreateReviewRequestResponseDataLinksHtml;
  issue: PullsCreateReviewRequestResponseDataLinksIssue;
  comments: PullsCreateReviewRequestResponseDataLinksComments;
  review_comments: PullsCreateReviewRequestResponseDataLinksReviewComments;
  review_comment: PullsCreateReviewRequestResponseDataLinksReviewComment;
  commits: PullsCreateReviewRequestResponseDataLinksCommits;
  statuses: PullsCreateReviewRequestResponseDataLinksStatuses;
};
type PullsCreateReviewRequestResponseDataBaseRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsCreateReviewRequestResponseDataBaseRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataBaseRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsCreateReviewRequestResponseDataBaseRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsCreateReviewRequestResponseDataBaseRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsCreateReviewRequestResponseDataBaseUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataBase = {
  label: string;
  ref: string;
  sha: string;
  user: PullsCreateReviewRequestResponseDataBaseUser;
  repo: PullsCreateReviewRequestResponseDataBaseRepo;
};
type PullsCreateReviewRequestResponseDataHeadRepoPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type PullsCreateReviewRequestResponseDataHeadRepoOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataHeadRepo = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: PullsCreateReviewRequestResponseDataHeadRepoOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: PullsCreateReviewRequestResponseDataHeadRepoPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type PullsCreateReviewRequestResponseDataHeadUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataHead = {
  label: string;
  ref: string;
  sha: string;
  user: PullsCreateReviewRequestResponseDataHeadUser;
  repo: PullsCreateReviewRequestResponseDataHeadRepo;
};
type PullsCreateReviewRequestResponseDataRequestedTeamsItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type PullsCreateReviewRequestResponseDataRequestedReviewersItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataAssigneesItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataAssignee = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataMilestoneCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseDataMilestone = {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  number: number;
  state: string;
  title: string;
  description: string;
  creator: PullsCreateReviewRequestResponseDataMilestoneCreator;
  open_issues: number;
  closed_issues: number;
  created_at: string;
  updated_at: string;
  closed_at: string;
  due_on: string;
};
type PullsCreateReviewRequestResponseDataLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  description: string;
  color: string;
  default: boolean;
};
type PullsCreateReviewRequestResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewRequestResponseData = {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  number: number;
  state: string;
  locked: boolean;
  title: string;
  user: PullsCreateReviewRequestResponseDataUser;
  body: string;
  labels: Array<PullsCreateReviewRequestResponseDataLabelsItem>;
  milestone: PullsCreateReviewRequestResponseDataMilestone;
  active_lock_reason: string;
  created_at: string;
  updated_at: string;
  closed_at: string;
  merged_at: string;
  merge_commit_sha: string;
  assignee: PullsCreateReviewRequestResponseDataAssignee;
  assignees: Array<PullsCreateReviewRequestResponseDataAssigneesItem>;
  requested_reviewers: Array<
    PullsCreateReviewRequestResponseDataRequestedReviewersItem
  >;
  requested_teams: Array<
    PullsCreateReviewRequestResponseDataRequestedTeamsItem
  >;
  head: PullsCreateReviewRequestResponseDataHead;
  base: PullsCreateReviewRequestResponseDataBase;
  _links: PullsCreateReviewRequestResponseDataLinks;
  author_association: string;
  draft: boolean;
};

type PullsDeleteReviewRequestEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * An array of user `login`s that will be removed.
   */
  reviewers?: string[];
  /**
   * An array of team `slug`s that will be removed.
   */
  team_reviewers?: string[];
};

type PullsDeleteReviewRequestRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type PullsListReviewsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsListReviewsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListReviewsResponseDataItemLinksPullRequest = { href: string };
type PullsListReviewsResponseDataItemLinksHtml = { href: string };
type PullsListReviewsResponseDataItemLinks = {
  html: PullsListReviewsResponseDataItemLinksHtml;
  pull_request: PullsListReviewsResponseDataItemLinksPullRequest;
};
type PullsListReviewsResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsListReviewsResponseDataItem = {
  id: number;
  node_id: string;
  user: PullsListReviewsResponseDataItemUser;
  body: string;
  submitted_at: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsListReviewsResponseDataItemLinks;
};
type PullsListReviewsResponseData = Array<PullsListReviewsResponseDataItem>;

type PullsCreateReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
   */
  commit_id?: string;
  /**
   * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
   */
  body?: string;
  /**
   * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
   */
  event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
  /**
   * Use the following table to specify the location, destination, and contents of the draft review comment.
   */
  comments?: PullsCreateReviewParamsComments[];
};

type PullsCreateReviewRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateReviewResponseDataLinksPullRequest = { href: string };
type PullsCreateReviewResponseDataLinksHtml = { href: string };
type PullsCreateReviewResponseDataLinks = {
  html: PullsCreateReviewResponseDataLinksHtml;
  pull_request: PullsCreateReviewResponseDataLinksPullRequest;
};
type PullsCreateReviewResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsCreateReviewResponseData = {
  id: number;
  node_id: string;
  user: PullsCreateReviewResponseDataUser;
  body: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsCreateReviewResponseDataLinks;
};

type PullsGetReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
};

type PullsGetReviewRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetReviewResponseDataLinksPullRequest = { href: string };
type PullsGetReviewResponseDataLinksHtml = { href: string };
type PullsGetReviewResponseDataLinks = {
  html: PullsGetReviewResponseDataLinksHtml;
  pull_request: PullsGetReviewResponseDataLinksPullRequest;
};
type PullsGetReviewResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetReviewResponseData = {
  id: number;
  node_id: string;
  user: PullsGetReviewResponseDataUser;
  body: string;
  submitted_at: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsGetReviewResponseDataLinks;
};

type PullsDeletePendingReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
};

type PullsDeletePendingReviewRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsDeletePendingReviewResponseDataLinksPullRequest = { href: string };
type PullsDeletePendingReviewResponseDataLinksHtml = { href: string };
type PullsDeletePendingReviewResponseDataLinks = {
  html: PullsDeletePendingReviewResponseDataLinksHtml;
  pull_request: PullsDeletePendingReviewResponseDataLinksPullRequest;
};
type PullsDeletePendingReviewResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsDeletePendingReviewResponseData = {
  id: number;
  node_id: string;
  user: PullsDeletePendingReviewResponseDataUser;
  body: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsDeletePendingReviewResponseDataLinks;
};

type PullsUpdateReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * The body text of the pull request review.
   */
  body: string;
};

type PullsUpdateReviewRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateReviewResponseDataLinksPullRequest = { href: string };
type PullsUpdateReviewResponseDataLinksHtml = { href: string };
type PullsUpdateReviewResponseDataLinks = {
  html: PullsUpdateReviewResponseDataLinksHtml;
  pull_request: PullsUpdateReviewResponseDataLinksPullRequest;
};
type PullsUpdateReviewResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsUpdateReviewResponseData = {
  id: number;
  node_id: string;
  user: PullsUpdateReviewResponseDataUser;
  body: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsUpdateReviewResponseDataLinks;
};

type PullsGetCommentsForReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type PullsGetCommentsForReviewRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetCommentsForReviewResponseDataItemLinksPullRequest = {
  href: string;
};
type PullsGetCommentsForReviewResponseDataItemLinksHtml = { href: string };
type PullsGetCommentsForReviewResponseDataItemLinksSelf = { href: string };
type PullsGetCommentsForReviewResponseDataItemLinks = {
  self: PullsGetCommentsForReviewResponseDataItemLinksSelf;
  html: PullsGetCommentsForReviewResponseDataItemLinksHtml;
  pull_request: PullsGetCommentsForReviewResponseDataItemLinksPullRequest;
};
type PullsGetCommentsForReviewResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsGetCommentsForReviewResponseDataItem = {
  url: string;
  id: number;
  node_id: string;
  pull_request_review_id: number;
  diff_hunk: string;
  path: string;
  position: number;
  original_position: number;
  commit_id: string;
  original_commit_id: string;
  in_reply_to_id: number;
  user: PullsGetCommentsForReviewResponseDataItemUser;
  body: string;
  created_at: string;
  updated_at: string;
  html_url: string;
  pull_request_url: string;
  author_association: string;
  _links: PullsGetCommentsForReviewResponseDataItemLinks;
};
type PullsGetCommentsForReviewResponseData = Array<
  PullsGetCommentsForReviewResponseDataItem
>;

type PullsDismissReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * The message for the pull request review dismissal
   */
  message: string;
};

type PullsDismissReviewRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsDismissReviewResponseDataLinksPullRequest = { href: string };
type PullsDismissReviewResponseDataLinksHtml = { href: string };
type PullsDismissReviewResponseDataLinks = {
  html: PullsDismissReviewResponseDataLinksHtml;
  pull_request: PullsDismissReviewResponseDataLinksPullRequest;
};
type PullsDismissReviewResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsDismissReviewResponseData = {
  id: number;
  node_id: string;
  user: PullsDismissReviewResponseDataUser;
  body: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsDismissReviewResponseDataLinks;
};

type PullsSubmitReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * The body text of the pull request review
   */
  body?: string;
  /**
   * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
   */
  event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
};

type PullsSubmitReviewRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsSubmitReviewResponseDataLinksPullRequest = { href: string };
type PullsSubmitReviewResponseDataLinksHtml = { href: string };
type PullsSubmitReviewResponseDataLinks = {
  html: PullsSubmitReviewResponseDataLinksHtml;
  pull_request: PullsSubmitReviewResponseDataLinksPullRequest;
};
type PullsSubmitReviewResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type PullsSubmitReviewResponseData = {
  id: number;
  node_id: string;
  user: PullsSubmitReviewResponseDataUser;
  body: string;
  submitted_at: string;
  commit_id: string;
  state: string;
  html_url: string;
  pull_request_url: string;
  _links: PullsSubmitReviewResponseDataLinks;
};

type PullsUpdateBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits on a repository](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
   */
  expected_head_sha?: string;
} & RequiredPreview<"lydian">;

type PullsUpdateBranchRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/pulls/:pull_number/update-branch";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateBranchResponseData = { message: string; url: string };

type ReposGetReadmeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
   */
  ref?: string;
};

type ReposGetReadmeRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/readme";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReadmeResponseDataLinks = {
  git: string;
  self: string;
  html: string;
};
type ReposGetReadmeResponseData = {
  type: string;
  encoding: string;
  size: number;
  name: string;
  path: string;
  content: string;
  sha: string;
  url: string;
  git_url: string;
  html_url: string;
  download_url: string;
  _links: ReposGetReadmeResponseDataLinks;
};

type ReposListReleasesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListReleasesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/releases";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListReleasesResponseDataItemAssetsItemUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListReleasesResponseDataItemAssetsItem = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposListReleasesResponseDataItemAssetsItemUploader;
};
type ReposListReleasesResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListReleasesResponseDataItem = {
  url: string;
  html_url: string;
  assets_url: string;
  upload_url: string;
  tarball_url: string;
  zipball_url: string;
  id: number;
  node_id: string;
  tag_name: string;
  target_commitish: string;
  name: string;
  body: string;
  draft: boolean;
  prerelease: boolean;
  created_at: string;
  published_at: string;
  author: ReposListReleasesResponseDataItemAuthor;
  assets: Array<ReposListReleasesResponseDataItemAssetsItem>;
};
type ReposListReleasesResponseData = Array<ReposListReleasesResponseDataItem>;

type ReposCreateReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the tag.
   */
  tag_name: string;
  /**
   * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
   */
  target_commitish?: string;
  /**
   * The name of the release.
   */
  name?: string;
  /**
   * Text describing the contents of the tag.
   */
  body?: string;
  /**
   * `true` to create a draft (unpublished) release, `false` to create a published one.
   */
  draft?: boolean;
  /**
   * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
   */
  prerelease?: boolean;
};

type ReposCreateReleaseRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/releases";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateReleaseResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateReleaseResponseData = {
  url: string;
  html_url: string;
  assets_url: string;
  upload_url: string;
  tarball_url: string;
  zipball_url: string;
  id: number;
  node_id: string;
  tag_name: string;
  target_commitish: string;
  name: string;
  body: string;
  draft: boolean;
  prerelease: boolean;
  created_at: string;
  published_at: string;
  author: ReposCreateReleaseResponseDataAuthor;
  assets: Array<any>;
};

type ReposGetReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * asset_id parameter
   */
  asset_id: number;
};

type ReposGetReleaseAssetRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/releases/assets/:asset_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReleaseAssetResponseDataUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetReleaseAssetResponseData = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposGetReleaseAssetResponseDataUploader;
};

type ReposUpdateReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * asset_id parameter
   */
  asset_id: number;
  /**
   * The file name of the asset.
   */
  name?: string;
  /**
   * An alternate short description of the asset. Used in place of the filename.
   */
  label?: string;
};

type ReposUpdateReleaseAssetRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/releases/assets/:asset_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateReleaseAssetResponseDataUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateReleaseAssetResponseData = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposUpdateReleaseAssetResponseDataUploader;
};

type ReposDeleteReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * asset_id parameter
   */
  asset_id: number;
};

type ReposDeleteReleaseAssetRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/releases/assets/:asset_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetLatestReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetLatestReleaseRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/releases/latest";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetLatestReleaseResponseDataAssetsItemUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetLatestReleaseResponseDataAssetsItem = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposGetLatestReleaseResponseDataAssetsItemUploader;
};
type ReposGetLatestReleaseResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetLatestReleaseResponseData = {
  url: string;
  html_url: string;
  assets_url: string;
  upload_url: string;
  tarball_url: string;
  zipball_url: string;
  id: number;
  node_id: string;
  tag_name: string;
  target_commitish: string;
  name: string;
  body: string;
  draft: boolean;
  prerelease: boolean;
  created_at: string;
  published_at: string;
  author: ReposGetLatestReleaseResponseDataAuthor;
  assets: Array<ReposGetLatestReleaseResponseDataAssetsItem>;
};

type ReposGetReleaseByTagEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * tag parameter
   */
  tag: string;
};

type ReposGetReleaseByTagRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/releases/tags/:tag";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReleaseByTagResponseDataAssetsItemUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetReleaseByTagResponseDataAssetsItem = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposGetReleaseByTagResponseDataAssetsItemUploader;
};
type ReposGetReleaseByTagResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetReleaseByTagResponseData = {
  url: string;
  html_url: string;
  assets_url: string;
  upload_url: string;
  tarball_url: string;
  zipball_url: string;
  id: number;
  node_id: string;
  tag_name: string;
  target_commitish: string;
  name: string;
  body: string;
  draft: boolean;
  prerelease: boolean;
  created_at: string;
  published_at: string;
  author: ReposGetReleaseByTagResponseDataAuthor;
  assets: Array<ReposGetReleaseByTagResponseDataAssetsItem>;
};

type ReposGetReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
};

type ReposGetReleaseRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/releases/:release_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReleaseResponseDataAssetsItemUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetReleaseResponseDataAssetsItem = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposGetReleaseResponseDataAssetsItemUploader;
};
type ReposGetReleaseResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetReleaseResponseData = {
  url: string;
  html_url: string;
  assets_url: string;
  upload_url: string;
  tarball_url: string;
  zipball_url: string;
  id: number;
  node_id: string;
  tag_name: string;
  target_commitish: string;
  name: string;
  body: string;
  draft: boolean;
  prerelease: boolean;
  created_at: string;
  published_at: string;
  author: ReposGetReleaseResponseDataAuthor;
  assets: Array<ReposGetReleaseResponseDataAssetsItem>;
};

type ReposUpdateReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
  /**
   * The name of the tag.
   */
  tag_name?: string;
  /**
   * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
   */
  target_commitish?: string;
  /**
   * The name of the release.
   */
  name?: string;
  /**
   * Text describing the contents of the tag.
   */
  body?: string;
  /**
   * `true` makes the release a draft, and `false` publishes the release.
   */
  draft?: boolean;
  /**
   * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
   */
  prerelease?: boolean;
};

type ReposUpdateReleaseRequestOptions = {
  method: "PATCH";
  url: "/repos/:owner/:repo/releases/:release_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateReleaseResponseDataAssetsItemUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateReleaseResponseDataAssetsItem = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposUpdateReleaseResponseDataAssetsItemUploader;
};
type ReposUpdateReleaseResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUpdateReleaseResponseData = {
  url: string;
  html_url: string;
  assets_url: string;
  upload_url: string;
  tarball_url: string;
  zipball_url: string;
  id: number;
  node_id: string;
  tag_name: string;
  target_commitish: string;
  name: string;
  body: string;
  draft: boolean;
  prerelease: boolean;
  created_at: string;
  published_at: string;
  author: ReposUpdateReleaseResponseDataAuthor;
  assets: Array<ReposUpdateReleaseResponseDataAssetsItem>;
};

type ReposDeleteReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
};

type ReposDeleteReleaseRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/releases/:release_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListAssetsForReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListAssetsForReleaseRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/releases/:release_id/assets";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListAssetsForReleaseResponseDataItemUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListAssetsForReleaseResponseDataItem = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposListAssetsForReleaseResponseDataItemUploader;
};
type ReposListAssetsForReleaseResponseData = Array<
  ReposListAssetsForReleaseResponseDataItem
>;

type ReposUploadReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
  /**
   * name parameter
   */
  name?: string;
  /**
   * label parameter
   */
  label?: string;
  /**
   * The raw file data
   */
  data: string;
  /**
   * The URL origin (protocol + host name + port) is included in `upload_url` returned in the response of the "Create a release" endpoint
   */
  origin?: string;
  /**
   * For https://api.github.com, set `baseUrl` to `https://uploads.github.com`. For GitHub Enterprise Server, set it to `<your hostname>/api/uploads`
   */
  baseUrl: string;
} & { headers: { "content-type": string } };
type ReposUploadReleaseAssetRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/releases/:release_id/assets{?name,label}";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUploadReleaseAssetResponseDataUploader = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposUploadReleaseAssetResponseData = {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  name: string;
  label: string;
  state: string;
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader: ReposUploadReleaseAssetResponseDataUploader;
};

type ActivityListStargazersForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListStargazersForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/stargazers";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListStargazersForRepoResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActivityListStargazersForRepoResponseData = Array<
  ActivityListStargazersForRepoResponseDataItem
>;

type ReposGetCodeFrequencyStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetCodeFrequencyStatsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/stats/code_frequency";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCodeFrequencyStatsResponseData = Array<Array<number>>;

type ReposGetCommitActivityStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetCommitActivityStatsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/stats/commit_activity";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCommitActivityStatsResponseDataItem = {
  days: Array<number>;
  total: number;
  week: number;
};
type ReposGetCommitActivityStatsResponseData = Array<
  ReposGetCommitActivityStatsResponseDataItem
>;

type ReposGetContributorsStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetContributorsStatsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/stats/contributors";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetContributorsStatsResponseDataItemWeeksItem = {
  w: string;
  a: number;
  d: number;
  c: number;
};
type ReposGetContributorsStatsResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposGetContributorsStatsResponseDataItem = {
  author: ReposGetContributorsStatsResponseDataItemAuthor;
  total: number;
  weeks: Array<ReposGetContributorsStatsResponseDataItemWeeksItem>;
};
type ReposGetContributorsStatsResponseData = Array<
  ReposGetContributorsStatsResponseDataItem
>;

type ReposGetParticipationStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetParticipationStatsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/stats/participation";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetParticipationStatsResponseData = {
  all: Array<number>;
  owner: Array<number>;
};

type ReposGetPunchCardStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetPunchCardStatsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/stats/punch_card";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetPunchCardStatsResponseData = Array<Array<number>>;

type ReposCreateStatusEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * sha parameter
   */
  sha: string;
  /**
   * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
   */
  state: "error" | "failure" | "pending" | "success";
  /**
   * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
   * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
   * `http://ci.example.com/user/repo/build/sha`
   */
  target_url?: string;
  /**
   * A short description of the status.
   */
  description?: string;
  /**
   * A string label to differentiate this status from the status of other systems.
   */
  context?: string;
};

type ReposCreateStatusRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/statuses/:sha";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateStatusResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateStatusResponseData = {
  url: string;
  avatar_url: string;
  id: number;
  node_id: string;
  state: string;
  description: string;
  target_url: string;
  context: string;
  created_at: string;
  updated_at: string;
  creator: ReposCreateStatusResponseDataCreator;
};

type ActivityListWatchersForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ActivityListWatchersForRepoRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/subscribers";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListWatchersForRepoResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ActivityListWatchersForRepoResponseData = Array<
  ActivityListWatchersForRepoResponseDataItem
>;

type ActivityGetRepoSubscriptionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ActivityGetRepoSubscriptionRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/subscription";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetRepoSubscriptionResponseData = {
  subscribed: boolean;
  ignored: boolean;
  reason: null;
  created_at: string;
  url: string;
  repository_url: string;
};

type ActivitySetRepoSubscriptionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Determines if notifications should be received from this repository.
   */
  subscribed?: boolean;
  /**
   * Determines if all notifications should be blocked from this repository.
   */
  ignored?: boolean;
};

type ActivitySetRepoSubscriptionRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/subscription";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivitySetRepoSubscriptionResponseData = {
  subscribed: boolean;
  ignored: boolean;
  reason: null;
  created_at: string;
  url: string;
  repository_url: string;
};

type ActivityDeleteRepoSubscriptionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ActivityDeleteRepoSubscriptionRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/subscription";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposListTagsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListTagsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/tags";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListTagsResponseDataItemCommit = { sha: string; url: string };
type ReposListTagsResponseDataItem = {
  name: string;
  commit: ReposListTagsResponseDataItemCommit;
  zipball_url: string;
  tarball_url: string;
};
type ReposListTagsResponseData = Array<ReposListTagsResponseDataItem>;

type ReposListTeamsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type ReposListTeamsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListTeamsResponseDataItem = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
};
type ReposListTeamsResponseData = Array<ReposListTeamsResponseDataItem>;

type ReposGetAllTopicsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"mercy">;

type ReposGetAllTopicsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/topics";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetAllTopicsResponseData = { names: Array<string> };

type ReposReplaceAllTopicsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
   */
  names: string[];
} & RequiredPreview<"mercy">;

type ReposReplaceAllTopicsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/topics";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceAllTopicsResponseData = { names: Array<string> };

type ReposGetClonesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Must be one of: `day`, `week`.
   */
  per?: "day" | "week";
};

type ReposGetClonesRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/traffic/clones";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetClonesResponseDataClonesItem = {
  timestamp: string;
  count: number;
  uniques: number;
};
type ReposGetClonesResponseData = {
  count: number;
  uniques: number;
  clones: Array<ReposGetClonesResponseDataClonesItem>;
};

type ReposGetTopPathsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetTopPathsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/traffic/popular/paths";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetTopPathsResponseDataItem = {
  path: string;
  title: string;
  count: number;
  uniques: number;
};
type ReposGetTopPathsResponseData = Array<ReposGetTopPathsResponseDataItem>;

type ReposGetTopReferrersEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type ReposGetTopReferrersRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/traffic/popular/referrers";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetTopReferrersResponseDataItem = {
  referrer: string;
  count: number;
  uniques: number;
};
type ReposGetTopReferrersResponseData = Array<
  ReposGetTopReferrersResponseDataItem
>;

type ReposGetViewsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Must be one of: `day`, `week`.
   */
  per?: "day" | "week";
};

type ReposGetViewsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/traffic/views";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetViewsResponseDataViewsItem = {
  timestamp: string;
  count: number;
  uniques: number;
};
type ReposGetViewsResponseData = {
  count: number;
  uniques: number;
  views: Array<ReposGetViewsResponseDataViewsItem>;
};

type ReposTransferEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * **Required:** The username or organization name the repository will be transferred to.
   */
  new_owner?: string;
  /**
   * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
   */
  team_ids?: number[];
};

type ReposTransferRequestOptions = {
  method: "POST";
  url: "/repos/:owner/:repo/transfer";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposTransferResponseDataPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposTransferResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposTransferResponseData = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposTransferResponseDataOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposTransferResponseDataPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};

type ReposCheckVulnerabilityAlertsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"dorian">;

type ReposCheckVulnerabilityAlertsRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/vulnerability-alerts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposEnableVulnerabilityAlertsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"dorian">;

type ReposEnableVulnerabilityAlertsRequestOptions = {
  method: "PUT";
  url: "/repos/:owner/:repo/vulnerability-alerts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposDisableVulnerabilityAlertsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
} & RequiredPreview<"dorian">;

type ReposDisableVulnerabilityAlertsRequestOptions = {
  method: "DELETE";
  url: "/repos/:owner/:repo/vulnerability-alerts";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposGetArchiveLinkEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * archive_format parameter
   */
  archive_format: string;
  /**
   * ref parameter
   */
  ref: string;
};

type ReposGetArchiveLinkRequestOptions = {
  method: "GET";
  url: "/repos/:owner/:repo/:archive_format/:ref";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReposCreateUsingTemplateEndpoint = {
  /**
   * template_owner parameter
   */
  template_owner: string;
  /**
   * template_repo parameter
   */
  template_repo: string;
  /**
   * The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
   */
  owner?: string;
  /**
   * The name of the new repository.
   */
  name: string;
  /**
   * A short description of the new repository.
   */
  description?: string;
  /**
   * Either `true` to create a new private repository or `false` to create a new public one.
   */
  private?: boolean;
} & RequiredPreview<"baptiste">;

type ReposCreateUsingTemplateRequestOptions = {
  method: "POST";
  url: "/repos/:template_owner/:template_repo/generate";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateUsingTemplateResponseDataTemplateRepositoryPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposCreateUsingTemplateResponseDataTemplateRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateUsingTemplateResponseDataTemplateRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposCreateUsingTemplateResponseDataTemplateRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposCreateUsingTemplateResponseDataTemplateRepositoryPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type ReposCreateUsingTemplateResponseDataPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type ReposCreateUsingTemplateResponseDataOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposCreateUsingTemplateResponseData = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposCreateUsingTemplateResponseDataOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: ReposCreateUsingTemplateResponseDataPermissions;
  allow_rebase_merge: boolean;
  template_repository: ReposCreateUsingTemplateResponseDataTemplateRepository;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};

type ReposListPublicEndpoint = {
  /**
   * The integer ID of the last repository that you've seen.
   */
  since?: number;
};

type ReposListPublicRequestOptions = {
  method: "GET";
  url: "/repositories";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListPublicResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReposListPublicResponseDataItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: ReposListPublicResponseDataItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
};
type ReposListPublicResponseData = Array<ReposListPublicResponseDataItem>;

type ScimListProvisionedIdentitiesEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Used for pagination: the index of the first result to return.
   */
  startIndex?: number;
  /**
   * Used for pagination: the number of results to return.
   */
  count?: number;
  /**
   * Filters results using the equals query parameter operator (`eq`). You can filter results that are equal to `id`, `userName`, `emails`, and `external_id`. For example, to search for an identity with the `userName` Octocat, you would use this query: `?filter=userName%20eq%20\"Octocat\"`.
   */
  filter?: string;
};

type ScimListProvisionedIdentitiesRequestOptions = {
  method: "GET";
  url: "/scim/v2/organizations/:org/Users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimListProvisionedIdentitiesResponseDataResourcesItemMeta = {
  resourceType: string;
  created: string;
  lastModified: string;
  location: string;
};
type ScimListProvisionedIdentitiesResponseDataResourcesItemEmailsItem = {
  value: string;
  primary: boolean;
  type: string;
};
type ScimListProvisionedIdentitiesResponseDataResourcesItemName = {
  givenName: string;
  familyName: string;
};
type ScimListProvisionedIdentitiesResponseDataResourcesItem = {
  schemas: Array<string>;
  id: string;
  externalId: string;
  userName: string;
  name: ScimListProvisionedIdentitiesResponseDataResourcesItemName;
  emails: Array<
    ScimListProvisionedIdentitiesResponseDataResourcesItemEmailsItem
  >;
  active: boolean;
  meta: ScimListProvisionedIdentitiesResponseDataResourcesItemMeta;
};
type ScimListProvisionedIdentitiesResponseData = {
  schemas: Array<string>;
  totalResults: number;
  itemsPerPage: number;
  startIndex: number;
  Resources: Array<ScimListProvisionedIdentitiesResponseDataResourcesItem>;
};

type ScimProvisionAndInviteUsersEndpoint = {
  /**
   * org parameter
   */
  org: string;
};

type ScimProvisionAndInviteUsersRequestOptions = {
  method: "POST";
  url: "/scim/v2/organizations/:org/Users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimProvisionAndInviteUsersResponseDataMeta = {
  resourceType: string;
  created: string;
  lastModified: string;
  location: string;
};
type ScimProvisionAndInviteUsersResponseDataEmailsItem = {
  value: string;
  type: string;
  primary: boolean;
};
type ScimProvisionAndInviteUsersResponseDataName = {
  givenName: string;
  familyName: string;
};
type ScimProvisionAndInviteUsersResponseData = {
  schemas: Array<string>;
  id: string;
  externalId: string;
  userName: string;
  name: ScimProvisionAndInviteUsersResponseDataName;
  emails: Array<ScimProvisionAndInviteUsersResponseDataEmailsItem>;
  active: boolean;
  meta: ScimProvisionAndInviteUsersResponseDataMeta;
};

type ScimGetProvisioningDetailsForUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};

type ScimGetProvisioningDetailsForUserRequestOptions = {
  method: "GET";
  url: "/scim/v2/organizations/:org/Users/:scim_user_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimGetProvisioningDetailsForUserResponseDataMeta = {
  resourceType: string;
  created: string;
  lastModified: string;
  location: string;
};
type ScimGetProvisioningDetailsForUserResponseDataEmailsItem = {
  value: string;
  type: string;
  primary: boolean;
};
type ScimGetProvisioningDetailsForUserResponseDataName = {
  givenName: string;
  familyName: string;
};
type ScimGetProvisioningDetailsForUserResponseData = {
  schemas: Array<string>;
  id: string;
  externalId: string;
  userName: string;
  name: ScimGetProvisioningDetailsForUserResponseDataName;
  emails: Array<ScimGetProvisioningDetailsForUserResponseDataEmailsItem>;
  active: boolean;
  meta: ScimGetProvisioningDetailsForUserResponseDataMeta;
};

type ScimReplaceProvisionedUserInformationEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};

type ScimReplaceProvisionedUserInformationRequestOptions = {
  method: "PUT";
  url: "/scim/v2/organizations/:org/Users/:scim_user_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimReplaceProvisionedUserInformationResponseDataMeta = {
  resourceType: string;
  created: string;
  lastModified: string;
  location: string;
};
type ScimReplaceProvisionedUserInformationResponseDataEmailsItem = {
  value: string;
  type: string;
  primary: boolean;
};
type ScimReplaceProvisionedUserInformationResponseDataName = {
  givenName: string;
  familyName: string;
};
type ScimReplaceProvisionedUserInformationResponseData = {
  schemas: Array<string>;
  id: string;
  externalId: string;
  userName: string;
  name: ScimReplaceProvisionedUserInformationResponseDataName;
  emails: Array<ScimReplaceProvisionedUserInformationResponseDataEmailsItem>;
  active: boolean;
  meta: ScimReplaceProvisionedUserInformationResponseDataMeta;
};

type ScimUpdateUserAttributeEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};

type ScimUpdateUserAttributeRequestOptions = {
  method: "PATCH";
  url: "/scim/v2/organizations/:org/Users/:scim_user_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimUpdateUserAttributeResponseDataMeta = {
  resourceType: string;
  created: string;
  lastModified: string;
  location: string;
};
type ScimUpdateUserAttributeResponseDataEmailsItem = {
  value: string;
  type: string;
  primary?: boolean;
};
type ScimUpdateUserAttributeResponseDataName = {
  givenName: string;
  familyName: string;
};
type ScimUpdateUserAttributeResponseData = {
  schemas: Array<string>;
  id: string;
  externalId: string;
  userName: string;
  name: ScimUpdateUserAttributeResponseDataName;
  emails: Array<ScimUpdateUserAttributeResponseDataEmailsItem>;
  active: boolean;
  meta: ScimUpdateUserAttributeResponseDataMeta;
};

type ScimRemoveUserFromOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};

type ScimRemoveUserFromOrgRequestOptions = {
  method: "DELETE";
  url: "/scim/v2/organizations/:org/Users/:scim_user_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type SearchCodeEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching code](https://help.github.com/articles/searching-code/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "indexed";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type SearchCodeRequestOptions = {
  method: "GET";
  url: "/search/code";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchCodeResponseDataItemsItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type SearchCodeResponseDataItemsItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: SearchCodeResponseDataItemsItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  forks_url: string;
  keys_url: string;
  collaborators_url: string;
  teams_url: string;
  hooks_url: string;
  issue_events_url: string;
  events_url: string;
  assignees_url: string;
  branches_url: string;
  tags_url: string;
  blobs_url: string;
  git_tags_url: string;
  git_refs_url: string;
  trees_url: string;
  statuses_url: string;
  languages_url: string;
  stargazers_url: string;
  contributors_url: string;
  subscribers_url: string;
  subscription_url: string;
  commits_url: string;
  git_commits_url: string;
  comments_url: string;
  issue_comment_url: string;
  contents_url: string;
  compare_url: string;
  merges_url: string;
  archive_url: string;
  downloads_url: string;
  issues_url: string;
  pulls_url: string;
  milestones_url: string;
  notifications_url: string;
  labels_url: string;
};
type SearchCodeResponseDataItemsItem = {
  name: string;
  path: string;
  sha: string;
  url: string;
  git_url: string;
  html_url: string;
  repository: SearchCodeResponseDataItemsItemRepository;
  score: number;
};
type SearchCodeResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchCodeResponseDataItemsItem>;
};

type SearchCommitsEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching commits](https://help.github.com/articles/searching-commits/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "author-date" | "committer-date";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"cloak">;

type SearchCommitsRequestOptions = {
  method: "GET";
  url: "/search/commits";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchCommitsResponseDataItemsItemRepositoryOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type SearchCommitsResponseDataItemsItemRepository = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: SearchCommitsResponseDataItemsItemRepositoryOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  forks_url: string;
  keys_url: string;
  collaborators_url: string;
  teams_url: string;
  hooks_url: string;
  issue_events_url: string;
  events_url: string;
  assignees_url: string;
  branches_url: string;
  tags_url: string;
  blobs_url: string;
  git_tags_url: string;
  git_refs_url: string;
  trees_url: string;
  statuses_url: string;
  languages_url: string;
  stargazers_url: string;
  contributors_url: string;
  subscribers_url: string;
  subscription_url: string;
  commits_url: string;
  git_commits_url: string;
  comments_url: string;
  issue_comment_url: string;
  contents_url: string;
  compare_url: string;
  merges_url: string;
  archive_url: string;
  downloads_url: string;
  issues_url: string;
  pulls_url: string;
  milestones_url: string;
  notifications_url: string;
  labels_url: string;
  releases_url: string;
  deployments_url: string;
};
type SearchCommitsResponseDataItemsItemParentsItem = {
  url: string;
  html_url: string;
  sha: string;
};
type SearchCommitsResponseDataItemsItemCommitter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type SearchCommitsResponseDataItemsItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type SearchCommitsResponseDataItemsItemCommitTree = {
  url: string;
  sha: string;
};
type SearchCommitsResponseDataItemsItemCommitCommitter = {
  date: string;
  name: string;
  email: string;
};
type SearchCommitsResponseDataItemsItemCommitAuthor = {
  date: string;
  name: string;
  email: string;
};
type SearchCommitsResponseDataItemsItemCommit = {
  url: string;
  author: SearchCommitsResponseDataItemsItemCommitAuthor;
  committer: SearchCommitsResponseDataItemsItemCommitCommitter;
  message: string;
  tree: SearchCommitsResponseDataItemsItemCommitTree;
  comment_count: number;
};
type SearchCommitsResponseDataItemsItem = {
  url: string;
  sha: string;
  html_url: string;
  comments_url: string;
  commit: SearchCommitsResponseDataItemsItemCommit;
  author: SearchCommitsResponseDataItemsItemAuthor;
  committer: SearchCommitsResponseDataItemsItemCommitter;
  parents: Array<SearchCommitsResponseDataItemsItemParentsItem>;
  repository: SearchCommitsResponseDataItemsItemRepository;
  score: number;
};
type SearchCommitsResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchCommitsResponseDataItemsItem>;
};

type SearchIssuesAndPullRequestsEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?:
    | "comments"
    | "reactions"
    | "reactions-+1"
    | "reactions--1"
    | "reactions-smile"
    | "reactions-thinking_face"
    | "reactions-heart"
    | "reactions-tada"
    | "interactions"
    | "created"
    | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type SearchIssuesAndPullRequestsRequestOptions = {
  method: "GET";
  url: "/search/issues";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchIssuesAndPullRequestsResponseDataItemsItemPullRequest = {
  html_url: null;
  diff_url: null;
  patch_url: null;
};
type SearchIssuesAndPullRequestsResponseDataItemsItemLabelsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  color: string;
};
type SearchIssuesAndPullRequestsResponseDataItemsItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
};
type SearchIssuesAndPullRequestsResponseDataItemsItem = {
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  id: number;
  node_id: string;
  number: number;
  title: string;
  user: SearchIssuesAndPullRequestsResponseDataItemsItemUser;
  labels: Array<SearchIssuesAndPullRequestsResponseDataItemsItemLabelsItem>;
  state: string;
  assignee: null;
  milestone: null;
  comments: number;
  created_at: string;
  updated_at: string;
  closed_at: null;
  pull_request: SearchIssuesAndPullRequestsResponseDataItemsItemPullRequest;
  body: string;
  score: number;
};
type SearchIssuesAndPullRequestsResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchIssuesAndPullRequestsResponseDataItemsItem>;
};

type SearchLabelsEndpoint = {
  /**
   * The id of the repository.
   */
  repository_id: number;
  /**
   * The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
   */
  q: string;
  /**
   * Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "created" | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
};

type SearchLabelsRequestOptions = {
  method: "GET";
  url: "/search/labels";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchLabelsResponseDataItemsItem = {
  id: number;
  node_id: string;
  url: string;
  name: string;
  color: string;
  default: boolean;
  description: string;
  score: number;
};
type SearchLabelsResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchLabelsResponseDataItemsItem>;
};

type SearchReposEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "stars" | "forks" | "help-wanted-issues" | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type SearchReposRequestOptions = {
  method: "GET";
  url: "/search/repositories";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchReposResponseDataItemsItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  received_events_url: string;
  type: string;
};
type SearchReposResponseDataItemsItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: SearchReposResponseDataItemsItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  created_at: string;
  updated_at: string;
  pushed_at: string;
  homepage: string;
  size: number;
  stargazers_count: number;
  watchers_count: number;
  language: string;
  forks_count: number;
  open_issues_count: number;
  master_branch: string;
  default_branch: string;
  score: number;
};
type SearchReposResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchReposResponseDataItemsItem>;
};

type SearchTopicsEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
   */
  q: string;
};

type SearchTopicsRequestOptions = {
  method: "GET";
  url: "/search/topics";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchTopicsResponseDataItemsItem = {
  name: string;
  display_name: string;
  short_description: string;
  description: string;
  created_by: string;
  released: string;
  created_at: string;
  updated_at: string;
  featured: boolean;
  curated: boolean;
  score: number;
};
type SearchTopicsResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchTopicsResponseDataItemsItem>;
};

type SearchUsersEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching users](https://help.github.com/articles/searching-users/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "followers" | "repositories" | "joined";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type SearchUsersRequestOptions = {
  method: "GET";
  url: "/search/users";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchUsersResponseDataItemsItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  received_events_url: string;
  type: string;
  score: number;
};
type SearchUsersResponseData = {
  total_count: number;
  incomplete_results: boolean;
  items: Array<SearchUsersResponseDataItemsItem>;
};

type TeamsGetLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};

type TeamsGetLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetLegacyResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
};
type TeamsGetLegacyResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
  members_count: number;
  repos_count: number;
  created_at: string;
  updated_at: string;
  organization: TeamsGetLegacyResponseDataOrganization;
};

type TeamsUpdateLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};

type TeamsUpdateLegacyRequestOptions = {
  method: "PATCH";
  url: "/teams/:team_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateLegacyResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  url: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string;
  name: string;
  company: string;
  blog: string;
  location: string;
  email: string;
  is_verified: boolean;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  public_repos: number;
  public_gists: number;
  followers: number;
  following: number;
  html_url: string;
  created_at: string;
  type: string;
};
type TeamsUpdateLegacyResponseData = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  repositories_url: string;
  parent: null;
  members_count: number;
  repos_count: number;
  created_at: string;
  updated_at: string;
  organization: TeamsUpdateLegacyResponseDataOrganization;
};

type TeamsDeleteLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};

type TeamsDeleteLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListDiscussionsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListDiscussionsLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/discussions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionsLegacyResponseDataItemReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsListDiscussionsLegacyResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListDiscussionsLegacyResponseDataItem = {
  author: TeamsListDiscussionsLegacyResponseDataItemAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: null;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsListDiscussionsLegacyResponseDataItemReactions;
};
type TeamsListDiscussionsLegacyResponseData = Array<
  TeamsListDiscussionsLegacyResponseDataItem
>;

type TeamsCreateDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The discussion post's title.
   */
  title: string;
  /**
   * The discussion post's body text.
   */
  body: string;
  /**
   * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
   */
  private?: boolean;
};

type TeamsCreateDiscussionLegacyRequestOptions = {
  method: "POST";
  url: "/teams/:team_id/discussions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionLegacyResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsCreateDiscussionLegacyResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCreateDiscussionLegacyResponseData = {
  author: TeamsCreateDiscussionLegacyResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: null;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsCreateDiscussionLegacyResponseDataReactions;
};

type TeamsGetDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};

type TeamsGetDiscussionLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/discussions/:discussion_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionLegacyResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsGetDiscussionLegacyResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsGetDiscussionLegacyResponseData = {
  author: TeamsGetDiscussionLegacyResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: null;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsGetDiscussionLegacyResponseDataReactions;
};

type TeamsUpdateDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion post's title.
   */
  title?: string;
  /**
   * The discussion post's body text.
   */
  body?: string;
};

type TeamsUpdateDiscussionLegacyRequestOptions = {
  method: "PATCH";
  url: "/teams/:team_id/discussions/:discussion_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionLegacyResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsUpdateDiscussionLegacyResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsUpdateDiscussionLegacyResponseData = {
  author: TeamsUpdateDiscussionLegacyResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  last_edited_at: string;
  html_url: string;
  node_id: string;
  number: number;
  pinned: boolean;
  private: boolean;
  team_url: string;
  title: string;
  updated_at: string;
  url: string;
  reactions: TeamsUpdateDiscussionLegacyResponseDataReactions;
};

type TeamsDeleteDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};

type TeamsDeleteDiscussionLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id/discussions/:discussion_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListDiscussionCommentsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListDiscussionCommentsLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/discussions/:discussion_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionCommentsLegacyResponseDataItemReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsListDiscussionCommentsLegacyResponseDataItemAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListDiscussionCommentsLegacyResponseDataItem = {
  author: TeamsListDiscussionCommentsLegacyResponseDataItemAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: null;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsListDiscussionCommentsLegacyResponseDataItemReactions;
};
type TeamsListDiscussionCommentsLegacyResponseData = Array<
  TeamsListDiscussionCommentsLegacyResponseDataItem
>;

type TeamsCreateDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};

type TeamsCreateDiscussionCommentLegacyRequestOptions = {
  method: "POST";
  url: "/teams/:team_id/discussions/:discussion_number/comments";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionCommentLegacyResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsCreateDiscussionCommentLegacyResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCreateDiscussionCommentLegacyResponseData = {
  author: TeamsCreateDiscussionCommentLegacyResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: null;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsCreateDiscussionCommentLegacyResponseDataReactions;
};

type TeamsGetDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};

type TeamsGetDiscussionCommentLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionCommentLegacyResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsGetDiscussionCommentLegacyResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsGetDiscussionCommentLegacyResponseData = {
  author: TeamsGetDiscussionCommentLegacyResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: null;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsGetDiscussionCommentLegacyResponseDataReactions;
};

type TeamsUpdateDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};

type TeamsUpdateDiscussionCommentLegacyRequestOptions = {
  method: "PATCH";
  url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionCommentLegacyResponseDataReactions = {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  confused: number;
  heart: number;
  hooray: number;
};
type TeamsUpdateDiscussionCommentLegacyResponseDataAuthor = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsUpdateDiscussionCommentLegacyResponseData = {
  author: TeamsUpdateDiscussionCommentLegacyResponseDataAuthor;
  body: string;
  body_html: string;
  body_version: string;
  created_at: string;
  last_edited_at: string;
  discussion_url: string;
  html_url: string;
  node_id: string;
  number: number;
  updated_at: string;
  url: string;
  reactions: TeamsUpdateDiscussionCommentLegacyResponseDataReactions;
};

type TeamsDeleteDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};

type TeamsDeleteDiscussionCommentLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type ReactionsListForTeamDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForTeamDiscussionCommentLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionCommentLegacyResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForTeamDiscussionCommentLegacyResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForTeamDiscussionCommentLegacyResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForTeamDiscussionCommentLegacyResponseData = Array<
  ReactionsListForTeamDiscussionCommentLegacyResponseDataItem
>;

type ReactionsCreateForTeamDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions = {
  method: "POST";
  url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionCommentLegacyResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForTeamDiscussionCommentLegacyResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForTeamDiscussionCommentLegacyResponseDataUser;
  content: string;
  created_at: string;
};

type ReactionsListForTeamDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"squirrel-girl">;

type ReactionsListForTeamDiscussionLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/discussions/:discussion_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionLegacyResponseDataItemUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsListForTeamDiscussionLegacyResponseDataItem = {
  id: number;
  node_id: string;
  user: ReactionsListForTeamDiscussionLegacyResponseDataItemUser;
  content: string;
  created_at: string;
};
type ReactionsListForTeamDiscussionLegacyResponseData = Array<
  ReactionsListForTeamDiscussionLegacyResponseDataItem
>;

type ReactionsCreateForTeamDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
} & RequiredPreview<"squirrel-girl">;

type ReactionsCreateForTeamDiscussionLegacyRequestOptions = {
  method: "POST";
  url: "/teams/:team_id/discussions/:discussion_number/reactions";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionLegacyResponseDataUser = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type ReactionsCreateForTeamDiscussionLegacyResponseData = {
  id: number;
  node_id: string;
  user: ReactionsCreateForTeamDiscussionLegacyResponseDataUser;
  content: string;
  created_at: string;
};

type TeamsListPendingInvitationsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListPendingInvitationsLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/invitations";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListPendingInvitationsLegacyResponseDataItemInviter = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListPendingInvitationsLegacyResponseDataItem = {
  id: number;
  login: string;
  email: string;
  role: string;
  created_at: string;
  inviter: TeamsListPendingInvitationsLegacyResponseDataItemInviter;
  team_count: number;
  invitation_team_url: string;
};
type TeamsListPendingInvitationsLegacyResponseData = Array<
  TeamsListPendingInvitationsLegacyResponseDataItem
>;

type TeamsListMembersLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Filters members returned by their role in the team. Can be one of:
   * \* `member` - normal members of the team.
   * \* `maintainer` - team maintainers.
   * \* `all` - all members of the team.
   */
  role?: "member" | "maintainer" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListMembersLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/members";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListMembersLegacyResponseDataItem = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListMembersLegacyResponseData = Array<
  TeamsListMembersLegacyResponseDataItem
>;

type TeamsGetMemberLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};

type TeamsGetMemberLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsAddMemberLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};

type TeamsAddMemberLegacyRequestOptions = {
  method: "PUT";
  url: "/teams/:team_id/members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddMemberLegacyResponseDataErrorsItem = {
  code: string;
  field: string;
  resource: string;
};
type TeamsAddMemberLegacyResponseData = {
  message: string;
  errors: Array<TeamsAddMemberLegacyResponseDataErrorsItem>;
};

type TeamsRemoveMemberLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};

type TeamsRemoveMemberLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id/members/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsGetMembershipLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};

type TeamsGetMembershipLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMembershipLegacyResponseData = {
  url: string;
  role: string;
  state: string;
};

type TeamsAddOrUpdateMembershipLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role that this user should have in the team. Can be one of:
   * \* `member` - a normal member of the team.
   * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
   */
  role?: "member" | "maintainer";
};

type TeamsAddOrUpdateMembershipLegacyRequestOptions = {
  method: "PUT";
  url: "/teams/:team_id/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateMembershipLegacyResponseData = {
  url: string;
  role: string;
  state: string;
};

type TeamsRemoveMembershipLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};

type TeamsRemoveMembershipLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id/memberships/:username";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListProjectsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
} & RequiredPreview<"inertia">;

type TeamsListProjectsLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/projects";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListProjectsLegacyResponseDataItemPermissions = {
  read: boolean;
  write: boolean;
  admin: boolean;
};
type TeamsListProjectsLegacyResponseDataItemCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListProjectsLegacyResponseDataItem = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: TeamsListProjectsLegacyResponseDataItemCreator;
  created_at: string;
  updated_at: string;
  organization_permission: string;
  private: boolean;
  permissions: TeamsListProjectsLegacyResponseDataItemPermissions;
};
type TeamsListProjectsLegacyResponseData = Array<
  TeamsListProjectsLegacyResponseDataItem
>;

type TeamsReviewProjectLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
} & RequiredPreview<"inertia">;

type TeamsReviewProjectLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsReviewProjectLegacyResponseDataPermissions = {
  read: boolean;
  write: boolean;
  admin: boolean;
};
type TeamsReviewProjectLegacyResponseDataCreator = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsReviewProjectLegacyResponseData = {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  name: string;
  body: string;
  number: number;
  state: string;
  creator: TeamsReviewProjectLegacyResponseDataCreator;
  created_at: string;
  updated_at: string;
  organization_permission: string;
  private: boolean;
  permissions: TeamsReviewProjectLegacyResponseDataPermissions;
};

type TeamsAddOrUpdateProjectLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The permission to grant to the team for this project. Can be one of:
   * \* `read` - team members can read, but not write to or administer this project.
   * \* `write` - team members can read and write, but not administer this project.
   * \* `admin` - team members can read, write and administer this project.
   * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
   */
  permission?: "read" | "write" | "admin";
} & RequiredPreview<"inertia">;

type TeamsAddOrUpdateProjectLegacyRequestOptions = {
  method: "PUT";
  url: "/teams/:team_id/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateProjectLegacyResponseData = {
  message: string;
  documentation_url: string;
};

type TeamsRemoveProjectLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
};

type TeamsRemoveProjectLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id/projects/:project_id";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListReposLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListReposLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/repos";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListReposLegacyResponseDataItemLicense = {
  key: string;
  name: string;
  spdx_id: string;
  url: string;
  node_id: string;
};
type TeamsListReposLegacyResponseDataItemPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type TeamsListReposLegacyResponseDataItemOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsListReposLegacyResponseDataItem = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: TeamsListReposLegacyResponseDataItemOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: TeamsListReposLegacyResponseDataItemPermissions;
  template_repository: null;
  temp_clone_token: string;
  subscribers_count: number;
  network_count: number;
  license: TeamsListReposLegacyResponseDataItemLicense;
};
type TeamsListReposLegacyResponseData = Array<
  TeamsListReposLegacyResponseDataItem
>;

type TeamsCheckManagesRepoLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type TeamsCheckManagesRepoLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCheckManagesRepoLegacyResponseDataPermissions = {
  pull: boolean;
  triage: boolean;
  push: boolean;
  maintain: boolean;
  admin: boolean;
};
type TeamsCheckManagesRepoLegacyResponseDataSourcePermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type TeamsCheckManagesRepoLegacyResponseDataSourceOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCheckManagesRepoLegacyResponseDataSource = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: TeamsCheckManagesRepoLegacyResponseDataSourceOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: TeamsCheckManagesRepoLegacyResponseDataSourcePermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type TeamsCheckManagesRepoLegacyResponseDataParentPermissions = {
  admin: boolean;
  push: boolean;
  pull: boolean;
};
type TeamsCheckManagesRepoLegacyResponseDataParentOwner = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCheckManagesRepoLegacyResponseDataParent = {
  id: number;
  node_id: string;
  name: string;
  full_name: string;
  owner: TeamsCheckManagesRepoLegacyResponseDataParentOwner;
  private: boolean;
  html_url: string;
  description: string;
  fork: boolean;
  url: string;
  archive_url: string;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  deployments_url: string;
  downloads_url: string;
  events_url: string;
  forks_url: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  languages_url: string;
  merges_url: string;
  milestones_url: string;
  notifications_url: string;
  pulls_url: string;
  releases_url: string;
  ssh_url: string;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  tags_url: string;
  teams_url: string;
  trees_url: string;
  clone_url: string;
  mirror_url: string;
  hooks_url: string;
  svn_url: string;
  homepage: string;
  language: null;
  forks_count: number;
  stargazers_count: number;
  watchers_count: number;
  size: number;
  default_branch: string;
  open_issues_count: number;
  is_template: boolean;
  topics: Array<string>;
  has_issues: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  has_pages: boolean;
  has_downloads: boolean;
  archived: boolean;
  disabled: boolean;
  visibility: string;
  pushed_at: string;
  created_at: string;
  updated_at: string;
  permissions: TeamsCheckManagesRepoLegacyResponseDataParentPermissions;
  allow_rebase_merge: boolean;
  template_repository: null;
  temp_clone_token: string;
  allow_squash_merge: boolean;
  allow_merge_commit: boolean;
  subscribers_count: number;
  network_count: number;
};
type TeamsCheckManagesRepoLegacyResponseDataOrganization = {
  login: string;
  id: number;
  node_id: string;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: string;
  site_admin: boolean;
};
type TeamsCheckManagesRepoLegacyResponseData = {
  organization: TeamsCheckManagesRepoLegacyResponseDataOrganization;
  parent: TeamsCheckManagesRepoLegacyResponseDataParent;
  source: TeamsCheckManagesRepoLegacyResponseDataSource;
  permissions: TeamsCheckManagesRepoLegacyResponseDataPermissions;
};

type TeamsAddOrUpdateRepoLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The permission to grant the team on this repository. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer this repository.
   * \* `push` - team members can pull and push, but not administer this repository.
   * \* `admin` - team members can pull, push and administer this repository.
   *
   * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
   */
  permission?: "pull" | "push" | "admin";
};

type TeamsAddOrUpdateRepoLegacyRequestOptions = {
  method: "PUT";
  url: "/teams/:team_id/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsRemoveRepoLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};

type TeamsRemoveRepoLegacyRequestOptions = {
  method: "DELETE";
  url: "/teams/:team_id/repos/:owner/:repo";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

type TeamsListIdPGroupsForLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};

type TeamsListIdPGroupsForLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/team-sync/group-mappings";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsForLegacyResponseDataGroupsItem = {
  group_id: string;
  group_name: string;
  group_description: string;
};
type TeamsListIdPGroupsForLegacyResponseData = {
  groups: Array<TeamsListIdPGroupsForLegacyResponseDataGroupsItem>;
};

type TeamsCreateOrUpdateIdPGroupConnectionsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
   */
  groups: TeamsCreateOrUpdateIdPGroupConnectionsLegacyParamsGroups[];
};

type TeamsCreateOrUpdateIdPGroupConnectionsLegacyRequestOptions = {
  method: "PATCH";
  url: "/teams/:team_id/team-sync/group-mappings";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateOrUpdateIdPGroupConnectionsLegacyResponseDataGroupsItem = {
  group_id: string;
  group_name: string;
  group_description: string;
};
type TeamsCreateOrUpdateIdPGroupConnectionsLegacyResponseData = {
  groups: Array<
    TeamsCreateOrUpdateIdPGroupConnectionsLegacyResponseDataGroupsItem
  >;
};

type TeamsListChildLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};

type TeamsListChildLegacyRequestOptions = {
  method: "GET";
  url: "/teams/:team_id/teams";
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListChildLegacyResponseDataItemParent = {
  id: number;
  node_id: string;
  url: string;
  html_url: string;
  name: string;
  slug: string;
  description: string;
  privacy: string;
  permission: string;
  members_url: string;
  r