# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['blitzly', 'blitzly.etc', 'blitzly.plots']

package_data = \
{'': ['*']}

install_requires = \
['nbformat==5.7.2',
 'numpy==1.23.5',
 'pandas==1.5.2',
 'plotly==5.11.0',
 'rich>=13.3.1,<14.0.0',
 'scikit-learn==1.2.0']

setup_kwargs = {
    'name': 'blitzly',
    'version': '0.6.0',
    'description': 'Lightning-fast way to get plots with Plotly',
    'long_description': '<img src="https://github.com/invia-flights/blitzly/raw/main/docs/assets/images/icon.png" alt="blitzly logo" width="200" height="200"/><br>\n# blitzly ⚡️\n***Lightning-fast way to get plots with Plotly***\n\n[![DeployPackage](https://github.com/invia-flights/blitzly/actions/workflows/deploy-package.yml/badge.svg)](https://github.com/invia-flights/blitzly/actions/workflows/deploy-package.yml)\n[![Testing](https://github.com/invia-flights/blitzly/actions/workflows/testing.yml/badge.svg?branch=main)](https://github.com/invia-flights/blitzly/actions/workflows/testing.yml)\n[![codecov](https://codecov.io/gh/invia-flights/blitzly/branch/develop/graph/badge.svg?token=ROCDJJV8JV)](https://codecov.io/gh/invia-flights/blitzly)\n[![pypi](https://img.shields.io/pypi/v/blitzly)](https://pypi.org/project/blitzly/)\n[![PyPI - Downloads](https://img.shields.io/pypi/dm/blitzly)](https://pypistats.org/packages/blitzly)\n[![python version](https://img.shields.io/pypi/pyversions/blitzly?logo=python&logoColor=yellow)](https://www.python.org/downloads/)\n[![docs](https://img.shields.io/badge/docs-mkdoks%20material-blue)](https://invia-flights.github.io/blitzly/)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![license](https://img.shields.io/github/license/invia-flights/blitzly)](https://github.com/invia-flights/blitzly/blob/main/LICENSE)\n[![isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://github.com/PyCQA/isort)\n[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](https://github.com/python/mypy)\n[![linting: pylint](https://img.shields.io/badge/linting-pylint-yellowgreen)](https://github.com/PyCQA/pylint)\n## Introduction 🎉\nPlotly is great and powerful. But with great power comes great responsibility 🕸. And sometimes you just want to get a plot up and running as fast as possible. That\'s where blitzly ⚡️ comes in. It provides a set of functions that allow you to create plots with Plotly in a lightning-fast way. It\'s not meant to replace Plotly, but rather to complement it.\n\nCheck out some examples in the [Jupyter notebook](https://github.com/invia-flights/blitzly/blob/main/examples/playground.ipynb).<br>\n[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/invia-flights/blitzly/blob/main/examples/playground.ipynb)\n\n## Install the package 📦\nIf you are using [pip](https://pip.pypa.io/en/stable/), you can install the package with the following command:\n```bash\npip install blitzly\n```\n\nIf you are using [Poetry](https://python-poetry.org/), you can install the package with the following command:\n```bash\npoetry add blitzly\n```\n## installing dependencies 🧑\u200d🔧\nWith [pip](https://pip.pypa.io/en/stable/):\n```bash\npip install -r requirements.txt\n```\n\nWith [Poetry](https://python-poetry.org/):\n```bash\npoetry install\n```\n## Available plots (so far 🚀)\n| Module | Method | Description |\n| ------ | ------ | ----------- |\n| [`bar`](https://invia-flights.github.io/blitzly/plots/bar/) | [`model_feature_importances`](https://invia-flights.github.io/blitzly/plots/bar/#blitzly.plots.bar.model_feature_importances) | Creates a bar chart with the feature importance of a model. |\n| [`bar`](https://invia-flights.github.io/blitzly/plots/bar/) | [`multi_chart`](https://invia-flights.github.io/blitzly/plots/bar/#blitzly.plots.bar.multi_chart) | Creates a bar chart with multiple groups. |\n| [`dumbbell`](https://invia-flights.github.io/blitzly/plots/dumbbell/) | [`simple_dumbbell`](https://invia-flights.github.io/blitzly/plots/dumbbell/#blitzly.plots.dumbbell.simple_dumbbell) | Plots a dumbbell plot. This can be used to compare two columns of data to visualize changes. |\n| [`histogram`](https://invia-flights.github.io/blitzly/plots/histogram/) | [`simple_histogram`](https://invia-flights.github.io/blitzly/plots/histogram/#blitzly.plots.histogram.simple_histogram) | Plots a histogram with one ore more distributions. |\n| [`matrix`](https://invia-flights.github.io/blitzly/plots/matrix/) | [`binary_confusion_matrix`](https://invia-flights.github.io/blitzly/plots/matrix/#blitzly.plots.matrix.binary_confusion_matrix) | Plots a confusion matrix for binary classification data. |\n| [`matrix`](https://invia-flights.github.io/blitzly/plots/matrix/) | [`cramers_v_corr_matrix`](https://invia-flights.github.io/blitzly/plots/matrix/#blitzly.plots.matrix.cramers_v_corr_matrix) | Cramer\'s V correlation for categorical features. |\n| [`matrix`](https://invia-flights.github.io/blitzly/plots/matrix/) | [`pearson_corr_matrix`](https://invia-flights.github.io/blitzly/plots/matrix/#blitzly.plots.matrix.pearson_corr_matrix) | Plots a Pearson product-moment correlation coefficients matrix. |\n| [`scatter`](https://invia-flights.github.io/blitzly/plots/scatter/) | [`scatter_matrix`](https://invia-flights.github.io/blitzly/plots/scatter/#blitzly.plots.scatter.scatter_matrix) | Plots a scatter matrix. |\n| [`scatter`](https://invia-flights.github.io/blitzly/plots/scatter/) | [`multi_scatter`](https://invia-flights.github.io/blitzly/plots/scatter/#blitzly.plots.scatter.multi_scatter) | Create a multi scatter plot. It can be used to visualize the relationship between multiple variables from the same Pandas DataFrame. |\n| [`scatter`](https://invia-flights.github.io/blitzly/plots/scatter/) | [`dimensionality_reduction`](https://invia-flights.github.io/blitzly/plots/scatter/#blitzly.plots.scatter.dimensionality_reduction) | Creates a plot to visualize higher dimensionality reduced data using matrix decomposition |\n\n\n### Subplots 👩\u200d👩\u200d👧\u200d👦\n\n| Module | Method | Description |\n| ------ | ------ | ----------- |\n| [`subplots`](https://invia-flights.github.io/blitzly/plots/subplots/) | [`make_subplots`](https://invia-flights.github.io/blitzly/plots/subplots/#blitzly.subplots.make_subplots) | Create subplots using figure objects created with any of the above available plots. |\n\n## Usage 🤌\nHere are some examples. You can also open the [playground notebook](https://github.com/invia-flights/blitzly/blob/main/examples/playground.ipynb) 📒.\n\n**[`dimensionality_reduction`](https://invia-flights.github.io/blitzly/plots/scatter/#blitzly.plots.scatter.dimensionality_reduction):**\n```python\nfrom blitzly.plots.scatter import dimensionality_reduction\nimport plotly.express as px\n\ndf = px.data.iris()\ndimensionality_reduction(\n  df,\n  n_components=2,\n  target_column="species",\n  reduction_funcs=["PCA", "TNSE"],\n)\n```\nGives you this:\n<img src="https://github.com/invia-flights/blitzly/raw/main/docs/assets/images/example_plots/dimensionality_reduction.png" alt="dimensionality reduction plot" width="1000" height="555"/>\n\n\n**[`multi_bar`](https://invia-flights.github.io/blitzly/plots/bar/#blitzly.plots.bar.multi_bar):**\n```python\nfrom blitzly.plots.bar import multi_bar\nimport numpy as np\n\ndata = np.array([[8, 3, 6], [9, 7, 5]])\nerror_array = np.array([[0.1, 0.2, 0.3], [0.4, 0.5, 0.6]])\n\nmulti_bar(\n    data,\n    x_labels=["Vienna", "Berlin", "Lisbon"],\n    group_labels=["Personal rating", "Global rating"],\n    errors=error_array,\n    title="City ratings 🏙",\n    mark_x_labels=["Lisbon"],\n    write_html_path="see_the_blitz.html",\n)\n```\nGives you this:\n<img src="https://github.com/invia-flights/blitzly/raw/main/docs/assets/images/example_plots/multi_bars.png" alt="multi bars plot" width="1000" height="555"/>\n\n**[`scatter matrix`](https://invia-flights.github.io/blitzly/plots/scatter/#blitzly.plots.scatter.scatter_matrix):**\n```python\n    from blitzly.plots.scatter import scatter_matrix\n    import numpy as np\n    import pandas as pd\n\n    foo = np.random.randn(1000)\n    bar = np.random.randn(1000) + 1\n    blitz = np.random.randint(2, size=1000)\n    licht = np.random.randint(2, size=1000)\n    data = np.array([foo, bar, blitz, licht])\n    df = pd.DataFrame(data.T, columns=["foo", "bar", "blitz", "licht"])\n\n    scatter_matrix(\n        df,\n        dimensions=["foo", "bar", "blitz"],\n        color_dim=df["licht"],\n        title="My first scatter matrix 🙃",\n        show_upper_half=True,\n        diagonal_visible=False,\n        marker_color_scale="Rainbow",\n        marker_line_color="blue",\n        size=(500, 500),\n    )\n```\nGives you this:\n<img src="https://github.com/invia-flights/blitzly/raw/main/docs/assets/images/example_plots/scatter_matrix.png" alt="scatter-matrix plot" width="500" height="500"/>\n\n## Contributing 👩\u200d💻\n\nPlease check out the [guide](https://invia-flights.github.io/blitzly/CONTRIBUTING/) on how to contribute to this project.\n',
    'author': 'Christopher Lemke',
    'author_email': 'christopher.lemke@invia.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/invia-flights/blitzly',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
