"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
class HttpLambdaIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct.
     * @param handler the Lambda handler to integrate with.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id, handler, props = {}) {
        super(id);
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpLambdaIntegrationProps(props);
        this._id = id;
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${(_b = route.path) !== null && _b !== void 0 ? _b : ''}`,
            }),
        });
        return {
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.handler.functionArn,
            payloadFormatVersion: (_c = this.props.payloadFormatVersion) !== null && _c !== void 0 ? _c : aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpLambdaIntegration = HttpLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration", version: "2.1.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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