# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.39.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class PackagePutRequired(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tracking_reference': 'str',
        'status': 'str',
        'carrier': 'str',
        'delivery_slip_url': 'str',
        'created_date': 'str',
        'packed_date': 'str',
        'processed_date': 'str',
        'shipped_date': 'str',
        'cancel_date': 'str',
        'customs_note': 'str'
    }

    attribute_map = {
        'tracking_reference': 'trackingReference',
        'status': 'status',
        'carrier': 'carrier',
        'delivery_slip_url': 'deliverySlipUrl',
        'created_date': 'createdDate',
        'packed_date': 'packedDate',
        'processed_date': 'processedDate',
        'shipped_date': 'shippedDate',
        'cancel_date': 'cancelDate',
        'customs_note': 'customsNote'
    }

    def __init__(self, tracking_reference=None, status=None, carrier=None, delivery_slip_url=None, created_date=None, packed_date=None, processed_date=None, shipped_date=None, cancel_date=None, customs_note=None, local_vars_configuration=None):  # noqa: E501
        """PackagePutRequired - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._tracking_reference = None
        self._status = None
        self._carrier = None
        self._delivery_slip_url = None
        self._created_date = None
        self._packed_date = None
        self._processed_date = None
        self._shipped_date = None
        self._cancel_date = None
        self._customs_note = None
        self.discriminator = None

        self.tracking_reference = tracking_reference
        if status is not None:
            self.status = status
        if carrier is not None:
            self.carrier = carrier
        if delivery_slip_url is not None:
            self.delivery_slip_url = delivery_slip_url
        if created_date is not None:
            self.created_date = created_date
        if packed_date is not None:
            self.packed_date = packed_date
        if processed_date is not None:
            self.processed_date = processed_date
        if shipped_date is not None:
            self.shipped_date = shipped_date
        if cancel_date is not None:
            self.cancel_date = cancel_date
        if customs_note is not None:
            self.customs_note = customs_note

    @property
    def tracking_reference(self):
        """Gets the tracking_reference of this PackagePutRequired.  # noqa: E501


        :return: The tracking_reference of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._tracking_reference

    @tracking_reference.setter
    def tracking_reference(self, tracking_reference):
        """Sets the tracking_reference of this PackagePutRequired.


        :param tracking_reference: The tracking_reference of this PackagePutRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and tracking_reference is None:  # noqa: E501
            raise ValueError("Invalid value for `tracking_reference`, must not be `None`")  # noqa: E501

        self._tracking_reference = tracking_reference

    @property
    def status(self):
        """Gets the status of this PackagePutRequired.  # noqa: E501

        package status, 4 available options: UNPROCESSED, PACKED, PROCESSED, CANCEL. Status SHIPPED is updated by confirm api  # noqa: E501

        :return: The status of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PackagePutRequired.

        package status, 4 available options: UNPROCESSED, PACKED, PROCESSED, CANCEL. Status SHIPPED is updated by confirm api  # noqa: E501

        :param status: The status of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def carrier(self):
        """Gets the carrier of this PackagePutRequired.  # noqa: E501

        nomad express carrier name  # noqa: E501

        :return: The carrier of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._carrier

    @carrier.setter
    def carrier(self, carrier):
        """Sets the carrier of this PackagePutRequired.

        nomad express carrier name  # noqa: E501

        :param carrier: The carrier of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._carrier = carrier

    @property
    def delivery_slip_url(self):
        """Gets the delivery_slip_url of this PackagePutRequired.  # noqa: E501

        express delivery slip url  # noqa: E501

        :return: The delivery_slip_url of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._delivery_slip_url

    @delivery_slip_url.setter
    def delivery_slip_url(self, delivery_slip_url):
        """Sets the delivery_slip_url of this PackagePutRequired.

        express delivery slip url  # noqa: E501

        :param delivery_slip_url: The delivery_slip_url of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._delivery_slip_url = delivery_slip_url

    @property
    def created_date(self):
        """Gets the created_date of this PackagePutRequired.  # noqa: E501

        waybill create date  # noqa: E501

        :return: The created_date of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """Sets the created_date of this PackagePutRequired.

        waybill create date  # noqa: E501

        :param created_date: The created_date of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._created_date = created_date

    @property
    def packed_date(self):
        """Gets the packed_date of this PackagePutRequired.  # noqa: E501

        waybill packed date  # noqa: E501

        :return: The packed_date of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._packed_date

    @packed_date.setter
    def packed_date(self, packed_date):
        """Sets the packed_date of this PackagePutRequired.

        waybill packed date  # noqa: E501

        :param packed_date: The packed_date of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._packed_date = packed_date

    @property
    def processed_date(self):
        """Gets the processed_date of this PackagePutRequired.  # noqa: E501

        waybill processed date  # noqa: E501

        :return: The processed_date of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._processed_date

    @processed_date.setter
    def processed_date(self, processed_date):
        """Sets the processed_date of this PackagePutRequired.

        waybill processed date  # noqa: E501

        :param processed_date: The processed_date of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._processed_date = processed_date

    @property
    def shipped_date(self):
        """Gets the shipped_date of this PackagePutRequired.  # noqa: E501

        waybill shipped date  # noqa: E501

        :return: The shipped_date of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._shipped_date

    @shipped_date.setter
    def shipped_date(self, shipped_date):
        """Sets the shipped_date of this PackagePutRequired.

        waybill shipped date  # noqa: E501

        :param shipped_date: The shipped_date of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._shipped_date = shipped_date

    @property
    def cancel_date(self):
        """Gets the cancel_date of this PackagePutRequired.  # noqa: E501

        waybill cancel date  # noqa: E501

        :return: The cancel_date of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._cancel_date

    @cancel_date.setter
    def cancel_date(self, cancel_date):
        """Sets the cancel_date of this PackagePutRequired.

        waybill cancel date  # noqa: E501

        :param cancel_date: The cancel_date of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._cancel_date = cancel_date

    @property
    def customs_note(self):
        """Gets the customs_note of this PackagePutRequired.  # noqa: E501

        Customs order declaration results  # noqa: E501

        :return: The customs_note of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._customs_note

    @customs_note.setter
    def customs_note(self, customs_note):
        """Sets the customs_note of this PackagePutRequired.

        Customs order declaration results  # noqa: E501

        :param customs_note: The customs_note of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._customs_note = customs_note

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackagePutRequired):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackagePutRequired):
            return True

        return self.to_dict() != other.to_dict()
