# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.39.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class PackageItemQuick(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'sku_number': 'str',
        'barcode': 'str',
        'quantity': 'int',
        'price': 'float'
    }

    attribute_map = {
        'sku_number': 'skuNumber',
        'barcode': 'barcode',
        'quantity': 'quantity',
        'price': 'price'
    }

    def __init__(self, sku_number=None, barcode=None, quantity=None, price=None, local_vars_configuration=None):  # noqa: E501
        """PackageItemQuick - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._sku_number = None
        self._barcode = None
        self._quantity = None
        self._price = None
        self.discriminator = None

        self.sku_number = sku_number
        if barcode is not None:
            self.barcode = barcode
        self.quantity = quantity
        self.price = price

    @property
    def sku_number(self):
        """Gets the sku_number of this PackageItemQuick.  # noqa: E501

        The sku Number of this product  # noqa: E501

        :return: The sku_number of this PackageItemQuick.  # noqa: E501
        :rtype: str
        """
        return self._sku_number

    @sku_number.setter
    def sku_number(self, sku_number):
        """Sets the sku_number of this PackageItemQuick.

        The sku Number of this product  # noqa: E501

        :param sku_number: The sku_number of this PackageItemQuick.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and sku_number is None:  # noqa: E501
            raise ValueError("Invalid value for `sku_number`, must not be `None`")  # noqa: E501

        self._sku_number = sku_number

    @property
    def barcode(self):
        """Gets the barcode of this PackageItemQuick.  # noqa: E501

        The barcode of this product  # noqa: E501

        :return: The barcode of this PackageItemQuick.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this PackageItemQuick.

        The barcode of this product  # noqa: E501

        :param barcode: The barcode of this PackageItemQuick.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def quantity(self):
        """Gets the quantity of this PackageItemQuick.  # noqa: E501

        The quantity of this product in current order  # noqa: E501

        :return: The quantity of this PackageItemQuick.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this PackageItemQuick.

        The quantity of this product in current order  # noqa: E501

        :param quantity: The quantity of this PackageItemQuick.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and quantity is None:  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501

        self._quantity = quantity

    @property
    def price(self):
        """Gets the price of this PackageItemQuick.  # noqa: E501

        The price of this product, not including any discount and tax.  # noqa: E501

        :return: The price of this PackageItemQuick.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this PackageItemQuick.

        The price of this product, not including any discount and tax.  # noqa: E501

        :param price: The price of this PackageItemQuick.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and price is None:  # noqa: E501
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageItemQuick):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageItemQuick):
            return True

        return self.to_dict() != other.to_dict()
