"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SslServerTest = exports.SslServerTestGrade = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const aws_stepfunctions_tasks_1 = require("aws-cdk-lib/aws-stepfunctions-tasks");
const constructs_1 = require("constructs");
const analyze_function_1 = require("./analyze-function");
const extract_grade_function_1 = require("./extract-grade-function");
/**
 * SSL Server test grade
 */
var SslServerTestGrade;
(function (SslServerTestGrade) {
    SslServerTestGrade["A_PLUS"] = "A+";
    SslServerTestGrade["A"] = "A";
    SslServerTestGrade["A_MINUS"] = "A-";
    SslServerTestGrade["B"] = "B";
    SslServerTestGrade["C"] = "C";
    SslServerTestGrade["D"] = "D";
    SslServerTestGrade["E"] = "E";
    SslServerTestGrade["F"] = "F";
})(SslServerTestGrade = exports.SslServerTestGrade || (exports.SslServerTestGrade = {}));
/**
 * Perform SSL server test for a hostname
 */
class SslServerTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.alarmTopic = props.alarmTopic ?? new aws_sns_1.Topic(this, 'AlarmTopic');
        const stateMachine = SslServerTestStateMachine.getOrCreate(this);
        this.alarmTopic.grantPublish(stateMachine);
        const rule = new aws_events_1.Rule(this, 'Rule', {
            schedule: props.schedule ?? aws_events_1.Schedule.rate(aws_cdk_lib_1.Duration.days(1)),
        });
        rule.addTarget(new aws_events_targets_1.SfnStateMachine(stateMachine, {
            input: aws_events_1.RuleTargetInput.fromObject({
                host: props.host,
                minimumGrade: props.minimumGrade ?? SslServerTestGrade.A_PLUS,
                alarmTopicArn: this.alarmTopic.topicArn,
            }),
        }));
    }
}
exports.SslServerTest = SslServerTest;
_a = JSII_RTTI_SYMBOL_1;
SslServerTest[_a] = { fqn: "cloudstructs.SslServerTest", version: "0.6.28" };
class SslServerTestStateMachine extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        const analyzeFunction = new analyze_function_1.AnalyzeFunction(this, 'AnalyzeFunction', {
            timeout: aws_cdk_lib_1.Duration.seconds(30),
        });
        const startAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Start Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
                startNew: 'on',
            }),
            payloadResponseOnly: true,
        }).addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(2),
            errors: ['Lambda.Unknown'],
        });
        const wait = new aws_stepfunctions_1.Wait(this, 'Wait', {
            time: aws_stepfunctions_1.WaitTime.duration(aws_cdk_lib_1.Duration.seconds(30)),
        });
        const pollAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Poll Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
            }),
            payloadResponseOnly: true,
        }).addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(2),
            errors: ['Lambda.Unknown'],
        });
        ;
        const extractGradeFunction = new extract_grade_function_1.ExtractGradeFunction(this, 'ExtractGradeFunction');
        const extractGrade = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Extract Grade', {
            lambdaFunction: extractGradeFunction,
            payloadResponseOnly: true,
            resultPath: '$.grade',
        });
        const notify = new SnsPublishToTopicAtPath(this, 'Notify', {
            path: '$$.Execution.Input.alarmTopicArn',
            message: aws_stepfunctions_1.TaskInput.fromJsonPathAt('States.JsonToString($)'),
            subject: aws_stepfunctions_1.JsonPath.stringAt("States.Format('SSL grade for {} is below minimum grade ({} < {})', $.host, $.grade, $$.Execution.Input.minimumGrade)"),
        });
        const fail = new aws_stepfunctions_1.Fail(this, 'Fail');
        this.stateMachine = new aws_stepfunctions_1.StateMachine(this, 'StateMachine', {
            definition: startAnalysis
                .next(wait)
                .next(pollAnalysis)
                .next(new aws_stepfunctions_1.Choice(this, 'Is Ready ?')
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'READY'), extractGrade.next(new aws_stepfunctions_1.Choice(this, 'Is Grade Below Minimum?')
                .when(aws_stepfunctions_1.Condition.stringLessThanJsonPath('$$.Execution.Input.minimumGrade', '$.grade'), notify)
                .otherwise(new aws_stepfunctions_1.Pass(this, 'Pass'))))
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'ERROR'), fail)
                .otherwise(wait)),
            timeout: aws_cdk_lib_1.Duration.hours(1),
        });
    }
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const uid = 'cloudstructs/ssl-server-test.StateMachine';
        const construct = stack.node.tryFindChild(uid) ?? new SslServerTestStateMachine(stack, uid);
        return construct.stateMachine;
    }
}
class SnsPublishToTopicAtPath extends aws_stepfunctions_1.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
    }
    _renderTask() {
        return {
            Resource: `arn:${aws_cdk_lib_1.Stack.of(this).partition}:states:::sns:publish`,
            Parameters: aws_stepfunctions_1.FieldUtils.renderObject({
                TopicArn: aws_stepfunctions_1.JsonPath.stringAt(this.props.path),
                Message: this.props.message.value,
                Subject: this.props.subject,
            }),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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