"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/toolkit-cleaner/get-stack-names.lambda.ts
var get_stack_names_lambda_exports = {};
__export(get_stack_names_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(get_stack_names_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var cloudFormation = new import_aws_sdk.CloudFormation();
async function handler() {
  const res = [];
  let nextToken;
  let finished = false;
  while (!finished) {
    const response = await cloudFormation.describeStacks({ NextToken: nextToken }).promise();
    res.push(...(response.Stacks ?? []).map((s) => s.StackName));
    nextToken = response.NextToken;
    if (nextToken === void 0) {
      finished = true;
    }
  }
  return res;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
