"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/toolkit-cleaner/clean-images.lambda.ts
var clean_images_lambda_exports = {};
__export(clean_images_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(clean_images_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var ecr = new import_aws_sdk.ECR();
async function handler(assetHashes) {
  var _a;
  if (!process.env.REPOSITORY_NAME) {
    throw new Error("Missing REPOSITORY_NAME");
  }
  let deleted = 0;
  let reclaimed = 0;
  let nextToken;
  let finished = false;
  while (!finished) {
    const response = await ecr.describeImages({
      repositoryName: process.env.REPOSITORY_NAME,
      nextToken
    }).promise();
    const toDelete = (_a = response.imageDetails) == null ? void 0 : _a.filter((x) => {
      if (!x.imageTags) {
        return false;
      }
      let pred = !assetHashes.includes(x.imageTags[0]);
      if (process.env.RETAIN_MILLISECONDS) {
        if (!x.imagePushedAt) {
          return false;
        }
        const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
        pred = pred && x.imagePushedAt && x.imagePushedAt < limitDate;
      }
      return pred;
    });
    if (toDelete && toDelete.length !== 0) {
      if (process.env.RUN) {
        await ecr.batchDeleteImage({
          repositoryName: process.env.REPOSITORY_NAME,
          imageIds: toDelete.map((x) => ({ imageTag: x.imageTags[0] }))
        }).promise();
      }
      deleted += toDelete.length;
      reclaimed += toDelete.reduce((acc, x) => acc + (x.imageSizeInBytes ?? 0), 0);
    }
    nextToken = response.nextToken;
    if (nextToken === void 0) {
      finished = true;
    }
  }
  return {
    Deleted: deleted,
    Reclaimed: reclaimed
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
