"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/slack-events/events.lambda.ts
var events_lambda_exports = {};
__export(events_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(events_lambda_exports);
var import_aws_sdk = require("aws-sdk");

// src/slack-events/signature.ts
var crypto = __toESM(require("crypto"));
function verifyRequestSignature(options) {
  const fiveMinutesAgo = Math.floor(Date.now() / 1e3) - 60 * 5;
  if (options.requestTimestamp < fiveMinutesAgo) {
    console.error("Slack request signing verification outdated");
    return false;
  }
  const hmac = crypto.createHmac("sha256", options.signingSecret);
  const [version, hash] = options.requestSignature.split("=");
  hmac.update(`${version}:${options.requestTimestamp}:${options.body}`);
  const hex = hmac.digest("hex");
  if (hash.length !== hex.length || !crypto.timingSafeEqual(Buffer.from(hash), Buffer.from(hex))) {
    console.error("Slack request signing verification failed");
    return false;
  }
  return true;
}

// src/slack-events/events.lambda.ts
async function handler(event) {
  console.log("Event: %j", event);
  const response = {
    statusCode: 200,
    body: ""
  };
  try {
    if (!process.env.SLACK_SIGNING_SECRET)
      throw new Error("The environment variable SLACK_SIGNING_SECRET is not defined");
    if (!event.body)
      throw new Error("Missing body");
    if (!event.headers["X-Slack-Signature"])
      throw new Error("Missing X-Slack-Signature");
    if (!event.headers["X-Slack-Request-Timestamp"])
      throw new Error("Missing X-Slack-Request-Timestamp");
    if (!verifyRequestSignature({
      body: event.body,
      requestSignature: event.headers["X-Slack-Signature"],
      requestTimestamp: parseInt(event.headers["X-Slack-Request-Timestamp"], 10),
      signingSecret: process.env.SLACK_SIGNING_SECRET
    })) {
      response.statusCode = 403;
      return response;
    }
    const body = JSON.parse(event.body);
    console.log("Body: %j", body);
    if (body.type === "url_verification") {
      console.log("URL verification");
      response.body = JSON.stringify({ challenge: body.challenge });
      return response;
    }
    const eventBridge = new import_aws_sdk.EventBridge({ apiVersion: "2015-10-07" });
    const putEvents = await eventBridge.putEvents({
      Entries: [
        {
          Detail: event.body,
          DetailType: "Slack Event",
          Source: "slack",
          Resources: [body.api_app_id],
          EventBusName: process.env.EVENT_BUS_NAME,
          Time: new Date(body.event_time)
        }
      ]
    }).promise();
    console.log("Put events: %j", putEvents);
    return response;
  } catch (err) {
    console.log(err);
    response.statusCode = 500;
    return response;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
