#-- bibtextidying 0.1.0 --

Author: Jian Ding and ShiBo Xu and Kun Chen
Email: qbei113043@163.com
Mentor: X. Fu and TingYu Luo

##[Purpose]
This software is trying to help users to tidy up their bibtex files.

##[Prerequisite]
- Python3
- MySQL

##[Requires Projects]
- bibtexparser
- mysqlclient

##[Github]
https://gitee.com/chen-kun19/summer-program

##[Manual]
- **How to install it?**
  - use command following.
    - For Windows 
    ```PowerShell
    pip install bibtexTidying
    ```
    - For Linux
    ```PowerShell
    sudo apt-get update
    sudo apt-get install libmysqlclient-dev
    sudo pip install mysqlclient
    pip install bibtexTidying
    ```
- **How to use it?**
  - Type following code in your python files:
    ```PowerShell
    from bibtextidying import finalbib
    ```
- **Then you can use all the function in module bibcopy!**
  ```PowerShell
  finalbib.comprehensive("filename")
  ```
![avatar](data:image/png;base64,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)
##[Function]
```PowerShell
1. Resolves the bib_file to a list form.
2. Checks whether the field provided by the file entry is complete.
3. Checks the same article whether there are more than the same items, remove the same items, if there are conflicts prompted conflict information.
4. Synthesizes the two files into a single file, outputting is filename1_filename2.bib.
5. Formats the file.
6. Uniform file keyword style.
7. Stores a database of the specified type.
8. Outputs domain information of the specified type for the specified type entry in the database, and generates bib_file.
```
##[Known Issues]:
1. 

##[Bug Report]:
Any bug or documentation error you found , please submit an issue on github parge: https://gitee.com/chen-kun19/summer-program