# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 registry: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 tag: pulumi.Input[str],
                 allow_image: Optional[pulumi.Input[bool]] = None,
                 block_image: Optional[pulumi.Input[bool]] = None,
                 permission_modification_comment: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[str] registry: The name of the registry where the image is stored.
        :param pulumi.Input[str] repository: The name of the image's repository.
        :param pulumi.Input[str] tag: The tag of the image.
        :param pulumi.Input[bool] allow_image: If this field is set to true, the image will be whitelisted.
        :param pulumi.Input[bool] block_image: If this field is set to true, the image will be blacklisted.
        :param pulumi.Input[str] permission_modification_comment: A comment on why the image was whitelisted or blacklisted
        """
        pulumi.set(__self__, "registry", registry)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "tag", tag)
        if allow_image is not None:
            pulumi.set(__self__, "allow_image", allow_image)
        if block_image is not None:
            pulumi.set(__self__, "block_image", block_image)
        if permission_modification_comment is not None:
            pulumi.set(__self__, "permission_modification_comment", permission_modification_comment)

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Input[str]:
        """
        The name of the registry where the image is stored.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The name of the image's repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tag(self) -> pulumi.Input[str]:
        """
        The tag of the image.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: pulumi.Input[str]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter(name="allowImage")
    def allow_image(self) -> Optional[pulumi.Input[bool]]:
        """
        If this field is set to true, the image will be whitelisted.
        """
        return pulumi.get(self, "allow_image")

    @allow_image.setter
    def allow_image(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_image", value)

    @property
    @pulumi.getter(name="blockImage")
    def block_image(self) -> Optional[pulumi.Input[bool]]:
        """
        If this field is set to true, the image will be blacklisted.
        """
        return pulumi.get(self, "block_image")

    @block_image.setter
    def block_image(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_image", value)

    @property
    @pulumi.getter(name="permissionModificationComment")
    def permission_modification_comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment on why the image was whitelisted or blacklisted
        """
        return pulumi.get(self, "permission_modification_comment")

    @permission_modification_comment.setter
    def permission_modification_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_modification_comment", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 allow_image: Optional[pulumi.Input[bool]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 assurance_checks_performeds: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAssuranceChecksPerformedArgs']]]] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 blacklisted: Optional[pulumi.Input[bool]] = None,
                 block_image: Optional[pulumi.Input[bool]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 critical_vulnerabilities: Optional[pulumi.Input[int]] = None,
                 default_user: Optional[pulumi.Input[str]] = None,
                 digest: Optional[pulumi.Input[str]] = None,
                 disallowed: Optional[pulumi.Input[bool]] = None,
                 disallowed_by_assurance_checks: Optional[pulumi.Input[bool]] = None,
                 docker_id: Optional[pulumi.Input[str]] = None,
                 docker_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 docker_version: Optional[pulumi.Input[str]] = None,
                 dta_severity_score: Optional[pulumi.Input[str]] = None,
                 dta_skipped: Optional[pulumi.Input[bool]] = None,
                 dta_skipped_reason: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 high_vulnerabilities: Optional[pulumi.Input[int]] = None,
                 histories: Optional[pulumi.Input[Sequence[pulumi.Input['ImageHistoryArgs']]]] = None,
                 image_size: Optional[pulumi.Input[int]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 low_vulnerabilities: Optional[pulumi.Input[int]] = None,
                 malware: Optional[pulumi.Input[int]] = None,
                 medium_vulnerabilities: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 negligible_vulnerabilities: Optional[pulumi.Input[int]] = None,
                 newer_image_exists: Optional[pulumi.Input[bool]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 partial_results: Optional[pulumi.Input[bool]] = None,
                 pending_disallowed: Optional[pulumi.Input[bool]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 permission_author: Optional[pulumi.Input[str]] = None,
                 permission_comment: Optional[pulumi.Input[str]] = None,
                 permission_modification_comment: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 registry_type: Optional[pulumi.Input[str]] = None,
                 repo_digests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 scan_date: Optional[pulumi.Input[str]] = None,
                 scan_error: Optional[pulumi.Input[str]] = None,
                 scan_status: Optional[pulumi.Input[str]] = None,
                 sensitive_data: Optional[pulumi.Input[int]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 total_vulnerabilities: Optional[pulumi.Input[int]] = None,
                 virtual_size: Optional[pulumi.Input[int]] = None,
                 vulnerabilities: Optional[pulumi.Input[Sequence[pulumi.Input['ImageVulnerabilityArgs']]]] = None,
                 whitelisted: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[bool] allow_image: If this field is set to true, the image will be whitelisted.
        :param pulumi.Input[str] architecture: The image architecture.
        :param pulumi.Input[Sequence[pulumi.Input['ImageAssuranceChecksPerformedArgs']]] assurance_checks_performeds: The list of image assurance checks performed on the image.
        :param pulumi.Input[str] author: The name of the user who registered the image.
        :param pulumi.Input[bool] blacklisted: Whether the image is blacklisted.
        :param pulumi.Input[bool] block_image: If this field is set to true, the image will be blacklisted.
        :param pulumi.Input[str] comment: The image creation comment.
        :param pulumi.Input[str] created: The date and time when the image was registered.
        :param pulumi.Input[int] critical_vulnerabilities: Number of critical severity vulnerabilities detected in the image.
        :param pulumi.Input[str] default_user: The default user of the image.
        :param pulumi.Input[str] digest: The content digest of the image.
        :param pulumi.Input[bool] disallowed: Whether the image is disallowed (non-compliant).
        :param pulumi.Input[bool] disallowed_by_assurance_checks: Whether the image was disallowed because of Image Assurance Policies.
        :param pulumi.Input[str] docker_id: The Docker image ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] docker_labels: Docker labels of the image.
        :param pulumi.Input[str] docker_version: The Docker version used when building the image.
        :param pulumi.Input[str] dta_severity_score: DTA severity score.
        :param pulumi.Input[bool] dta_skipped: If DTA was skipped.
        :param pulumi.Input[str] dta_skipped_reason: The reason why DTA was skipped.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] environment_variables: Environment variables in the image.
        :param pulumi.Input[int] high_vulnerabilities: Number of high severity vulnerabilities detected in the image.
        :param pulumi.Input[Sequence[pulumi.Input['ImageHistoryArgs']]] histories: The Docker history of the image.
        :param pulumi.Input[int] image_size: The size of the image in bytes.
        :param pulumi.Input[str] image_type: The type of the image.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: Aqua labels of the image.
        :param pulumi.Input[int] low_vulnerabilities: Number of low severity vulnerabilities detected in the image.
        :param pulumi.Input[int] malware: Number of malware found on the image.
        :param pulumi.Input[int] medium_vulnerabilities: Number of medium severity vulnerabilities detected in the image.
        :param pulumi.Input[str] name: The name of the image.
        :param pulumi.Input[int] negligible_vulnerabilities: Number of negligible severity vulnerabilities detected in the image.
        :param pulumi.Input[bool] newer_image_exists: Whether a new version of the image is available in the registry but is not scanned and registered yet.
        :param pulumi.Input[str] os: The operating system detected in the image
        :param pulumi.Input[str] os_version: The version of the OS detected in the image.
        :param pulumi.Input[str] parent: The ID of the parent image.
        :param pulumi.Input[bool] partial_results: Whether the image could only be partially scanned.
        :param pulumi.Input[bool] pending_disallowed: Whether the image is non-compliant, but is pending this status due to running containers.
        :param pulumi.Input[str] permission: Permission of the image.
        :param pulumi.Input[str] permission_author: The name of the user who last modified the image permissions.
        :param pulumi.Input[str] permission_comment: The comment provided when the image permissions were last modified
        :param pulumi.Input[str] permission_modification_comment: A comment on why the image was whitelisted or blacklisted
        :param pulumi.Input[str] registry: The name of the registry where the image is stored.
        :param pulumi.Input[str] registry_type: Type of the registry.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repo_digests: The repository digests.
        :param pulumi.Input[str] repository: The name of the image's repository.
        :param pulumi.Input[str] scan_date: The date and time when the image was last scanned.
        :param pulumi.Input[str] scan_error: If the image scan failed, the failure message.
        :param pulumi.Input[str] scan_status: The scan status of the image (either 'pending', 'in*progress', 'finished', 'failed' or 'not*started').
        :param pulumi.Input[int] sensitive_data: Number of sensitive data detected in the image.
        :param pulumi.Input[str] tag: The tag of the image.
        :param pulumi.Input[int] total_vulnerabilities: The total number of vulnerabilities detected in the image.
        :param pulumi.Input[int] virtual_size: The virtual size of the image.
        :param pulumi.Input[Sequence[pulumi.Input['ImageVulnerabilityArgs']]] vulnerabilities: A list of all the vulnerabilities found in the image
        :param pulumi.Input[bool] whitelisted: Whether the image is whitelisted.
        """
        if allow_image is not None:
            pulumi.set(__self__, "allow_image", allow_image)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if assurance_checks_performeds is not None:
            pulumi.set(__self__, "assurance_checks_performeds", assurance_checks_performeds)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if blacklisted is not None:
            pulumi.set(__self__, "blacklisted", blacklisted)
        if block_image is not None:
            pulumi.set(__self__, "block_image", block_image)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if critical_vulnerabilities is not None:
            pulumi.set(__self__, "critical_vulnerabilities", critical_vulnerabilities)
        if default_user is not None:
            pulumi.set(__self__, "default_user", default_user)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if disallowed is not None:
            pulumi.set(__self__, "disallowed", disallowed)
        if disallowed_by_assurance_checks is not None:
            pulumi.set(__self__, "disallowed_by_assurance_checks", disallowed_by_assurance_checks)
        if docker_id is not None:
            pulumi.set(__self__, "docker_id", docker_id)
        if docker_labels is not None:
            pulumi.set(__self__, "docker_labels", docker_labels)
        if docker_version is not None:
            pulumi.set(__self__, "docker_version", docker_version)
        if dta_severity_score is not None:
            pulumi.set(__self__, "dta_severity_score", dta_severity_score)
        if dta_skipped is not None:
            pulumi.set(__self__, "dta_skipped", dta_skipped)
        if dta_skipped_reason is not None:
            pulumi.set(__self__, "dta_skipped_reason", dta_skipped_reason)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if high_vulnerabilities is not None:
            pulumi.set(__self__, "high_vulnerabilities", high_vulnerabilities)
        if histories is not None:
            pulumi.set(__self__, "histories", histories)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if low_vulnerabilities is not None:
            pulumi.set(__self__, "low_vulnerabilities", low_vulnerabilities)
        if malware is not None:
            pulumi.set(__self__, "malware", malware)
        if medium_vulnerabilities is not None:
            pulumi.set(__self__, "medium_vulnerabilities", medium_vulnerabilities)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negligible_vulnerabilities is not None:
            pulumi.set(__self__, "negligible_vulnerabilities", negligible_vulnerabilities)
        if newer_image_exists is not None:
            pulumi.set(__self__, "newer_image_exists", newer_image_exists)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if partial_results is not None:
            pulumi.set(__self__, "partial_results", partial_results)
        if pending_disallowed is not None:
            pulumi.set(__self__, "pending_disallowed", pending_disallowed)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if permission_author is not None:
            pulumi.set(__self__, "permission_author", permission_author)
        if permission_comment is not None:
            pulumi.set(__self__, "permission_comment", permission_comment)
        if permission_modification_comment is not None:
            pulumi.set(__self__, "permission_modification_comment", permission_modification_comment)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_type is not None:
            pulumi.set(__self__, "registry_type", registry_type)
        if repo_digests is not None:
            pulumi.set(__self__, "repo_digests", repo_digests)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if scan_date is not None:
            pulumi.set(__self__, "scan_date", scan_date)
        if scan_error is not None:
            pulumi.set(__self__, "scan_error", scan_error)
        if scan_status is not None:
            pulumi.set(__self__, "scan_status", scan_status)
        if sensitive_data is not None:
            pulumi.set(__self__, "sensitive_data", sensitive_data)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if total_vulnerabilities is not None:
            pulumi.set(__self__, "total_vulnerabilities", total_vulnerabilities)
        if virtual_size is not None:
            pulumi.set(__self__, "virtual_size", virtual_size)
        if vulnerabilities is not None:
            pulumi.set(__self__, "vulnerabilities", vulnerabilities)
        if whitelisted is not None:
            pulumi.set(__self__, "whitelisted", whitelisted)

    @property
    @pulumi.getter(name="allowImage")
    def allow_image(self) -> Optional[pulumi.Input[bool]]:
        """
        If this field is set to true, the image will be whitelisted.
        """
        return pulumi.get(self, "allow_image")

    @allow_image.setter
    def allow_image(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_image", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The image architecture.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="assuranceChecksPerformeds")
    def assurance_checks_performeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageAssuranceChecksPerformedArgs']]]]:
        """
        The list of image assurance checks performed on the image.
        """
        return pulumi.get(self, "assurance_checks_performeds")

    @assurance_checks_performeds.setter
    def assurance_checks_performeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAssuranceChecksPerformedArgs']]]]):
        pulumi.set(self, "assurance_checks_performeds", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user who registered the image.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def blacklisted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the image is blacklisted.
        """
        return pulumi.get(self, "blacklisted")

    @blacklisted.setter
    def blacklisted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blacklisted", value)

    @property
    @pulumi.getter(name="blockImage")
    def block_image(self) -> Optional[pulumi.Input[bool]]:
        """
        If this field is set to true, the image will be blacklisted.
        """
        return pulumi.get(self, "block_image")

    @block_image.setter
    def block_image(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_image", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        The image creation comment.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the image was registered.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="criticalVulnerabilities")
    def critical_vulnerabilities(self) -> Optional[pulumi.Input[int]]:
        """
        Number of critical severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "critical_vulnerabilities")

    @critical_vulnerabilities.setter
    def critical_vulnerabilities(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "critical_vulnerabilities", value)

    @property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> Optional[pulumi.Input[str]]:
        """
        The default user of the image.
        """
        return pulumi.get(self, "default_user")

    @default_user.setter
    def default_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_user", value)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[str]]:
        """
        The content digest of the image.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter
    def disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the image is disallowed (non-compliant).
        """
        return pulumi.get(self, "disallowed")

    @disallowed.setter
    def disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disallowed", value)

    @property
    @pulumi.getter(name="disallowedByAssuranceChecks")
    def disallowed_by_assurance_checks(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the image was disallowed because of Image Assurance Policies.
        """
        return pulumi.get(self, "disallowed_by_assurance_checks")

    @disallowed_by_assurance_checks.setter
    def disallowed_by_assurance_checks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disallowed_by_assurance_checks", value)

    @property
    @pulumi.getter(name="dockerId")
    def docker_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Docker image ID.
        """
        return pulumi.get(self, "docker_id")

    @docker_id.setter
    def docker_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_id", value)

    @property
    @pulumi.getter(name="dockerLabels")
    def docker_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Docker labels of the image.
        """
        return pulumi.get(self, "docker_labels")

    @docker_labels.setter
    def docker_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "docker_labels", value)

    @property
    @pulumi.getter(name="dockerVersion")
    def docker_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Docker version used when building the image.
        """
        return pulumi.get(self, "docker_version")

    @docker_version.setter
    def docker_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_version", value)

    @property
    @pulumi.getter(name="dtaSeverityScore")
    def dta_severity_score(self) -> Optional[pulumi.Input[str]]:
        """
        DTA severity score.
        """
        return pulumi.get(self, "dta_severity_score")

    @dta_severity_score.setter
    def dta_severity_score(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dta_severity_score", value)

    @property
    @pulumi.getter(name="dtaSkipped")
    def dta_skipped(self) -> Optional[pulumi.Input[bool]]:
        """
        If DTA was skipped.
        """
        return pulumi.get(self, "dta_skipped")

    @dta_skipped.setter
    def dta_skipped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dta_skipped", value)

    @property
    @pulumi.getter(name="dtaSkippedReason")
    def dta_skipped_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why DTA was skipped.
        """
        return pulumi.get(self, "dta_skipped_reason")

    @dta_skipped_reason.setter
    def dta_skipped_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dta_skipped_reason", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Environment variables in the image.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="highVulnerabilities")
    def high_vulnerabilities(self) -> Optional[pulumi.Input[int]]:
        """
        Number of high severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "high_vulnerabilities")

    @high_vulnerabilities.setter
    def high_vulnerabilities(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "high_vulnerabilities", value)

    @property
    @pulumi.getter
    def histories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageHistoryArgs']]]]:
        """
        The Docker history of the image.
        """
        return pulumi.get(self, "histories")

    @histories.setter
    def histories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageHistoryArgs']]]]):
        pulumi.set(self, "histories", value)

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "image_size")

    @image_size.setter
    def image_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_size", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Aqua labels of the image.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lowVulnerabilities")
    def low_vulnerabilities(self) -> Optional[pulumi.Input[int]]:
        """
        Number of low severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "low_vulnerabilities")

    @low_vulnerabilities.setter
    def low_vulnerabilities(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "low_vulnerabilities", value)

    @property
    @pulumi.getter
    def malware(self) -> Optional[pulumi.Input[int]]:
        """
        Number of malware found on the image.
        """
        return pulumi.get(self, "malware")

    @malware.setter
    def malware(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "malware", value)

    @property
    @pulumi.getter(name="mediumVulnerabilities")
    def medium_vulnerabilities(self) -> Optional[pulumi.Input[int]]:
        """
        Number of medium severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "medium_vulnerabilities")

    @medium_vulnerabilities.setter
    def medium_vulnerabilities(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "medium_vulnerabilities", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="negligibleVulnerabilities")
    def negligible_vulnerabilities(self) -> Optional[pulumi.Input[int]]:
        """
        Number of negligible severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "negligible_vulnerabilities")

    @negligible_vulnerabilities.setter
    def negligible_vulnerabilities(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "negligible_vulnerabilities", value)

    @property
    @pulumi.getter(name="newerImageExists")
    def newer_image_exists(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a new version of the image is available in the registry but is not scanned and registered yet.
        """
        return pulumi.get(self, "newer_image_exists")

    @newer_image_exists.setter
    def newer_image_exists(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "newer_image_exists", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system detected in the image
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the OS detected in the image.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the parent image.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="partialResults")
    def partial_results(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the image could only be partially scanned.
        """
        return pulumi.get(self, "partial_results")

    @partial_results.setter
    def partial_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "partial_results", value)

    @property
    @pulumi.getter(name="pendingDisallowed")
    def pending_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the image is non-compliant, but is pending this status due to running containers.
        """
        return pulumi.get(self, "pending_disallowed")

    @pending_disallowed.setter
    def pending_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pending_disallowed", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        Permission of the image.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="permissionAuthor")
    def permission_author(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user who last modified the image permissions.
        """
        return pulumi.get(self, "permission_author")

    @permission_author.setter
    def permission_author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_author", value)

    @property
    @pulumi.getter(name="permissionComment")
    def permission_comment(self) -> Optional[pulumi.Input[str]]:
        """
        The comment provided when the image permissions were last modified
        """
        return pulumi.get(self, "permission_comment")

    @permission_comment.setter
    def permission_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_comment", value)

    @property
    @pulumi.getter(name="permissionModificationComment")
    def permission_modification_comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment on why the image was whitelisted or blacklisted
        """
        return pulumi.get(self, "permission_modification_comment")

    @permission_modification_comment.setter
    def permission_modification_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_modification_comment", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the registry where the image is stored.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the registry.
        """
        return pulumi.get(self, "registry_type")

    @registry_type.setter
    def registry_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_type", value)

    @property
    @pulumi.getter(name="repoDigests")
    def repo_digests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The repository digests.
        """
        return pulumi.get(self, "repo_digests")

    @repo_digests.setter
    def repo_digests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "repo_digests", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image's repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="scanDate")
    def scan_date(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the image was last scanned.
        """
        return pulumi.get(self, "scan_date")

    @scan_date.setter
    def scan_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_date", value)

    @property
    @pulumi.getter(name="scanError")
    def scan_error(self) -> Optional[pulumi.Input[str]]:
        """
        If the image scan failed, the failure message.
        """
        return pulumi.get(self, "scan_error")

    @scan_error.setter
    def scan_error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_error", value)

    @property
    @pulumi.getter(name="scanStatus")
    def scan_status(self) -> Optional[pulumi.Input[str]]:
        """
        The scan status of the image (either 'pending', 'in*progress', 'finished', 'failed' or 'not*started').
        """
        return pulumi.get(self, "scan_status")

    @scan_status.setter
    def scan_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_status", value)

    @property
    @pulumi.getter(name="sensitiveData")
    def sensitive_data(self) -> Optional[pulumi.Input[int]]:
        """
        Number of sensitive data detected in the image.
        """
        return pulumi.get(self, "sensitive_data")

    @sensitive_data.setter
    def sensitive_data(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sensitive_data", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The tag of the image.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter(name="totalVulnerabilities")
    def total_vulnerabilities(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of vulnerabilities detected in the image.
        """
        return pulumi.get(self, "total_vulnerabilities")

    @total_vulnerabilities.setter
    def total_vulnerabilities(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_vulnerabilities", value)

    @property
    @pulumi.getter(name="virtualSize")
    def virtual_size(self) -> Optional[pulumi.Input[int]]:
        """
        The virtual size of the image.
        """
        return pulumi.get(self, "virtual_size")

    @virtual_size.setter
    def virtual_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "virtual_size", value)

    @property
    @pulumi.getter
    def vulnerabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageVulnerabilityArgs']]]]:
        """
        A list of all the vulnerabilities found in the image
        """
        return pulumi.get(self, "vulnerabilities")

    @vulnerabilities.setter
    def vulnerabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageVulnerabilityArgs']]]]):
        pulumi.set(self, "vulnerabilities", value)

    @property
    @pulumi.getter
    def whitelisted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the image is whitelisted.
        """
        return pulumi.get(self, "whitelisted")

    @whitelisted.setter
    def whitelisted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "whitelisted", value)


class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_image: Optional[pulumi.Input[bool]] = None,
                 block_image: Optional[pulumi.Input[bool]] = None,
                 permission_modification_comment: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Image resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_image: If this field is set to true, the image will be whitelisted.
        :param pulumi.Input[bool] block_image: If this field is set to true, the image will be blacklisted.
        :param pulumi.Input[str] permission_modification_comment: A comment on why the image was whitelisted or blacklisted
        :param pulumi.Input[str] registry: The name of the registry where the image is stored.
        :param pulumi.Input[str] repository: The name of the image's repository.
        :param pulumi.Input[str] tag: The tag of the image.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Image resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_image: Optional[pulumi.Input[bool]] = None,
                 block_image: Optional[pulumi.Input[bool]] = None,
                 permission_modification_comment: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["allow_image"] = allow_image
            __props__.__dict__["block_image"] = block_image
            __props__.__dict__["permission_modification_comment"] = permission_modification_comment
            if registry is None and not opts.urn:
                raise TypeError("Missing required property 'registry'")
            __props__.__dict__["registry"] = registry
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            if tag is None and not opts.urn:
                raise TypeError("Missing required property 'tag'")
            __props__.__dict__["tag"] = tag
            __props__.__dict__["architecture"] = None
            __props__.__dict__["assurance_checks_performeds"] = None
            __props__.__dict__["author"] = None
            __props__.__dict__["blacklisted"] = None
            __props__.__dict__["comment"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["critical_vulnerabilities"] = None
            __props__.__dict__["default_user"] = None
            __props__.__dict__["digest"] = None
            __props__.__dict__["disallowed"] = None
            __props__.__dict__["disallowed_by_assurance_checks"] = None
            __props__.__dict__["docker_id"] = None
            __props__.__dict__["docker_labels"] = None
            __props__.__dict__["docker_version"] = None
            __props__.__dict__["dta_severity_score"] = None
            __props__.__dict__["dta_skipped"] = None
            __props__.__dict__["dta_skipped_reason"] = None
            __props__.__dict__["environment_variables"] = None
            __props__.__dict__["high_vulnerabilities"] = None
            __props__.__dict__["histories"] = None
            __props__.__dict__["image_size"] = None
            __props__.__dict__["image_type"] = None
            __props__.__dict__["labels"] = None
            __props__.__dict__["low_vulnerabilities"] = None
            __props__.__dict__["malware"] = None
            __props__.__dict__["medium_vulnerabilities"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["negligible_vulnerabilities"] = None
            __props__.__dict__["newer_image_exists"] = None
            __props__.__dict__["os"] = None
            __props__.__dict__["os_version"] = None
            __props__.__dict__["parent"] = None
            __props__.__dict__["partial_results"] = None
            __props__.__dict__["pending_disallowed"] = None
            __props__.__dict__["permission"] = None
            __props__.__dict__["permission_author"] = None
            __props__.__dict__["permission_comment"] = None
            __props__.__dict__["registry_type"] = None
            __props__.__dict__["repo_digests"] = None
            __props__.__dict__["scan_date"] = None
            __props__.__dict__["scan_error"] = None
            __props__.__dict__["scan_status"] = None
            __props__.__dict__["sensitive_data"] = None
            __props__.__dict__["total_vulnerabilities"] = None
            __props__.__dict__["virtual_size"] = None
            __props__.__dict__["vulnerabilities"] = None
            __props__.__dict__["whitelisted"] = None
        super(Image, __self__).__init__(
            'aquasec:index/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_image: Optional[pulumi.Input[bool]] = None,
            architecture: Optional[pulumi.Input[str]] = None,
            assurance_checks_performeds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageAssuranceChecksPerformedArgs']]]]] = None,
            author: Optional[pulumi.Input[str]] = None,
            blacklisted: Optional[pulumi.Input[bool]] = None,
            block_image: Optional[pulumi.Input[bool]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            created: Optional[pulumi.Input[str]] = None,
            critical_vulnerabilities: Optional[pulumi.Input[int]] = None,
            default_user: Optional[pulumi.Input[str]] = None,
            digest: Optional[pulumi.Input[str]] = None,
            disallowed: Optional[pulumi.Input[bool]] = None,
            disallowed_by_assurance_checks: Optional[pulumi.Input[bool]] = None,
            docker_id: Optional[pulumi.Input[str]] = None,
            docker_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            docker_version: Optional[pulumi.Input[str]] = None,
            dta_severity_score: Optional[pulumi.Input[str]] = None,
            dta_skipped: Optional[pulumi.Input[bool]] = None,
            dta_skipped_reason: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            high_vulnerabilities: Optional[pulumi.Input[int]] = None,
            histories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageHistoryArgs']]]]] = None,
            image_size: Optional[pulumi.Input[int]] = None,
            image_type: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            low_vulnerabilities: Optional[pulumi.Input[int]] = None,
            malware: Optional[pulumi.Input[int]] = None,
            medium_vulnerabilities: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            negligible_vulnerabilities: Optional[pulumi.Input[int]] = None,
            newer_image_exists: Optional[pulumi.Input[bool]] = None,
            os: Optional[pulumi.Input[str]] = None,
            os_version: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            partial_results: Optional[pulumi.Input[bool]] = None,
            pending_disallowed: Optional[pulumi.Input[bool]] = None,
            permission: Optional[pulumi.Input[str]] = None,
            permission_author: Optional[pulumi.Input[str]] = None,
            permission_comment: Optional[pulumi.Input[str]] = None,
            permission_modification_comment: Optional[pulumi.Input[str]] = None,
            registry: Optional[pulumi.Input[str]] = None,
            registry_type: Optional[pulumi.Input[str]] = None,
            repo_digests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            scan_date: Optional[pulumi.Input[str]] = None,
            scan_error: Optional[pulumi.Input[str]] = None,
            scan_status: Optional[pulumi.Input[str]] = None,
            sensitive_data: Optional[pulumi.Input[int]] = None,
            tag: Optional[pulumi.Input[str]] = None,
            total_vulnerabilities: Optional[pulumi.Input[int]] = None,
            virtual_size: Optional[pulumi.Input[int]] = None,
            vulnerabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageVulnerabilityArgs']]]]] = None,
            whitelisted: Optional[pulumi.Input[bool]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_image: If this field is set to true, the image will be whitelisted.
        :param pulumi.Input[str] architecture: The image architecture.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageAssuranceChecksPerformedArgs']]]] assurance_checks_performeds: The list of image assurance checks performed on the image.
        :param pulumi.Input[str] author: The name of the user who registered the image.
        :param pulumi.Input[bool] blacklisted: Whether the image is blacklisted.
        :param pulumi.Input[bool] block_image: If this field is set to true, the image will be blacklisted.
        :param pulumi.Input[str] comment: The image creation comment.
        :param pulumi.Input[str] created: The date and time when the image was registered.
        :param pulumi.Input[int] critical_vulnerabilities: Number of critical severity vulnerabilities detected in the image.
        :param pulumi.Input[str] default_user: The default user of the image.
        :param pulumi.Input[str] digest: The content digest of the image.
        :param pulumi.Input[bool] disallowed: Whether the image is disallowed (non-compliant).
        :param pulumi.Input[bool] disallowed_by_assurance_checks: Whether the image was disallowed because of Image Assurance Policies.
        :param pulumi.Input[str] docker_id: The Docker image ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] docker_labels: Docker labels of the image.
        :param pulumi.Input[str] docker_version: The Docker version used when building the image.
        :param pulumi.Input[str] dta_severity_score: DTA severity score.
        :param pulumi.Input[bool] dta_skipped: If DTA was skipped.
        :param pulumi.Input[str] dta_skipped_reason: The reason why DTA was skipped.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] environment_variables: Environment variables in the image.
        :param pulumi.Input[int] high_vulnerabilities: Number of high severity vulnerabilities detected in the image.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageHistoryArgs']]]] histories: The Docker history of the image.
        :param pulumi.Input[int] image_size: The size of the image in bytes.
        :param pulumi.Input[str] image_type: The type of the image.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: Aqua labels of the image.
        :param pulumi.Input[int] low_vulnerabilities: Number of low severity vulnerabilities detected in the image.
        :param pulumi.Input[int] malware: Number of malware found on the image.
        :param pulumi.Input[int] medium_vulnerabilities: Number of medium severity vulnerabilities detected in the image.
        :param pulumi.Input[str] name: The name of the image.
        :param pulumi.Input[int] negligible_vulnerabilities: Number of negligible severity vulnerabilities detected in the image.
        :param pulumi.Input[bool] newer_image_exists: Whether a new version of the image is available in the registry but is not scanned and registered yet.
        :param pulumi.Input[str] os: The operating system detected in the image
        :param pulumi.Input[str] os_version: The version of the OS detected in the image.
        :param pulumi.Input[str] parent: The ID of the parent image.
        :param pulumi.Input[bool] partial_results: Whether the image could only be partially scanned.
        :param pulumi.Input[bool] pending_disallowed: Whether the image is non-compliant, but is pending this status due to running containers.
        :param pulumi.Input[str] permission: Permission of the image.
        :param pulumi.Input[str] permission_author: The name of the user who last modified the image permissions.
        :param pulumi.Input[str] permission_comment: The comment provided when the image permissions were last modified
        :param pulumi.Input[str] permission_modification_comment: A comment on why the image was whitelisted or blacklisted
        :param pulumi.Input[str] registry: The name of the registry where the image is stored.
        :param pulumi.Input[str] registry_type: Type of the registry.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repo_digests: The repository digests.
        :param pulumi.Input[str] repository: The name of the image's repository.
        :param pulumi.Input[str] scan_date: The date and time when the image was last scanned.
        :param pulumi.Input[str] scan_error: If the image scan failed, the failure message.
        :param pulumi.Input[str] scan_status: The scan status of the image (either 'pending', 'in*progress', 'finished', 'failed' or 'not*started').
        :param pulumi.Input[int] sensitive_data: Number of sensitive data detected in the image.
        :param pulumi.Input[str] tag: The tag of the image.
        :param pulumi.Input[int] total_vulnerabilities: The total number of vulnerabilities detected in the image.
        :param pulumi.Input[int] virtual_size: The virtual size of the image.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageVulnerabilityArgs']]]] vulnerabilities: A list of all the vulnerabilities found in the image
        :param pulumi.Input[bool] whitelisted: Whether the image is whitelisted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["allow_image"] = allow_image
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["assurance_checks_performeds"] = assurance_checks_performeds
        __props__.__dict__["author"] = author
        __props__.__dict__["blacklisted"] = blacklisted
        __props__.__dict__["block_image"] = block_image
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created"] = created
        __props__.__dict__["critical_vulnerabilities"] = critical_vulnerabilities
        __props__.__dict__["default_user"] = default_user
        __props__.__dict__["digest"] = digest
        __props__.__dict__["disallowed"] = disallowed
        __props__.__dict__["disallowed_by_assurance_checks"] = disallowed_by_assurance_checks
        __props__.__dict__["docker_id"] = docker_id
        __props__.__dict__["docker_labels"] = docker_labels
        __props__.__dict__["docker_version"] = docker_version
        __props__.__dict__["dta_severity_score"] = dta_severity_score
        __props__.__dict__["dta_skipped"] = dta_skipped
        __props__.__dict__["dta_skipped_reason"] = dta_skipped_reason
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["high_vulnerabilities"] = high_vulnerabilities
        __props__.__dict__["histories"] = histories
        __props__.__dict__["image_size"] = image_size
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["low_vulnerabilities"] = low_vulnerabilities
        __props__.__dict__["malware"] = malware
        __props__.__dict__["medium_vulnerabilities"] = medium_vulnerabilities
        __props__.__dict__["name"] = name
        __props__.__dict__["negligible_vulnerabilities"] = negligible_vulnerabilities
        __props__.__dict__["newer_image_exists"] = newer_image_exists
        __props__.__dict__["os"] = os
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["parent"] = parent
        __props__.__dict__["partial_results"] = partial_results
        __props__.__dict__["pending_disallowed"] = pending_disallowed
        __props__.__dict__["permission"] = permission
        __props__.__dict__["permission_author"] = permission_author
        __props__.__dict__["permission_comment"] = permission_comment
        __props__.__dict__["permission_modification_comment"] = permission_modification_comment
        __props__.__dict__["registry"] = registry
        __props__.__dict__["registry_type"] = registry_type
        __props__.__dict__["repo_digests"] = repo_digests
        __props__.__dict__["repository"] = repository
        __props__.__dict__["scan_date"] = scan_date
        __props__.__dict__["scan_error"] = scan_error
        __props__.__dict__["scan_status"] = scan_status
        __props__.__dict__["sensitive_data"] = sensitive_data
        __props__.__dict__["tag"] = tag
        __props__.__dict__["total_vulnerabilities"] = total_vulnerabilities
        __props__.__dict__["virtual_size"] = virtual_size
        __props__.__dict__["vulnerabilities"] = vulnerabilities
        __props__.__dict__["whitelisted"] = whitelisted
        return Image(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowImage")
    def allow_image(self) -> pulumi.Output[Optional[bool]]:
        """
        If this field is set to true, the image will be whitelisted.
        """
        return pulumi.get(self, "allow_image")

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[str]:
        """
        The image architecture.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="assuranceChecksPerformeds")
    def assurance_checks_performeds(self) -> pulumi.Output[Sequence['outputs.ImageAssuranceChecksPerformed']]:
        """
        The list of image assurance checks performed on the image.
        """
        return pulumi.get(self, "assurance_checks_performeds")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        The name of the user who registered the image.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def blacklisted(self) -> pulumi.Output[bool]:
        """
        Whether the image is blacklisted.
        """
        return pulumi.get(self, "blacklisted")

    @property
    @pulumi.getter(name="blockImage")
    def block_image(self) -> pulumi.Output[Optional[bool]]:
        """
        If this field is set to true, the image will be blacklisted.
        """
        return pulumi.get(self, "block_image")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[str]:
        """
        The image creation comment.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The date and time when the image was registered.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="criticalVulnerabilities")
    def critical_vulnerabilities(self) -> pulumi.Output[int]:
        """
        Number of critical severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "critical_vulnerabilities")

    @property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> pulumi.Output[str]:
        """
        The default user of the image.
        """
        return pulumi.get(self, "default_user")

    @property
    @pulumi.getter
    def digest(self) -> pulumi.Output[str]:
        """
        The content digest of the image.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def disallowed(self) -> pulumi.Output[bool]:
        """
        Whether the image is disallowed (non-compliant).
        """
        return pulumi.get(self, "disallowed")

    @property
    @pulumi.getter(name="disallowedByAssuranceChecks")
    def disallowed_by_assurance_checks(self) -> pulumi.Output[bool]:
        """
        Whether the image was disallowed because of Image Assurance Policies.
        """
        return pulumi.get(self, "disallowed_by_assurance_checks")

    @property
    @pulumi.getter(name="dockerId")
    def docker_id(self) -> pulumi.Output[str]:
        """
        The Docker image ID.
        """
        return pulumi.get(self, "docker_id")

    @property
    @pulumi.getter(name="dockerLabels")
    def docker_labels(self) -> pulumi.Output[Sequence[str]]:
        """
        Docker labels of the image.
        """
        return pulumi.get(self, "docker_labels")

    @property
    @pulumi.getter(name="dockerVersion")
    def docker_version(self) -> pulumi.Output[str]:
        """
        The Docker version used when building the image.
        """
        return pulumi.get(self, "docker_version")

    @property
    @pulumi.getter(name="dtaSeverityScore")
    def dta_severity_score(self) -> pulumi.Output[str]:
        """
        DTA severity score.
        """
        return pulumi.get(self, "dta_severity_score")

    @property
    @pulumi.getter(name="dtaSkipped")
    def dta_skipped(self) -> pulumi.Output[bool]:
        """
        If DTA was skipped.
        """
        return pulumi.get(self, "dta_skipped")

    @property
    @pulumi.getter(name="dtaSkippedReason")
    def dta_skipped_reason(self) -> pulumi.Output[str]:
        """
        The reason why DTA was skipped.
        """
        return pulumi.get(self, "dta_skipped_reason")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Sequence[str]]:
        """
        Environment variables in the image.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="highVulnerabilities")
    def high_vulnerabilities(self) -> pulumi.Output[int]:
        """
        Number of high severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "high_vulnerabilities")

    @property
    @pulumi.getter
    def histories(self) -> pulumi.Output[Sequence['outputs.ImageHistory']]:
        """
        The Docker history of the image.
        """
        return pulumi.get(self, "histories")

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> pulumi.Output[int]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "image_size")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[str]:
        """
        The type of the image.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence[str]]:
        """
        Aqua labels of the image.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lowVulnerabilities")
    def low_vulnerabilities(self) -> pulumi.Output[int]:
        """
        Number of low severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "low_vulnerabilities")

    @property
    @pulumi.getter
    def malware(self) -> pulumi.Output[int]:
        """
        Number of malware found on the image.
        """
        return pulumi.get(self, "malware")

    @property
    @pulumi.getter(name="mediumVulnerabilities")
    def medium_vulnerabilities(self) -> pulumi.Output[int]:
        """
        Number of medium severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "medium_vulnerabilities")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="negligibleVulnerabilities")
    def negligible_vulnerabilities(self) -> pulumi.Output[int]:
        """
        Number of negligible severity vulnerabilities detected in the image.
        """
        return pulumi.get(self, "negligible_vulnerabilities")

    @property
    @pulumi.getter(name="newerImageExists")
    def newer_image_exists(self) -> pulumi.Output[bool]:
        """
        Whether a new version of the image is available in the registry but is not scanned and registered yet.
        """
        return pulumi.get(self, "newer_image_exists")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        The operating system detected in the image
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[str]:
        """
        The version of the OS detected in the image.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The ID of the parent image.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="partialResults")
    def partial_results(self) -> pulumi.Output[bool]:
        """
        Whether the image could only be partially scanned.
        """
        return pulumi.get(self, "partial_results")

    @property
    @pulumi.getter(name="pendingDisallowed")
    def pending_disallowed(self) -> pulumi.Output[bool]:
        """
        Whether the image is non-compliant, but is pending this status due to running containers.
        """
        return pulumi.get(self, "pending_disallowed")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[str]:
        """
        Permission of the image.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="permissionAuthor")
    def permission_author(self) -> pulumi.Output[str]:
        """
        The name of the user who last modified the image permissions.
        """
        return pulumi.get(self, "permission_author")

    @property
    @pulumi.getter(name="permissionComment")
    def permission_comment(self) -> pulumi.Output[str]:
        """
        The comment provided when the image permissions were last modified
        """
        return pulumi.get(self, "permission_comment")

    @property
    @pulumi.getter(name="permissionModificationComment")
    def permission_modification_comment(self) -> pulumi.Output[Optional[str]]:
        """
        A comment on why the image was whitelisted or blacklisted
        """
        return pulumi.get(self, "permission_modification_comment")

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Output[str]:
        """
        The name of the registry where the image is stored.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> pulumi.Output[str]:
        """
        Type of the registry.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter(name="repoDigests")
    def repo_digests(self) -> pulumi.Output[Sequence[str]]:
        """
        The repository digests.
        """
        return pulumi.get(self, "repo_digests")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The name of the image's repository.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="scanDate")
    def scan_date(self) -> pulumi.Output[str]:
        """
        The date and time when the image was last scanned.
        """
        return pulumi.get(self, "scan_date")

    @property
    @pulumi.getter(name="scanError")
    def scan_error(self) -> pulumi.Output[str]:
        """
        If the image scan failed, the failure message.
        """
        return pulumi.get(self, "scan_error")

    @property
    @pulumi.getter(name="scanStatus")
    def scan_status(self) -> pulumi.Output[str]:
        """
        The scan status of the image (either 'pending', 'in*progress', 'finished', 'failed' or 'not*started').
        """
        return pulumi.get(self, "scan_status")

    @property
    @pulumi.getter(name="sensitiveData")
    def sensitive_data(self) -> pulumi.Output[int]:
        """
        Number of sensitive data detected in the image.
        """
        return pulumi.get(self, "sensitive_data")

    @property
    @pulumi.getter
    def tag(self) -> pulumi.Output[str]:
        """
        The tag of the image.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="totalVulnerabilities")
    def total_vulnerabilities(self) -> pulumi.Output[int]:
        """
        The total number of vulnerabilities detected in the image.
        """
        return pulumi.get(self, "total_vulnerabilities")

    @property
    @pulumi.getter(name="virtualSize")
    def virtual_size(self) -> pulumi.Output[int]:
        """
        The virtual size of the image.
        """
        return pulumi.get(self, "virtual_size")

    @property
    @pulumi.getter
    def vulnerabilities(self) -> pulumi.Output[Sequence['outputs.ImageVulnerability']]:
        """
        A list of all the vulnerabilities found in the image
        """
        return pulumi.get(self, "vulnerabilities")

    @property
    @pulumi.getter
    def whitelisted(self) -> pulumi.Output[bool]:
        """
        Whether the image is whitelisted.
        """
        return pulumi.get(self, "whitelisted")

