# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'email': 'str',
        'phone_number': 'str',
        'application_role_code': 'ApplicationRoleCode',
        'is_approved': 'bool',
        'is_password_reset_pending': 'bool',
        'last_password_change': 'datetime',
        'identity_provider_name': 'str',
        'accepted_eula': 'bool',
        'last_login': 'datetime',
        'locked_out': 'bool',
        'corporations': 'list[UserCorporationChild]',
        'locations': 'list[UserLocationChild]'
    }

    attribute_map = {
        'id': 'Id',
        'first_name': 'FirstName',
        'last_name': 'LastName',
        'email': 'Email',
        'phone_number': 'PhoneNumber',
        'application_role_code': 'ApplicationRoleCode',
        'is_approved': 'IsApproved',
        'is_password_reset_pending': 'IsPasswordResetPending',
        'last_password_change': 'LastPasswordChange',
        'identity_provider_name': 'IdentityProviderName',
        'accepted_eula': 'AcceptedEula',
        'last_login': 'LastLogin',
        'locked_out': 'LockedOut',
        'corporations': 'Corporations',
        'locations': 'Locations'
    }

    def __init__(self, id=None, first_name=None, last_name=None, email=None, phone_number=None, application_role_code=None, is_approved=None, is_password_reset_pending=None, last_password_change=None, identity_provider_name=None, accepted_eula=None, last_login=None, locked_out=None, corporations=None, locations=None):  # noqa: E501
        """UserResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._first_name = None
        self._last_name = None
        self._email = None
        self._phone_number = None
        self._application_role_code = None
        self._is_approved = None
        self._is_password_reset_pending = None
        self._last_password_change = None
        self._identity_provider_name = None
        self._accepted_eula = None
        self._last_login = None
        self._locked_out = None
        self._corporations = None
        self._locations = None
        self.discriminator = None
        self.id = id
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        if phone_number is not None:
            self.phone_number = phone_number
        self.application_role_code = application_role_code
        self.is_approved = is_approved
        self.is_password_reset_pending = is_password_reset_pending
        if last_password_change is not None:
            self.last_password_change = last_password_change
        if identity_provider_name is not None:
            self.identity_provider_name = identity_provider_name
        self.accepted_eula = accepted_eula
        if last_login is not None:
            self.last_login = last_login
        self.locked_out = locked_out
        self.corporations = corporations
        self.locations = locations

    @property
    def id(self):
        """Gets the id of this UserResponse.  # noqa: E501


        :return: The id of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UserResponse.


        :param id: The id of this UserResponse.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def first_name(self):
        """Gets the first_name of this UserResponse.  # noqa: E501


        :return: The first_name of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this UserResponse.


        :param first_name: The first_name of this UserResponse.  # noqa: E501
        :type: str
        """
        if first_name is None:
            raise ValueError("Invalid value for `first_name`, must not be `None`")  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this UserResponse.  # noqa: E501


        :return: The last_name of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this UserResponse.


        :param last_name: The last_name of this UserResponse.  # noqa: E501
        :type: str
        """
        if last_name is None:
            raise ValueError("Invalid value for `last_name`, must not be `None`")  # noqa: E501

        self._last_name = last_name

    @property
    def email(self):
        """Gets the email of this UserResponse.  # noqa: E501


        :return: The email of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserResponse.


        :param email: The email of this UserResponse.  # noqa: E501
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def phone_number(self):
        """Gets the phone_number of this UserResponse.  # noqa: E501


        :return: The phone_number of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this UserResponse.


        :param phone_number: The phone_number of this UserResponse.  # noqa: E501
        :type: str
        """

        self._phone_number = phone_number

    @property
    def application_role_code(self):
        """Gets the application_role_code of this UserResponse.  # noqa: E501


        :return: The application_role_code of this UserResponse.  # noqa: E501
        :rtype: ApplicationRoleCode
        """
        return self._application_role_code

    @application_role_code.setter
    def application_role_code(self, application_role_code):
        """Sets the application_role_code of this UserResponse.


        :param application_role_code: The application_role_code of this UserResponse.  # noqa: E501
        :type: ApplicationRoleCode
        """
        if application_role_code is None:
            raise ValueError("Invalid value for `application_role_code`, must not be `None`")  # noqa: E501

        self._application_role_code = application_role_code

    @property
    def is_approved(self):
        """Gets the is_approved of this UserResponse.  # noqa: E501


        :return: The is_approved of this UserResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_approved

    @is_approved.setter
    def is_approved(self, is_approved):
        """Sets the is_approved of this UserResponse.


        :param is_approved: The is_approved of this UserResponse.  # noqa: E501
        :type: bool
        """
        if is_approved is None:
            raise ValueError("Invalid value for `is_approved`, must not be `None`")  # noqa: E501

        self._is_approved = is_approved

    @property
    def is_password_reset_pending(self):
        """Gets the is_password_reset_pending of this UserResponse.  # noqa: E501


        :return: The is_password_reset_pending of this UserResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_password_reset_pending

    @is_password_reset_pending.setter
    def is_password_reset_pending(self, is_password_reset_pending):
        """Sets the is_password_reset_pending of this UserResponse.


        :param is_password_reset_pending: The is_password_reset_pending of this UserResponse.  # noqa: E501
        :type: bool
        """
        if is_password_reset_pending is None:
            raise ValueError("Invalid value for `is_password_reset_pending`, must not be `None`")  # noqa: E501

        self._is_password_reset_pending = is_password_reset_pending

    @property
    def last_password_change(self):
        """Gets the last_password_change of this UserResponse.  # noqa: E501


        :return: The last_password_change of this UserResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_password_change

    @last_password_change.setter
    def last_password_change(self, last_password_change):
        """Sets the last_password_change of this UserResponse.


        :param last_password_change: The last_password_change of this UserResponse.  # noqa: E501
        :type: datetime
        """

        self._last_password_change = last_password_change

    @property
    def identity_provider_name(self):
        """Gets the identity_provider_name of this UserResponse.  # noqa: E501

        The user's identity provider. May not exist if user isn't assigned to an IDP  # noqa: E501

        :return: The identity_provider_name of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._identity_provider_name

    @identity_provider_name.setter
    def identity_provider_name(self, identity_provider_name):
        """Sets the identity_provider_name of this UserResponse.

        The user's identity provider. May not exist if user isn't assigned to an IDP  # noqa: E501

        :param identity_provider_name: The identity_provider_name of this UserResponse.  # noqa: E501
        :type: str
        """

        self._identity_provider_name = identity_provider_name

    @property
    def accepted_eula(self):
        """Gets the accepted_eula of this UserResponse.  # noqa: E501


        :return: The accepted_eula of this UserResponse.  # noqa: E501
        :rtype: bool
        """
        return self._accepted_eula

    @accepted_eula.setter
    def accepted_eula(self, accepted_eula):
        """Sets the accepted_eula of this UserResponse.


        :param accepted_eula: The accepted_eula of this UserResponse.  # noqa: E501
        :type: bool
        """
        if accepted_eula is None:
            raise ValueError("Invalid value for `accepted_eula`, must not be `None`")  # noqa: E501

        self._accepted_eula = accepted_eula

    @property
    def last_login(self):
        """Gets the last_login of this UserResponse.  # noqa: E501


        :return: The last_login of this UserResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_login

    @last_login.setter
    def last_login(self, last_login):
        """Sets the last_login of this UserResponse.


        :param last_login: The last_login of this UserResponse.  # noqa: E501
        :type: datetime
        """

        self._last_login = last_login

    @property
    def locked_out(self):
        """Gets the locked_out of this UserResponse.  # noqa: E501

        This is only relevant to non-SSO users, even if it is {true}  # noqa: E501

        :return: The locked_out of this UserResponse.  # noqa: E501
        :rtype: bool
        """
        return self._locked_out

    @locked_out.setter
    def locked_out(self, locked_out):
        """Sets the locked_out of this UserResponse.

        This is only relevant to non-SSO users, even if it is {true}  # noqa: E501

        :param locked_out: The locked_out of this UserResponse.  # noqa: E501
        :type: bool
        """
        if locked_out is None:
            raise ValueError("Invalid value for `locked_out`, must not be `None`")  # noqa: E501

        self._locked_out = locked_out

    @property
    def corporations(self):
        """Gets the corporations of this UserResponse.  # noqa: E501


        :return: The corporations of this UserResponse.  # noqa: E501
        :rtype: list[UserCorporationChild]
        """
        return self._corporations

    @corporations.setter
    def corporations(self, corporations):
        """Sets the corporations of this UserResponse.


        :param corporations: The corporations of this UserResponse.  # noqa: E501
        :type: list[UserCorporationChild]
        """
        if corporations is None:
            raise ValueError("Invalid value for `corporations`, must not be `None`")  # noqa: E501

        self._corporations = corporations

    @property
    def locations(self):
        """Gets the locations of this UserResponse.  # noqa: E501


        :return: The locations of this UserResponse.  # noqa: E501
        :rtype: list[UserLocationChild]
        """
        return self._locations

    @locations.setter
    def locations(self, locations):
        """Sets the locations of this UserResponse.


        :param locations: The locations of this UserResponse.  # noqa: E501
        :type: list[UserLocationChild]
        """
        if locations is None:
            raise ValueError("Invalid value for `locations`, must not be `None`")  # noqa: E501

        self._locations = locations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
