# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class ThermalCamerasApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_thermal_camera(self, **kwargs):  # noqa: E501
        """Create ThermalCamera object with associated ThermalCameraSettings  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_thermal_camera(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThermalCameraCreateRequest body: ThermalCamera and ThermalCameraSettings properties.
        :return: ThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_thermal_camera_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_thermal_camera_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_thermal_camera_with_http_info(self, **kwargs):  # noqa: E501
        """Create ThermalCamera object with associated ThermalCameraSettings  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_thermal_camera_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThermalCameraCreateRequest body: ThermalCamera and ThermalCameraSettings properties.
        :return: ThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_thermal_camera" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_thermal_camera_region(self, **kwargs):  # noqa: E501
        """Creates a Thermal Camera Region  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_thermal_camera_region(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThermalCameraRegionCreateRequest body:
        :return: ThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_thermal_camera_region_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_thermal_camera_region_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_thermal_camera_region_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a Thermal Camera Region  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_thermal_camera_region_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThermalCameraRegionCreateRequest body:
        :return: ThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_thermal_camera_region" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/regions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraRegionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_thermal_camera(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Deletes a ThermalCamera object and it's associated objects:  Regions, Images, Settings  # noqa: E501

        Deletion of a ThermalCamera is location admin only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_thermal_camera(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The serial number of the ThermalCamera to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_thermal_camera_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_thermal_camera_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
            return data

    def delete_thermal_camera_with_http_info(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Deletes a ThermalCamera object and it's associated objects:  Regions, Images, Settings  # noqa: E501

        Deletion of a ThermalCamera is location admin only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_thermal_camera_with_http_info(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The serial number of the ThermalCamera to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thermal_camera_serial_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_thermal_camera" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'thermal_camera_serial_number' is set
        if ('thermal_camera_serial_number' not in params or
                params['thermal_camera_serial_number'] is None):
            raise ValueError("Missing the required parameter `thermal_camera_serial_number` when calling `delete_thermal_camera`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'thermal_camera_serial_number' in params:
            path_params['thermalCameraSerialNumber'] = params['thermal_camera_serial_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_thermal_camera_region(self, region_id, **kwargs):  # noqa: E501
        """Deletes a Thermal Camera Region  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_thermal_camera_region(region_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str region_id: The id of the region to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_thermal_camera_region_with_http_info(region_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_thermal_camera_region_with_http_info(region_id, **kwargs)  # noqa: E501
            return data

    def delete_thermal_camera_region_with_http_info(self, region_id, **kwargs):  # noqa: E501
        """Deletes a Thermal Camera Region  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_thermal_camera_region_with_http_info(region_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str region_id: The id of the region to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['region_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_thermal_camera_region" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'region_id' is set
        if ('region_id' not in params or
                params['region_id'] is None):
            raise ValueError("Missing the required parameter `region_id` when calling `delete_thermal_camera_region`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region_id' in params:
            path_params['regionId'] = params['region_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/regions/{regionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_image(self, thermal_camera_serial_number, timestamp, **kwargs):  # noqa: E501
        """Gets a single thermal camera image  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_image(thermal_camera_serial_number, timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The serial number of the camera (required)
        :param int timestamp: The unix timestamp of the image in ms (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_image_with_http_info(thermal_camera_serial_number, timestamp, **kwargs)  # noqa: E501
        else:
            (data) = self.get_image_with_http_info(thermal_camera_serial_number, timestamp, **kwargs)  # noqa: E501
            return data

    def get_image_with_http_info(self, thermal_camera_serial_number, timestamp, **kwargs):  # noqa: E501
        """Gets a single thermal camera image  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_image_with_http_info(thermal_camera_serial_number, timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The serial number of the camera (required)
        :param int timestamp: The unix timestamp of the image in ms (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thermal_camera_serial_number', 'timestamp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'thermal_camera_serial_number' is set
        if ('thermal_camera_serial_number' not in params or
                params['thermal_camera_serial_number'] is None):
            raise ValueError("Missing the required parameter `thermal_camera_serial_number` when calling `get_image`")  # noqa: E501
        # verify the required parameter 'timestamp' is set
        if ('timestamp' not in params or
                params['timestamp'] is None):
            raise ValueError("Missing the required parameter `timestamp` when calling `get_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'thermal_camera_serial_number' in params:
            path_params['thermalCameraSerialNumber'] = params['thermal_camera_serial_number']  # noqa: E501
        if 'timestamp' in params:
            path_params['timestamp'] = params['timestamp']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}/images/{timestamp}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_image(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Gets the latest ThermalCameraImage for a ThermalCamera  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_image(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The serial number of the camera (required)
        :return: ThermalCameraImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_image_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_image_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
            return data

    def get_latest_image_with_http_info(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Gets the latest ThermalCameraImage for a ThermalCamera  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_image_with_http_info(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The serial number of the camera (required)
        :return: ThermalCameraImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thermal_camera_serial_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'thermal_camera_serial_number' is set
        if ('thermal_camera_serial_number' not in params or
                params['thermal_camera_serial_number'] is None):
            raise ValueError("Missing the required parameter `thermal_camera_serial_number` when calling `get_latest_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'thermal_camera_serial_number' in params:
            path_params['thermalCameraSerialNumber'] = params['thermal_camera_serial_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}/images/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraImageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_thermal_camera(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Get a single ThermalCamera object  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_camera(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: (required)
        :return: ThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_thermal_camera_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_thermal_camera_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
            return data

    def get_thermal_camera_with_http_info(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Get a single ThermalCamera object  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_camera_with_http_info(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: (required)
        :return: ThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thermal_camera_serial_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_thermal_camera" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'thermal_camera_serial_number' is set
        if ('thermal_camera_serial_number' not in params or
                params['thermal_camera_serial_number'] is None):
            raise ValueError("Missing the required parameter `thermal_camera_serial_number` when calling `get_thermal_camera`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'thermal_camera_serial_number' in params:
            path_params['thermalCameraSerialNumber'] = params['thermal_camera_serial_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_thermal_camera_region(self, region_id, **kwargs):  # noqa: E501
        """Gets a single Thermal Camera Region  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_camera_region(region_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str region_id: The id of the region to get (required)
        :return: ThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_thermal_camera_region_with_http_info(region_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_thermal_camera_region_with_http_info(region_id, **kwargs)  # noqa: E501
            return data

    def get_thermal_camera_region_with_http_info(self, region_id, **kwargs):  # noqa: E501
        """Gets a single Thermal Camera Region  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_camera_region_with_http_info(region_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str region_id: The id of the region to get (required)
        :return: ThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['region_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_thermal_camera_region" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'region_id' is set
        if ('region_id' not in params or
                params['region_id'] is None):
            raise ValueError("Missing the required parameter `region_id` when calling `get_thermal_camera_region`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region_id' in params:
            path_params['regionId'] = params['region_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/regions/{regionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraRegionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_thermal_camera_regions(self, **kwargs):  # noqa: E501
        """Gets Thermal Camera Regions  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_camera_regions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThermalCameraSerialNumber` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `Created` | DateTime | | `Height` | Int32 | | `Name` | String | | `Updated` | DateTime | | `Width` | Int32 |
        :return: PagedResultsModelThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_thermal_camera_regions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_thermal_camera_regions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_thermal_camera_regions_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Thermal Camera Regions  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_camera_regions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThermalCameraSerialNumber` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `Created` | DateTime | | `Height` | Int32 | | `Name` | String | | `Updated` | DateTime | | `Width` | Int32 |
        :return: PagedResultsModelThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_thermal_camera_regions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/regions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelThermalCameraRegionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_thermal_cameras(self, **kwargs):  # noqa: E501
        """Get multiple ThermalCamera objects  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_cameras(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `Created` | DateTime | | `LocationName` | String | | `Updated` | DateTime |
        :return: PagedResultsModelThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_thermal_cameras_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_thermal_cameras_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_thermal_cameras_with_http_info(self, **kwargs):  # noqa: E501
        """Get multiple ThermalCamera objects  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thermal_cameras_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `Created` | DateTime | | `LocationName` | String | | `Updated` | DateTime |
        :return: PagedResultsModelThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_thermal_cameras" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelThermalCameraResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_thermal_camera(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Updates a single Thermal Camera/ settings  # noqa: E501

        Updating a ThermalCamera is location admin only.  Updating a ThermalCamera Location is System Admin/Sentry only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_thermal_camera(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The id of the thermal camera to update (required)
        :param ThermalCameraUpdateRequest body: The update request for a given Thermal Camera
        :return: ThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_thermal_camera_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_thermal_camera_with_http_info(thermal_camera_serial_number, **kwargs)  # noqa: E501
            return data

    def update_thermal_camera_with_http_info(self, thermal_camera_serial_number, **kwargs):  # noqa: E501
        """Updates a single Thermal Camera/ settings  # noqa: E501

        Updating a ThermalCamera is location admin only.  Updating a ThermalCamera Location is System Admin/Sentry only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_thermal_camera_with_http_info(thermal_camera_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int thermal_camera_serial_number: The id of the thermal camera to update (required)
        :param ThermalCameraUpdateRequest body: The update request for a given Thermal Camera
        :return: ThermalCameraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thermal_camera_serial_number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_thermal_camera" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'thermal_camera_serial_number' is set
        if ('thermal_camera_serial_number' not in params or
                params['thermal_camera_serial_number'] is None):
            raise ValueError("Missing the required parameter `thermal_camera_serial_number` when calling `update_thermal_camera`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'thermal_camera_serial_number' in params:
            path_params['thermalCameraSerialNumber'] = params['thermal_camera_serial_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_thermal_camera_region(self, region_id, **kwargs):  # noqa: E501
        """Updates a single Thermal Camera Region  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_thermal_camera_region(region_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str region_id: The id of the region to update (required)
        :param ThermalCameraRegionUpdateRequest body: The update request for a given Thermal Camera Region
        :return: ThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_thermal_camera_region_with_http_info(region_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_thermal_camera_region_with_http_info(region_id, **kwargs)  # noqa: E501
            return data

    def update_thermal_camera_region_with_http_info(self, region_id, **kwargs):  # noqa: E501
        """Updates a single Thermal Camera Region  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_thermal_camera_region_with_http_info(region_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str region_id: The id of the region to update (required)
        :param ThermalCameraRegionUpdateRequest body: The update request for a given Thermal Camera Region
        :return: ThermalCameraRegionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['region_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_thermal_camera_region" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'region_id' is set
        if ('region_id' not in params or
                params['region_id'] is None):
            raise ValueError("Missing the required parameter `region_id` when calling `update_thermal_camera_region`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region_id' in params:
            path_params['regionId'] = params['region_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ThermalCameras/regions/{regionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThermalCameraRegionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
