# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class PicturesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assign_pictures_to_group(self, group_id, **kwargs):  # noqa: E501
        """Associate an ordered list of pictures to a group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_pictures_to_group(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: The GUID of the group to assign pictures to (required)
        :param list[str] body: An ordered list of picture GUIDs to associate with the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_pictures_to_group_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_pictures_to_group_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def assign_pictures_to_group_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Associate an ordered list of pictures to a group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_pictures_to_group_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: The GUID of the group to assign pictures to (required)
        :param list[str] body: An ordered list of picture GUIDs to associate with the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_pictures_to_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `assign_pictures_to_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Pictures/group/{groupId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_picture(self, id, **kwargs):  # noqa: E501
        """Returns a single picture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_picture(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Picture Id (required)
        :return: PicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_picture_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_picture_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_picture_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns a single picture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_picture_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Picture Id (required)
        :return: PicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Pictures/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PicturesModelV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pictures(self, **kwargs):  # noqa: E501
        """Returns a paged list of all pictures  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pictures(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `ImageFileName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThumbnailFileName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Guid | | `ImageFileName` | String | | `Name` | String | | `ThumbnailFileName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `ImageFileName`, `Name`.
        :return: PagedResultsModelPicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pictures_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pictures_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pictures_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a paged list of all pictures  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pictures_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `ImageFileName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThumbnailFileName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Guid | | `ImageFileName` | String | | `Name` | String | | `ThumbnailFileName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `ImageFileName`, `Name`.
        :return: PagedResultsModelPicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pictures" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Pictures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPicturesModelV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pictures_for_group(self, group_id, **kwargs):  # noqa: E501
        """Get a paged list of pictures associated with a group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pictures_for_group(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: The GUID of the group (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `ImageFileName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThumbnailFileName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Guid | | `ImageFileName` | String | | `Name` | String | | `ThumbnailFileName` | String |
        :return: PagedResultsModelPicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pictures_for_group_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pictures_for_group_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def get_pictures_for_group_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Get a paged list of pictures associated with a group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pictures_for_group_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: The GUID of the group (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `ImageFileName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThumbnailFileName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Guid | | `ImageFileName` | String | | `Name` | String | | `ThumbnailFileName` | String |
        :return: PagedResultsModelPicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pictures_for_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_pictures_for_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Pictures/group/{groupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPicturesModelV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pictures_for_location(self, location_id, **kwargs):  # noqa: E501
        """Returns a paged list of pictures associated with an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pictures_for_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: The GUID of the account/location (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `ImageFileName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThumbnailFileName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Guid | | `ImageFileName` | String | | `Name` | String | | `ThumbnailFileName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `ImageFileName`, `Name`.
        :return: PagedResultsModelPicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pictures_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pictures_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_pictures_for_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Returns a paged list of pictures associated with an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pictures_for_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: The GUID of the account/location (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `ImageFileName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `ThumbnailFileName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Guid | | `ImageFileName` | String | | `Name` | String | | `ThumbnailFileName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `ImageFileName`, `Name`.
        :return: PagedResultsModelPicturesModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pictures_for_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_pictures_for_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Pictures/location/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPicturesModelV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
