# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class LocationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_location(self, **kwargs):  # noqa: E501
        """Creates a new location  # noqa: E501

        Required Permissions: System Admin / Sentry / Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_location(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LocationCreateRequest body: Model for new location
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_location_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_location_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_location_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new location  # noqa: E501

        Required Permissions: System Admin / Sentry / Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_location_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LocationCreateRequest body: Model for new location
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_location" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_location_api_key(self, id, **kwargs):  # noqa: E501
        """Generates a new API key for the specified location, replacing the existing one  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_location_api_key(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_location_api_key_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_location_api_key_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def generate_location_api_key_with_http_info(self, id, **kwargs):  # noqa: E501
        """Generates a new API key for the specified location, replacing the existing one  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_location_api_key_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_location_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `generate_location_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations/{id}/GenerateApiKey', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_baseline_indicators_for_location(self, location_id, **kwargs):  # noqa: E501
        """Gets a list of valid baselines for a given location  # noqa: E501

        Required Permissions: Location User  The searching on this route mimics the original copy baseline functionality from Sd3.  This means the user can choose to narrow down searching on either the group hierarchy, the indicator, or both.  When an asterisk ('*') is included, everything before the asterisk is considered a search on the group hierarchy while  everything after the asterisk will search on the indicator name. Leaving out an asterisk will do a search  on both the indicator name and the group hierarchy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_baseline_indicators_for_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Id of requested location (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `IsDamageAccumulationPressure` | Boolean | `eq, neq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Name`.
        :return: PagedResultsModelIndicatorBaselineResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_baseline_indicators_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_baseline_indicators_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_baseline_indicators_for_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets a list of valid baselines for a given location  # noqa: E501

        Required Permissions: Location User  The searching on this route mimics the original copy baseline functionality from Sd3.  This means the user can choose to narrow down searching on either the group hierarchy, the indicator, or both.  When an asterisk ('*') is included, everything before the asterisk is considered a search on the group hierarchy while  everything after the asterisk will search on the indicator name. Leaving out an asterisk will do a search  on both the indicator name and the group hierarchy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_baseline_indicators_for_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Id of requested location (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `IsDamageAccumulationPressure` | Boolean | `eq, neq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Name`.
        :return: PagedResultsModelIndicatorBaselineResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_baseline_indicators_for_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_baseline_indicators_for_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations/{locationId}/indicators/baselines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelIndicatorBaselineResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_location(self, location_id, **kwargs):  # noqa: E501
        """Gets a specific location  # noqa: E501

        Required Permissions: Users, Sentry, and System Admins will receive all the locations that are visible to them at their access level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Id of location (required)
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets a specific location  # noqa: E501

        Required Permissions: Users, Sentry, and System Admins will receive all the locations that are visible to them at their access level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Id of location (required)
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_location_roi(self, location_id, **kwargs):  # noqa: E501
        """Gets ROI information for a location  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_location_roi(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param datetime start_date:
        :param datetime end_date:
        :return: RoiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_location_roi_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_location_roi_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_location_roi_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets ROI information for a location  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_location_roi_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param datetime start_date:
        :param datetime end_date:
        :return: RoiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'start_date', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_location_roi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_location_roi`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('StartDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('EndDate', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations/{locationId}/roi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_locations(self, **kwargs):  # noqa: E501
        """Returns a paged list of all locations that the user has access to  # noqa: E501

        Required Permissions: Users, Sentry, and System Admins will receive all the locations that are visible to them at their access level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_locations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `Active` | Boolean | | `CorporationName` | String | | `Name` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `CorporationName`, `Name`.
        :return: PagedResultsModelLocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_locations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_locations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_locations_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a paged list of all locations that the user has access to  # noqa: E501

        Required Permissions: Users, Sentry, and System Admins will receive all the locations that are visible to them at their access level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_locations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `Active` | Boolean | | `CorporationName` | String | | `Name` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `CorporationName`, `Name`.
        :return: PagedResultsModelLocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_locations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelLocationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_location(self, id, **kwargs):  # noqa: E501
        """Updates the specified location  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_location(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The Location Id (required)
        :param LocationUpdateRequest body: Model for updated location
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_location_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_location_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_location_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates the specified location  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_location_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The Location Id (required)
        :param LocationUpdateRequest body: Model for updated location
        :return: LocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_location_permissions(self, id, **kwargs):  # noqa: E501
        """Updates the feature-permissions for the specified location  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_location_permissions(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The Location Id (required)
        :param LocationPermissionsUpdateRequest body: Model for updated location permissions
        :return: LocationPermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_location_permissions_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_location_permissions_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_location_permissions_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates the feature-permissions for the specified location  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_location_permissions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The Location Id (required)
        :param LocationPermissionsUpdateRequest body: Model for updated location permissions
        :return: LocationPermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_location_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_location_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Locations/{id}/Permissions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationPermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
